/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest.protocols.tcp.redis;

import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisCommonAbstractTest
extends GridCommonAbstractTest {
    private static final int GRID_CNT = 2;
    protected static final String HOST = "127.0.0.1";
    protected static final int PORT = 6379;
    protected static JedisPool pool;
    private static final String DFLT_CACHE_NAME = "redis-ignite-internal-cache-0";

    protected void beforeTestsStarted() throws Exception {
        this.startGrids(this.gridCount());
        JedisPoolConfig jedisPoolCfg = new JedisPoolConfig();
        jedisPoolCfg.setMaxWaitMillis(20000L);
        jedisPoolCfg.setMaxIdle(100);
        jedisPoolCfg.setMinIdle(1);
        jedisPoolCfg.setNumTestsPerEvictionRun(10);
        jedisPoolCfg.setTestOnBorrow(true);
        jedisPoolCfg.setTestOnReturn(true);
        jedisPoolCfg.setTestWhileIdle(true);
        jedisPoolCfg.setTimeBetweenEvictionRunsMillis(30000L);
        pool = new JedisPool((GenericObjectPoolConfig)jedisPoolCfg, HOST, 6379, 10000);
    }

    protected void afterTestsStopped() throws Exception {
        pool.destroy();
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setLocalHost(HOST);
        assert (cfg.getConnectorConfiguration() == null);
        ConnectorConfiguration redisCfg = new ConnectorConfiguration();
        redisCfg.setHost(HOST);
        redisCfg.setPort(6379);
        cfg.setConnectorConfiguration(redisCfg);
        CacheConfiguration ccfg = RedisCommonAbstractTest.defaultCacheConfiguration();
        ccfg.setStatisticsEnabled(true);
        ccfg.setIndexedTypes(new Class[]{String.class, String.class});
        ccfg.setName(DFLT_CACHE_NAME);
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg});
        return cfg;
    }

    protected <K, V> IgniteCache<K, V> jcache() {
        return this.grid(0).cache(DFLT_CACHE_NAME);
    }

    protected int gridCount() {
        return 2;
    }

    protected void beforeTest() throws Exception {
        assert (this.grid(0).cluster().nodes().size() == this.gridCount());
    }

    protected void afterTest() throws Exception {
        this.jcache().clear();
        RedisCommonAbstractTest.assertTrue((this.jcache().localSize(new CachePeekMode[0]) == 0 ? 1 : 0) != 0);
    }
}

