/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest;

import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.processors.rest.JettyRestProcessorAbstractSelfTest;
import org.apache.ignite.internal.processors.rest.TestRestClient;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.junit.Test;

public class JettyRestProcessorSignedSelfTest
extends JettyRestProcessorAbstractSelfTest {
    protected static final String REST_SECRET_KEY = "secret-key";

    @Override
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        assert (cfg.getConnectorConfiguration() != null);
        cfg.getConnectorConfiguration().setSecretKey(REST_SECRET_KEY);
        return cfg;
    }

    @Override
    protected TestRestClient createRestClient() {
        return new TestRestClient(this::signature){

            @Override
            public int restPort() {
                return 8092;
            }
        };
    }

    @Test
    public void testUnauthorized() throws Exception {
        String addr = "http://127.0.0.1:" + this.restPort() + "/ignite?cacheName=default&cmd=top";
        URL url = new URL(addr);
        URLConnection conn = url.openConnection();
        conn.connect();
        assert (((HttpURLConnection)conn).getResponseCode() == 401);
        addr = "http://127.0.0.1:" + this.restPort() + "/ignite?cacheName=default&cmd=top";
        url = new URL(addr);
        conn = url.openConnection();
        conn.setRequestProperty("X-Signature", this.signature());
        conn.connect();
        JettyRestProcessorSignedSelfTest.assertEquals((int)200, (int)((HttpURLConnection)conn).getResponseCode());
    }

    @Override
    protected String signature() throws Exception {
        long ts = U.currentTimeMillis();
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            String s = ts + ":" + REST_SECRET_KEY;
            md.update(s.getBytes());
            String hash = Base64.getEncoder().encodeToString(md.digest());
            return ts + ":" + hash;
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception("Failed to create authentication signature.", e);
        }
    }
}

