/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.ignite.cluster.BaselineNode;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.rest.GridRestCommand;
import org.apache.ignite.internal.processors.rest.JettyRestProcessorCommonSelfTest;
import org.apache.ignite.internal.processors.rest.handlers.cluster.GridBaselineCommandResponse;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

public class JettyRestProcessorBaselineSelfTest
extends JettyRestProcessorCommonSelfTest {
    @Override
    protected void beforeTestsStarted() throws Exception {
        U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"db", (boolean)true);
        super.beforeTestsStarted();
        this.grid(0).cluster().baselineAutoAdjustEnabled(false);
        this.grid(0).cluster().active(true);
    }

    @Override
    protected void afterTest() throws Exception {
        super.afterTest();
        this.grid(0).cluster().setBaselineTopology(this.grid(0).cluster().topologyVersion());
    }

    @Override
    protected String signature() {
        return null;
    }

    @Override
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        DataStorageConfiguration dsCfg = new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setMaxSize(0x6400000L).setPersistenceEnabled(true)).setWalMode(WALMode.NONE);
        cfg.setDataStorageConfiguration(dsCfg);
        return cfg;
    }

    private static Collection<String> nodeConsistentIds(@Nullable Collection<? extends BaselineNode> nodes) {
        if (nodes == null || nodes.isEmpty()) {
            return Collections.emptyList();
        }
        return F.viewReadOnly(nodes, (IgniteClosure & Serializable)n -> String.valueOf(n.consistentId()), (IgnitePredicate[])new IgnitePredicate[0]);
    }

    private void assertBaseline(String content, int baselineSz, int srvsSz) throws IOException {
        JettyRestProcessorBaselineSelfTest.assertNotNull((Object)content);
        JettyRestProcessorBaselineSelfTest.assertFalse((boolean)content.isEmpty());
        JsonNode node = JSON_MAPPER.readTree(content);
        JettyRestProcessorBaselineSelfTest.assertEquals((int)0, (int)node.get("successStatus").asInt());
        JettyRestProcessorBaselineSelfTest.assertTrue((boolean)node.get("error").isNull());
        JettyRestProcessorBaselineSelfTest.assertNotSame((Object)this.securityEnabled(), (Object)node.get("sessionToken").isNull());
        JsonNode res = node.get("response");
        JettyRestProcessorBaselineSelfTest.assertFalse((boolean)res.isNull());
        GridBaselineCommandResponse baseline = (GridBaselineCommandResponse)JSON_MAPPER.treeToValue((TreeNode)res, GridBaselineCommandResponse.class);
        JettyRestProcessorBaselineSelfTest.assertTrue((boolean)baseline.isActive());
        JettyRestProcessorBaselineSelfTest.assertEquals((long)this.grid(0).cluster().topologyVersion(), (long)baseline.getTopologyVersion());
        JettyRestProcessorBaselineSelfTest.assertEquals((int)baselineSz, (int)baseline.getBaseline().size());
        JettyRestProcessorBaselineSelfTest.assertEqualsCollections(JettyRestProcessorBaselineSelfTest.nodeConsistentIds(this.grid(0).cluster().currentBaselineTopology()), (Collection)baseline.getBaseline());
        JettyRestProcessorBaselineSelfTest.assertEquals((int)srvsSz, (int)baseline.getServers().size());
        JettyRestProcessorBaselineSelfTest.assertEqualsCollections(JettyRestProcessorBaselineSelfTest.nodeConsistentIds(this.grid(0).cluster().nodes()), (Collection)baseline.getServers());
    }

    @Test
    public void testBaseline() throws Exception {
        int sz = this.gridCount();
        this.assertBaseline(this.content(null, GridRestCommand.BASELINE_CURRENT_STATE, new String[0]), sz, sz);
        this.stopGrid(sz - 1);
        this.assertBaseline(this.content(null, GridRestCommand.BASELINE_CURRENT_STATE, new String[0]), sz, sz - 1);
        this.startGrid(sz - 1);
        this.assertBaseline(this.content(null, GridRestCommand.BASELINE_CURRENT_STATE, new String[0]), sz, sz);
    }

    @Test
    public void testBaselineSet() throws Exception {
        int sz = this.gridCount();
        this.assertBaseline(this.content(null, GridRestCommand.BASELINE_CURRENT_STATE, new String[0]), sz, sz);
        IgniteEx ignite = this.startGrid(sz);
        ignite.cluster().baselineAutoAdjustEnabled(false);
        this.assertBaseline(this.content(null, GridRestCommand.BASELINE_CURRENT_STATE, new String[0]), sz, sz + 1);
        this.assertBaseline(this.content(null, GridRestCommand.BASELINE_SET, "topVer", String.valueOf(this.grid(0).cluster().topologyVersion())), sz + 1, sz + 1);
        this.stopGrid(sz);
        this.assertBaseline(this.content(null, GridRestCommand.BASELINE_CURRENT_STATE, new String[0]), sz + 1, sz);
        this.assertBaseline(this.content(null, GridRestCommand.BASELINE_SET, "topVer", String.valueOf(this.grid(0).cluster().topologyVersion())), sz, sz);
        this.startGrid(sz);
        this.assertBaseline(this.content(null, GridRestCommand.BASELINE_CURRENT_STATE, new String[0]), sz, sz + 1);
        ArrayList<String> params = new ArrayList<String>();
        int i = 1;
        for (BaselineNode n : this.grid(0).cluster().nodes()) {
            params.add("consistentId" + i++);
            params.add(String.valueOf(n.consistentId()));
        }
        this.assertBaseline(this.content(null, GridRestCommand.BASELINE_SET, params.toArray(new String[0])), sz + 1, sz + 1);
        this.stopGrid(sz);
    }

    @Test
    public void testBaselineAdd() throws Exception {
        int sz = this.gridCount();
        this.assertBaseline(this.content(null, GridRestCommand.BASELINE_CURRENT_STATE, new String[0]), sz, sz);
        this.startGrid(sz);
        this.assertBaseline(this.content(null, GridRestCommand.BASELINE_CURRENT_STATE, new String[0]), sz, sz + 1);
        this.assertBaseline(this.content(null, GridRestCommand.BASELINE_ADD, "consistentId1", this.grid(sz).localNode().consistentId().toString()), sz + 1, sz + 1);
        this.stopGrid(sz);
    }

    @Test
    public void testBaselineRemove() throws Exception {
        int sz = this.gridCount();
        this.assertBaseline(this.content(null, GridRestCommand.BASELINE_CURRENT_STATE, new String[0]), sz, sz);
        this.startGrid(sz);
        this.assertBaseline(this.content(null, GridRestCommand.BASELINE_CURRENT_STATE, new String[0]), sz, sz + 1);
        this.assertBaseline(this.content(null, GridRestCommand.BASELINE_SET, "topVer", String.valueOf(this.grid(0).cluster().topologyVersion())), sz + 1, sz + 1);
        String consistentId = this.grid(sz).localNode().consistentId().toString();
        this.stopGrid(sz);
        this.assertBaseline(this.content(null, GridRestCommand.BASELINE_CURRENT_STATE, new String[0]), sz + 1, sz);
        this.assertBaseline(this.content(null, GridRestCommand.BASELINE_REMOVE, "consistentId1", consistentId), sz, sz);
    }
}

