/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc2;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.ignite.Ignite;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class JdbcCursorLeaksTest
extends AbstractIndexingCommonTest {
    private static final int KEYS = 100;
    @Parameterized.Parameter
    public boolean remote;
    @Parameterized.Parameter(value=1)
    public boolean multipleStatement;
    @Parameterized.Parameter(value=2)
    public boolean distributedJoin;

    @Parameterized.Parameters(name="remote={0}, multipleStatement={1}, distributedJoin={2}")
    public static Collection parameters() {
        LinkedHashSet<Object[]> paramsSet = new LinkedHashSet<Object[]>();
        for (int i = 0; i < 8; ++i) {
            Object[] params = new Object[]{(i & 1) != 0, (i & 2) != 0, (i & 4) != 0};
            paramsSet.add(params);
        }
        return paramsSet;
    }

    protected void beforeTestsStarted() throws Exception {
        this.startGrids(3);
        this.sql("CREATE TABLE A(ID INT PRIMARY KEY, JID INT)", new Object[0]);
        this.sql("CREATE TABLE B(ID INT PRIMARY KEY, JID INT)", new Object[0]);
        for (int i = 0; i < 100; ++i) {
            this.sql("INSERT INTO A VALUES (?, ?)", i, i);
            this.sql("INSERT INTO B VALUES (?, ?)", i, i + 1);
        }
    }

    @Test
    public void testSingleQuery() throws Exception {
        this.checkQuery("SELECT 1");
    }

    @Test
    public void testMultipleStatement0() throws Exception {
        if (!this.multipleStatement) {
            return;
        }
        this.checkQuery("SELECT 1; SELECT 2");
    }

    @Test
    public void testMultipleStatement1() throws Exception {
        if (!this.multipleStatement) {
            return;
        }
        this.checkQuery("SELECT 1; SELECT 2; SELECT 3");
    }

    @Test
    public void testJoin() throws Exception {
        this.checkQuery("SELECT * FROM A JOIN B on A.JID=B.JID");
    }

    private void checkQuery(String sql) throws Exception {
        try (Connection conn = DriverManager.getConnection(this.url());){
            for (int i = 0; i < 10; ++i) {
                try (Statement stmt = conn.createStatement();){
                    stmt.execute(sql);
                    continue;
                }
            }
            this.checkThereAreNoRunningQueries(1000);
        }
    }

    private void checkThereAreNoRunningQueries(int timeout) {
        for (Ignite ign : G.allGrids()) {
            this.checkThereAreNoRunningQueries((IgniteEx)ign, timeout);
        }
    }

    private void checkThereAreNoRunningQueries(IgniteEx ign, int timeout) {
        long t0 = U.currentTimeMillis();
        List res;
        while ((res = ign.context().query().querySqlFields(new SqlFieldsQuery("SELECT * FROM " + QueryUtils.sysSchemaName() + ".SQL_QUERIES"), false).getAll()).size() != 1) {
            if (U.currentTimeMillis() - t0 <= (long)timeout) continue;
            JdbcCursorLeaksTest.fail((String)("Timeout. There are unexpected running queries [node=" + ign.name() + ", queries= " + res + ']'));
        }
        return;
    }

    private String url() {
        StringBuilder params = new StringBuilder();
        params.append("multipleStatementsAllowed=").append(this.multipleStatement);
        params.append(":");
        params.append("distributedJoin=").append(this.distributedJoin);
        params.append(":");
        if (this.remote) {
            params.append("nodeId=").append(this.grid(0).cluster().localNode().id());
        }
        return "jdbc:ignite:cfg://" + params + "@modules/clients/src/test/config/jdbc-config.xml";
    }

    private FieldsQueryCursor<List<?>> sql(String sql, Object ... args) {
        return this.grid(0).context().query().querySqlFields(new SqlFieldsQuery(sql).setArgs(args), false);
    }
}

