/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobAdapter;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeJobResultPolicy;
import org.apache.ignite.compute.ComputeTaskSplitAdapter;

public class SleepTestTask
extends ComputeTaskSplitAdapter<String, Integer> {
    public Collection<? extends ComputeJob> split(int gridSize, String arg) {
        return Collections.singleton(new ComputeJobAdapter(arg){

            public Object execute() {
                try {
                    Thread.sleep(10000L);
                    String val = (String)this.argument(0);
                    return val == null ? 0 : val.length();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public Integer reduce(List<ComputeJobResult> results) {
        int sum = 0;
        for (ComputeJobResult res : results) {
            sum += ((Integer)res.getData()).intValue();
        }
        return sum;
    }

    public ComputeJobResultPolicy result(ComputeJobResult res, List<ComputeJobResult> rcvd) {
        if (res.getException() != null) {
            return ComputeJobResultPolicy.FAILOVER;
        }
        return ComputeJobResultPolicy.WAIT;
    }
}

