/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc.thin;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.jdbc.thin.JdbcThinAbstractSelfTest;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;

public abstract class JdbcThinTransactionsAbstractComplexSelfTest
extends JdbcThinAbstractSelfTest {
    static final int CLI_IDX = 1;
    private final IgniteInClosure<Connection> afterReadDel = new IgniteInClosure<Connection>(){

        public void apply(Connection conn) {
            JdbcThinTransactionsAbstractComplexSelfTest.this.execute(conn, "DELETE FROM \"Person\".Person where firstname = 'John'", new Object[0]);
        }
    };
    private final IgniteInClosure<Connection> afterReadFastDel = new IgniteInClosure<Connection>(){

        public void apply(Connection conn) {
            JdbcThinTransactionsAbstractComplexSelfTest.this.execute(conn, "DELETE FROM \"Person\".Person where id = 1", new Object[0]);
        }
    };
    private final IgniteInClosure<Connection> afterReadUpdate = new IgniteInClosure<Connection>(){

        public void apply(Connection conn) {
            JdbcThinTransactionsAbstractComplexSelfTest.this.execute(conn, "UPDATE \"Person\".Person set firstname = 'Joe' where firstname = 'John'", new Object[0]);
        }
    };
    private final IgniteInClosure<Connection> afterReadDelAndRollback = new IgniteInClosure<Connection>(){

        public void apply(Connection conn) {
            JdbcThinTransactionsAbstractComplexSelfTest.this.execute(conn, "DELETE FROM \"Person\".Person where firstname = 'John'", new Object[0]);
            JdbcThinTransactionsAbstractComplexSelfTest.this.rollback(conn);
        }
    };
    private final IgniteInClosure<Connection> afterReadFastDelAndRollback = new IgniteInClosure<Connection>(){

        public void apply(Connection conn) {
            JdbcThinTransactionsAbstractComplexSelfTest.this.execute(conn, "DELETE FROM \"Person\".Person where id = 1", new Object[0]);
            JdbcThinTransactionsAbstractComplexSelfTest.this.rollback(conn);
        }
    };
    private final IgniteInClosure<Connection> afterReadUpdateAndRollback = new IgniteInClosure<Connection>(){

        public void apply(Connection conn) {
            JdbcThinTransactionsAbstractComplexSelfTest.this.execute(conn, "UPDATE \"Person\".Person set firstname = 'Joe' where firstname = 'John'", new Object[0]);
            JdbcThinTransactionsAbstractComplexSelfTest.this.rollback(conn);
        }
    };

    protected IgniteConfiguration getConfiguration(String testIgniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(testIgniteInstanceName);
        CacheConfiguration ccfg = new CacheConfiguration("Person");
        ccfg.setIndexedTypes(new Class[]{Integer.class, Person.class});
        ((QueryEntity)ccfg.getQueryEntities().iterator().next()).setKeyFieldName("id");
        ccfg.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT);
        ccfg.setCacheMode(CacheMode.PARTITIONED);
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg});
        cfg.setClientMode(F.eq((Object)testIgniteInstanceName, (Object)this.getTestIgniteInstanceName(1)));
        return cfg;
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.execute("ALTER TABLE \"Person\".person add if not exists cityid int", new Object[0]);
        this.execute("ALTER TABLE \"Person\".person add if not exists companyid int", new Object[0]);
        this.execute("CREATE TABLE City (id int primary key, name varchar, population int) WITH \"atomicity=transactional_snapshot,template=partitioned,backups=3,cache_name=City\"", new Object[0]);
        this.execute("CREATE TABLE Company (id int, \"cityid\" int, name varchar, primary key (id, \"cityid\")) WITH \"atomicity=transactional_snapshot,template=partitioned,backups=1,wrap_value=false,affinity_key=cityid,cache_name=Company\"", new Object[0]);
        this.execute("CREATE TABLE Product (id int primary key, name varchar, companyid int) WITH \"atomicity=transactional_snapshot,template=partitioned,backups=2,cache_name=Product\"", new Object[0]);
        this.execute("CREATE INDEX IF NOT EXISTS prodidx ON Product(companyid)", new Object[0]);
        this.execute("CREATE INDEX IF NOT EXISTS persidx ON \"Person\".person(cityid)", new Object[0]);
        this.insertPerson(1, "John", "Smith", 1, 1);
        this.insertPerson(2, "Mike", "Johns", 1, 2);
        this.insertPerson(3, "Sam", "Jules", 2, 2);
        this.insertPerson(4, "Alex", "Pope", 2, 3);
        this.insertPerson(5, "Peter", "Williams", 2, 3);
        this.insertCity(1, "Los Angeles", 5000);
        this.insertCity(2, "Seattle", 1500);
        this.insertCity(3, "New York", 12000);
        this.insertCity(4, "Cupertino", 400);
        this.insertCompany(1, "Microsoft", 2);
        this.insertCompany(2, "Google", 3);
        this.insertCompany(3, "Facebook", 1);
        this.insertCompany(4, "Uber", 1);
        this.insertCompany(5, "Apple", 4);
        this.insertProduct(1, "Search", 2);
        this.insertProduct(2, "Windows", 1);
        this.insertProduct(3, "Mac", 5);
        this.awaitPartitionMapExchange();
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGridsMultiThreaded(4);
    }

    protected void afterTest() throws Exception {
        this.execute("DELETE FROM \"Person\".Person", new Object[0]);
        this.execute("DROP TABLE City", new Object[0]);
        this.execute("DROP TABLE Company", new Object[0]);
        this.execute("DROP TABLE Product", new Object[0]);
        super.afterTest();
    }

    @Test
    public void testSingleDmlStatement() throws SQLException {
        this.insertPerson(6, "John", "Doe", 2, 2);
        JdbcThinTransactionsAbstractComplexSelfTest.assertEquals(Collections.singletonList(JdbcThinTransactionsAbstractComplexSelfTest.l(6, "John", "Doe", 2, 2)), this.execute("SELECT * FROM \"Person\".Person where id = 6", new Object[0]));
    }

    @Test
    public void testMultipleDmlStatements() throws SQLException {
        this.executeInTransaction(new TransactionClosure(){

            public void apply(Connection conn) {
                JdbcThinTransactionsAbstractComplexSelfTest.this.insertPerson(conn, 6, "John", "Doe", 2, 2);
                JdbcThinTransactionsAbstractComplexSelfTest.this.execute(conn, "UPDATE \"Person\".person SET lastname = 'Jameson' where lastname = 'Jules'", new Object[0]);
                JdbcThinTransactionsAbstractComplexSelfTest.this.execute(conn, "DELETE FROM \"Person\".person where id = 5", new Object[0]);
            }
        });
        JdbcThinTransactionsAbstractComplexSelfTest.assertEquals(JdbcThinTransactionsAbstractComplexSelfTest.l(JdbcThinTransactionsAbstractComplexSelfTest.l(3, "Sam", "Jameson", 2, 2), JdbcThinTransactionsAbstractComplexSelfTest.l(6, "John", "Doe", 2, 2)), this.execute("SELECT * FROM \"Person\".Person where id = 3 or id >= 5 order by id", new Object[0]));
    }

    @Test
    public void testBatchDmlStatements() throws SQLException {
        this.doBatchedInsert();
        JdbcThinTransactionsAbstractComplexSelfTest.assertEquals(JdbcThinTransactionsAbstractComplexSelfTest.l(JdbcThinTransactionsAbstractComplexSelfTest.l(6, "John", "Doe", 2, 2), JdbcThinTransactionsAbstractComplexSelfTest.l(7, "Mary", "Lee", 1, 3)), this.execute("SELECT * FROM \"Person\".Person where id > 5 order by id", new Object[0]));
    }

    @Test
    public void testBatchDmlStatementsIntermediateFailure() throws SQLException {
        this.insertPerson(6, "John", "Doe", 2, 2);
        IgniteException e = (IgniteException)GridTestUtils.assertThrows(null, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JdbcThinTransactionsAbstractComplexSelfTest.this.doBatchedInsert();
                return null;
            }
        }, IgniteException.class, (String)("Duplicate key during INSERT [key=" + IgniteUtils.hash((int)6) + ", table=Person.PERSON]"));
        JdbcThinTransactionsAbstractComplexSelfTest.assertTrue((boolean)(e.getCause() instanceof BatchUpdateException));
        JdbcThinTransactionsAbstractComplexSelfTest.assertEquals((int)4001, (int)((BatchUpdateException)e.getCause()).getErrorCode());
        JdbcThinTransactionsAbstractComplexSelfTest.assertTrue((boolean)e.getCause().getMessage().contains("Duplicate key during INSERT [key=" + IgniteUtils.hash((int)6) + ", table=Person.PERSON]"));
        JdbcThinTransactionsAbstractComplexSelfTest.assertEquals(Collections.emptyList(), this.execute("SELECT * FROM \"Person\".Person where id > 6 order by id", new Object[0]));
    }

    private void doBatchedInsert() throws SQLException {
        this.executeInTransaction(new TransactionClosure(){

            public void apply(Connection conn) {
                try (PreparedStatement ps = conn.prepareStatement("INSERT INTO \"Person\".person (id, firstName, lastName, cityId, companyId) values (?, ?, ?, ?, ?)");){
                    ps.setInt(1, 7);
                    ps.setString(2, "Mary");
                    ps.setString(3, "Lee");
                    ps.setInt(4, 1);
                    ps.setInt(5, 3);
                    ps.addBatch();
                    ps.setInt(1, 6);
                    ps.setString(2, "John");
                    ps.setString(3, "Doe");
                    ps.setInt(4, 2);
                    ps.setInt(5, 2);
                    ps.addBatch();
                    ps.executeBatch();
                }
                catch (SQLException e) {
                    throw new IgniteException((Throwable)e);
                }
            }
        });
    }

    @Test
    public void testInsertAndQueryMultipleCaches() throws SQLException {
        this.executeInTransaction(new TransactionClosure(){

            public void apply(Connection conn) {
                JdbcThinTransactionsAbstractComplexSelfTest.this.insertCity(conn, 5, "St Petersburg", 6000);
                JdbcThinTransactionsAbstractComplexSelfTest.this.insertCompany(conn, 6, "VK", 5);
                JdbcThinTransactionsAbstractComplexSelfTest.this.insertPerson(conn, 6, "Peter", "Sergeev", 5, 6);
            }
        });
        try (Connection c = this.connect("distributedJoins=true");){
            JdbcThinTransactionsAbstractComplexSelfTest.assertEquals(JdbcThinTransactionsAbstractComplexSelfTest.l(JdbcThinTransactionsAbstractComplexSelfTest.l(5, "St Petersburg", 6000, 6, 5, "VK", 6, "Peter", "Sergeev", 5, 6)), this.execute(c, "SELECT * FROM City left join Company on City.id = Company.\"cityid\" left join \"Person\".Person p on City.id = p.cityid WHERE p.id = 6 or company.id = 6", new Object[0]));
        }
    }

    @Test
    public void testColocatedJoinSelectAndInsertInTransaction() throws SQLException {
        this.executeInTransaction(new TransactionClosure(){

            public void apply(Connection conn) {
                List ids = JdbcThinTransactionsAbstractComplexSelfTest.flat(JdbcThinTransactionsAbstractComplexSelfTest.this.execute(conn, "SELECT distinct City.id from City left join Company c on City.id = c.\"cityid\" where population >= 1000 and c.name <> 'Google' order by City.id", new Object[0]));
                JdbcThinTransactionsAbstractComplexSelfTest.assertEqualsCollections((Collection)JdbcThinTransactionsAbstractComplexSelfTest.l(new Object[]{1, 2}), (Collection)ids);
                int i = 5;
                Iterator iterator = ids.iterator();
                while (iterator.hasNext()) {
                    int l = (Integer)iterator.next();
                    JdbcThinTransactionsAbstractComplexSelfTest.this.insertCompany(conn, ++i, "Google", l);
                }
            }
        });
        JdbcThinTransactionsAbstractComplexSelfTest.assertEqualsCollections(JdbcThinTransactionsAbstractComplexSelfTest.l("Los Angeles", "Seattle", "New York"), JdbcThinTransactionsAbstractComplexSelfTest.flat(this.execute("SELECT City.name from City left join Company c on city.id = c.\"cityid\" WHERE c.name = 'Google' order by City.id", new Object[0])));
    }

    @Test
    public void testDistributedJoinSelectAndInsertInTransaction() throws SQLException {
        try (Connection c = this.connect("distributedJoins=true");){
            this.executeInTransaction(c, new TransactionClosure(){

                public void apply(Connection conn) {
                    List res = JdbcThinTransactionsAbstractComplexSelfTest.flat(JdbcThinTransactionsAbstractComplexSelfTest.this.execute(conn, "SELECT p.id,p.name,c.id from Company c left join Product p on c.id = p.companyid left join City on city.id = c.\"cityid\" WHERE c.name <> 'Microsoft' and population < 1000", new Object[0]));
                    JdbcThinTransactionsAbstractComplexSelfTest.assertEqualsCollections((Collection)JdbcThinTransactionsAbstractComplexSelfTest.l(new Object[]{3, "Mac", 5}), (Collection)res);
                    JdbcThinTransactionsAbstractComplexSelfTest.this.insertProduct(conn, 4, (String)res.get(1), 1);
                }
            });
        }
        c = this.connect("distributedJoins=true");
        var2_2 = null;
        try {
            JdbcThinTransactionsAbstractComplexSelfTest.assertEqualsCollections(JdbcThinTransactionsAbstractComplexSelfTest.l("Windows", "Mac"), JdbcThinTransactionsAbstractComplexSelfTest.flat(this.execute(c, "SELECT p.name from Company c left join Product p on c.id = p.companyid WHERE c.name = 'Microsoft' order by p.id", new Object[0])));
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (c != null) {
                if (var2_2 != null) {
                    try {
                        c.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    c.close();
                }
            }
        }
    }

    @Test
    public void testInsertFromExpression() throws SQLException {
        this.executeInTransaction(new TransactionClosure(){

            public void apply(Connection conn) {
                JdbcThinTransactionsAbstractComplexSelfTest.this.execute(conn, "insert into city (id, name, population) values (? + 1, ?, ?)", 8, "Moscow", 15000);
            }
        });
    }

    @Test
    public void testAutoRollback() throws SQLException {
        try (Connection c = this.connect();){
            this.begin(c);
            this.insertPerson(c, 6, "John", "Doe", 2, 2);
        }
        JdbcThinTransactionsAbstractComplexSelfTest.assertTrue((boolean)this.personCache().query(new SqlFieldsQuery("SELECT * FROM \"Person\".Person WHERE id = 6")).getAll().isEmpty());
    }

    @Test
    public void testRepeatableReadWithConcurrentDelete() throws Exception {
        this.doTestRepeatableRead(new IgniteInClosure<Connection>(){

            public void apply(Connection conn) {
                JdbcThinTransactionsAbstractComplexSelfTest.this.execute(conn, "DELETE FROM \"Person\".Person where firstname = 'John'", new Object[0]);
            }
        }, null);
    }

    @Test
    public void testRepeatableReadWithConcurrentFastDelete() throws Exception {
        this.doTestRepeatableRead(new IgniteInClosure<Connection>(){

            public void apply(Connection conn) {
                JdbcThinTransactionsAbstractComplexSelfTest.this.execute(conn, "DELETE FROM \"Person\".Person where id = 1", new Object[0]);
            }
        }, null);
    }

    @Test
    public void testRepeatableReadWithConcurrentCacheRemove() throws Exception {
        this.doTestRepeatableRead(new IgniteInClosure<Connection>(){

            public void apply(Connection conn) {
                JdbcThinTransactionsAbstractComplexSelfTest.this.personCache().remove((Object)1);
            }
        }, null);
    }

    @Test
    public void testRepeatableReadAndDeleteWithConcurrentDelete() throws Exception {
        this.doTestRepeatableRead(new IgniteInClosure<Connection>(){

            public void apply(Connection conn) {
                JdbcThinTransactionsAbstractComplexSelfTest.this.execute(conn, "DELETE FROM \"Person\".Person where firstname = 'John'", new Object[0]);
            }
        }, this.afterReadDel);
    }

    @Test
    public void testRepeatableReadAndDeleteWithConcurrentFastDelete() throws Exception {
        this.doTestRepeatableRead(new IgniteInClosure<Connection>(){

            public void apply(Connection conn) {
                JdbcThinTransactionsAbstractComplexSelfTest.this.execute(conn, "DELETE FROM \"Person\".Person where id = 1", new Object[0]);
            }
        }, this.afterReadDel);
    }

    @Test
    public void testRepeatableReadAndDeleteWithConcurrentCacheRemove() throws Exception {
        this.doTestRepeatableRead(new IgniteInClosure<Connection>(){

            public void apply(Connection conn) {
                JdbcThinTransactionsAbstractComplexSelfTest.this.personCache().remove((Object)1);
            }
        }, this.afterReadDel);
    }

    @Test
    public void testRepeatableReadAndFastDeleteWithConcurrentDelete() throws Exception {
        this.doTestRepeatableRead(new IgniteInClosure<Connection>(){

            public void apply(Connection conn) {
                JdbcThinTransactionsAbstractComplexSelfTest.this.execute(conn, "DELETE FROM \"Person\".Person where firstname = 'John'", new Object[0]);
            }
        }, this.afterReadFastDel);
    }

    @Test
    public void testRepeatableReadAndFastDeleteWithConcurrentFastDelete() throws Exception {
        this.doTestRepeatableRead(new IgniteInClosure<Connection>(){

            public void apply(Connection conn) {
                JdbcThinTransactionsAbstractComplexSelfTest.this.execute(conn, "DELETE FROM \"Person\".Person where id = 1", new Object[0]);
            }
        }, this.afterReadFastDel);
    }

    @Test
    public void testRepeatableReadAndFastDeleteWithConcurrentCacheRemove() throws Exception {
        this.doTestRepeatableRead(new IgniteInClosure<Connection>(){

            public void apply(Connection conn) {
                JdbcThinTransactionsAbstractComplexSelfTest.this.personCache().remove((Object)1);
            }
        }, this.afterReadFastDel);
    }

    @Test
    public void testRepeatableReadAndDeleteWithConcurrentDeleteAndRollback() throws Exception {
        this.doTestRepeatableRead(new IgniteInClosure<Connection>(){

            public void apply(Connection conn) {
                JdbcThinTransactionsAbstractComplexSelfTest.this.execute(conn, "DELETE FROM \"Person\".Person where firstname = 'John'", new Object[0]);
            }
        }, this.afterReadDelAndRollback);
    }

    @Test
    public void testRepeatableReadAndDeleteWithConcurrentFastDeleteAndRollback() throws Exception {
        this.doTestRepeatableRead(new IgniteInClosure<Connection>(){

            public void apply(Connection conn) {
                JdbcThinTransactionsAbstractComplexSelfTest.this.execute(conn, "DELETE FROM \"Person\".Person where id = 1", new Object[0]);
            }
        }, this.afterReadDelAndRollback);
    }

    @Test
    public void testRepeatableReadAndDeleteWithConcurrentCacheRemoveAndRollback() throws Exception {
        this.doTestRepeatableRead(new IgniteInClosure<Connection>(){

            public void apply(Connection conn) {
                JdbcThinTransactionsAbstractComplexSelfTest.this.personCache().remove((Object)1);
            }
        }, this.afterReadDelAndRollback);
    }

    @Test
    public void testRepeatableReadAndFastDeleteWithConcurrentDeleteAndRollback() throws Exception {
        this.doTestRepeatableRead(new IgniteInClosure<Connection>(){

            public void apply(Connection conn) {
                JdbcThinTransactionsAbstractComplexSelfTest.this.execute(conn, "DELETE FROM \"Person\".Person where firstname = 'John'", new Object[0]);
            }
        }, this.afterReadFastDelAndRollback);
    }

    @Test
    public void testRepeatableReadAndFastDeleteWithConcurrentFastDeleteAndRollback() throws Exception {
        this.doTestRepeatableRead(new IgniteInClosure<Connection>(){

            public void apply(Connection conn) {
                JdbcThinTransactionsAbstractComplexSelfTest.this.execute(conn, "DELETE FROM \"Person\".Person where id = 1", new Object[0]);
            }
        }, this.afterReadFastDelAndRollback);
    }

    @Test
    public void testRepeatableReadAndFastDeleteWithConcurrentCacheRemoveAndRollback() throws Exception {
        this.doTestRepeatableRead(new IgniteInClosure<Connection>(){

            public void apply(Connection conn) {
                JdbcThinTransactionsAbstractComplexSelfTest.this.personCache().remove((Object)1);
            }
        }, this.afterReadFastDelAndRollback);
    }

    @Test
    public void testRepeatableReadWithConcurrentUpdate() throws Exception {
        this.doTestRepeatableRead(new IgniteInClosure<Connection>(){

            public void apply(Connection conn) {
                JdbcThinTransactionsAbstractComplexSelfTest.this.execute(conn, "UPDATE \"Person\".Person SET lastname = 'Fix' where firstname = 'John'", new Object[0]);
            }
        }, null);
    }

    @Test
    public void testRepeatableReadWithConcurrentCacheReplace() throws Exception {
        this.doTestRepeatableRead(new IgniteInClosure<Connection>(){

            public void apply(Connection conn) {
                Person p = new Person();
                p.id = 1;
                p.firstName = "Luke";
                p.lastName = "Maxwell";
                JdbcThinTransactionsAbstractComplexSelfTest.this.personCache().replace((Object)1, (Object)p);
            }
        }, null);
    }

    @Test
    public void testRepeatableReadAndUpdateWithConcurrentUpdate() throws Exception {
        this.doTestRepeatableRead(new IgniteInClosure<Connection>(){

            public void apply(Connection conn) {
                JdbcThinTransactionsAbstractComplexSelfTest.this.execute(conn, "UPDATE \"Person\".Person SET lastname = 'Fix' where firstname = 'John'", new Object[0]);
            }
        }, this.afterReadUpdate);
    }

    @Test
    public void testRepeatableReadAndUpdateWithConcurrentCacheReplace() throws Exception {
        this.doTestRepeatableRead(new IgniteInClosure<Connection>(){

            public void apply(Connection conn) {
                Person p = new Person();
                p.id = 1;
                p.firstName = "Luke";
                p.lastName = "Maxwell";
                JdbcThinTransactionsAbstractComplexSelfTest.this.personCache().replace((Object)1, (Object)p);
            }
        }, this.afterReadUpdate);
    }

    @Test
    public void testRepeatableReadAndUpdateWithConcurrentUpdateAndRollback() throws Exception {
        this.doTestRepeatableRead(new IgniteInClosure<Connection>(){

            public void apply(Connection conn) {
                JdbcThinTransactionsAbstractComplexSelfTest.this.execute(conn, "UPDATE \"Person\".Person SET lastname = 'Fix' where firstname = 'John'", new Object[0]);
            }
        }, this.afterReadUpdateAndRollback);
    }

    @Test
    public void testRepeatableReadAndUpdateWithConcurrentCacheReplaceAndRollback() throws Exception {
        this.doTestRepeatableRead(new IgniteInClosure<Connection>(){

            public void apply(Connection conn) {
                Person p = new Person();
                p.id = 1;
                p.firstName = "Luke";
                p.lastName = "Maxwell";
                JdbcThinTransactionsAbstractComplexSelfTest.this.personCache().replace((Object)1, (Object)p);
            }
        }, this.afterReadUpdateAndRollback);
    }

    private void doTestRepeatableRead(final IgniteInClosure<Connection> concurrentWriteClo, final IgniteInClosure<Connection> afterReadClo) throws Exception {
        final CountDownLatch repeatableReadLatch = new CountDownLatch(1);
        final CountDownLatch initLatch = new CountDownLatch(1);
        final IgniteInternalFuture readFut = this.multithreadedAsync(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JdbcThinTransactionsAbstractComplexSelfTest.this.executeInTransaction(new TransactionClosure(){

                    public void apply(Connection conn) {
                        List before = JdbcThinTransactionsAbstractComplexSelfTest.flat(JdbcThinTransactionsAbstractComplexSelfTest.this.execute(conn, "SELECT * from \"Person\".Person where id = 1", new Object[0]));
                        JdbcThinTransactionsAbstractComplexSelfTest.assertEqualsCollections((Collection)JdbcThinTransactionsAbstractComplexSelfTest.l(new Object[]{1, "John", "Smith", 1, 1}), (Collection)before);
                        initLatch.countDown();
                        try {
                            U.await((CountDownLatch)repeatableReadLatch);
                        }
                        catch (IgniteInterruptedCheckedException e) {
                            throw new IgniteException((Throwable)e);
                        }
                        List after = JdbcThinTransactionsAbstractComplexSelfTest.flat(JdbcThinTransactionsAbstractComplexSelfTest.this.execute(conn, "SELECT * from \"Person\".Person where id = 1", new Object[0]));
                        JdbcThinTransactionsAbstractComplexSelfTest.assertEqualsCollections((Collection)before, (Collection)after);
                        if (afterReadClo != null) {
                            afterReadClo.apply((Object)conn);
                        }
                    }
                });
                return null;
            }
        }, 1);
        IgniteInternalFuture conModFut = this.multithreadedAsync(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JdbcThinTransactionsAbstractComplexSelfTest.this.executeInTransaction(new TransactionClosure(){

                    public void apply(Connection conn) {
                        try {
                            U.await((CountDownLatch)initLatch);
                        }
                        catch (IgniteInterruptedCheckedException e) {
                            throw new IgniteException((Throwable)e);
                        }
                        concurrentWriteClo.apply((Object)conn);
                        repeatableReadLatch.countDown();
                    }
                });
                return null;
            }
        }, 1);
        conModFut.get();
        if (afterReadClo != null) {
            IgniteCheckedException ex = (IgniteCheckedException)GridTestUtils.assertThrows(null, (Callable)new Callable(){

                public Object call() throws Exception {
                    readFut.get();
                    return null;
                }
            }, IgniteCheckedException.class, (String)"Cannot serialize transaction due to write conflict");
            JdbcThinTransactionsAbstractComplexSelfTest.assertTrue((boolean)X.hasCause((Throwable)ex, (Class[])new Class[]{SQLException.class}));
            JdbcThinTransactionsAbstractComplexSelfTest.assertTrue((boolean)X.getCause((Throwable)ex).getMessage().contains("Cannot serialize transaction due to write conflict"));
        } else {
            readFut.get();
        }
    }

    private void executeInTransaction(TransactionClosure clo) throws SQLException {
        try (Connection conn = this.connect();){
            this.executeInTransaction(conn, clo);
        }
    }

    private void executeInTransaction(Connection conn, TransactionClosure clo) throws SQLException {
        this.begin(conn);
        clo.apply(conn);
        this.commit(conn);
    }

    abstract boolean autoCommit();

    private void begin(Connection c) {
        if (this.autoCommit()) {
            this.execute(c, "BEGIN", new Object[0]);
        }
    }

    private void commit(Connection c) throws SQLException {
        if (this.autoCommit()) {
            this.execute(c, "COMMIT", new Object[0]);
        } else {
            c.commit();
        }
    }

    private void rollback(Connection c) {
        try {
            if (this.autoCommit()) {
                this.execute(c, "ROLLBACK", new Object[0]);
            } else {
                c.rollback();
            }
        }
        catch (SQLException e) {
            throw new IgniteException((Throwable)e);
        }
    }

    List<List<?>> execute(String sql, Object ... args) throws SQLException {
        try (Connection c = this.connect();){
            c.setAutoCommit(true);
            List<List<?>> list = this.execute(c, sql, args);
            return list;
        }
    }

    @Override
    protected List<List<?>> execute(Connection conn, String sql, Object ... args) {
        try {
            return super.execute(conn, sql, args);
        }
        catch (SQLException e) {
            throw new IgniteException((Throwable)e);
        }
    }

    private Connection connect() throws SQLException {
        return this.connect(null);
    }

    private Connection connect(String params) throws SQLException {
        Connection c = this.connect(this.node(), params);
        c.setAutoCommit(false);
        return c;
    }

    @Override
    protected Connection connect(IgniteEx node, String params) {
        try {
            return super.connect(node, params);
        }
        catch (SQLException e) {
            throw new AssertionError((Object)e);
        }
    }

    private IgniteEx node() {
        return this.grid(this.nodeIndex());
    }

    private IgniteCache<Integer, Person> personCache() {
        return this.node().cache("Person");
    }

    abstract int nodeIndex();

    private void insertPerson(final int id, final String firstName, final String lastName, final int cityId, final int companyId) throws SQLException {
        this.executeInTransaction(new TransactionClosure(){

            public void apply(Connection conn) {
                JdbcThinTransactionsAbstractComplexSelfTest.this.insertPerson(conn, id, firstName, lastName, cityId, companyId);
            }
        });
    }

    private void insertPerson(Connection c, int id, String firstName, String lastName, int cityId, int companyId) {
        this.execute(c, "INSERT INTO \"Person\".person (id, firstName, lastName, cityId, companyId) values (?, ?, ?, ?, ?)", id, firstName, lastName, cityId, companyId);
    }

    private void insertCity(final int id, final String name, final int population) throws SQLException {
        this.executeInTransaction(new TransactionClosure(){

            public void apply(Connection conn) {
                JdbcThinTransactionsAbstractComplexSelfTest.this.insertCity(conn, id, name, population);
            }
        });
    }

    private void insertCity(Connection c, int id, String name, int population) {
        this.execute(c, "INSERT INTO city (id, name, population) values (?, ?, ?)", id, name, population);
    }

    private void insertCompany(final int id, final String name, final int cityId) throws SQLException {
        this.executeInTransaction(new TransactionClosure(){

            public void apply(Connection conn) {
                JdbcThinTransactionsAbstractComplexSelfTest.this.insertCompany(conn, id, name, cityId);
            }
        });
    }

    private void insertCompany(Connection c, int id, String name, int cityId) {
        this.execute(c, "INSERT INTO company (id, name, \"cityid\") values (?, ?, ?)", id, name, cityId);
    }

    private void insertProduct(final int id, final String name, final int companyId) throws SQLException {
        this.executeInTransaction(new TransactionClosure(){

            public void apply(Connection conn) {
                JdbcThinTransactionsAbstractComplexSelfTest.this.insertProduct(conn, id, name, companyId);
            }
        });
    }

    private void insertProduct(Connection c, int id, String name, int companyId) {
        this.execute(c, "INSERT INTO product (id, name, companyid) values (?, ?, ?)", id, name, companyId);
    }

    private static List<?> l(Object ... args) {
        return F.asList((Object[])args);
    }

    private static <T> List<T> flat(Collection<? extends Collection<?>> rows) {
        return new ArrayList(F.flatCollections(rows));
    }

    private static abstract class TransactionClosure
    implements IgniteInClosure<Connection> {
        private TransactionClosure() {
        }
    }

    private static final class Person {
        @QuerySqlField
        public int id;
        @QuerySqlField
        public String firstName;
        @QuerySqlField
        public String lastName;

        private Person() {
        }
    }
}

