/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc.thin;

import java.io.File;
import java.io.FileWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.sql.Statement;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.query.annotations.QuerySqlFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.ClientConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.jdbc.thin.JdbcThinConnection;
import org.apache.ignite.jdbc.thin.JdbcThinAbstractDmlStatementSelfTest;
import org.apache.ignite.jdbc.thin.JdbcThinAbstractSelfTest;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class JdbcThinStatementTimeoutSelfTest
extends JdbcThinAbstractSelfTest {
    private static final TcpDiscoveryIpFinder IP_FINDER = new TcpDiscoveryVmIpFinder(true);
    private static final String URL = "jdbc:ignite:thin://127.0.0.1/";
    private static final int SERVER_THREAD_POOL_SIZE = 4;
    private Connection conn;
    private Statement stmt;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        CacheConfiguration cache = JdbcThinStatementTimeoutSelfTest.defaultCacheConfiguration();
        cache.setCacheMode(CacheMode.PARTITIONED);
        cache.setBackups(1);
        cache.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        cache.setSqlFunctionClasses(new Class[]{TestSQLFunctions.class});
        cache.setIndexedTypes(new Class[]{Integer.class, Integer.class, Long.class, Long.class, String.class, JdbcThinAbstractDmlStatementSelfTest.Person.class});
        cfg.setCacheConfiguration(new CacheConfiguration[]{cache});
        TcpDiscoverySpi disco = new TcpDiscoverySpi();
        disco.setIpFinder(IP_FINDER);
        cfg.setDiscoverySpi((DiscoverySpi)disco);
        cfg.setClientConnectorConfiguration(new ClientConnectorConfiguration().setThreadPoolSize(4));
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        int i;
        super.beforeTestsStarted();
        this.startGridsMultiThreaded(3);
        for (i = 0; i < 10000; ++i) {
            this.grid(0).cache("default").put((Object)i, (Object)i);
        }
        for (i = 0; i < 10000; ++i) {
            this.grid(0).cache("default").put((Object)i, (Object)i);
        }
    }

    @Before
    public void before() throws Exception {
        this.conn = DriverManager.getConnection(URL);
        this.conn.setSchema("\"default\"");
        this.stmt = this.conn.createStatement();
        assert (this.stmt != null);
        assert (!this.stmt.isClosed());
    }

    @After
    public void after() throws Exception {
        if (this.stmt != null && !this.stmt.isClosed()) {
            this.stmt.close();
            assert (this.stmt.isClosed());
        }
        this.conn.close();
        assert (this.stmt.isClosed());
        assert (this.conn.isClosed());
    }

    @Test
    public void testSettingNegativeQueryTimeout() {
        GridTestUtils.assertThrows((IgniteLogger)log, () -> {
            this.stmt.setQueryTimeout(-1);
            return null;
        }, SQLException.class, (String)"Invalid timeout value.");
    }

    @Test
    public void testNegativeQueryTimeout() throws SQLException {
        GridTestUtils.assertThrows((IgniteLogger)log, () -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }, SQLException.class, (String)"Property cannot be lower than 0 [name=queryTimeout, value=-1]");
    }

    @Test
    public void testSettingZeroQueryTimeout() throws Exception {
        this.stmt.setQueryTimeout(0);
        this.stmt.executeQuery("select sleep_func(1000);");
    }

    @Test
    public void testZeroQueryTimeout() throws Exception {
        try (Connection conn = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1/?queryTimeout=0");){
            conn.setSchema("\"default\"");
            try (Statement stmt = conn.createStatement();){
                stmt.executeQuery("select sleep_func(1000);");
            }
        }
    }

    private String getInfoFromConnection(JdbcThinConnection conn, int timeout) {
        String cliIoInfo = "";
        cliIoInfo = " [";
        if (conn.nodeId() != null) {
            cliIoInfo = cliIoInfo + "[Node UUID: " + conn.nodeId().toString() + "]";
        }
        if (conn.igniteVersion() != null) {
            cliIoInfo = cliIoInfo + "[Ignite version: " + conn.igniteVersion().toString() + "]";
        }
        cliIoInfo = cliIoInfo + "]";
        return "The query was cancelled while executing due to timeout. Query timeout was : " + timeout + "." + cliIoInfo;
    }

    @Test
    public void testQueryTimeout() throws Exception {
        this.stmt.setQueryTimeout(2);
        GridTestUtils.assertThrows((IgniteLogger)log, () -> {
            this.stmt.executeQuery("select sleep_func(10) from Integer;");
            return null;
        }, SQLTimeoutException.class, (String)this.getInfoFromConnection((JdbcThinConnection)this.stmt.getConnection(), 2));
    }

    @Test
    public void testQueryTimeoutRetrival() throws Exception {
        try (Connection conn = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1/?queryTimeout=5");){
            conn.setSchema("\"default\"");
            try (Statement stmt = conn.createStatement();){
                stmt.executeQuery("select sleep_func(2);");
            }
            stmt = conn.createStatement();
            var4_6 = null;
            try {
                stmt.setQueryTimeout(1);
                GridTestUtils.assertThrows((IgniteLogger)log, () -> {
                    stmt.executeQuery("select sleep_func(2) from Integer;");
                    return null;
                }, SQLTimeoutException.class, (String)this.getInfoFromConnection((JdbcThinConnection)stmt.getConnection(), 1));
            }
            catch (Throwable throwable) {
                var4_6 = throwable;
                throw throwable;
            }
            finally {
                if (stmt != null) {
                    if (var4_6 != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable) {
                            var4_6.addSuppressed(throwable);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
    }

    @Test
    public void testQueryTimeoutRepeatable() throws Exception {
        int queryTimeout = 2;
        this.stmt.setQueryTimeout(2);
        GridTestUtils.assertThrows((IgniteLogger)log, () -> {
            this.stmt.executeQuery("select sleep_func(5) from Integer;");
            return null;
        }, SQLTimeoutException.class, (String)this.getInfoFromConnection((JdbcThinConnection)this.stmt.getConnection(), 2));
        GridTestUtils.assertThrows((IgniteLogger)log, () -> {
            this.stmt.executeQuery("select sleep_func(5) from Integer;");
            return null;
        }, SQLTimeoutException.class, (String)this.getInfoFromConnection((JdbcThinConnection)this.stmt.getConnection(), 2));
        this.stmt.executeQuery("select sleep_func(50)");
    }

    @Test
    public void testFileUploadingTimeout() throws Exception {
        File file = File.createTempFile("bulkload", "csv");
        FileWriter writer = new FileWriter(file);
        for (int i = 1; i <= 1000000; ++i) {
            writer.write(String.format("%d,%d,\"FirstName%d MiddleName%d\",LastName%d", i, i, i, i, i));
        }
        writer.close();
        this.stmt.setQueryTimeout(1);
        GridTestUtils.assertThrows((IgniteLogger)log, () -> {
            this.stmt.executeUpdate("copy from '" + file.getAbsolutePath() + "' into Person (_key, age, firstName, lastName) format csv");
            return null;
        }, SQLTimeoutException.class, (String)this.getInfoFromConnection((JdbcThinConnection)this.stmt.getConnection(), 1));
    }

    @Test
    public void testBatchQuery() throws Exception {
        this.stmt.setQueryTimeout(1);
        GridTestUtils.assertThrows((IgniteLogger)log, () -> {
            this.stmt.addBatch("update Long set _val = _val + 1 where _key < sleep_func (30)");
            this.stmt.addBatch("update Long set _val = _val + 1 where _key > sleep_func (10)");
            this.stmt.executeBatch();
            return null;
        }, SQLTimeoutException.class, (String)this.getInfoFromConnection((JdbcThinConnection)this.stmt.getConnection(), 1));
    }

    @Test
    public void testMultipleStatementsQuery() throws Exception {
        this.stmt.setQueryTimeout(1);
        GridTestUtils.assertThrows((IgniteLogger)log, () -> {
            this.stmt.execute("update Long set _val = _val + 1 where _key > sleep_func (10);update Long set _val = _val + 1 where _key > sleep_func (10);update Long set _val = _val + 1 where _key > sleep_func (10);update Long set _val = _val + 1 where _key > sleep_func (10);select _val, sleep_func(10) as s from Integer limit 10");
            return null;
        }, SQLTimeoutException.class, (String)this.getInfoFromConnection((JdbcThinConnection)this.stmt.getConnection(), 1));
    }

    @Test
    public void testExecuteUpdateTimeout() throws Exception {
        boolean queryTimeout = true;
        this.stmt.setQueryTimeout(1);
        GridTestUtils.assertThrows((IgniteLogger)log, () -> this.stmt.executeUpdate("update Integer set _val=1 where _key > sleep_func(10)"), SQLTimeoutException.class, (String)this.getInfoFromConnection((JdbcThinConnection)this.stmt.getConnection(), 1));
    }

    public static class TestSQLFunctions {
        @QuerySqlFunction
        public static int sleep_func(int v) {
            try {
                Thread.sleep(v);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return v;
        }
    }
}

