/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc.thin;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.concurrent.Callable;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.binary.BinaryInvalidTypeException;
import org.apache.ignite.binary.BinaryObjectBuilder;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.cache.query.annotations.QuerySqlFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.jdbc.thin.JdbcThinAbstractSelfTest;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Ignore;

public class JdbcThinStatementSelfTest
extends JdbcThinAbstractSelfTest {
    private String url = partitionAwareness ? "jdbc:ignite:thin://127.0.0.1:10800..10802?partitionAwareness=true" : "jdbc:ignite:thin://127.0.0.1?partitionAwareness=false";
    private int nodesCnt = partitionAwareness ? 4 : 3;
    private static final String SQL = "select * from Person where age > 30";
    private Connection conn;
    private Statement stmt;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        CacheConfiguration cache = JdbcThinStatementSelfTest.defaultCacheConfiguration();
        cache.setCacheMode(CacheMode.PARTITIONED);
        cache.setBackups(1);
        cache.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        cache.setIndexedTypes(new Class[]{String.class, Person.class, Integer.class, Test.class});
        cfg.setCacheConfiguration(new CacheConfiguration[]{cache});
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGridsMultiThreaded(this.nodesCnt);
        this.fillCache();
    }

    protected void beforeTest() throws Exception {
        this.conn = DriverManager.getConnection(this.url);
        this.conn.setSchema("\"default\"");
        this.stmt = this.conn.createStatement();
        assert (this.stmt != null);
        assert (!this.stmt.isClosed());
    }

    protected void afterTest() throws Exception {
        if (this.stmt != null && !this.stmt.isClosed()) {
            this.stmt.close();
            assert (this.stmt.isClosed());
        }
        this.conn.close();
        assert (this.stmt.isClosed());
        assert (this.conn.isClosed());
    }

    @org.junit.Test
    public void testExecuteQuery0() throws Exception {
        ResultSet rs = this.stmt.executeQuery(SQL);
        JdbcThinStatementSelfTest.assertNotNull((Object)rs);
        int cnt = 0;
        while (rs.next()) {
            int id = rs.getInt("id");
            if (id == 2) {
                JdbcThinStatementSelfTest.assertEquals((String)"Joe", (String)rs.getString("firstName"));
                JdbcThinStatementSelfTest.assertEquals((String)"Black", (String)rs.getString("lastName"));
                JdbcThinStatementSelfTest.assertEquals((int)35, (int)rs.getInt("age"));
            } else if (id == 3) {
                JdbcThinStatementSelfTest.assertEquals((String)"Mike", (String)rs.getString("firstName"));
                JdbcThinStatementSelfTest.assertEquals((String)"Green", (String)rs.getString("lastName"));
                JdbcThinStatementSelfTest.assertEquals((int)40, (int)rs.getInt("age"));
            } else {
                JdbcThinStatementSelfTest.fail((String)("Wrong ID: " + id));
            }
            ++cnt;
        }
        JdbcThinStatementSelfTest.assertEquals((int)2, (int)cnt);
    }

    @org.junit.Test
    public void testExecuteQuery1() throws Exception {
        String sqlText = "select val from test";
        try (ResultSet rs = this.stmt.executeQuery("select val from test");){
            JdbcThinStatementSelfTest.assertNotNull((Object)rs);
            JdbcThinStatementSelfTest.assertTrue((boolean)rs.next());
            int val = rs.getInt(1);
            JdbcThinStatementSelfTest.assertTrue((String)("Invalid val: " + val), (val >= 1 && val <= 10 ? 1 : 0) != 0);
        }
        this.stmt.close();
        this.checkStatementClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                JdbcThinStatementSelfTest.this.stmt.executeQuery("select val from test");
            }
        });
    }

    @org.junit.Test
    public void testExecute() throws Exception {
        JdbcThinStatementSelfTest.assertTrue((boolean)this.stmt.execute(SQL));
        JdbcThinStatementSelfTest.assertEquals((String)"Update count must be -1 for SELECT query", (int)-1, (int)this.stmt.getUpdateCount());
        ResultSet rs = this.stmt.getResultSet();
        JdbcThinStatementSelfTest.assertNotNull((Object)rs);
        int cnt = 0;
        while (rs.next()) {
            int id = rs.getInt("id");
            if (id == 2) {
                JdbcThinStatementSelfTest.assertEquals((String)"Joe", (String)rs.getString("firstName"));
                JdbcThinStatementSelfTest.assertEquals((String)"Black", (String)rs.getString("lastName"));
                JdbcThinStatementSelfTest.assertEquals((int)35, (int)rs.getInt("age"));
            } else if (id == 3) {
                JdbcThinStatementSelfTest.assertEquals((String)"Mike", (String)rs.getString("firstName"));
                JdbcThinStatementSelfTest.assertEquals((String)"Green", (String)rs.getString("lastName"));
                JdbcThinStatementSelfTest.assertEquals((int)40, (int)rs.getInt("age"));
            } else {
                JdbcThinStatementSelfTest.fail((String)("Wrong ID: " + id));
            }
            ++cnt;
        }
        JdbcThinStatementSelfTest.assertEquals((int)2, (int)cnt);
        JdbcThinStatementSelfTest.assertFalse((String)"Statement has more results.", (boolean)this.stmt.getMoreResults());
    }

    @org.junit.Test
    public void testMaxRows() throws Exception {
        int id;
        this.stmt.setMaxRows(1);
        JdbcThinStatementSelfTest.assertEquals((int)1, (int)this.stmt.getMaxRows());
        ResultSet rs = this.stmt.executeQuery(SQL);
        JdbcThinStatementSelfTest.assertNotNull((Object)rs);
        int cnt = 0;
        while (rs.next()) {
            id = rs.getInt("id");
            if (id == 2) {
                JdbcThinStatementSelfTest.assertEquals((String)"Joe", (String)rs.getString("firstName"));
                JdbcThinStatementSelfTest.assertEquals((String)"Black", (String)rs.getString("lastName"));
                JdbcThinStatementSelfTest.assertEquals((int)35, (int)rs.getInt("age"));
            } else if (id == 3) {
                JdbcThinStatementSelfTest.assertEquals((String)"Mike", (String)rs.getString("firstName"));
                JdbcThinStatementSelfTest.assertEquals((String)"Green", (String)rs.getString("lastName"));
                JdbcThinStatementSelfTest.assertEquals((int)40, (int)rs.getInt("age"));
            } else {
                JdbcThinStatementSelfTest.fail((String)("Wrong ID: " + id));
            }
            ++cnt;
        }
        JdbcThinStatementSelfTest.assertEquals((int)1, (int)cnt);
        this.stmt.setMaxRows(0);
        rs = this.stmt.executeQuery(SQL);
        JdbcThinStatementSelfTest.assertNotNull((Object)rs);
        cnt = 0;
        while (rs.next()) {
            id = rs.getInt("id");
            if (id == 2) {
                JdbcThinStatementSelfTest.assertEquals((String)"Joe", (String)rs.getString("firstName"));
                JdbcThinStatementSelfTest.assertEquals((String)"Black", (String)rs.getString("lastName"));
                JdbcThinStatementSelfTest.assertEquals((int)35, (int)rs.getInt("age"));
            } else if (id == 3) {
                JdbcThinStatementSelfTest.assertEquals((String)"Mike", (String)rs.getString("firstName"));
                JdbcThinStatementSelfTest.assertEquals((String)"Green", (String)rs.getString("lastName"));
                JdbcThinStatementSelfTest.assertEquals((int)40, (int)rs.getInt("age"));
            } else {
                JdbcThinStatementSelfTest.fail((String)("Wrong ID: " + id));
            }
            ++cnt;
        }
        JdbcThinStatementSelfTest.assertEquals((int)2, (int)cnt);
    }

    @org.junit.Test
    public void testCloseResultSet0() throws Exception {
        ResultSet rs0 = this.stmt.executeQuery(SQL);
        ResultSet rs1 = this.stmt.executeQuery(SQL);
        ResultSet rs2 = this.stmt.executeQuery(SQL);
        JdbcThinStatementSelfTest.assertTrue((String)"ResultSet must be implicitly closed after re-execute statement", (boolean)rs0.isClosed());
        JdbcThinStatementSelfTest.assertTrue((String)"ResultSet must be implicitly closed after re-execute statement", (boolean)rs1.isClosed());
        JdbcThinStatementSelfTest.assertFalse((String)"Last result set must be available", (boolean)rs2.isClosed());
        this.stmt.close();
        JdbcThinStatementSelfTest.assertTrue((String)"ResultSet must be explicitly closed after close statement", (boolean)rs2.isClosed());
    }

    @org.junit.Test
    public void testCloseResultSet1() throws Exception {
        this.stmt.execute(SQL);
        ResultSet rs = this.stmt.getResultSet();
        this.stmt.close();
        JdbcThinStatementSelfTest.assertTrue((String)"ResultSet must be explicitly closed after close statement", (boolean)rs.isClosed());
    }

    @org.junit.Test
    public void testCloseResultSetByConnectionClose() throws Exception {
        ResultSet rs = this.stmt.executeQuery(SQL);
        this.conn.close();
        JdbcThinStatementSelfTest.assertTrue((String)"Statement must be implicitly closed after close connection", (boolean)this.stmt.isClosed());
        JdbcThinStatementSelfTest.assertTrue((String)"ResultSet must be implicitly closed after close connection", (boolean)rs.isClosed());
    }

    @org.junit.Test
    public void testCloseOnCompletionAfterQuery() throws Exception {
        JdbcThinStatementSelfTest.assertFalse((String)"Invalid default closeOnCompletion", (boolean)this.stmt.isCloseOnCompletion());
        ResultSet rs0 = this.stmt.executeQuery(SQL);
        ResultSet rs1 = this.stmt.executeQuery(SQL);
        JdbcThinStatementSelfTest.assertTrue((String)"Result set must be closed implicitly", (boolean)rs0.isClosed());
        JdbcThinStatementSelfTest.assertFalse((String)"Statement must not be closed", (boolean)this.stmt.isClosed());
        rs1.close();
        JdbcThinStatementSelfTest.assertFalse((String)"Statement must not be closed", (boolean)this.stmt.isClosed());
        ResultSet rs2 = this.stmt.executeQuery(SQL);
        this.stmt.closeOnCompletion();
        JdbcThinStatementSelfTest.assertTrue((String)"Invalid closeOnCompletion", (boolean)this.stmt.isCloseOnCompletion());
        rs2.close();
        JdbcThinStatementSelfTest.assertTrue((String)"Statement must be closed", (boolean)this.stmt.isClosed());
    }

    @org.junit.Test
    public void testCloseOnCompletionBeforeQuery() throws Exception {
        JdbcThinStatementSelfTest.assertFalse((String)"Invalid default closeOnCompletion", (boolean)this.stmt.isCloseOnCompletion());
        ResultSet rs0 = this.stmt.executeQuery(SQL);
        ResultSet rs1 = this.stmt.executeQuery(SQL);
        JdbcThinStatementSelfTest.assertTrue((String)"Result set must be closed implicitly", (boolean)rs0.isClosed());
        JdbcThinStatementSelfTest.assertFalse((String)"Statement must not be closed", (boolean)this.stmt.isClosed());
        rs1.close();
        JdbcThinStatementSelfTest.assertFalse((String)"Statement must not be closed", (boolean)this.stmt.isClosed());
        this.stmt.closeOnCompletion();
        ResultSet rs2 = this.stmt.executeQuery(SQL);
        JdbcThinStatementSelfTest.assertTrue((String)"Invalid closeOnCompletion", (boolean)this.stmt.isCloseOnCompletion());
        rs2.close();
        JdbcThinStatementSelfTest.assertTrue((String)"Statement must be closed", (boolean)this.stmt.isClosed());
    }

    @org.junit.Test
    public void testExecuteQueryMultipleOnlyResultSets() throws Exception {
        int i;
        JdbcThinStatementSelfTest.assertTrue((boolean)this.conn.getMetaData().supportsMultipleResultSets());
        int stmtCnt = 10;
        StringBuilder sql = new StringBuilder();
        for (i = 0; i < stmtCnt; ++i) {
            sql.append("select ").append(i).append("; ");
        }
        JdbcThinStatementSelfTest.assertTrue((boolean)this.stmt.execute(sql.toString()));
        for (i = 0; i < stmtCnt - 1; ++i) {
            ResultSet rs = this.stmt.getResultSet();
            JdbcThinStatementSelfTest.assertTrue((boolean)rs.next());
            JdbcThinStatementSelfTest.assertEquals((int)i, (int)rs.getInt(1));
            JdbcThinStatementSelfTest.assertFalse((boolean)rs.next());
            JdbcThinStatementSelfTest.assertTrue((boolean)this.stmt.getMoreResults());
        }
        ResultSet rs = this.stmt.getResultSet();
        JdbcThinStatementSelfTest.assertTrue((boolean)rs.next());
        JdbcThinStatementSelfTest.assertEquals((int)(stmtCnt - 1), (int)rs.getInt(1));
        JdbcThinStatementSelfTest.assertFalse((boolean)rs.next());
        JdbcThinStatementSelfTest.assertFalse((boolean)this.stmt.getMoreResults());
    }

    @org.junit.Test
    public void testExecuteQueryMultipleOnlyDml() throws Exception {
        int i;
        this.conn.setSchema(null);
        Statement stmt0 = this.conn.createStatement();
        int stmtCnt = 10;
        StringBuilder sql = new StringBuilder("drop table if exists test; create table test(ID int primary key, NAME varchar(20)); ");
        for (i = 0; i < stmtCnt; ++i) {
            sql.append("insert into test (ID, NAME) values (" + i + ", 'name_" + i + "'); ");
        }
        JdbcThinStatementSelfTest.assertFalse((boolean)stmt0.execute(sql.toString()));
        JdbcThinStatementSelfTest.assertNull((Object)stmt0.getResultSet());
        JdbcThinStatementSelfTest.assertEquals((int)0, (int)stmt0.getUpdateCount());
        stmt0.getMoreResults();
        JdbcThinStatementSelfTest.assertNull((Object)stmt0.getResultSet());
        JdbcThinStatementSelfTest.assertEquals((int)0, (int)stmt0.getUpdateCount());
        for (i = 0; i < stmtCnt; ++i) {
            JdbcThinStatementSelfTest.assertTrue((boolean)stmt0.getMoreResults());
            JdbcThinStatementSelfTest.assertNull((Object)stmt0.getResultSet());
            JdbcThinStatementSelfTest.assertEquals((int)1, (int)stmt0.getUpdateCount());
        }
        JdbcThinStatementSelfTest.assertFalse((boolean)stmt0.getMoreResults());
    }

    @org.junit.Test
    public void testExecuteQueryMultipleMixed() throws Exception {
        this.conn.setSchema(null);
        Statement stmt0 = this.conn.createStatement();
        int stmtCnt = 10;
        StringBuilder sql = new StringBuilder("drop table if exists test; create table test(ID int primary key, NAME varchar(20)); ");
        for (int i = 0; i < stmtCnt; ++i) {
            if (i % 2 == 0) {
                sql.append(" insert into test (ID, NAME) values (" + i + ", 'name_" + i + "'); ");
                continue;
            }
            sql.append(" select * from test where id < " + i + "; ");
        }
        JdbcThinStatementSelfTest.assertFalse((boolean)stmt0.execute(sql.toString()));
        JdbcThinStatementSelfTest.assertNull((Object)stmt0.getResultSet());
        JdbcThinStatementSelfTest.assertEquals((int)0, (int)stmt0.getUpdateCount());
        JdbcThinStatementSelfTest.assertTrue((String)"Result set doesn't have more results.", (boolean)stmt0.getMoreResults());
        JdbcThinStatementSelfTest.assertNull((Object)stmt0.getResultSet());
        JdbcThinStatementSelfTest.assertEquals((int)0, (int)stmt0.getUpdateCount());
        boolean notEmptyResult = false;
        for (int i = 0; i < stmtCnt; ++i) {
            JdbcThinStatementSelfTest.assertTrue((boolean)stmt0.getMoreResults());
            if (i % 2 == 0) {
                JdbcThinStatementSelfTest.assertNull((Object)stmt0.getResultSet());
                JdbcThinStatementSelfTest.assertEquals((int)1, (int)stmt0.getUpdateCount());
                continue;
            }
            JdbcThinStatementSelfTest.assertEquals((int)-1, (int)stmt0.getUpdateCount());
            ResultSet rs = stmt0.getResultSet();
            int rowsCnt = 0;
            while (rs.next()) {
                ++rowsCnt;
            }
            JdbcThinStatementSelfTest.assertTrue((rowsCnt <= (i + 1) / 2 ? 1 : 0) != 0);
            if (rowsCnt != (i + 1) / 2) continue;
            notEmptyResult = true;
        }
        JdbcThinStatementSelfTest.assertTrue((boolean)notEmptyResult);
        JdbcThinStatementSelfTest.assertFalse((boolean)stmt0.getMoreResults());
    }

    @org.junit.Test
    public void testExecuteUpdate() throws Exception {
        String sqlText = "update test set val=1 where _key=1";
        JdbcThinStatementSelfTest.assertEquals((int)1, (int)this.stmt.executeUpdate("update test set val=1 where _key=1"));
        this.stmt.close();
        this.checkStatementClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                JdbcThinStatementSelfTest.this.stmt.executeUpdate("update test set val=1 where _key=1");
            }
        });
    }

    @org.junit.Test
    public void testExecuteUpdateProducesResultSet() throws Exception {
        String sqlText = "select * from test";
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return JdbcThinStatementSelfTest.this.stmt.executeUpdate("select * from test");
            }
        }, SQLException.class, (String)"Given statement type does not match that declared by JDBC driver");
    }

    @org.junit.Test
    public void testClose() throws Exception {
        String sqlText = "select * from test";
        ResultSet rs = this.stmt.executeQuery(sqlText);
        JdbcThinStatementSelfTest.assertTrue((boolean)rs.next());
        JdbcThinStatementSelfTest.assertFalse((boolean)rs.isClosed());
        JdbcThinStatementSelfTest.assertFalse((boolean)this.stmt.isClosed());
        this.stmt.close();
        this.stmt.close();
        JdbcThinStatementSelfTest.assertTrue((boolean)this.stmt.isClosed());
        JdbcThinStatementSelfTest.assertTrue((boolean)rs.isClosed());
    }

    @org.junit.Test
    public void testGetSetMaxFieldSizeUnsupported() throws Exception {
        JdbcThinStatementSelfTest.assertEquals((int)0, (int)this.stmt.getMaxFieldSize());
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JdbcThinStatementSelfTest.this.stmt.setMaxFieldSize(100);
                return null;
            }
        }, SQLFeatureNotSupportedException.class, (String)"Field size limitation is not supported");
        JdbcThinStatementSelfTest.assertEquals((int)0, (int)this.stmt.getMaxFieldSize());
        this.stmt.close();
        this.checkStatementClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                JdbcThinStatementSelfTest.this.stmt.getMaxFieldSize();
            }
        });
        this.checkStatementClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                JdbcThinStatementSelfTest.this.stmt.setMaxFieldSize(100);
            }
        });
    }

    @org.junit.Test
    public void testGetSetMaxRows() throws Exception {
        JdbcThinStatementSelfTest.assertEquals((int)0, (int)this.stmt.getMaxRows());
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JdbcThinStatementSelfTest.this.stmt.setMaxRows(-1);
                return null;
            }
        }, SQLException.class, (String)"Invalid max rows value");
        JdbcThinStatementSelfTest.assertEquals((int)0, (int)this.stmt.getMaxRows());
        boolean maxRows = true;
        this.stmt.setMaxRows(1);
        JdbcThinStatementSelfTest.assertEquals((int)1, (int)this.stmt.getMaxRows());
        String sqlText = "select * from test";
        ResultSet rs = this.stmt.executeQuery(sqlText);
        JdbcThinStatementSelfTest.assertTrue((boolean)rs.next());
        JdbcThinStatementSelfTest.assertFalse((boolean)rs.next());
        this.stmt.close();
        this.checkStatementClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                JdbcThinStatementSelfTest.this.stmt.getMaxRows();
            }
        });
        this.checkStatementClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                JdbcThinStatementSelfTest.this.stmt.setMaxRows(1);
            }
        });
    }

    @org.junit.Test
    @Ignore(value="https://issues.apache.org/jira/browse/IGNITE-5440")
    public void testSetEscapeProcessing() throws Exception {
        this.stmt.setEscapeProcessing(false);
        String sqlText = "select {fn CONVERT(1, SQL_BOOLEAN)}";
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return JdbcThinStatementSelfTest.this.stmt.executeQuery("select {fn CONVERT(1, SQL_BOOLEAN)}");
            }
        }, SQLException.class, (String)"Failed to parse");
        ResultSet rs = this.stmt.executeQuery("select {fn CONVERT(1, SQL_BOOLEAN)}");
        JdbcThinStatementSelfTest.assertTrue((boolean)rs.next());
        JdbcThinStatementSelfTest.assertEquals((boolean)true, (boolean)rs.getBoolean(1));
        this.stmt.setEscapeProcessing(true);
        this.stmt.close();
        this.checkStatementClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                JdbcThinStatementSelfTest.this.stmt.setEscapeProcessing(true);
            }
        });
    }

    @org.junit.Test
    public void testGetSetQueryTimeout() throws Exception {
        JdbcThinStatementSelfTest.assertEquals((int)0, (int)this.stmt.getQueryTimeout());
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JdbcThinStatementSelfTest.this.stmt.setQueryTimeout(-1);
                return null;
            }
        }, SQLException.class, (String)"Invalid timeout value");
        JdbcThinStatementSelfTest.assertEquals((int)0, (int)this.stmt.getQueryTimeout());
        int timeout = 3;
        this.stmt.setQueryTimeout(3);
        JdbcThinStatementSelfTest.assertEquals((int)3, (int)this.stmt.getQueryTimeout());
        this.stmt.close();
        this.checkStatementClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                JdbcThinStatementSelfTest.this.stmt.getQueryTimeout();
            }
        });
        this.checkStatementClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                JdbcThinStatementSelfTest.this.stmt.setQueryTimeout(3);
            }
        });
    }

    @org.junit.Test
    public void testMaxFieldSize() throws Exception {
        JdbcThinStatementSelfTest.assertTrue((this.stmt.getMaxFieldSize() >= 0 ? 1 : 0) != 0);
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JdbcThinStatementSelfTest.this.stmt.setMaxFieldSize(-1);
                return null;
            }
        }, SQLException.class, (String)"Invalid field limit");
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                JdbcThinStatementSelfTest.this.stmt.setMaxFieldSize(100);
            }
        });
    }

    @org.junit.Test
    public void testQueryTimeout() throws Exception {
        JdbcThinStatementSelfTest.assertEquals((String)("Default timeout invalid: " + this.stmt.getQueryTimeout()), (int)0, (int)this.stmt.getQueryTimeout());
        this.stmt.setQueryTimeout(10);
        JdbcThinStatementSelfTest.assertEquals((int)10, (int)this.stmt.getQueryTimeout());
        this.stmt.close();
        this.checkStatementClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                JdbcThinStatementSelfTest.this.stmt.getQueryTimeout();
            }
        });
        this.checkStatementClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                JdbcThinStatementSelfTest.this.stmt.setQueryTimeout(10);
            }
        });
    }

    @org.junit.Test
    public void testWarningsOnClosedStatement() throws Exception {
        this.stmt.clearWarnings();
        JdbcThinStatementSelfTest.assertNull(null, (Object)this.stmt.getWarnings());
        this.stmt.close();
        this.checkStatementClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                JdbcThinStatementSelfTest.this.stmt.getWarnings();
            }
        });
        this.checkStatementClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                JdbcThinStatementSelfTest.this.stmt.clearWarnings();
            }
        });
    }

    @org.junit.Test
    public void testCursorName() throws Exception {
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                JdbcThinStatementSelfTest.this.stmt.setCursorName("test");
            }
        });
        this.stmt.close();
        this.checkStatementClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                JdbcThinStatementSelfTest.this.stmt.setCursorName("test");
            }
        });
    }

    @org.junit.Test
    public void testGetMoreResults() throws Exception {
        JdbcThinStatementSelfTest.assertFalse((boolean)this.stmt.getMoreResults());
        this.stmt.execute("select 1; ");
        ResultSet rs = this.stmt.getResultSet();
        JdbcThinStatementSelfTest.assertFalse((boolean)this.stmt.getMoreResults());
        JdbcThinStatementSelfTest.assertNull((Object)this.stmt.getResultSet());
        JdbcThinStatementSelfTest.assertTrue((boolean)rs.isClosed());
        this.stmt.close();
        this.checkStatementClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                JdbcThinStatementSelfTest.this.stmt.getMoreResults();
            }
        });
    }

    @org.junit.Test
    public void testGetMoreResultsKeepCurrent() throws Exception {
        JdbcThinStatementSelfTest.assertFalse((boolean)this.stmt.getMoreResults(1));
        JdbcThinStatementSelfTest.assertFalse((boolean)this.stmt.getMoreResults(2));
        JdbcThinStatementSelfTest.assertFalse((boolean)this.stmt.getMoreResults(3));
        this.stmt.execute("select 1; ");
        ResultSet rs = this.stmt.getResultSet();
        JdbcThinStatementSelfTest.assertFalse((boolean)this.stmt.getMoreResults(2));
        JdbcThinStatementSelfTest.assertFalse((boolean)rs.isClosed());
        this.stmt.close();
        this.checkStatementClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                JdbcThinStatementSelfTest.this.stmt.getMoreResults(2);
            }
        });
    }

    @org.junit.Test
    public void testGetMoreResultsCloseAll() throws Exception {
        JdbcThinStatementSelfTest.assertFalse((boolean)this.stmt.getMoreResults(1));
        JdbcThinStatementSelfTest.assertFalse((boolean)this.stmt.getMoreResults(2));
        JdbcThinStatementSelfTest.assertFalse((boolean)this.stmt.getMoreResults(3));
        this.stmt.execute("select 1; ");
        ResultSet rs = this.stmt.getResultSet();
        JdbcThinStatementSelfTest.assertFalse((boolean)this.stmt.getMoreResults(3));
        this.stmt.close();
        this.checkStatementClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                JdbcThinStatementSelfTest.this.stmt.getMoreResults(2);
            }
        });
    }

    @org.junit.Test
    public void testBatchEmpty() throws Exception {
        JdbcThinStatementSelfTest.assertTrue((boolean)this.conn.getMetaData().supportsBatchUpdates());
        this.stmt.addBatch("");
        this.stmt.clearBatch();
        this.stmt.executeBatch();
    }

    @org.junit.Test
    public void testFetchDirection() throws Exception {
        JdbcThinStatementSelfTest.assertEquals((int)1000, (int)this.stmt.getFetchDirection());
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JdbcThinStatementSelfTest.this.stmt.setFetchDirection(1001);
                return null;
            }
        }, SQLFeatureNotSupportedException.class, (String)"Only forward direction is supported.");
        this.stmt.close();
        this.checkStatementClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                JdbcThinStatementSelfTest.this.stmt.setFetchDirection(-1);
            }
        });
        this.checkStatementClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                JdbcThinStatementSelfTest.this.stmt.getFetchDirection();
            }
        });
    }

    @org.junit.Test
    public void testAutogenerated() throws Exception {
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JdbcThinStatementSelfTest.this.stmt.executeUpdate("select 1", -1);
                return null;
            }
        }, SQLException.class, (String)"Invalid autoGeneratedKeys value");
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JdbcThinStatementSelfTest.this.stmt.execute("select 1", -1);
                return null;
            }
        }, SQLException.class, (String)"Invalid autoGeneratedKeys value");
        JdbcThinStatementSelfTest.assertFalse((boolean)this.conn.getMetaData().supportsGetGeneratedKeys());
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                JdbcThinStatementSelfTest.this.stmt.getGeneratedKeys();
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                JdbcThinStatementSelfTest.this.stmt.executeUpdate("select 1", 1);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                JdbcThinStatementSelfTest.this.stmt.executeUpdate("select 1", new int[]{1, 2});
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                JdbcThinStatementSelfTest.this.stmt.executeUpdate("select 1", new String[]{"a", "b"});
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                JdbcThinStatementSelfTest.this.stmt.execute("select 1", 1);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                JdbcThinStatementSelfTest.this.stmt.execute("select 1", new int[]{1, 2});
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                JdbcThinStatementSelfTest.this.stmt.execute("select 1", new String[]{"a", "b"});
            }
        });
    }

    @org.junit.Test
    public void testStatementTypeMismatchSelectForCachedQuery() throws Exception {
        this.stmt.executeQuery("select 1;");
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JdbcThinStatementSelfTest.this.stmt.executeUpdate("select 1;");
                return null;
            }
        }, SQLException.class, (String)"Given statement type does not match that declared by JDBC driver");
        JdbcThinStatementSelfTest.assertNull((String)"Not results expected. Last statement is executed with exception", (Object)this.stmt.getResultSet());
    }

    @org.junit.Test
    public void testStatementTypeMismatchUpdate() throws Exception {
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JdbcThinStatementSelfTest.this.stmt.executeQuery("update test set val=28 where _key=1");
                return null;
            }
        }, SQLException.class, (String)"Given statement type does not match that declared by JDBC driver");
        ResultSet rs = this.stmt.executeQuery("select val from test where _key=1");
        boolean next = rs.next();
        JdbcThinStatementSelfTest.assertTrue((boolean)next);
        JdbcThinStatementSelfTest.assertEquals((String)("The data must not be updated. Because update statement is executed via 'executeQuery' method. Data [val=" + rs.getInt(1) + ']'), (int)1, (int)rs.getInt(1));
    }

    @org.junit.Test
    public void testExceptionOnDeserializeResponse() throws SQLException {
        try (Connection c = this.connect(this.grid(0), null);){
            this.execute(c, "CREATE TABLE TEST_DESERIALIZE(id int primary key, name varchar, BINFIELD OTHER) WITH \"cache_name=TEST_DESERIALIZE,VALUE_TYPE=TEST_TYPE\"", new Object[0]);
            IgniteCache cc = this.grid(0).cache("TEST_DESERIALIZE");
            BinaryObjectBuilder bobFld = this.grid(0).binary().builder("TestType");
            bobFld.setField("fld0", (Object)0);
            BinaryObjectBuilder bob = this.grid(0).binary().builder("TEST_TYPE");
            bob.setField("NAME", (Object)"name0");
            bob.setField("BINFIELD", (Object)bobFld.build());
            cc.put((Object)0, (Object)bob.build());
            try (Statement stmt = c.createStatement();){
                SQLException ex = (SQLException)GridTestUtils.assertThrows((IgniteLogger)log, () -> stmt.executeQuery("SELECT * FROM TEST_DESERIALIZE"), SQLException.class, (String)"Serialization error during sending an sql request");
                JdbcThinStatementSelfTest.assertEquals((String)"22000", (String)ex.getSQLState());
                JdbcThinStatementSelfTest.assertTrue((boolean)X.hasCause((Throwable)ex, (String)"TestType", (Class[])new Class[]{BinaryInvalidTypeException.class}));
                ResultSet rs = stmt.executeQuery("SELECT id FROM TEST_DESERIALIZE");
                rs.next();
                JdbcThinStatementSelfTest.assertEquals((int)0, (int)rs.getInt(1));
            }
        }
    }

    private void fillCache() {
        IgniteCache cachePerson = this.grid(0).cache("default");
        JdbcThinStatementSelfTest.assertNotNull((Object)cachePerson);
        cachePerson.put((Object)"p1", (Object)new Person(1, "John", "White", 25));
        cachePerson.put((Object)"p2", (Object)new Person(2, "Joe", "Black", 35));
        cachePerson.put((Object)"p3", (Object)new Person(3, "Mike", "Green", 40));
        IgniteCache cacheTest = this.grid(0).cache("default");
        for (int i = 1; i <= 10; ++i) {
            cacheTest.put((Object)i, (Object)new Test(i));
        }
    }

    @QuerySqlFunction
    public static int sleep_func(int v) {
        try {
            Thread.sleep(v * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return v;
    }

    private static class Person
    implements Serializable {
        @QuerySqlField
        private final int id;
        @QuerySqlField
        private final String firstName;
        @QuerySqlField
        private final String lastName;
        @QuerySqlField
        private final int age;

        private Person(int id, String firstName, String lastName, int age) {
            assert (!F.isEmpty((String)firstName));
            assert (!F.isEmpty((String)lastName));
            assert (age > 0);
            this.id = id;
            this.firstName = firstName;
            this.lastName = lastName;
            this.age = age;
        }
    }

    public static class Test {
        @QuerySqlField
        private int val;

        public Test(int val) {
            this.val = val;
        }
    }
}

