/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc.thin;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.concurrent.Callable;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.jdbc.thin.JdbcThinAbstractSelfTest;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class JdbcThinResultSetSelfTest
extends JdbcThinAbstractSelfTest {
    private static final String URL = "jdbc:ignite:thin://127.0.0.1/";
    private static final String SQL = "select id, boolVal, byteVal, shortVal, intVal, longVal, floatVal, doubleVal, bigVal, strVal, arrVal, dateVal, timeVal, tsVal, objVal from TestObject where id = 1";
    private Statement stmt;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        CacheConfiguration cache = JdbcThinResultSetSelfTest.defaultCacheConfiguration();
        cache.setCacheMode(CacheMode.PARTITIONED);
        cache.setBackups(1);
        cache.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        cache.setIndexedTypes(new Class[]{Integer.class, TestObject.class});
        cfg.setCacheConfiguration(new CacheConfiguration[]{cache});
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGridsMultiThreaded(3);
        IgniteCache cache = this.grid(0).cache("default");
        assert (cache != null);
        TestObject o = this.createObjectWithData(1);
        cache.put((Object)1, (Object)o);
        cache.put((Object)2, (Object)new TestObject(2));
    }

    protected void beforeTest() throws Exception {
        Connection conn = DriverManager.getConnection(URL);
        conn.setSchema("\"default\"");
        this.stmt = conn.createStatement();
        assert (this.stmt != null);
        assert (!this.stmt.isClosed());
    }

    protected void afterTest() throws Exception {
        if (this.stmt != null) {
            this.stmt.getConnection().close();
            this.stmt.close();
            assert (this.stmt.isClosed());
        }
    }

    private TestObject createObjectWithData(int id) throws MalformedURLException {
        TestObject o = new TestObject(id);
        o.boolVal = true;
        o.byteVal = (byte)1;
        o.shortVal = (short)1;
        o.intVal = 1;
        o.longVal = 1L;
        o.floatVal = Float.valueOf(1.0f);
        o.doubleVal = 1.0;
        o.bigVal = new BigDecimal(1);
        o.strVal = "1";
        TestObject.access$1002(o, new byte[]{1});
        o.dateVal = new Date(1, 1, 1);
        o.timeVal = new Time(1, 1, 1);
        o.tsVal = new Timestamp(1L);
        o.urlVal = new URL("http://abc.com/");
        return o;
    }

    @Test
    public void testBoolean() throws Exception {
        ResultSet rs = this.stmt.executeQuery(SQL);
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) {
                assert (rs.getBoolean("boolVal"));
                assert (rs.getBoolean(2));
                assert (rs.getByte(2) == 1);
                assert (rs.getInt(2) == 1);
                assert (rs.getShort(2) == 1);
                assert (rs.getLong(2) == 1L);
                assert (rs.getDouble(2) == 1.0);
                assert (rs.getFloat(2) == 1.0f);
                assert (rs.getBigDecimal(2).equals(new BigDecimal(1)));
                assert (rs.getString(2).equals("true"));
                assert (rs.getObject(2, Boolean.class).booleanValue());
                assert (rs.getObject(2, Byte.class) == 1);
                assert (rs.getObject(2, Short.class) == 1);
                assert (rs.getObject(2, Integer.class) == 1);
                assert (rs.getObject(2, Long.class) == 1L);
                assert (rs.getObject(2, Float.class).floatValue() == 1.0f);
                assert (rs.getObject(2, Double.class) == 1.0);
                assert (rs.getObject(2, BigDecimal.class).equals(new BigDecimal(1)));
                assert (rs.getObject(2, String.class).equals("true"));
            }
            ++cnt;
        }
        assert (cnt == 1);
        ResultSet rs0 = this.stmt.executeQuery("select 1");
        assert (rs0.next());
        assert (rs0.getBoolean(1));
        rs0 = this.stmt.executeQuery("select 0");
        assert (rs0.next());
        assert (!rs0.getBoolean(1));
        rs0 = this.stmt.executeQuery("select '1'");
        assert (rs0.next());
        assert (rs0.getBoolean(1));
        rs0 = this.stmt.executeQuery("select '0'");
        assert (rs0.next());
        assert (!rs0.getBoolean(1));
        GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ResultSet rs0 = JdbcThinResultSetSelfTest.this.stmt.executeQuery("select ''");
                assert (rs0.next());
                assert (rs0.getBoolean(1));
                return null;
            }
        }, SQLException.class, (String)"Cannot convert to boolean: ");
        GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ResultSet rs0 = JdbcThinResultSetSelfTest.this.stmt.executeQuery("select 'qwe'");
                assert (rs0.next());
                assert (rs0.getBoolean(1));
                return null;
            }
        }, SQLException.class, (String)"Cannot convert to boolean: qwe");
    }

    @Test
    public void testByte() throws Exception {
        ResultSet rs = this.stmt.executeQuery(SQL);
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) {
                assert (rs.getByte("byteVal") == 1);
                assert (rs.getBoolean(3));
                assert (rs.getByte(3) == 1);
                assert (rs.getInt(3) == 1);
                assert (rs.getShort(3) == 1);
                assert (rs.getLong(3) == 1L);
                assert (rs.getDouble(3) == 1.0);
                assert (rs.getFloat(3) == 1.0f);
                assert (rs.getBigDecimal(3).equals(new BigDecimal(1)));
                assert (rs.getString(3).equals("1"));
                assert (rs.getObject(3, Boolean.class).booleanValue());
                assert (rs.getObject(3, Byte.class) == 1);
                assert (rs.getObject(3, Short.class) == 1);
                assert (rs.getObject(3, Integer.class) == 1);
                assert (rs.getObject(3, Long.class) == 1L);
                assert (rs.getObject(3, Float.class).floatValue() == 1.0f);
                assert (rs.getObject(3, Double.class) == 1.0);
                assert (rs.getObject(3, BigDecimal.class).equals(new BigDecimal(1)));
                assert (rs.getObject(3, String.class).equals("1"));
            }
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testShort() throws Exception {
        ResultSet rs = this.stmt.executeQuery(SQL);
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) {
                assert (rs.getShort("shortVal") == 1);
                assert (rs.getBoolean(4));
                assert (rs.getByte(4) == 1);
                assert (rs.getShort(4) == 1);
                assert (rs.getInt(4) == 1);
                assert (rs.getLong(4) == 1L);
                assert (rs.getDouble(4) == 1.0);
                assert (rs.getFloat(4) == 1.0f);
                assert (rs.getBigDecimal(4).equals(new BigDecimal(1)));
                assert (rs.getString(4).equals("1"));
                assert (rs.getObject(4, Boolean.class).booleanValue());
                assert (rs.getObject(4, Byte.class) == 1);
                assert (rs.getObject(4, Short.class) == 1);
                assert (rs.getObject(4, Integer.class) == 1);
                assert (rs.getObject(4, Long.class) == 1L);
                assert (rs.getObject(4, Float.class).floatValue() == 1.0f);
                assert (rs.getObject(4, Double.class) == 1.0);
                assert (rs.getObject(4, BigDecimal.class).equals(new BigDecimal(1)));
                assert (rs.getObject(4, String.class).equals("1"));
            }
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testInteger() throws Exception {
        ResultSet rs = this.stmt.executeQuery(SQL);
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) {
                assert (rs.getInt("intVal") == 1);
                assert (rs.getBoolean(5));
                assert (rs.getByte(5) == 1);
                assert (rs.getShort(5) == 1);
                assert (rs.getInt(5) == 1);
                assert (rs.getLong(5) == 1L);
                assert (rs.getDouble(5) == 1.0);
                assert (rs.getFloat(5) == 1.0f);
                assert (rs.getBigDecimal(5).equals(new BigDecimal(1)));
                assert (rs.getString(5).equals("1"));
                assert (rs.getObject(5, Boolean.class).booleanValue());
                assert (rs.getObject(5, Byte.class) == 1);
                assert (rs.getObject(5, Short.class) == 1);
                assert (rs.getObject(5, Integer.class) == 1);
                assert (rs.getObject(5, Long.class) == 1L);
                assert (rs.getObject(5, Float.class).floatValue() == 1.0f);
                assert (rs.getObject(5, Double.class) == 1.0);
                assert (rs.getObject(5, BigDecimal.class).equals(new BigDecimal(1)));
                assert (rs.getObject(5, String.class).equals("1"));
            }
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testLong() throws Exception {
        ResultSet rs = this.stmt.executeQuery(SQL);
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) {
                assert (rs.getLong("longVal") == 1L);
                assert (rs.getBoolean(6));
                assert (rs.getByte(6) == 1);
                assert (rs.getShort(6) == 1);
                assert (rs.getInt(6) == 1);
                assert (rs.getLong(6) == 1L);
                assert (rs.getDouble(6) == 1.0);
                assert (rs.getFloat(6) == 1.0f);
                assert (rs.getBigDecimal(6).equals(new BigDecimal(1)));
                assert (rs.getString(6).equals("1"));
                assert (rs.getObject(6, Boolean.class).booleanValue());
                assert (rs.getObject(6, Byte.class) == 1);
                assert (rs.getObject(6, Short.class) == 1);
                assert (rs.getObject(6, Integer.class) == 1);
                assert (rs.getObject(6, Long.class) == 1L);
                assert (rs.getObject(6, Float.class).floatValue() == 1.0f);
                assert (rs.getObject(6, Double.class) == 1.0);
                assert (rs.getObject(6, BigDecimal.class).equals(new BigDecimal(1)));
                assert (rs.getObject(6, String.class).equals("1"));
            }
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testFloat() throws Exception {
        ResultSet rs = this.stmt.executeQuery(SQL);
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) {
                assert ((double)rs.getFloat("floatVal") == 1.0);
                assert (rs.getBoolean(7));
                assert (rs.getByte(7) == 1);
                assert (rs.getShort(7) == 1);
                assert (rs.getInt(7) == 1);
                assert (rs.getLong(7) == 1L);
                assert (rs.getDouble(7) == 1.0);
                assert (rs.getFloat(7) == 1.0f);
                assert (rs.getBigDecimal(7).equals(new BigDecimal(1)));
                assert (rs.getString(7).equals("1.0"));
                assert (rs.getObject(7, Boolean.class).booleanValue());
                assert (rs.getObject(7, Byte.class) == 1);
                assert (rs.getObject(7, Short.class) == 1);
                assert (rs.getObject(7, Integer.class) == 1);
                assert (rs.getObject(7, Long.class) == 1L);
                assert (rs.getObject(7, Float.class).floatValue() == 1.0f);
                assert (rs.getObject(7, Double.class) == 1.0);
                assert (rs.getObject(7, BigDecimal.class).equals(new BigDecimal(1)));
                assert (rs.getObject(7, String.class).equals("1.0"));
            }
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testDouble() throws Exception {
        ResultSet rs = this.stmt.executeQuery(SQL);
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) {
                assert (rs.getDouble("doubleVal") == 1.0);
                assert (rs.getBoolean(8));
                assert (rs.getByte(8) == 1);
                assert (rs.getShort(8) == 1);
                assert (rs.getInt(8) == 1);
                assert (rs.getLong(8) == 1L);
                assert (rs.getDouble(8) == 1.0);
                assert (rs.getFloat(8) == 1.0f);
                assert (rs.getBigDecimal(8).equals(new BigDecimal(1)));
                assert (rs.getString(8).equals("1.0"));
                assert (rs.getObject(8, Boolean.class).booleanValue());
                assert (rs.getObject(8, Byte.class) == 1);
                assert (rs.getObject(8, Short.class) == 1);
                assert (rs.getObject(8, Integer.class) == 1);
                assert (rs.getObject(8, Long.class) == 1L);
                assert (rs.getObject(8, Float.class).floatValue() == 1.0f);
                assert (rs.getObject(8, Double.class) == 1.0);
                assert (rs.getObject(8, BigDecimal.class).equals(new BigDecimal(1)));
                assert (rs.getObject(8, String.class).equals("1.0"));
            }
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testBigDecimal() throws Exception {
        ResultSet rs = this.stmt.executeQuery(SQL);
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) {
                assert (rs.getBigDecimal("bigVal").intValue() == 1);
                assert (rs.getBoolean(9));
                assert (rs.getByte(9) == 1);
                assert (rs.getShort(9) == 1);
                assert (rs.getInt(9) == 1);
                assert (rs.getLong(9) == 1L);
                assert (rs.getDouble(9) == 1.0);
                assert (rs.getFloat(9) == 1.0f);
                assert (rs.getBigDecimal(9).equals(new BigDecimal(1)));
                assert (rs.getString(9).equals("1"));
                assert (rs.getObject(9, Boolean.class).booleanValue());
                assert (rs.getObject(9, Byte.class) == 1);
                assert (rs.getObject(9, Short.class) == 1);
                assert (rs.getObject(9, Integer.class) == 1);
                assert (rs.getObject(9, Long.class) == 1L);
                assert (rs.getObject(9, Float.class).floatValue() == 1.0f);
                assert (rs.getObject(9, Double.class) == 1.0);
                assert (rs.getObject(9, BigDecimal.class).equals(new BigDecimal(1)));
                assert (rs.getObject(9, String.class).equals("1"));
            }
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testBigDecimalScale() throws Exception {
        assert ("0.12".equals(this.convertStringToBigDecimalViaJdbc("0.1234", 2).toString()));
        assert ("1.001".equals(this.convertStringToBigDecimalViaJdbc("1.0005", 3).toString()));
        assert ("1E+3".equals(this.convertStringToBigDecimalViaJdbc("1205.5", -3).toString()));
        assert ("1.3E+4".equals(this.convertStringToBigDecimalViaJdbc("12505.5", -3).toString()));
    }

    private BigDecimal convertStringToBigDecimalViaJdbc(String strDec, int scale) throws SQLException {
        try (ResultSet rs = this.stmt.executeQuery("select '" + strDec + "'");){
            assert (rs.next());
            BigDecimal bigDecimal = rs.getBigDecimal(1, scale);
            return bigDecimal;
        }
    }

    @Test
    public void testString() throws Exception {
        ResultSet rs = this.stmt.executeQuery(SQL);
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) {
                assert ("1".equals(rs.getString("strVal")));
                assert (rs.getBoolean(10));
                assert (rs.getByte(10) == 1);
                assert (rs.getShort(10) == 1);
                assert (rs.getInt(10) == 1);
                assert (rs.getLong(10) == 1L);
                assert (rs.getDouble(10) == 1.0);
                assert (rs.getFloat(10) == 1.0f);
                assert (rs.getBigDecimal(10).equals(new BigDecimal("1")));
                assert (rs.getString(10).equals("1"));
                assert (rs.getObject(10, Boolean.class).booleanValue());
                assert (rs.getObject(10, Byte.class) == 1);
                assert (rs.getObject(10, Short.class) == 1);
                assert (rs.getObject(10, Integer.class) == 1);
                assert (rs.getObject(10, Long.class) == 1L);
                assert (rs.getObject(10, Float.class).floatValue() == 1.0f);
                assert (rs.getObject(10, Double.class) == 1.0);
                assert (rs.getObject(10, BigDecimal.class).equals(new BigDecimal(1)));
                assert (rs.getObject(10, String.class).equals("1"));
            }
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testArray() throws Exception {
        ResultSet rs = this.stmt.executeQuery(SQL);
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) {
                assert (Arrays.equals(rs.getBytes("arrVal"), new byte[]{1}));
                assert (Arrays.equals(rs.getBytes(11), new byte[]{1}));
            }
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testDate() throws Exception {
        ResultSet rs = this.stmt.executeQuery(SQL);
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) {
                JdbcThinResultSetSelfTest.assertEquals((Object)new Date(1, 1, 1), (Object)rs.getDate("dateVal"));
                JdbcThinResultSetSelfTest.assertEquals((Object)new Date(1, 1, 1), (Object)rs.getDate(12));
                JdbcThinResultSetSelfTest.assertEquals((Object)new Date(1, 1, 1), (Object)rs.getObject("dateVal"));
                JdbcThinResultSetSelfTest.assertEquals((Object)new Date(1, 1, 1), (Object)rs.getObject(12));
                JdbcThinResultSetSelfTest.assertEquals((Object)new Time(new Date(1, 1, 1).getTime()), (Object)rs.getTime(12));
                JdbcThinResultSetSelfTest.assertEquals((Object)new Timestamp(new Date(1, 1, 1).getTime()), (Object)rs.getTimestamp(12));
                JdbcThinResultSetSelfTest.assertEquals((Object)new Date(1, 1, 1), (Object)rs.getObject(12, Date.class));
                JdbcThinResultSetSelfTest.assertEquals((Object)new Time(new Date(1, 1, 1).getTime()), (Object)rs.getObject(12, Time.class));
                JdbcThinResultSetSelfTest.assertEquals((Object)new Timestamp(new Date(1, 1, 1).getTime()), (Object)rs.getObject(12, Timestamp.class));
            }
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testTime() throws Exception {
        ResultSet rs = this.stmt.executeQuery(SQL);
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) {
                JdbcThinResultSetSelfTest.assertEquals((Object)new Time(1, 1, 1), (Object)rs.getTime("timeVal"));
                JdbcThinResultSetSelfTest.assertEquals((Object)new Time(1, 1, 1), (Object)rs.getTime(13));
                JdbcThinResultSetSelfTest.assertEquals((Object)new Time(1, 1, 1), (Object)rs.getObject("timeVal"));
                JdbcThinResultSetSelfTest.assertEquals((Object)new Time(1, 1, 1), (Object)rs.getObject(13));
                JdbcThinResultSetSelfTest.assertEquals((Object)new Date(new Time(1, 1, 1).getTime()), (Object)rs.getDate(13));
                JdbcThinResultSetSelfTest.assertEquals((Object)new Timestamp(new Time(1, 1, 1).getTime()), (Object)rs.getTimestamp(13));
                JdbcThinResultSetSelfTest.assertEquals((Object)new Time(1, 1, 1), (Object)rs.getObject(13, Time.class));
                JdbcThinResultSetSelfTest.assertEquals((Object)new Date(new Time(1, 1, 1).getTime()), (Object)rs.getObject(13, Date.class));
                JdbcThinResultSetSelfTest.assertEquals((Object)new Timestamp(new Time(1, 1, 1).getTime()), (Object)rs.getObject(13, Timestamp.class));
            }
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testTimestamp() throws Exception {
        ResultSet rs = this.stmt.executeQuery(SQL);
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) {
                JdbcThinResultSetSelfTest.assertEquals((Object)new Timestamp(1L), (Object)rs.getTimestamp("tsVal"));
                JdbcThinResultSetSelfTest.assertEquals((Object)new Timestamp(1L), (Object)rs.getTimestamp(14));
                JdbcThinResultSetSelfTest.assertEquals((Object)new Timestamp(1L), (Object)rs.getObject("tsVal"));
                JdbcThinResultSetSelfTest.assertEquals((Object)new Timestamp(1L), (Object)rs.getObject(14));
                JdbcThinResultSetSelfTest.assertEquals((Object)new Date(new Timestamp(1L).getTime()), (Object)rs.getDate(14));
                JdbcThinResultSetSelfTest.assertEquals((Object)new Time(new Timestamp(1L).getTime()), (Object)rs.getTime(14));
                JdbcThinResultSetSelfTest.assertEquals((Object)new Date(new Timestamp(1L).getTime()), (Object)rs.getObject(14, Date.class));
                JdbcThinResultSetSelfTest.assertEquals((Object)new Time(new Timestamp(1L).getTime()), (Object)rs.getObject(14, Time.class));
                JdbcThinResultSetSelfTest.assertEquals((Object)new Timestamp(1L), (Object)rs.getObject(14, Timestamp.class));
            }
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testObject() throws Exception {
        ResultSet rs = this.stmt.executeQuery(SQL);
        int cnt = 0;
        TestObjectField exp = new TestObjectField(100, "AAAA");
        while (rs.next()) {
            if (cnt == 0) {
                Assert.assertEquals((String)"Result by column label mismatch", (Object)exp, (Object)rs.getObject("objVal"));
                Assert.assertEquals((String)"Result by column index mismatch", (Object)exp, (Object)rs.getObject(15));
                Assert.assertEquals((String)"Result by column index with general cast mismatch", (Object)exp, (Object)rs.getObject(15, Object.class));
                Assert.assertEquals((String)"Result by column index with precise cast mismatch", (Object)exp, (Object)rs.getObject(15, TestObjectField.class));
            }
            ++cnt;
        }
        Assert.assertEquals((String)"Result count mismatch", (long)1L, (long)cnt);
    }

    @Test
    public void testNavigation() throws Exception {
        ResultSet rs = this.stmt.executeQuery("select id from TestObject where id > 0");
        assert (rs.isBeforeFirst());
        assert (!rs.isAfterLast());
        assert (!rs.isFirst());
        assert (!rs.isLast());
        assert (rs.getRow() == 0);
        assert (rs.next());
        assert (!rs.isBeforeFirst());
        assert (!rs.isAfterLast());
        assert (rs.isFirst());
        assert (!rs.isLast());
        assert (rs.getRow() == 1);
        assert (rs.next());
        assert (!rs.isBeforeFirst());
        assert (!rs.isAfterLast());
        assert (!rs.isFirst());
        assert (rs.isLast());
        assert (rs.getRow() == 2);
        assert (!rs.next());
        assert (!rs.isBeforeFirst());
        assert (rs.isAfterLast());
        assert (!rs.isFirst());
        assert (!rs.isLast());
        assert (rs.getRow() == 0);
        rs = this.stmt.executeQuery("select id from TestObject where id < 0");
        assert (!rs.isBeforeFirst());
    }

    @Test
    public void testFindColumn() throws Exception {
        final ResultSet rs = this.stmt.executeQuery(SQL);
        assert (rs != null);
        assert (rs.next());
        assert (rs.findColumn("id") == 1);
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                rs.findColumn("wrong");
                return null;
            }
        }, SQLException.class, (String)"Column not found: wrong");
    }

    @Test
    public void testNotSupportedTypes() throws Exception {
        final ResultSet rs = this.stmt.executeQuery(SQL);
        assert (rs.next());
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.getArray(1);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.getArray("id");
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.getAsciiStream(1);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.getAsciiStream("id");
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.getBinaryStream(1);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.getBinaryStream("id");
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.getBlob(1);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.getBlob("id");
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.getClob(1);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.getClob("id");
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.getCharacterStream(1);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.getCharacterStream("id");
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.getNCharacterStream(1);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.getNCharacterStream("id");
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.getNClob(1);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.getNClob("id");
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.getRef(1);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.getRef("id");
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.getRowId(1);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.getRowId("id");
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.getSQLXML(1);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.getSQLXML("id");
            }
        });
    }

    @Test
    public void testUpdateNotSupported() throws Exception {
        final ResultSet rs = this.stmt.executeQuery(SQL);
        assert (rs.next());
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateBoolean(1, true);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateBoolean("id", true);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateByte(1, (byte)0);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateByte("id", (byte)0);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateShort(1, (short)0);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateShort("id", (short)0);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateInt(1, 0);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateInt("id", 0);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateLong(1, 0L);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateLong("id", 0L);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateFloat(1, 0.0f);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateFloat("id", 0.0f);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateDouble(1, 0.0);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateDouble("id", 0.0);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateString(1, "");
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateString("id", "");
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateTime(1, new Time(0L));
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateTime("id", new Time(0L));
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateDate(1, new Date(0L));
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateDate("id", new Date(0L));
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateTimestamp(1, new Timestamp(0L));
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateTimestamp("id", new Timestamp(0L));
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateBytes(1, new byte[0]);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateBytes("id", new byte[0]);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateArray(1, null);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateArray("id", null);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateBlob(1, (Blob)null);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateBlob(1, (InputStream)null);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateBlob(1, null, 0L);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateBlob("id", (Blob)null);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateBlob("id", (InputStream)null);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateBlob("id", null, 0L);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateClob(1, (Clob)null);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateClob(1, (Reader)null);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateClob(1, null, 0L);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateClob("id", (Clob)null);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateClob("id", (Reader)null);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateClob("id", null, 0L);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateNClob(1, (NClob)null);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateNClob(1, (Reader)null);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateNClob(1, null, 0L);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateNClob("id", (NClob)null);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateNClob("id", (Reader)null);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateNClob("id", null, 0L);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateAsciiStream(1, null);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateAsciiStream(1, (InputStream)null, 0);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateAsciiStream(1, null, 0L);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateAsciiStream("id", null);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateAsciiStream("id", (InputStream)null, 0);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateAsciiStream("id", null, 0L);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateCharacterStream(1, null);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateCharacterStream(1, (Reader)null, 0);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateCharacterStream(1, null, 0L);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateCharacterStream("id", null);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateCharacterStream("id", (Reader)null, 0);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateCharacterStream("id", null, 0L);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateNCharacterStream(1, null);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateNCharacterStream(1, null, 0L);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateNCharacterStream(1, null, 0L);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateNCharacterStream("id", null);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateNCharacterStream("id", null, 0L);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateNCharacterStream("id", null, 0L);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateRef(1, null);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateRef("id", null);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateRowId(1, null);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateRowId("id", null);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateNString(1, null);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateNString("id", null);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateSQLXML(1, null);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateSQLXML("id", null);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateObject(1, null);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateObject(1, null, 0);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateObject("id", null);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateObject("id", null, 0);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateBigDecimal(1, null);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateBigDecimal("id", null);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateNull(1);
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateNull("id");
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.cancelRowUpdates();
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.updateRow();
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.deleteRow();
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.insertRow();
            }
        });
        this.checkNotSupported(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.moveToInsertRow();
            }
        });
    }

    @Test
    public void testExceptionOnClosedResultSet() throws Exception {
        final ResultSet rs = this.stmt.executeQuery(SQL);
        rs.close();
        rs.close();
        this.checkResultSetClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.getBoolean(1);
            }
        });
        this.checkResultSetClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.getBoolean("id");
            }
        });
        this.checkResultSetClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.getByte(1);
            }
        });
        this.checkResultSetClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.getByte("id");
            }
        });
        this.checkResultSetClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.getShort(1);
            }
        });
        this.checkResultSetClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.getShort("id");
            }
        });
        this.checkResultSetClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.getInt(1);
            }
        });
        this.checkResultSetClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.getInt("id");
            }
        });
        this.checkResultSetClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.getLong(1);
            }
        });
        this.checkResultSetClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.getLong("id");
            }
        });
        this.checkResultSetClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.getFloat(1);
            }
        });
        this.checkResultSetClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.getFloat("id");
            }
        });
        this.checkResultSetClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.getDouble(1);
            }
        });
        this.checkResultSetClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.getDouble("id");
            }
        });
        this.checkResultSetClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.getString(1);
            }
        });
        this.checkResultSetClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.getString("id");
            }
        });
        this.checkResultSetClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.getBytes(1);
            }
        });
        this.checkResultSetClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.getBytes("id");
            }
        });
        this.checkResultSetClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.getDate(1);
            }
        });
        this.checkResultSetClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.getDate(1, (Calendar)new GregorianCalendar());
            }
        });
        this.checkResultSetClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.getDate("id");
            }
        });
        this.checkResultSetClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.getDate("id", (Calendar)new GregorianCalendar());
            }
        });
        this.checkResultSetClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.getTime(1);
            }
        });
        this.checkResultSetClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.getTime(1, (Calendar)new GregorianCalendar());
            }
        });
        this.checkResultSetClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.getTime("id");
            }
        });
        this.checkResultSetClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.getTime("id", (Calendar)new GregorianCalendar());
            }
        });
        this.checkResultSetClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.getTimestamp(1);
            }
        });
        this.checkResultSetClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.getTimestamp(1, (Calendar)new GregorianCalendar());
            }
        });
        this.checkResultSetClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.getTimestamp("id");
            }
        });
        this.checkResultSetClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.getTimestamp("id", (Calendar)new GregorianCalendar());
            }
        });
        this.checkResultSetClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.getObject("objVal");
            }
        });
        this.checkResultSetClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.getObject("objVal", TestObjectField.class);
            }
        });
        this.checkResultSetClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.wasNull();
            }
        });
        this.checkResultSetClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.getMetaData();
            }
        });
        this.checkResultSetClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.next();
            }
        });
        this.checkResultSetClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.last();
            }
        });
        this.checkResultSetClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.afterLast();
            }
        });
        this.checkResultSetClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.beforeFirst();
            }
        });
        this.checkResultSetClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.first();
            }
        });
        this.checkResultSetClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.findColumn("id");
            }
        });
        this.checkResultSetClosed(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                rs.getRow();
            }
        });
    }

    private static class TestObjectField
    implements Serializable {
        final int a;
        final String b;

        private TestObjectField(int a, String b) {
            this.a = a;
            this.b = b;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestObjectField that = (TestObjectField)o;
            return this.a == that.a && !(this.b == null ? that.b != null : !this.b.equals(that.b));
        }

        public int hashCode() {
            int res = this.a;
            res = 31 * res + (this.b != null ? this.b.hashCode() : 0);
            return res;
        }

        public String toString() {
            return S.toString(TestObjectField.class, (Object)this);
        }
    }

    private static class TestObject
    implements Serializable {
        @QuerySqlField
        private final int id;
        @QuerySqlField
        private Boolean boolVal;
        @QuerySqlField
        private Byte byteVal;
        @QuerySqlField
        private Short shortVal;
        @QuerySqlField
        private Integer intVal;
        @QuerySqlField
        private Long longVal;
        @QuerySqlField
        private Float floatVal;
        @QuerySqlField
        private Double doubleVal;
        @QuerySqlField
        private BigDecimal bigVal;
        @QuerySqlField
        private String strVal;
        @QuerySqlField
        private byte[] arrVal;
        @QuerySqlField
        private Date dateVal;
        @QuerySqlField
        private Time timeVal;
        @QuerySqlField
        private Timestamp tsVal;
        @QuerySqlField
        private URL urlVal;
        @QuerySqlField
        private TestObjectField objVal = new TestObjectField(100, "AAAA");
        @QuerySqlField
        private TestObjectField f2 = new TestObjectField(500, "BBBB");
        @QuerySqlField
        private TestObjectField f3;

        private TestObject(int id) {
            this.id = id;
        }

        public String toString() {
            return S.toString(TestObject.class, (Object)this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestObject that = (TestObject)o;
            if (this.id != that.id) {
                return false;
            }
            if (!Arrays.equals(this.arrVal, that.arrVal)) {
                return false;
            }
            if (this.bigVal != null ? !this.bigVal.equals(that.bigVal) : that.bigVal != null) {
                return false;
            }
            if (this.boolVal != null ? !this.boolVal.equals(that.boolVal) : that.boolVal != null) {
                return false;
            }
            if (this.byteVal != null ? !this.byteVal.equals(that.byteVal) : that.byteVal != null) {
                return false;
            }
            if (this.dateVal != null ? !this.dateVal.equals(that.dateVal) : that.dateVal != null) {
                return false;
            }
            if (this.doubleVal != null ? !this.doubleVal.equals(that.doubleVal) : that.doubleVal != null) {
                return false;
            }
            if (this.objVal != null ? !this.objVal.equals(that.objVal) : that.objVal != null) {
                return false;
            }
            if (this.f2 != null ? !this.f2.equals(that.f2) : that.f2 != null) {
                return false;
            }
            if (this.f3 != null ? !this.f3.equals(that.f3) : that.f3 != null) {
                return false;
            }
            if (this.floatVal != null ? !this.floatVal.equals(that.floatVal) : that.floatVal != null) {
                return false;
            }
            if (this.intVal != null ? !this.intVal.equals(that.intVal) : that.intVal != null) {
                return false;
            }
            if (this.longVal != null ? !this.longVal.equals(that.longVal) : that.longVal != null) {
                return false;
            }
            if (this.shortVal != null ? !this.shortVal.equals(that.shortVal) : that.shortVal != null) {
                return false;
            }
            if (this.strVal != null ? !this.strVal.equals(that.strVal) : that.strVal != null) {
                return false;
            }
            if (this.timeVal != null ? !this.timeVal.equals(that.timeVal) : that.timeVal != null) {
                return false;
            }
            if (this.tsVal != null ? !this.tsVal.equals(that.tsVal) : that.tsVal != null) {
                return false;
            }
            return !(this.urlVal != null ? !this.urlVal.equals(that.urlVal) : that.urlVal != null);
        }

        public int hashCode() {
            int res = this.id;
            res = 31 * res + (this.boolVal != null ? this.boolVal.hashCode() : 0);
            res = 31 * res + (this.byteVal != null ? this.byteVal.hashCode() : 0);
            res = 31 * res + (this.shortVal != null ? this.shortVal.hashCode() : 0);
            res = 31 * res + (this.intVal != null ? this.intVal.hashCode() : 0);
            res = 31 * res + (this.longVal != null ? this.longVal.hashCode() : 0);
            res = 31 * res + (this.floatVal != null ? this.floatVal.hashCode() : 0);
            res = 31 * res + (this.doubleVal != null ? this.doubleVal.hashCode() : 0);
            res = 31 * res + (this.bigVal != null ? this.bigVal.hashCode() : 0);
            res = 31 * res + (this.strVal != null ? this.strVal.hashCode() : 0);
            res = 31 * res + (this.arrVal != null ? Arrays.hashCode(this.arrVal) : 0);
            res = 31 * res + (this.dateVal != null ? this.dateVal.hashCode() : 0);
            res = 31 * res + (this.timeVal != null ? this.timeVal.hashCode() : 0);
            res = 31 * res + (this.tsVal != null ? this.tsVal.hashCode() : 0);
            res = 31 * res + (this.urlVal != null ? this.urlVal.hashCode() : 0);
            res = 31 * res + (this.objVal != null ? this.objVal.hashCode() : 0);
            res = 31 * res + (this.f2 != null ? this.f2.hashCode() : 0);
            res = 31 * res + (this.f3 != null ? this.f3.hashCode() : 0);
            return res;
        }

        static /* synthetic */ byte[] access$1002(TestObject x0, byte[] x1) {
            x0.arrVal = x1;
            return x1;
        }
    }
}

