/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc.thin;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.jdbc.thin.JdbcThinAbstractSelfTest;
import org.junit.Test;

public class JdbcThinEmptyCacheSelfTest
extends JdbcThinAbstractSelfTest {
    private static final String CACHE_NAME = "cache";
    private static final String URL = "jdbc:ignite:thin://127.0.0.1/";
    private Statement stmt;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        CacheConfiguration cache = JdbcThinEmptyCacheSelfTest.defaultCacheConfiguration();
        cache.setName(CACHE_NAME);
        cache.setCacheMode(CacheMode.PARTITIONED);
        cache.setBackups(1);
        cache.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        cache.setIndexedTypes(new Class[]{Byte.class, Byte.class});
        cfg.setCacheConfiguration(new CacheConfiguration[]{cache});
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGrid();
    }

    protected void beforeTest() throws Exception {
        Connection conn = DriverManager.getConnection(URL);
        conn.setSchema("\"cache\"");
        this.stmt = conn.createStatement();
        assert (this.stmt != null);
        assert (!this.stmt.isClosed());
    }

    protected void afterTest() throws Exception {
        if (this.stmt != null) {
            this.stmt.getConnection().close();
            this.stmt.close();
            assert (this.stmt.isClosed());
        }
    }

    @Test
    public void testSelectNumber() throws Exception {
        ResultSet rs = this.stmt.executeQuery("select 1");
        int cnt = 0;
        while (rs.next()) {
            assert (rs.getInt(1) == 1);
            assert ("1".equals(rs.getString(1)));
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testSelectString() throws Exception {
        ResultSet rs = this.stmt.executeQuery("select 'str'");
        int cnt = 0;
        while (rs.next()) {
            JdbcThinEmptyCacheSelfTest.assertEquals((String)"str", (String)rs.getString(1));
            ++cnt;
        }
        assert (cnt == 1);
    }
}

