/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc.thin;

import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.query.oom.DiskSpillingAbstractTest;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.junit.Test;

public class JdbcThinDiskSpillingClientsTest
extends DiskSpillingAbstractTest {
    private ClientQueryRunner qryRunner;

    protected ClientQueryRunner createQueryRunner() {
        return new JdbcThinClient();
    }

    @Test
    public void testSimpleSelect() {
        this.getQueryRunner().checkQuery("SELECT * FROM person");
    }

    @Test
    public void testSelectSorted() {
        this.getQueryRunner().checkQuery("SELECT code FROM person ORDER BY code");
    }

    @Test
    public void testSelectDistinct() {
        this.getQueryRunner().checkQuery("SELECT DISTINCT depId, code FROM person ORDER BY depId, code");
    }

    @Test
    public void testSelectAggGroupBy() {
        this.getQueryRunner().checkQuery("SELECT code, age, AVG(DISTINCT temperature), SUM(DISTINCT temperature), MAX(DISTINCT temperature), MIN(DISTINCT temperature) FROM person GROUP BY age, code");
    }

    @Test
    public void testSelectDML() {
        this.getQueryRunner().checkQuery("UPDATE person SET age = age + 1 WHERE age >= 0");
    }

    @Test
    public void testSelectIntersect() {
        this.getQueryRunner().checkQuery("((SELECT * FROM person WHERE depId < 20 ORDER BY depId) INTERSECT SELECT * FROM person WHERE depId > 10 ) UNION ALL SELECT DISTINCT * FROM person WHERE age <100 ORDER BY id LIMIT 10000 OFFSET 20");
    }

    private ClientQueryRunner getQueryRunner() {
        if (this.qryRunner == null) {
            this.qryRunner = this.createQueryRunner();
            this.qryRunner.init(this.grid(0), this.getWorkDir());
        }
        return this.qryRunner;
    }

    protected static class JdbcThinClient
    extends ClientQueryRunner {
        private Connection conn;

        protected JdbcThinClient() {
        }

        @Override
        protected void initInternal() {
            try {
                JdbcThinDiskSpillingClientsTest.assertNotNull((Object)this.server);
                this.conn = DriverManager.getConnection(this.getConnectionString());
                this.conn.setSchema("\"PUBLIC\"");
            }
            catch (SQLException e) {
                throw new AssertionError((Object)e);
            }
        }

        protected String getConnectionString() {
            return "jdbc:ignite:thin://127.0.0.1:10800..10802?queryMaxMemory=4096&lazy=false";
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected List<List<?>> runQuery(String qry) {
            try {
                JdbcThinDiskSpillingClientsTest.assertNotNull((Object)this.conn);
                try (PreparedStatement s = this.conn.prepareStatement(qry);){
                    if (s.execute()) {
                        ArrayList res = new ArrayList();
                        try (ResultSet rs = s.getResultSet();){
                            ResultSetMetaData meta = rs.getMetaData();
                            int cnt = meta.getColumnCount();
                            while (rs.next()) {
                                ArrayList<Object> row = new ArrayList<Object>(cnt);
                                for (int i = 1; i <= cnt; ++i) {
                                    row.add(rs.getObject(i));
                                }
                                res.add(row);
                            }
                        }
                        ArrayList arrayList = res;
                        return arrayList;
                    }
                    List<List<?>> list = Collections.singletonList(Collections.singletonList(Long.valueOf(s.getUpdateCount())));
                    return list;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new AssertionError((Object)e);
            }
        }
    }

    protected static abstract class ClientQueryRunner {
        protected IgniteEx server;
        protected Path workDir;

        protected ClientQueryRunner() {
        }

        void init(IgniteEx srv, Path workDir) {
            this.server = srv;
            this.workDir = workDir;
            this.initInternal();
        }

        void checkQuery(String qry) {
            WatchService watchSvc = null;
            try {
                watchSvc = FileSystems.getDefault().newWatchService();
                WatchKey watchKey = this.workDir.register(watchSvc, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE);
                List<List<?>> res = this.runQuery(qry);
                List<WatchEvent<?>> dirEvts = watchKey.pollEvents();
                JdbcThinDiskSpillingClientsTest.assertFalse((String)"Disk spilling not happened.", (boolean)dirEvts.isEmpty());
                JdbcThinDiskSpillingClientsTest.assertEquals((int)0, (int)this.workDir.toFile().list().length);
                List intApiRes = this.server.cache("default").query(new SqlFieldsQuery(qry)).getAll();
                JdbcThinDiskSpillingClientsTest.assertEqualsCollections((Collection)intApiRes, (Collection)res);
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
            finally {
                U.closeQuiet((AutoCloseable)watchSvc);
            }
        }

        protected abstract void initInternal();

        protected abstract List<List<?>> runQuery(String var1);

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }
}

