/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc.thin;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.query.GridQueryCancel;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.processors.query.SqlClientContext;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.jetbrains.annotations.Nullable;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class JdbcThinDataPageScanPropertySelfTest
extends GridCommonAbstractTest {
    private static final int BATCH_SIZE = 10;
    private static final int TOTAL_QUERIES_TO_EXECUTE = 25;
    private static final int INITIAL_ROWS_CNT = 100;

    protected void beforeTestsStarted() throws Exception {
        GridQueryProcessor.idxCls = IndexingWithQueries.class;
        this.startGrids(3);
    }

    private void executeUpdate(String sql) throws Exception {
        try (Connection conn = GridTestUtils.connect((IgniteEx)this.grid(0), null);
             PreparedStatement upd = conn.prepareStatement(sql);){
            upd.executeUpdate();
        }
    }

    @Before
    public void inint() throws Exception {
        this.executeUpdate("DROP TABLE IF EXISTS TEST");
        this.executeUpdate("CREATE TABLE TEST (id INT PRIMARY KEY, val INT)");
        IgniteCache cache = this.grid(0).cache("SQL_PUBLIC_TEST");
        for (int i = 0; i < 100; ++i) {
            this.executeUpdate("INSERT INTO TEST VALUES (" + i + ", " + (i + 1) + ")");
        }
        IndexingWithQueries.queries.clear();
    }

    @Test
    @Ignore(value="https://ggsystems.atlassian.net/browse/GG-20800")
    public void testDataPageScanSingle() throws Exception {
        this.checkDataPageScan("SELECT * FROM TEST WHERE val > 42", null);
        this.checkDataPageScan("UPDATE TEST SET val = val + 1 WHERE val > 10", null);
        this.checkDataPageScan("SELECT id FROM TEST WHERE val < 3", true);
        this.checkDataPageScan("UPDATE TEST SET val = val + 3 WHERE val < 3", true);
        this.checkDataPageScan("SELECT val FROM TEST WHERE id = 5", false);
        this.checkDataPageScan("UPDATE TEST SET val = val - 5 WHERE val < 100", false);
    }

    @Test
    @Ignore(value="https://ggsystems.atlassian.net/browse/GG-20800")
    public void testDataPageScanBatching() throws Exception {
        this.checkDataPageScanInBatch("UPDATE TEST SET val = ? WHERE val > 10", null);
        this.checkDataPageScanInBatch("UPDATE TEST SET val = val + 3 WHERE val < ?", true);
        this.checkDataPageScanInBatch("UPDATE TEST SET val = val - 5 WHERE val < ?", false);
    }

    private void checkDataPageScanInBatch(String qryWithParam, @Nullable Boolean dps) throws Exception {
        String params = dps == null ? null : "dataPageScanEnabled=" + dps;
        int expCnt = 0;
        try (Connection conn = GridTestUtils.connect((IgniteEx)this.grid(0), (String)params);
             PreparedStatement upd = conn.prepareStatement(qryWithParam);){
            for (int i = 0; i < 25; ++i) {
                upd.setInt(1, i);
                upd.addBatch();
                if ((i + 1) % 10 != 0 && i + 1 != 25) continue;
                upd.executeBatch();
                ++expCnt;
            }
        }
        boolean containsOrig = IndexingWithQueries.queries.stream().anyMatch(executedQry -> qryWithParam.equals(executedQry.getSql()));
        JdbcThinDataPageScanPropertySelfTest.assertTrue((String)"Original query have not been executed.", (boolean)containsOrig);
        IndexingWithQueries.queries.forEach(query -> JdbcThinDataPageScanPropertySelfTest.assertEquals((String)("Data page scan flag value is unexpected for query " + query), (Object)dps, null));
        int executed = IndexingWithQueries.queries.size();
        JdbcThinDataPageScanPropertySelfTest.assertEquals((int)expCnt, (int)executed);
        IndexingWithQueries.queries.clear();
    }

    private void checkDataPageScan(String qry, @Nullable Boolean dps) throws Exception {
        String params = dps == null ? null : "dataPageScanEnabled=" + dps;
        try (Connection conn = GridTestUtils.connect((IgniteEx)this.grid(0), params);
             PreparedStatement stmt = conn.prepareStatement(qry);){
            stmt.execute();
        }
        boolean containsOrig = IndexingWithQueries.queries.stream().anyMatch(executedQry -> qry.equals(executedQry.getSql()));
        JdbcThinDataPageScanPropertySelfTest.assertTrue((String)"Original query have not been executed.", (boolean)containsOrig);
        IndexingWithQueries.queries.forEach(executedQry -> JdbcThinDataPageScanPropertySelfTest.assertEquals((String)("Data page scan flag value is unexpected for query " + executedQry), (Object)dps, null));
        int executed = IndexingWithQueries.queries.size();
        JdbcThinDataPageScanPropertySelfTest.assertTrue((String)("Expected that there are executed at least one query. But executed only " + executed), (executed >= 1 ? 1 : 0) != 0);
        IndexingWithQueries.queries.clear();
    }

    private static class IndexingWithQueries
    extends IgniteH2Indexing {
        static final Queue<SqlFieldsQuery> queries = new LinkedBlockingQueue<SqlFieldsQuery>();

        private IndexingWithQueries() {
        }

        public List<FieldsQueryCursor<List<?>>> querySqlFields(String schemaName, SqlFieldsQuery qry, @Nullable SqlClientContext cliCtx, boolean keepBinary, boolean failOnMultipleStmts, GridQueryCancel cancel) {
            queries.add(qry);
            return super.querySqlFields(schemaName, qry, cliCtx, keepBinary, failOnMultipleStmts, cancel);
        }
    }
}

