/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc.thin;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.sql.Statement;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.query.annotations.QuerySqlFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.ClientConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.jdbc.thin.JdbcThinAbstractSelfTest;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class JdbcThinConnectionTimeoutSelfTest
extends JdbcThinAbstractSelfTest {
    private static final TcpDiscoveryIpFinder IP_FINDER = new TcpDiscoveryVmIpFinder(true);
    private static final String URL = "jdbc:ignite:thin://127.0.0.1/";
    private static final String INCORRECT_URL = "jdbc:ignite:thin://192.0.0.8/";
    private static final int IMMEDIATE_TIMEOUT = 1;
    private static final int SERVER_THREAD_POOL_SIZE = 4;
    private static final byte NODES_COUNT = 3;
    private static final int MAX_ROWS = 10000;
    private static final Executor EXECUTOR_STUB = command -> {};
    private Connection conn;
    private Statement stmt;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        CacheConfiguration cache = JdbcThinConnectionTimeoutSelfTest.defaultCacheConfiguration();
        cache.setCacheMode(CacheMode.PARTITIONED);
        cache.setBackups(1);
        cache.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        cache.setSqlFunctionClasses(new Class[]{JdbcThinConnectionTimeoutSelfTest.class});
        cache.setIndexedTypes(new Class[]{Integer.class, Integer.class});
        cfg.setCacheConfiguration(new CacheConfiguration[]{cache});
        TcpDiscoverySpi disco = new TcpDiscoverySpi();
        disco.setIpFinder(IP_FINDER);
        cfg.setDiscoverySpi((DiscoverySpi)disco);
        cfg.setClientConnectorConfiguration(new ClientConnectorConfiguration().setThreadPoolSize(4));
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGridsMultiThreaded(3);
        for (int i = 0; i < 10000; ++i) {
            this.grid(0).cache("default").put((Object)i, (Object)i);
        }
    }

    @Before
    public void before() throws Exception {
        this.conn = DriverManager.getConnection(URL);
        this.conn.setSchema("\"default\"");
        this.stmt = this.conn.createStatement();
        assert (this.stmt != null);
        assert (!this.stmt.isClosed());
    }

    @After
    public void after() throws Exception {
        if (this.stmt != null && !this.stmt.isClosed()) {
            this.stmt.close();
            assert (this.stmt.isClosed());
        }
        this.conn.close();
        assert (this.stmt.isClosed());
        assert (this.conn.isClosed());
    }

    @Test
    public void testSettingNegativeConnectionTimeout() {
        GridTestUtils.assertThrows((IgniteLogger)log, () -> {
            this.conn.setNetworkTimeout(EXECUTOR_STUB, -1);
            return null;
        }, SQLException.class, (String)"Network timeout cannot be negative.");
    }

    @Test
    public void testNegativeConnectionTimeout() {
        GridTestUtils.assertThrows((IgniteLogger)log, () -> {
            try (Connection conn = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1/?connectionTimeout=-1");){
                Object var2_2 = null;
                return var2_2;
            }
        }, SQLException.class, (String)"Property cannot be lower than 0 [name=connectionTimeout, value=-1]");
    }

    @Test
    public void testConnectionTimeoutRetrieval() throws Exception {
        try (Connection conn = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1/?connectionTimeout=1000");){
            JdbcThinConnectionTimeoutSelfTest.assertEquals((int)1000, (int)conn.getNetworkTimeout());
            conn.setNetworkTimeout(EXECUTOR_STUB, 2000);
            JdbcThinConnectionTimeoutSelfTest.assertEquals((int)2000, (int)conn.getNetworkTimeout());
        }
    }

    @Test
    public void testConnectionTimeout() throws Exception {
        this.conn.setNetworkTimeout(EXECUTOR_STUB, 1000);
        GridTestUtils.assertThrows((IgniteLogger)log, () -> {
            this.stmt.execute("select sleep_func(2000)");
            return null;
        }, SQLException.class, (String)"Connection timed out.");
        this.stmt.execute("select 1");
        this.stmt.execute("select 1");
    }

    @Test
    public void testUrlConnectionTimeoutProperty() throws Exception {
        try (Connection conn = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1/?connectionTimeout=1000");){
            conn.setSchema("\"default\"");
            try (Statement stmt = conn.createStatement();){
                GridTestUtils.assertThrows((IgniteLogger)log, () -> {
                    stmt.execute("select sleep_func(2000)");
                    return null;
                }, SQLException.class, (String)"Connection timed out.");
                stmt.execute("select 1");
                stmt.execute("select 1");
            }
        }
    }

    @Test
    public void testUrlImmediateConnectionTimeoutProperty() throws Exception {
        GridTestUtils.assertTimeout((long)1L, (TimeUnit)TimeUnit.SECONDS, () -> {
            IgniteException cfr_ignored_0 = (IgniteException)GridTestUtils.assertThrows((IgniteLogger)log, () -> {
                try (Connection conn = DriverManager.getConnection("jdbc:ignite:thin://192.0.0.8/?connectionTimeout=1");){
                    JdbcThinConnectionTimeoutSelfTest.fail((String)("Connection was established to " + conn.getMetaData().getURL()));
                }
            }, IgniteException.class, (String)"Failed to connect to server");
        });
    }

    @Test
    public void testQueryTimeoutOccursBeforeConnectionTimeout() throws Exception {
        this.conn.setNetworkTimeout(EXECUTOR_STUB, 10000);
        boolean QRY_TIMEOUT = true;
        this.stmt.setQueryTimeout(1);
        GridTestUtils.assertThrows((IgniteLogger)log, () -> {
            this.stmt.executeQuery("select sleep_func(3) from Integer;");
            return null;
        }, SQLTimeoutException.class, (String)"The query was cancelled while executing due to timeout. Query timeout was : 1");
        this.stmt.execute("select 1");
    }

    @Test
    public void testUrlQueryTimeoutProperty() throws Exception {
        boolean QRY_TIMEOUT = true;
        try (Connection conn = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1/?connectionTimeout=10000&queryTimeout=1");){
            conn.setSchema("\"default\"");
            Statement stmt = conn.createStatement();
            GridTestUtils.assertThrows((IgniteLogger)log, () -> {
                stmt.executeQuery("select sleep_func(3) from Integer;");
                return null;
            }, SQLTimeoutException.class, (String)"The query was cancelled while executing due to timeout. Query timeout was : 1");
            stmt.execute("select 1");
        }
    }

    @Test
    public void testConnectionTimeoutUpdate() throws Exception {
        try (Connection conn = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1/?connectionTimeout=5000");){
            conn.setSchema("\"default\"");
            Statement stmt = conn.createStatement();
            stmt.execute("select sleep_func(1000)");
            conn.setNetworkTimeout(EXECUTOR_STUB, 500);
            GridTestUtils.assertThrows((IgniteLogger)log, () -> {
                stmt.execute("select sleep_func(1000)");
                return null;
            }, SQLException.class, (String)"Connection timed out.");
        }
    }

    @Test
    public void testCancelingTimedOutStatement() throws Exception {
        this.conn.setNetworkTimeout(EXECUTOR_STUB, 1);
        GridTestUtils.runAsync(() -> {
            try {
                Thread.sleep(1000L);
                GridTestUtils.assertThrows((IgniteLogger)log, () -> {
                    this.stmt.cancel();
                    return null;
                }, SQLException.class, (String)"Statement is closed.");
            }
            catch (Exception e) {
                log.error("Unexpected exception.", (Throwable)e);
                JdbcThinConnectionTimeoutSelfTest.fail((String)"Unexpected exception");
            }
        });
        GridTestUtils.runAsync(() -> {
            try {
                GridTestUtils.assertThrows((IgniteLogger)log, () -> {
                    this.stmt.execute("select sleep_func(1000)");
                    return null;
                }, SQLException.class, (String)"Connection timed out.");
            }
            catch (Exception e) {
                log.error("Unexpected exception.", (Throwable)e);
                JdbcThinConnectionTimeoutSelfTest.fail((String)"Unexpected exception");
            }
        });
    }

    @QuerySqlFunction
    public static int sleep_func(int v) {
        try {
            Thread.sleep(v);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return v;
    }
}

