/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class JdbcThinMetadataSqlMatchTest
extends GridCommonAbstractTest {
    private static Connection conn;

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        IgniteEx ign = this.startGrid(0);
        conn = GridTestUtils.connect((IgniteEx)ign, null);
    }

    protected void executeDDl(String sql) throws SQLException {
        try (PreparedStatement upd = conn.prepareStatement(sql);){
            upd.executeUpdate();
        }
    }

    protected List<String> getTableNames(String tabNamePtrn) throws SQLException {
        ArrayList<String> names = new ArrayList<String>();
        try (ResultSet tabsRs = conn.getMetaData().getTables(null, null, tabNamePtrn, new String[]{"TABLE"});){
            while (tabsRs.next()) {
                names.add(tabsRs.getString("TABLE_NAME"));
            }
        }
        Collections.sort(names);
        return names;
    }

    @Before
    public void createTables() throws Exception {
        this.executeDDl("CREATE TABLE MY_FAV_TABLE (id INT PRIMARY KEY, val VARCHAR)");
        this.executeDDl("CREATE TABLE MY0FAV0TABLE (id INT PRIMARY KEY, val VARCHAR)");
        this.executeDDl("CREATE TABLE OTHER_TABLE (id INT PRIMARY KEY, val VARCHAR)");
    }

    @After
    public void dropTables() throws Exception {
        this.executeDDl("DROP TABLE MY_FAV_TABLE");
        this.executeDDl("DROP TABLE MY0FAV0TABLE");
        this.executeDDl("DROP TABLE OTHER_TABLE");
    }

    @Test
    public void testTablesMatch() throws SQLException {
        JdbcThinMetadataSqlMatchTest.assertEqualsCollections(Arrays.asList("MY0FAV0TABLE", "MY_FAV_TABLE"), this.getTableNames("MY_FAV_TABLE"));
        JdbcThinMetadataSqlMatchTest.assertEqualsCollections(Collections.emptyList(), this.getTableNames("\\%"));
        JdbcThinMetadataSqlMatchTest.assertEqualsCollections(Arrays.asList("MY0FAV0TABLE", "MY_FAV_TABLE", "OTHER_TABLE"), this.getTableNames("%"));
        JdbcThinMetadataSqlMatchTest.assertEqualsCollections(Collections.emptyList(), this.getTableNames(""));
        JdbcThinMetadataSqlMatchTest.assertEqualsCollections(Arrays.asList("MY0FAV0TABLE", "MY_FAV_TABLE", "OTHER_TABLE"), this.getTableNames(null));
    }

    @Test
    public void testTablesWithBackslashInTheNameMatch() throws SQLException {
        JdbcThinMetadataSqlMatchTest.assertEqualsCollections(Arrays.asList("MY0FAV0TABLE", "MY_FAV_TABLE"), this.getTableNames("MY_FAV_TABLE"));
    }

    private void assertEqNoOrder(Collection<String> exp, Collection<String> actual) {
        ArrayList<String> expSorted = new ArrayList<String>(exp);
        ArrayList<String> actSorted = new ArrayList<String>(exp);
        Collections.sort(expSorted);
        Collections.sort(actSorted);
        JdbcThinMetadataSqlMatchTest.assertEqualsCollections(expSorted, actSorted);
    }

    protected void afterTestsStopped() throws Exception {
        try {
            conn.close();
            conn = null;
            this.stopAllGrids();
        }
        finally {
            super.afterTestsStopped();
        }
    }
}

