/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest.protocols.tcp.redis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.ignite.internal.processors.rest.protocols.tcp.redis.RedisCommonAbstractTest;
import org.junit.Assert;
import org.junit.Test;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.exceptions.JedisDataException;

public class RedisProtocolStringSelfTest
extends RedisCommonAbstractTest {
    @Test
    public void testGet() throws Exception {
        try (Jedis jedis = pool.getResource();){
            this.jcache().put((Object)"getKey1", (Object)"getVal1");
            Assert.assertEquals((Object)"getVal1", (Object)jedis.get("getKey1"));
            Assert.assertNull((Object)jedis.get("wrongKey"));
            this.jcache().put((Object)"setDataTypeKey", new HashSet<String>(Arrays.asList("1", "2")));
            try {
                jedis.get("setDataTypeKey");
                assert (false) : "Exception has to be thrown!";
            }
            catch (JedisDataException e) {
                RedisProtocolStringSelfTest.assertTrue((boolean)e.getMessage().startsWith("WRONGTYPE"));
            }
        }
    }

    @Test
    public void testGetSet() throws Exception {
        try (Jedis jedis = pool.getResource();){
            this.jcache().put((Object)"getSetKey1", (Object)"1");
            Assert.assertEquals((Object)"1", (Object)jedis.getSet("getSetKey1", "0"));
            Assert.assertNull((Object)jedis.get("getSetNonExistingKey"));
            this.jcache().put((Object)"setDataTypeKey", new HashSet<String>(Arrays.asList("1", "2")));
            try {
                jedis.getSet("setDataTypeKey", "0");
                assert (false) : "Exception has to be thrown!";
            }
            catch (JedisDataException e) {
                RedisProtocolStringSelfTest.assertTrue((boolean)e.getMessage().startsWith("WRONGTYPE"));
            }
        }
    }

    @Test
    public void testMGet() throws Exception {
        try (Jedis jedis = pool.getResource();){
            this.jcache().put((Object)"getKey1", (Object)"getVal1");
            this.jcache().put((Object)"getKey2", (Object)0);
            List res = jedis.mget(new String[]{"getKey1", "getKey2", "wrongKey"});
            Assert.assertTrue((boolean)res.contains("getVal1"));
            Assert.assertTrue((boolean)res.contains("0"));
        }
    }

    @Test
    public void testMGetDirectOrder() throws Exception {
        this.testMGetOrder(true);
    }

    @Test
    public void testMGetReverseOrder() throws Exception {
        this.testMGetOrder(false);
    }

    public void testMGetOrder(boolean directOrder) {
        int keysCnt = 33;
        ArrayList<String> keys = new ArrayList<String>(keysCnt);
        ArrayList<String> values = new ArrayList<String>(keysCnt);
        for (int i = 0; i < keysCnt; ++i) {
            keys.add("getKey" + i);
            values.add("getValue" + i);
        }
        try (Jedis jedis = pool.getResource();){
            for (int i = 0; i < keysCnt; ++i) {
                this.jcache().put(keys.get(i), values.get(i));
            }
            if (!directOrder) {
                Collections.reverse(keys);
                Collections.reverse(values);
            }
            List res = jedis.mget(keys.toArray(new String[keysCnt]));
            Assert.assertEquals((String)"The response size is not expected.", (long)keysCnt, (long)res.size());
            for (int i = 0; i < keysCnt; ++i) {
                Assert.assertEquals(values.get(i), res.get(i));
            }
        }
    }

    @Test
    public void testMGetDuplicates() throws Exception {
        try (Jedis jedis = pool.getResource();){
            this.jcache().put((Object)"key-A", (Object)"value-A");
            this.jcache().put((Object)"key-B", (Object)"value-B");
            List res = jedis.mget(new String[]{"key-A", "key-B", "key-A"});
            Assert.assertEquals((String)"The size of returned array must be equal to 3.", (long)3L, (long)res.size());
            Assert.assertEquals((Object)"value-A", res.get(0));
            Assert.assertEquals((Object)"value-B", res.get(1));
            Assert.assertEquals((Object)"value-A", res.get(2));
        }
    }

    @Test
    public void testSet() throws Exception {
        long EXPIRE_MS = 1000L;
        int EXPIRE_SEC = 1;
        try (Jedis jedis = pool.getResource();){
            jedis.set("setKey1", "1");
            jedis.set("setKey2".getBytes(), "b0".getBytes());
            Assert.assertEquals((Object)"1", (Object)this.jcache().get((Object)"setKey1"));
            Assert.assertEquals((Object)"b0", (Object)this.jcache().get((Object)"setKey2"));
            jedis.set("setKey1", "2", "nx");
            jedis.set("setKey3", "3", "nx", "px", EXPIRE_MS);
            Assert.assertEquals((Object)"1", (Object)this.jcache().get((Object)"setKey1"));
            Assert.assertEquals((Object)"3", (Object)this.jcache().get((Object)"setKey3"));
            jedis.set("setKey1", "2", "xx", "ex", EXPIRE_SEC);
            jedis.set("setKey4", "4", "xx");
            Assert.assertEquals((Object)"2", (Object)this.jcache().get((Object)"setKey1"));
            Assert.assertNull((Object)this.jcache().get((Object)"setKey4"));
            Thread.sleep((long)((double)EXPIRE_MS * 1.2));
            Assert.assertNull((Object)this.jcache().get((Object)"setKey1"));
            Assert.assertNull((Object)this.jcache().get((Object)"setKey3"));
        }
    }

    @Test
    public void testMSet() throws Exception {
        try (Jedis jedis = pool.getResource();){
            jedis.mset(new String[]{"setKey1", "1", "setKey2", "2"});
            Assert.assertEquals((Object)"1", (Object)this.jcache().get((Object)"setKey1"));
            Assert.assertEquals((Object)"2", (Object)this.jcache().get((Object)"setKey2"));
        }
    }

    @Test
    public void testIncrDecr() throws Exception {
        try (Jedis jedis = pool.getResource();){
            Assert.assertEquals((long)1L, (long)jedis.incr("newKeyIncr"));
            Assert.assertEquals((long)-1L, (long)jedis.decr("newKeyDecr"));
            Assert.assertEquals((Object)"1", (Object)jedis.get("newKeyIncr"));
            Assert.assertEquals((Object)"-1", (Object)jedis.get("newKeyDecr"));
            Assert.assertEquals((long)1L, (long)jedis.incr("incrKey1"));
            jedis.set("incrKey1", "10");
            Assert.assertEquals((long)11L, (long)jedis.incr("incrKey1"));
            jedis.set("decrKey1", "10");
            Assert.assertEquals((long)9L, (long)jedis.decr("decrKey1"));
            jedis.set("nonInt", "abc");
            try {
                jedis.incr("nonInt");
                assert (false) : "Exception has to be thrown!";
            }
            catch (JedisDataException e) {
                RedisProtocolStringSelfTest.assertTrue((boolean)e.getMessage().startsWith("ERR"));
            }
            try {
                jedis.decr("nonInt");
                assert (false) : "Exception has to be thrown!";
            }
            catch (JedisDataException e) {
                RedisProtocolStringSelfTest.assertTrue((boolean)e.getMessage().startsWith("ERR"));
            }
            jedis.set("outOfRangeIncr1", "9223372036854775808");
            try {
                jedis.incr("outOfRangeIncr1");
                assert (false) : "Exception has to be thrown!";
            }
            catch (JedisDataException e) {
                RedisProtocolStringSelfTest.assertTrue((boolean)e.getMessage().startsWith("ERR"));
            }
            jedis.set("outOfRangeDecr1", "-9223372036854775809");
            try {
                jedis.decr("outOfRangeDecr1");
                assert (false) : "Exception has to be thrown!";
            }
            catch (JedisDataException e) {
                RedisProtocolStringSelfTest.assertTrue((boolean)e.getMessage().startsWith("ERR"));
            }
            jedis.set("outOfRangeInc2", String.valueOf(Long.MAX_VALUE));
            try {
                jedis.incr("outOfRangeInc2");
                assert (false) : "Exception has to be thrown!";
            }
            catch (JedisDataException e) {
                RedisProtocolStringSelfTest.assertTrue((boolean)e.getMessage().startsWith("ERR"));
            }
            jedis.set("outOfRangeDecr2", String.valueOf(Long.MIN_VALUE));
            try {
                jedis.decr("outOfRangeDecr2");
                assert (false) : "Exception has to be thrown!";
            }
            catch (JedisDataException e) {
                RedisProtocolStringSelfTest.assertTrue((boolean)e.getMessage().startsWith("ERR"));
            }
        }
    }

    @Test
    public void testIncrDecrBy() throws Exception {
        try (Jedis jedis = pool.getResource();){
            Assert.assertEquals((long)2L, (long)jedis.incrBy("newKeyIncrBy", 2L));
            Assert.assertEquals((long)-2L, (long)jedis.decrBy("newKeyDecrBy", 2L));
            jedis.set("incrDecrKeyBy", "1");
            Assert.assertEquals((long)11L, (long)jedis.incrBy("incrDecrKeyBy", 10L));
            Assert.assertEquals((long)9L, (long)jedis.decrBy("incrDecrKeyBy", 2L));
            jedis.set("outOfRangeIncrBy", "1");
            try {
                jedis.incrBy("outOfRangeIncrBy", Long.MAX_VALUE);
                assert (false) : "Exception has to be thrown!";
            }
            catch (JedisDataException e) {
                RedisProtocolStringSelfTest.assertTrue((boolean)e.getMessage().startsWith("ERR"));
            }
            jedis.set("outOfRangeDecrBy", "-1");
            try {
                jedis.decrBy("outOfRangeDecrBy", Long.MIN_VALUE);
                assert (false) : "Exception has to be thrown!";
            }
            catch (JedisDataException e) {
                RedisProtocolStringSelfTest.assertTrue((boolean)e.getMessage().startsWith("ERR"));
            }
            jedis.set("outOfRangeIncBy2", String.valueOf(Long.MAX_VALUE));
            try {
                jedis.incrBy("outOfRangeIncBy2", Long.MAX_VALUE);
                assert (false) : "Exception has to be thrown!";
            }
            catch (JedisDataException e) {
                RedisProtocolStringSelfTest.assertTrue((boolean)e.getMessage().startsWith("ERR"));
            }
            jedis.set("outOfRangeDecrBy2", String.valueOf(Long.MIN_VALUE));
            try {
                jedis.decrBy("outOfRangeDecrBy2", Long.MIN_VALUE);
                assert (false) : "Exception has to be thrown!";
            }
            catch (JedisDataException e) {
                RedisProtocolStringSelfTest.assertTrue((boolean)e.getMessage().startsWith("ERR"));
            }
        }
    }

    @Test
    public void testAppend() throws Exception {
        try (Jedis jedis = pool.getResource();){
            Assert.assertEquals((long)5L, (long)jedis.append("appendKey1", "Hello"));
            Assert.assertEquals((long)12L, (long)jedis.append("appendKey1", " World!"));
            this.jcache().put((Object)"setDataTypeKey", new HashSet<String>(Arrays.asList("1", "2")));
            try {
                jedis.append("setDataTypeKey", "");
                assert (false) : "Exception has to be thrown!";
            }
            catch (JedisDataException e) {
                RedisProtocolStringSelfTest.assertTrue((boolean)e.getMessage().startsWith("WRONGTYPE"));
            }
        }
    }

    @Test
    public void testStrlen() throws Exception {
        try (Jedis jedis = pool.getResource();){
            Assert.assertEquals((long)0L, (long)jedis.strlen("strlenKeyNonExisting"));
            this.jcache().put((Object)"strlenKey", (Object)"abc");
            Assert.assertEquals((long)3L, (long)jedis.strlen("strlenKey"));
            this.jcache().put((Object)"setDataTypeKey", new HashSet<String>(Arrays.asList("1", "2")));
            try {
                jedis.strlen("setDataTypeKey");
                assert (false) : "Exception has to be thrown!";
            }
            catch (JedisDataException e) {
                RedisProtocolStringSelfTest.assertTrue((boolean)e.getMessage().startsWith("WRONGTYPE"));
            }
        }
    }

    @Test
    public void testSetRange() throws Exception {
        try (Jedis jedis = pool.getResource();){
            Assert.assertEquals((long)0L, (long)jedis.setrange("setRangeKey1", 0L, ""));
            this.jcache().put((Object)"setRangeKey2", (Object)"abc");
            Assert.assertEquals((long)3L, (long)jedis.setrange("setRangeKey2", 0L, ""));
            Assert.assertEquals((long)3L, (long)jedis.setrange("setRangeKeyPadded", 2L, "a"));
            try {
                jedis.setrange("setRangeKeyWrongOffset", -1L, "a");
                assert (false) : "Exception has to be thrown!";
            }
            catch (JedisDataException e) {
                RedisProtocolStringSelfTest.assertTrue((boolean)e.getMessage().startsWith("ERR"));
            }
            try {
                jedis.setrange("setRangeKeyWrongOffset2", 0x1FFFFFFFL, "a");
                assert (false) : "Exception has to be thrown!";
            }
            catch (JedisDataException e) {
                RedisProtocolStringSelfTest.assertTrue((boolean)e.getMessage().startsWith("ERR"));
            }
            this.jcache().put((Object)"setRangeKey3", (Object)"Hello World");
            Assert.assertEquals((long)11L, (long)jedis.setrange("setRangeKey3", 6L, "Redis"));
            this.jcache().put((Object)"setDataTypeKey", new HashSet<String>(Arrays.asList("1", "2")));
            try {
                jedis.setrange("setDataTypeKey", 0L, "Redis");
                assert (false) : "Exception has to be thrown!";
            }
            catch (JedisDataException e) {
                RedisProtocolStringSelfTest.assertTrue((boolean)e.getMessage().startsWith("WRONGTYPE"));
            }
        }
    }

    @Test
    public void testGetRange() throws Exception {
        try (Jedis jedis = pool.getResource();){
            Assert.assertEquals((Object)"", (Object)jedis.getrange("getRangeKeyNonExisting", 0L, 0L));
            this.jcache().put((Object)"getRangeKey", (Object)"This is a string");
            Assert.assertEquals((Object)"This", (Object)jedis.getrange("getRangeKey", 0L, 3L));
            Assert.assertEquals((Object)"ing", (Object)jedis.getrange("getRangeKey", -3L, -1L));
            Assert.assertEquals((Object)"This is a string", (Object)jedis.getrange("getRangeKey", 0L, -1L));
            Assert.assertEquals((Object)"string", (Object)jedis.getrange("getRangeKey", 10L, 100L));
            this.jcache().put((Object)"setDataTypeKey", new HashSet<String>(Arrays.asList("1", "2")));
            try {
                jedis.getrange("setDataTypeKey", 0L, 1L);
                assert (false) : "Exception has to be thrown!";
            }
            catch (JedisDataException e) {
                RedisProtocolStringSelfTest.assertTrue((boolean)e.getMessage().startsWith("WRONGTYPE"));
            }
        }
    }

    @Test
    public void testDel() throws Exception {
        this.jcache().put((Object)"delKey1", (Object)"abc");
        this.jcache().put((Object)"delKey2", (Object)"abcd");
        try (Jedis jedis = pool.getResource();){
            Assert.assertEquals((long)2L, (long)jedis.del(new String[]{"delKey1", "delKey2"}));
        }
    }

    @Test
    public void testExists() throws Exception {
        this.jcache().put((Object)"existsKey1", (Object)"abc");
        this.jcache().put((Object)"existsKey2", (Object)"abcd");
        try (Jedis jedis = pool.getResource();){
            Assert.assertFalse((boolean)jedis.exists("nonExistingDelKey"));
            Assert.assertEquals((long)2L, (long)jedis.exists(new String[]{"existsKey1", "existsKey2"}));
        }
    }

    @Test
    public void testExpire() throws Exception {
        this.testExpire(new Expiration(){

            @Override
            public long expire(Jedis jedis, String key) {
                return jedis.expire("k1", 2);
            }
        });
    }

    @Test
    public void testExpireMs() throws Exception {
        this.testExpire(new Expiration(){

            @Override
            public long expire(Jedis jedis, String key) {
                return jedis.pexpire("k1", 2000);
            }
        });
    }

    private void testExpire(Expiration exp) throws Exception {
        try (Jedis jedis = pool.getResource();){
            jedis.set("k1", "v1");
            Assert.assertTrue((boolean)jedis.exists("k1"));
            Assert.assertEquals((long)1L, (long)exp.expire(jedis, "k1"));
            Assert.assertEquals((Object)"v1", (Object)jedis.get("k1"));
            Thread.sleep(2100L);
            Assert.assertFalse((boolean)jedis.exists("k1"));
            Assert.assertEquals((long)0L, (long)jedis.expire("k1", 2));
        }
    }

    private static interface Expiration {
        public long expire(Jedis var1, String var2);
    }
}

