/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.logger.java.JavaLogger;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.jetbrains.annotations.Nullable;

final class TestMemcacheClient {
    private static final short HDR_LEN = 24;
    private static final short SERIALIZED_FLAG = 1;
    private static final short BOOLEAN_FLAG = 256;
    private static final short INT_FLAG = 512;
    private static final short LONG_FLAG = 768;
    private static final short DATE_FLAG = 1024;
    private static final short BYTE_FLAG = 1280;
    private static final short FLOAT_FLAG = 1536;
    private static final short DOUBLE_FLAG = 1792;
    private static final short BYTE_ARR_FLAG = 2048;
    private final IgniteLogger log = new JavaLogger();
    private final Marshaller jdkMarshaller = new JdkMarshaller();
    private final Socket sock;
    private final AtomicInteger opaqueCntr = new AtomicInteger(0);
    private final BlockingQueue<Response> queue = new LinkedBlockingQueue<Response>();
    private final Thread rdr;
    private static final Response QUIT_RESP = new Response(0, false, null, null);

    TestMemcacheClient(String host, int port) throws IgniteCheckedException {
        assert (host != null);
        assert (port > 0);
        try {
            this.sock = new Socket(host, port);
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to establish connection.", (Throwable)e);
        }
        this.rdr = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    InputStream in = TestMemcacheClient.this.sock.getInputStream();
                    ByteArrayOutputStream buf = new ByteArrayOutputStream();
                    boolean running = true;
                    block7: while (running) {
                        byte opCode = 0;
                        byte extrasLength = 0;
                        short keyLength = 0;
                        boolean success = false;
                        int totalLength = 0;
                        int opaque = 0;
                        short keyFlags = 0;
                        short valFlags = 0;
                        Object obj = null;
                        Object key = null;
                        int i = 0;
                        while (true) {
                            int symbol;
                            if ((symbol = in.read()) == -1) {
                                running = false;
                                continue block7;
                            }
                            byte b = (byte)symbol;
                            if (i == 1) {
                                opCode = b;
                            }
                            if (i == 2 || i == 3) {
                                buf.write(b);
                                if (i == 3) {
                                    keyLength = U.bytesToShort((byte[])buf.toByteArray(), (int)0);
                                    buf.reset();
                                }
                            } else if (i == 4) {
                                extrasLength = b;
                            } else if (i == 6 || i == 7) {
                                buf.write(b);
                                if (i == 7) {
                                    success = U.bytesToShort((byte[])buf.toByteArray(), (int)0) == 0;
                                    buf.reset();
                                }
                            } else if (i >= 8 && i <= 11) {
                                buf.write(b);
                                if (i == 11) {
                                    totalLength = U.bytesToInt((byte[])buf.toByteArray(), (int)0);
                                    buf.reset();
                                }
                            } else if (i >= 12 && i <= 15) {
                                buf.write(b);
                                if (i == 15) {
                                    opaque = U.bytesToInt((byte[])buf.toByteArray(), (int)0);
                                    buf.reset();
                                }
                            } else if (i >= 24 && i < 24 + extrasLength) {
                                buf.write(b);
                                if (i == 24 + extrasLength - 1) {
                                    byte[] rawFlags = buf.toByteArray();
                                    keyFlags = U.bytesToShort((byte[])rawFlags, (int)0);
                                    valFlags = U.bytesToShort((byte[])rawFlags, (int)2);
                                    buf.reset();
                                }
                            } else if (i >= 24 + extrasLength && i < 24 + extrasLength + keyLength) {
                                buf.write(b);
                                if (i == 24 + extrasLength + keyLength - 1) {
                                    key = TestMemcacheClient.this.decode(buf.toByteArray(), keyFlags);
                                    buf.reset();
                                }
                            } else if (i >= 24 + extrasLength + keyLength && i < 24 + totalLength) {
                                buf.write(b);
                                if (opCode == 5 || opCode == 6) {
                                    valFlags = 768;
                                }
                                if (i == 24 + totalLength - 1) {
                                    obj = TestMemcacheClient.this.decode(buf.toByteArray(), valFlags);
                                    buf.reset();
                                }
                            }
                            if (i == 24 + totalLength - 1) {
                                TestMemcacheClient.this.queue.add(new Response(opaque, success, key, obj));
                                continue block7;
                            }
                            ++i;
                        }
                    }
                }
                catch (IOException e) {
                    if (!Thread.currentThread().isInterrupted()) {
                        U.error((IgniteLogger)TestMemcacheClient.this.log, (Object)e);
                    }
                }
                catch (Exception e) {
                    U.error((IgniteLogger)TestMemcacheClient.this.log, (Object)e);
                }
                finally {
                    U.closeQuiet((Socket)TestMemcacheClient.this.sock);
                    TestMemcacheClient.this.queue.add(QUIT_RESP);
                }
            }
        });
        this.rdr.start();
    }

    public void shutdown() throws IgniteCheckedException {
        try {
            if (this.rdr != null) {
                this.rdr.interrupt();
                U.closeQuiet((Socket)this.sock);
                this.rdr.join();
            }
        }
        catch (InterruptedException e) {
            throw new IgniteCheckedException((Throwable)e);
        }
    }

    private Response makeRequest(Command cmd, @Nullable String cacheName, @Nullable Object key, @Nullable Object val, Long ... extras) throws IgniteCheckedException {
        assert (cmd != null);
        int opaque = this.opaqueCntr.getAndIncrement();
        try {
            this.sock.getOutputStream().write(this.createPacket(cmd, cacheName, key, val, opaque, extras));
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to send packet.", (Throwable)e);
        }
        try {
            while (true) {
                Response res;
                if ((res = this.queue.take()) == QUIT_RESP) {
                    return res;
                }
                if (res.getOpaque() == opaque) {
                    if (!res.isSuccess() && res.getObject() != null) {
                        throw new IgniteCheckedException((String)res.getObject());
                    }
                    return res;
                }
                this.queue.add(res);
            }
        }
        catch (InterruptedException e) {
            throw new IgniteCheckedException("Interrupted while waiting for response.", (Throwable)e);
        }
    }

    private List<Response> makeMultiRequest(Command cmd, @Nullable String cacheName, @Nullable Object key, @Nullable Object val, Long ... extras) throws IgniteCheckedException {
        assert (cmd != null);
        int opaque = this.opaqueCntr.getAndIncrement();
        LinkedList<Response> resList = new LinkedList<Response>();
        try {
            this.sock.getOutputStream().write(this.createPacket(cmd, cacheName, key, val, opaque, extras));
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to send packet.", (Throwable)e);
        }
        try {
            while (true) {
                Response res;
                if ((res = this.queue.take()) == QUIT_RESP) {
                    return resList;
                }
                if (res.getOpaque() == opaque) {
                    if (!res.isSuccess() && res.getObject() != null) {
                        throw new IgniteCheckedException((String)res.getObject());
                    }
                    if (res.getObject() == null) {
                        return resList;
                    }
                    resList.add(res);
                    continue;
                }
                this.queue.add(res);
            }
        }
        catch (InterruptedException e) {
            throw new IgniteCheckedException("Interrupted while waiting for response.", (Throwable)e);
        }
    }

    private byte[] createPacket(Command cmd, @Nullable String cacheName, @Nullable Object key, @Nullable Object val, int opaque, @Nullable Long[] extras) throws IgniteCheckedException {
        assert (cmd != null);
        assert (opaque >= 0);
        byte[] cacheNameBytes = cacheName != null ? cacheName.getBytes() : null;
        Data keyData = this.encode(key);
        Data valData = this.encode(val);
        int cacheNameLength = cacheNameBytes != null ? cacheNameBytes.length : 0;
        int extrasLength = cmd.extrasLength() + cacheNameLength;
        byte[] packet = new byte[24 + extrasLength + keyData.length() + valData.length()];
        packet[0] = -128;
        packet[1] = cmd.operationCode();
        U.shortToBytes((short)((short)keyData.length()), (byte[])packet, (int)2);
        packet[4] = (byte)extrasLength;
        U.intToBytes((int)(extrasLength + keyData.length() + valData.length()), (byte[])packet, (int)8);
        U.intToBytes((int)opaque, (byte[])packet, (int)12);
        if (extrasLength > 0) {
            if (extras != null) {
                int offset = 24;
                for (Long extra : extras) {
                    if (extra != null) {
                        U.longToBytes((long)extra, (byte[])packet, (int)offset);
                    }
                    offset += 8;
                }
            } else {
                U.shortToBytes((short)keyData.getFlags(), (byte[])packet, (int)24);
                U.shortToBytes((short)valData.getFlags(), (byte[])packet, (int)26);
            }
        }
        if (cacheNameBytes != null) {
            U.arrayCopy((byte[])cacheNameBytes, (int)0, (byte[])packet, (int)(24 + cmd.extrasLength()), (int)cacheNameLength);
        }
        if (keyData.getBytes() != null) {
            U.arrayCopy((byte[])keyData.getBytes(), (int)0, (byte[])packet, (int)(24 + extrasLength), (int)keyData.length());
        }
        if (valData.getBytes() != null) {
            U.arrayCopy((byte[])valData.getBytes(), (int)0, (byte[])packet, (int)(24 + extrasLength + keyData.length()), (int)valData.length());
        }
        return packet;
    }

    public <K, V> boolean cachePut(@Nullable String cacheName, K key, V val) throws IgniteCheckedException {
        assert (key != null);
        assert (val != null);
        return this.makeRequest(Command.PUT, cacheName, key, val, new Long[0]).isSuccess();
    }

    public <K, V> V cacheGet(@Nullable String cacheName, K key) throws IgniteCheckedException {
        assert (key != null);
        return (V)this.makeRequest(Command.GET, cacheName, key, null, new Long[0]).getObject();
    }

    public <K> boolean cacheRemove(@Nullable String cacheName, K key) throws IgniteCheckedException {
        assert (key != null);
        return this.makeRequest(Command.REMOVE, cacheName, key, null, new Long[0]).isSuccess();
    }

    public <K, V> boolean cacheAdd(@Nullable String cacheName, K key, V val) throws IgniteCheckedException {
        assert (key != null);
        assert (val != null);
        return this.makeRequest(Command.ADD, cacheName, key, val, new Long[0]).isSuccess();
    }

    public <K, V> boolean cacheReplace(@Nullable String cacheName, K key, V val) throws IgniteCheckedException {
        assert (key != null);
        assert (val != null);
        return this.makeRequest(Command.REPLACE, cacheName, key, val, new Long[0]).isSuccess();
    }

    public <K> Map<String, Long> cacheMetrics(@Nullable String cacheName) throws IgniteCheckedException {
        List<Response> raw = this.makeMultiRequest(Command.CACHE_METRICS, cacheName, null, null, new Long[0]);
        HashMap<String, Long> res = new HashMap<String, Long>(raw.size());
        for (Response resp : raw) {
            res.put((String)resp.key(), Long.parseLong(String.valueOf(resp.getObject())));
        }
        return res;
    }

    public <K> long increment(K key, @Nullable Long init, long incr) throws IgniteCheckedException {
        assert (key != null);
        return (Long)this.makeRequest(Command.INCREMENT, null, key, null, incr, init).getObject();
    }

    public <K> long decrement(K key, @Nullable Long init, long decr) throws IgniteCheckedException {
        assert (key != null);
        return (Long)this.makeRequest(Command.DECREMENT, null, key, null, decr, init).getObject();
    }

    public <K> boolean cacheAppend(@Nullable String cacheName, K key, String val) throws IgniteCheckedException {
        assert (key != null);
        assert (val != null);
        return this.makeRequest(Command.APPEND, cacheName, key, val, new Long[0]).isSuccess();
    }

    public <K> boolean cachePrepend(@Nullable String cacheName, K key, String val) throws IgniteCheckedException {
        assert (key != null);
        assert (val != null);
        return this.makeRequest(Command.PREPEND, cacheName, key, val, new Long[0]).isSuccess();
    }

    public String version() throws IgniteCheckedException {
        return (String)this.makeRequest(Command.VERSION, null, null, null, new Long[0]).getObject();
    }

    public void noop() throws IgniteCheckedException {
        Response res = this.makeRequest(Command.NOOP, null, null, null, new Long[0]);
        assert (res != null);
        assert (res.isSuccess());
        assert (res.getObject() == null);
    }

    public void quit() throws IgniteCheckedException {
        this.makeRequest(Command.QUIT, null, null, null, new Long[0]);
        assert (this.sock.isClosed());
    }

    public Data encode(@Nullable Object obj) throws IgniteCheckedException {
        byte[] bytes;
        if (obj == null) {
            return new Data(null, 0);
        }
        short flags = 0;
        if (obj instanceof String) {
            bytes = ((String)obj).getBytes();
        } else if (obj instanceof Boolean) {
            bytes = new byte[]{(byte)((Boolean)obj != false ? 49 : 48)};
            flags = (short)(flags | 0x100);
        } else if (obj instanceof Integer) {
            bytes = U.intToBytes((int)((Integer)obj));
            flags = (short)(flags | 0x200);
        } else if (obj instanceof Long) {
            bytes = U.longToBytes((long)((Long)obj));
            flags = (short)(flags | 0x300);
        } else if (obj instanceof Date) {
            bytes = U.longToBytes((long)((Date)obj).getTime());
            flags = (short)(flags | 0x400);
        } else if (obj instanceof Byte) {
            bytes = new byte[]{(Byte)obj};
            flags = (short)(flags | 0x500);
        } else if (obj instanceof Float) {
            bytes = U.intToBytes((int)Float.floatToIntBits(((Float)obj).floatValue()));
            flags = (short)(flags | 0x600);
        } else if (obj instanceof Double) {
            bytes = U.longToBytes((long)Double.doubleToLongBits((Double)obj));
            flags = (short)(flags | 0x700);
        } else if (obj instanceof byte[]) {
            bytes = (byte[])obj;
            flags = (short)(flags | 0x800);
        } else {
            bytes = this.jdkMarshaller.marshal(obj);
            flags = (short)(flags | 1);
        }
        return new Data(bytes, flags);
    }

    public Object decode(byte[] bytes, short flags) throws IgniteCheckedException {
        assert (bytes != null);
        assert (flags >= 0);
        if ((flags & 1) != 0) {
            return this.jdkMarshaller.unmarshal(bytes, this.getClass().getClassLoader());
        }
        int masked = flags & 0xFF00;
        switch (masked) {
            case 256: {
                return bytes[0] == 49;
            }
            case 512: {
                return U.bytesToInt((byte[])bytes, (int)0);
            }
            case 768: {
                return U.bytesToLong((byte[])bytes, (int)0);
            }
            case 1024: {
                return new Date(U.bytesToLong((byte[])bytes, (int)0));
            }
            case 1280: {
                return bytes[0];
            }
            case 1536: {
                return Float.valueOf(Float.intBitsToFloat(U.bytesToInt((byte[])bytes, (int)0)));
            }
            case 1792: {
                return Double.longBitsToDouble(U.bytesToLong((byte[])bytes, (int)0));
            }
            case 2048: {
                return bytes;
            }
        }
        return new String(bytes);
    }

    private static enum Command {
        GET(0, 4),
        PUT(1, 8),
        ADD(2, 8),
        REPLACE(3, 8),
        REMOVE(4, 4),
        INCREMENT(5, 20),
        DECREMENT(6, 20),
        QUIT(7, 0),
        CACHE_METRICS(16, 4),
        NOOP(10, 0),
        VERSION(11, 0),
        APPEND(14, 4),
        PREPEND(15, 4);

        private final byte opCode;
        private final int extrasLength;

        private Command(byte opCode, int extrasLength) {
            this.opCode = opCode;
            this.extrasLength = extrasLength;
        }

        public byte operationCode() {
            return this.opCode;
        }

        public int extrasLength() {
            return this.extrasLength;
        }
    }

    private static class Data {
        private final byte[] bytes;
        private final short flags;

        Data(@Nullable byte[] bytes, short flags) {
            assert (flags >= 0);
            this.bytes = bytes;
            this.flags = flags;
        }

        @Nullable
        public byte[] getBytes() {
            return this.bytes;
        }

        public short getFlags() {
            return this.flags;
        }

        public int length() {
            return this.bytes != null ? this.bytes.length : 0;
        }
    }

    private static class Response {
        private final int opaque;
        private final boolean success;
        private final Object key;
        private final Object obj;

        Response(int opaque, boolean success, @Nullable Object key, @Nullable Object obj) {
            assert (opaque >= 0);
            this.opaque = opaque;
            this.success = success;
            this.key = key;
            this.obj = obj;
        }

        int getOpaque() {
            return this.opaque;
        }

        boolean isSuccess() {
            return this.success;
        }

        Object key() {
            return this.key;
        }

        <T> T getObject() {
            return (T)this.obj;
        }
    }
}

