/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest;

import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientFactory;
import org.apache.ignite.internal.client.GridClientProtocol;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

public class RestProcessorStartSelfTest
extends GridCommonAbstractTest {
    private static final String HOST = "127.0.0.1";
    public static final int TCP_PORT = 11222;
    private CountDownLatch gridReady;
    private CountDownLatch proceed;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setLocalHost(HOST);
        assert (cfg.getConnectorConfiguration() == null);
        ConnectorConfiguration clientCfg = new ConnectorConfiguration();
        clientCfg.setPort(11222);
        cfg.setConnectorConfiguration(clientCfg);
        TestDiscoverySpi disc = new TestDiscoverySpi();
        disc.setIpFinder(sharedStaticIpFinder);
        cfg.setDiscoverySpi((DiscoverySpi)disc);
        return cfg;
    }

    protected void beforeTest() throws Exception {
        this.gridReady = new CountDownLatch(1);
        this.proceed = new CountDownLatch(1);
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
    }

    @Test
    public void testTcpStart() throws Exception {
        GridClientConfiguration clCfg = new GridClientConfiguration();
        clCfg.setProtocol(GridClientProtocol.TCP);
        clCfg.setServers(Collections.singleton("127.0.0.1:11222"));
        this.doTest(clCfg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTest(final GridClientConfiguration cfg) throws Exception {
        GridTestUtils.runAsync((Callable)new IgniteCallable<Object>(){

            public Object call() {
                try {
                    RestProcessorStartSelfTest.this.startGrid();
                }
                catch (Exception e) {
                    RestProcessorStartSelfTest.this.log().error("Grid start failed", (Throwable)e);
                    RestProcessorStartSelfTest.fail();
                }
                return null;
            }
        });
        try {
            this.gridReady.await();
            IgniteInternalFuture c = GridTestUtils.runAsync((Callable)new Callable<GridClient>(){

                @Override
                public GridClient call() throws Exception {
                    return GridClientFactory.start((GridClientConfiguration)cfg);
                }
            });
            try {
                this.proceed.countDown();
                ((GridClient)c.get()).compute().refreshTopology(false, false);
            }
            finally {
                GridClientFactory.stopAll();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            this.proceed.countDown();
        }
    }

    private class TestDiscoverySpi
    extends TcpDiscoverySpi {
        private TestDiscoverySpi() {
        }

        public void spiStart(@Nullable String igniteInstanceName) throws IgniteSpiException {
            RestProcessorStartSelfTest.this.gridReady.countDown();
            try {
                RestProcessorStartSelfTest.this.proceed.await();
            }
            catch (InterruptedException e) {
                throw new IgniteSpiException("Failed to await start signal.", (Throwable)e);
            }
            super.spiStart(igniteInstanceName);
        }
    }
}

