/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteVersionUtils;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.processors.cache.query.GridCacheSqlIndexMetadata;
import org.apache.ignite.internal.processors.cache.query.GridCacheSqlMetadata;
import org.apache.ignite.internal.processors.rest.GridRestCommand;
import org.apache.ignite.internal.processors.rest.JettyRestProcessorCommonSelfTest;
import org.apache.ignite.internal.processors.rest.SimplePerson;
import org.apache.ignite.internal.processors.rest.TestTask1;
import org.apache.ignite.internal.processors.rest.TestTask2;
import org.apache.ignite.internal.processors.rest.handlers.GridRestCommandHandler;
import org.apache.ignite.internal.processors.rest.model.VisorGatewayArgument;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.P1;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.cache.VisorCacheConfigurationCollectorTask;
import org.apache.ignite.internal.visor.cache.VisorCacheConfigurationCollectorTaskArg;
import org.apache.ignite.internal.visor.cache.VisorCacheStopTask;
import org.apache.ignite.internal.visor.cache.VisorCacheStopTaskArg;
import org.apache.ignite.jdbc.thin.JdbcThinStatementCancelSelfTest;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;

public abstract class JettyRestProcessorAbstractSelfTest
extends JettyRestProcessorCommonSelfTest {
    private static final String CHARSET = StandardCharsets.UTF_8.name();
    private static boolean memoryMetricsEnabled;
    private static final AtomicInteger KEY_GEN;
    private static final int EXPECTED_MIN_DURATION = 100;

    @Override
    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.initCache();
    }

    @Override
    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.grid(0).cluster().state(ClusterState.ACTIVE);
        this.grid(0).cache("default").removeAll();
        if (memoryMetricsEnabled) {
            memoryMetricsEnabled = false;
            this.restartGrid();
        }
    }

    @Override
    protected void afterTest() throws Exception {
        super.afterTest();
    }

    protected void assertResponseContainsError(String content, String err) throws IOException {
        JettyRestProcessorAbstractSelfTest.assertFalse((boolean)F.isEmpty((String)content));
        JettyRestProcessorAbstractSelfTest.assertNotNull((Object)err);
        JsonNode node = JSON_MAPPER.readTree(content);
        JettyRestProcessorAbstractSelfTest.assertTrue((node.get("successStatus").asInt() != 0 ? 1 : 0) != 0);
        JettyRestProcessorAbstractSelfTest.assertTrue((boolean)node.get("response").isNull());
        JettyRestProcessorAbstractSelfTest.assertTrue((boolean)node.get("error").asText().contains(err));
    }

    protected JsonNode assertResponseSucceeded(String content, boolean bulk) throws IOException {
        JettyRestProcessorAbstractSelfTest.assertNotNull((Object)content);
        JettyRestProcessorAbstractSelfTest.assertFalse((boolean)content.isEmpty());
        JsonNode node = JSON_MAPPER.readTree(content);
        JsonNode affNode = node.get("affinityNodeId");
        if (affNode != null) {
            JettyRestProcessorAbstractSelfTest.assertEquals((boolean)bulk, (boolean)affNode.isNull());
        }
        JettyRestProcessorAbstractSelfTest.assertEquals((int)0, (int)node.get("successStatus").asInt());
        JettyRestProcessorAbstractSelfTest.assertTrue((boolean)node.get("error").isNull());
        JettyRestProcessorAbstractSelfTest.assertNotSame((Object)this.securityEnabled(), (Object)node.get("sessionToken").isNull());
        return node.get("response");
    }

    private void assertCacheOperation(String content, Object res) throws IOException {
        JsonNode ret = this.assertResponseSucceeded(content, false);
        JettyRestProcessorAbstractSelfTest.assertEquals((String)String.valueOf(res), (String)(ret.isObject() ? ret.toString() : ret.asText()));
    }

    private void assertCacheBulkOperation(String content, Object res) throws IOException {
        JsonNode ret = this.assertResponseSucceeded(content, true);
        JettyRestProcessorAbstractSelfTest.assertEquals((String)String.valueOf(res), (String)ret.asText());
    }

    private void assertCacheMetrics(String content) throws IOException {
        JsonNode ret = this.assertResponseSucceeded(content, true);
        JettyRestProcessorAbstractSelfTest.assertTrue((boolean)ret.isObject());
    }

    protected JsonNode validateJsonResponse(String content) throws IOException {
        return this.validateJsonResponse(content, false);
    }

    protected JsonNode validateJsonResponse(String content, boolean errorExpected) throws IOException {
        return this.validateJsonResponse(content, errorExpected, false);
    }

    protected JsonNode validateJsonResponse(String content, boolean errorExpected, boolean canBeUnauthenticated) throws IOException {
        JettyRestProcessorAbstractSelfTest.assertNotNull((Object)content);
        JettyRestProcessorAbstractSelfTest.assertFalse((boolean)content.isEmpty());
        JsonNode node = JSON_MAPPER.readTree(content);
        JsonNode errNode = node.get("error");
        if (errorExpected) {
            JettyRestProcessorAbstractSelfTest.assertTrue((String)"Expected an error.", (!errNode.isNull() ? 1 : 0) != 0);
        } else {
            JettyRestProcessorAbstractSelfTest.assertTrue((String)("Unexpected error: " + errNode.asText()), (boolean)errNode.isNull());
        }
        JettyRestProcessorAbstractSelfTest.assertEquals((int)0, (int)node.get("successStatus").asInt());
        if (!canBeUnauthenticated) {
            JettyRestProcessorAbstractSelfTest.assertNotSame((Object)this.securityEnabled(), (Object)node.get("sessionToken").isNull());
        }
        return node.get(errorExpected ? "error" : "response");
    }

    protected JsonNode jsonTaskResult(String content) throws IOException {
        JettyRestProcessorAbstractSelfTest.assertNotNull((Object)content);
        JettyRestProcessorAbstractSelfTest.assertFalse((boolean)content.isEmpty());
        JsonNode node = JSON_MAPPER.readTree(content);
        JettyRestProcessorAbstractSelfTest.assertEquals((int)0, (int)node.get("successStatus").asInt());
        JettyRestProcessorAbstractSelfTest.assertTrue((boolean)node.get("error").isNull());
        JettyRestProcessorAbstractSelfTest.assertFalse((boolean)node.get("response").isNull());
        JettyRestProcessorAbstractSelfTest.assertEquals((boolean)this.securityEnabled(), (!node.get("sessionToken").isNull() ? 1 : 0) != 0);
        JsonNode res = node.get("response");
        JettyRestProcessorAbstractSelfTest.assertTrue((boolean)res.isObject());
        JettyRestProcessorAbstractSelfTest.assertFalse((boolean)res.get("id").isNull());
        JettyRestProcessorAbstractSelfTest.assertTrue((boolean)res.get("finished").asBoolean());
        JettyRestProcessorAbstractSelfTest.assertTrue((boolean)res.get("error").isNull());
        return res.get("result");
    }

    protected JsonNode jsonTaskErrorResult(String content) throws IOException {
        JettyRestProcessorAbstractSelfTest.assertNotNull((Object)content);
        JettyRestProcessorAbstractSelfTest.assertFalse((boolean)content.isEmpty());
        JsonNode node = JSON_MAPPER.readTree(content);
        JettyRestProcessorAbstractSelfTest.assertEquals((int)1, (int)node.get("successStatus").asInt());
        JettyRestProcessorAbstractSelfTest.assertFalse((boolean)node.get("error").isNull());
        JettyRestProcessorAbstractSelfTest.assertTrue((boolean)node.get("response").isNull());
        JsonNode error = node.get("error");
        JettyRestProcessorAbstractSelfTest.assertTrue((boolean)error.isTextual());
        return error;
    }

    @Test
    public void testGet() throws Exception {
        this.jcache().put((Object)"getKey", (Object)"getVal");
        String ret = this.content("default", GridRestCommand.CACHE_GET, "key", "getKey");
        this.info("Get command result: " + ret);
        this.assertCacheOperation(ret, "getVal");
    }

    private void checkJson(String json, Person p) throws IOException {
        JsonNode res = this.assertResponseSucceeded(json, false);
        JettyRestProcessorAbstractSelfTest.assertEquals((int)p.id, (int)res.get("id").asInt());
        JettyRestProcessorAbstractSelfTest.assertEquals((int)p.getOrganizationId(), (int)res.get("orgId").asInt());
        JettyRestProcessorAbstractSelfTest.assertEquals((String)p.getFirstName(), (String)res.get("firstName").asText());
        JettyRestProcessorAbstractSelfTest.assertEquals((String)p.getLastName(), (String)res.get("lastName").asText());
        JettyRestProcessorAbstractSelfTest.assertEquals((double)p.getSalary(), (double)res.get("salary").asDouble());
    }

    @Test
    public void testGetBinaryObjects() throws Exception {
        Person p = new Person(1, "John", "Doe", 300.0);
        this.jcache().put((Object)300, (Object)p);
        String ret = this.content("default", GridRestCommand.CACHE_GET, "keyType", "int", "key", "300");
        this.info("Get command result: " + ret);
        this.checkJson(ret, p);
        ret = this.content("default", GridRestCommand.CACHE_GET, "keyType", "int", "key", "300", "destId", this.grid(1).localNode().id().toString());
        this.info("Get command result: " + ret);
        this.checkJson(ret, p);
        SqlFieldsQuery qry = new SqlFieldsQuery("create table employee(id integer primary key, name varchar(100), salary integer);insert into employee(id, name, salary) values (1, 'Alex', 300);");
        this.grid(0).context().query().querySqlFields(qry, true, false);
        ret = this.content("SQL_PUBLIC_EMPLOYEE", GridRestCommand.CACHE_GET, "keyType", "int", "key", "1");
        this.info("Get command result: " + ret);
        JsonNode res = this.assertResponseSucceeded(ret, false);
        JettyRestProcessorAbstractSelfTest.assertEquals((String)"Alex", (String)res.get("NAME").asText());
        JettyRestProcessorAbstractSelfTest.assertEquals((int)300, (int)res.get("SALARY").asInt());
        CircularRef ref1 = new CircularRef(1, "Alex");
        CircularRef ref2 = new CircularRef(2, "300");
        CircularRef ref3 = new CircularRef(3, "220");
        ref1.ref(ref2);
        this.jcache().put((Object)220, (Object)ref1);
        ret = this.content("default", GridRestCommand.CACHE_GET, "keyType", "int", "key", "220");
        this.info("Get command result: " + ret);
        JsonNode json = this.assertResponseSucceeded(ret, false);
        JettyRestProcessorAbstractSelfTest.assertEquals((String)ref1.name, (String)json.get("name").asText());
        JettyRestProcessorAbstractSelfTest.assertEquals((String)ref1.ref.toString(), (String)json.get("ref").toString());
        ref2.ref(ref1);
        this.jcache().put((Object)222, (Object)ref1);
        ret = this.content("default", GridRestCommand.CACHE_GET, "keyType", "int", "key", "222");
        this.info("Get command result: " + ret);
        this.assertResponseContainsError(ret, "Failed convert to JSON object for circular references");
        ref1.ref(ref2);
        ref2.ref(ref3);
        ref3.ref(ref1);
        this.jcache().put((Object)223, (Object)ref1);
        ret = this.content("default", GridRestCommand.CACHE_GET, "keyType", "int", "key", "223");
        this.info("Get command result: " + ret);
        this.assertResponseContainsError(ret, "Failed convert to JSON object for circular references");
    }

    @Test
    public void testNullMapKeyAndValue() throws Exception {
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put(null, null);
        map1.put("key", "value");
        this.jcache().put((Object)"mapKey1", map1);
        String ret = this.content("default", GridRestCommand.CACHE_GET, "key", "mapKey1");
        this.info("Get command result: " + ret);
        JsonNode res = this.validateJsonResponse(ret);
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)F.asMap((Object)"", null, (Object)"key", (Object)"value"), (Object)JSON_MAPPER.treeToValue((TreeNode)res, HashMap.class));
        HashMap<String, String> map2 = new HashMap<String, String>();
        map2.put(null, "value");
        map2.put("key", null);
        this.jcache().put((Object)"mapKey2", map2);
        ret = this.content("default", GridRestCommand.CACHE_GET, "key", "mapKey2");
        this.info("Get command result: " + ret);
        res = this.validateJsonResponse(ret);
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)F.asMap((Object)"", (Object)"value", (Object)"key", null), (Object)JSON_MAPPER.treeToValue((TreeNode)res, HashMap.class));
    }

    @Test
    public void testSimpleObject() throws Exception {
        SimplePerson p = new SimplePerson(1, "Test", Date.valueOf("1977-01-26"), 1000.55, 39, "CIO", 25);
        this.jcache().put((Object)"simplePersonKey", (Object)p);
        String ret = this.content("default", GridRestCommand.CACHE_GET, "key", "simplePersonKey");
        this.info("Get command result: " + ret);
        JsonNode res = this.assertResponseSucceeded(ret, false);
        JettyRestProcessorAbstractSelfTest.assertEquals((int)p.id, (int)res.get("id").asInt());
        JettyRestProcessorAbstractSelfTest.assertEquals((String)p.name, (String)res.get("name").asText());
        JettyRestProcessorAbstractSelfTest.assertEquals((String)p.birthday.toString(), (String)res.get("birthday").asText());
        JettyRestProcessorAbstractSelfTest.assertEquals((double)p.salary, (double)res.get("salary").asDouble());
        JettyRestProcessorAbstractSelfTest.assertNull((Object)res.get("age"));
        JettyRestProcessorAbstractSelfTest.assertEquals((String)p.post, (String)res.get("post").asText());
        JettyRestProcessorAbstractSelfTest.assertEquals((int)25, (int)res.get("bonus").asInt());
    }

    @Test
    public void testDate() throws Exception {
        java.util.Date utilDate = new java.util.Date();
        DateFormat formatter = DateFormat.getDateTimeInstance(2, 2, Locale.US);
        String date = formatter.format(utilDate);
        this.jcache().put((Object)"utilDateKey", (Object)utilDate);
        String ret = this.content("default", GridRestCommand.CACHE_GET, "key", "utilDateKey");
        this.info("Get command result: " + ret);
        this.assertCacheOperation(ret, date);
        Date sqlDate = new Date(utilDate.getTime());
        this.jcache().put((Object)"sqlDateKey", (Object)sqlDate);
        ret = this.content("default", GridRestCommand.CACHE_GET, "key", "sqlDateKey");
        this.info("Get SQL result: " + ret);
        this.assertCacheOperation(ret, sqlDate.toString());
        this.jcache().put((Object)"timestampKey", (Object)new Timestamp(utilDate.getTime()));
        ret = this.content("default", GridRestCommand.CACHE_GET, "key", "timestampKey");
        this.info("Get timestamp: " + ret);
        this.assertCacheOperation(ret, date);
    }

    @Test
    public void testUUID() throws Exception {
        UUID uuid = UUID.randomUUID();
        this.jcache().put((Object)"uuidKey", (Object)uuid);
        String ret = this.content("default", GridRestCommand.CACHE_GET, "key", "uuidKey");
        this.info("Get command result: " + ret);
        this.assertCacheOperation(ret, uuid.toString());
        IgniteUuid igniteUuid = IgniteUuid.fromUuid((UUID)uuid);
        this.jcache().put((Object)"igniteUuidKey", (Object)igniteUuid);
        ret = this.content("default", GridRestCommand.CACHE_GET, "key", "igniteUuidKey");
        this.info("Get command result: " + ret);
        this.assertCacheOperation(ret, igniteUuid.toString());
    }

    @Test
    public void testTuple() throws Exception {
        T2 t = new T2((Object)"key", (Object)"value");
        this.jcache().put((Object)"tupleKey", (Object)t);
        String ret = this.content("default", GridRestCommand.CACHE_GET, "key", "tupleKey");
        this.info("Get command result: " + ret);
        JsonNode res = this.assertResponseSucceeded(ret, false);
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)t.getKey(), (Object)res.get("key").asText());
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)t.getValue(), (Object)res.get("value").asText());
    }

    @Test
    public void testCacheSize() throws Exception {
        this.jcache().removeAll();
        this.jcache().put((Object)"getKey", (Object)"getVal");
        String ret = this.content("default", GridRestCommand.CACHE_SIZE, new String[0]);
        this.info("Size command result: " + ret);
        this.assertCacheBulkOperation(ret, 1);
    }

    @Test
    public void testIgniteName() throws Exception {
        String ret = this.content(null, GridRestCommand.NAME, new String[0]);
        this.info("Name command result: " + ret);
        JettyRestProcessorAbstractSelfTest.assertEquals((String)this.getTestIgniteInstanceName(0), (String)this.validateJsonResponse(ret).asText());
    }

    private void checkGetOrCreateAndDestroy(String cacheName, CacheMode mode, int backups, CacheWriteSynchronizationMode wrtSync, String cacheGrp, String dataRegion, String ... params) throws Exception {
        String ret = this.content(cacheName, GridRestCommand.GET_OR_CREATE_CACHE, params);
        this.info("GetOrCreateCache command result: " + ret);
        this.validateJsonResponse(ret);
        IgniteCache cache = this.grid(0).cache(cacheName);
        cache.put((Object)"1", (Object)"1");
        CacheConfiguration ccfg = (CacheConfiguration)cache.getConfiguration(CacheConfiguration.class);
        JettyRestProcessorAbstractSelfTest.assertEquals((int)backups, (int)ccfg.getBackups());
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)mode, (Object)ccfg.getCacheMode());
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)wrtSync, (Object)ccfg.getWriteSynchronizationMode());
        if (!F.isEmpty((String)cacheGrp)) {
            JettyRestProcessorAbstractSelfTest.assertEquals((String)cacheGrp, (String)ccfg.getGroupName());
        }
        if (!F.isEmpty((String)dataRegion)) {
            JettyRestProcessorAbstractSelfTest.assertEquals((String)dataRegion, (String)ccfg.getDataRegionName());
        }
        ret = this.content(cacheName, GridRestCommand.DESTROY_CACHE, new String[0]);
        JettyRestProcessorAbstractSelfTest.assertTrue((boolean)this.validateJsonResponse(ret).isNull());
        JettyRestProcessorAbstractSelfTest.assertNull((Object)this.grid(0).cache(cacheName));
    }

    @Test
    public void testGetOrCreateCache() throws Exception {
        this.checkGetOrCreateAndDestroy("testCache", CacheMode.PARTITIONED, 0, CacheWriteSynchronizationMode.FULL_SYNC, null, null, new String[0]);
        this.checkGetOrCreateAndDestroy("testCache", CacheMode.PARTITIONED, 3, CacheWriteSynchronizationMode.FULL_SYNC, null, null, "backups", "3");
        this.checkGetOrCreateAndDestroy("testCache", CacheMode.PARTITIONED, 2, CacheWriteSynchronizationMode.FULL_ASYNC, null, null, "backups", "2", "writeSynchronizationMode", CacheWriteSynchronizationMode.FULL_ASYNC.name());
        this.checkGetOrCreateAndDestroy("testCache", CacheMode.REPLICATED, Integer.MAX_VALUE, CacheWriteSynchronizationMode.FULL_ASYNC, null, null, "templateName", "REPLICATED", "writeSynchronizationMode", CacheWriteSynchronizationMode.FULL_ASYNC.name());
        this.checkGetOrCreateAndDestroy("testCache", CacheMode.REPLICATED, Integer.MAX_VALUE, CacheWriteSynchronizationMode.FULL_ASYNC, null, null, "templateName", "REPLICATED", "backups", "0", "writeSynchronizationMode", CacheWriteSynchronizationMode.FULL_ASYNC.name());
        this.checkGetOrCreateAndDestroy("testCache", CacheMode.PARTITIONED, 1, CacheWriteSynchronizationMode.FULL_ASYNC, "testGroup", null, "templateName", "PARTITIONED", "backups", "1", "writeSynchronizationMode", CacheWriteSynchronizationMode.FULL_ASYNC.name(), "cacheGroup", "testGroup");
        this.checkGetOrCreateAndDestroy("testCache", CacheMode.PARTITIONED, 2, CacheWriteSynchronizationMode.FULL_ASYNC, null, "testDataRegion", "templateName", "PARTITIONED", "backups", "2", "writeSynchronizationMode", CacheWriteSynchronizationMode.FULL_ASYNC.name(), "dataRegion", "testDataRegion");
        this.checkGetOrCreateAndDestroy("testCache", CacheMode.PARTITIONED, 3, CacheWriteSynchronizationMode.FULL_ASYNC, "testGroup", "testDataRegion", "templateName", "PARTITIONED", "backups", "3", "writeSynchronizationMode", CacheWriteSynchronizationMode.FULL_ASYNC.name(), "cacheGroup", "testGroup", "dataRegion", "testDataRegion");
    }

    @Test
    public void testGetAll() throws Exception {
        Map entries = F.asMap((Object)"getKey1", (Object)"getVal1", (Object)"getKey2", (Object)"getVal2");
        this.jcache().putAll(entries);
        String ret = this.content("default", GridRestCommand.CACHE_GET_ALL, "k1", "getKey1", "k2", "getKey2");
        this.info("Get all command result: " + ret);
        JsonNode res = this.assertResponseSucceeded(ret, true);
        JettyRestProcessorAbstractSelfTest.assertTrue((boolean)res.isObject());
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)entries, (Object)JSON_MAPPER.treeToValue((TreeNode)res, Map.class));
    }

    @Test
    public void testIncorrectPut() throws Exception {
        String ret = this.content("default", GridRestCommand.CACHE_PUT, "key", "key0");
        this.assertResponseContainsError(ret, "Failed to find mandatory parameter in request: val");
    }

    @Test
    public void testContainsKey() throws Exception {
        this.grid(0).cache("default").put((Object)"key0", (Object)"val0");
        String ret = this.content("default", GridRestCommand.CACHE_CONTAINS_KEY, "key", "key0");
        this.assertCacheOperation(ret, true);
    }

    @Test
    public void testContainsKeys() throws Exception {
        this.grid(0).cache("default").put((Object)"key0", (Object)"val0");
        this.grid(0).cache("default").put((Object)"key1", (Object)"val1");
        String ret = this.content("default", GridRestCommand.CACHE_CONTAINS_KEYS, "k1", "key0", "k2", "key1");
        this.assertCacheBulkOperation(ret, true);
    }

    @Test
    public void testGetAndPut() throws Exception {
        this.grid(0).cache("default").put((Object)"key0", (Object)"val0");
        String ret = this.content("default", GridRestCommand.CACHE_GET_AND_PUT, "key", "key0", "val", "val1");
        this.assertCacheOperation(ret, "val0");
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)"val1", (Object)this.grid(0).cache("default").get((Object)"key0"));
    }

    @Test
    public void testGetAndPutIfAbsent() throws Exception {
        this.grid(0).cache("default").put((Object)"key0", (Object)"val0");
        String ret = this.content("default", GridRestCommand.CACHE_GET_AND_PUT_IF_ABSENT, "key", "key0", "val", "val1");
        this.assertCacheOperation(ret, "val0");
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)"val0", (Object)this.grid(0).cache("default").get((Object)"key0"));
    }

    @Test
    public void testPutIfAbsent2() throws Exception {
        String ret = this.content("default", GridRestCommand.CACHE_PUT_IF_ABSENT, "key", "key0", "val", "val1");
        this.assertCacheOperation(ret, true);
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)"val1", (Object)this.grid(0).cache("default").get((Object)"key0"));
    }

    @Test
    public void testRemoveValue() throws Exception {
        this.grid(0).cache("default").put((Object)"key0", (Object)"val0");
        String ret = this.content("default", GridRestCommand.CACHE_REMOVE_VALUE, "key", "key0", "val", "val1");
        this.assertCacheOperation(ret, false);
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)"val0", (Object)this.grid(0).cache("default").get((Object)"key0"));
        ret = this.content("default", GridRestCommand.CACHE_REMOVE_VALUE, "key", "key0", "val", "val0");
        this.assertCacheOperation(ret, true);
        JettyRestProcessorAbstractSelfTest.assertNull((Object)this.grid(0).cache("default").get((Object)"key0"));
    }

    @Test
    public void testGetAndRemove() throws Exception {
        this.grid(0).cache("default").put((Object)"key0", (Object)"val0");
        String ret = this.content("default", GridRestCommand.CACHE_GET_AND_REMOVE, "key", "key0");
        this.assertCacheOperation(ret, "val0");
        JettyRestProcessorAbstractSelfTest.assertNull((Object)this.grid(0).cache("default").get((Object)"key0"));
    }

    @Test
    public void testReplaceValue() throws Exception {
        this.grid(0).cache("default").put((Object)"key0", (Object)"val0");
        String ret = this.content("default", GridRestCommand.CACHE_REPLACE_VALUE, "key", "key0", "val", "val1", "val2", "val2");
        this.assertCacheOperation(ret, false);
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)"val0", (Object)this.grid(0).cache("default").get((Object)"key0"));
        ret = this.content("default", GridRestCommand.CACHE_REPLACE_VALUE, "key", "key0", "val", "val1", "val2", "val0");
        this.assertCacheOperation(ret, true);
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)"val1", (Object)this.grid(0).cache("default").get((Object)"key0"));
    }

    @Test
    public void testGetAndReplace() throws Exception {
        this.grid(0).cache("default").put((Object)"key0", (Object)"val0");
        String ret = this.content("default", GridRestCommand.CACHE_GET_AND_REPLACE, "key", "key0", "val", "val1");
        this.assertCacheOperation(ret, "val0");
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)"val1", (Object)this.grid(0).cache("default").get((Object)"key0"));
    }

    @Test
    public void testClusterStateChange() throws Exception {
        try {
            this.changeClusterState(GridRestCommand.CLUSTER_SET_STATE, ClusterState.ACTIVE, ClusterState.ACTIVE_READ_ONLY, false, true);
            this.changeClusterState(GridRestCommand.CLUSTER_SET_STATE, ClusterState.ACTIVE_READ_ONLY, ClusterState.INACTIVE, false, false);
            this.changeClusterState(GridRestCommand.CLUSTER_SET_STATE, ClusterState.ACTIVE_READ_ONLY, ClusterState.INACTIVE, true, true);
            this.changeClusterState(GridRestCommand.CLUSTER_SET_STATE, ClusterState.INACTIVE, ClusterState.ACTIVE, false, true);
            this.changeClusterState(GridRestCommand.CLUSTER_SET_STATE, ClusterState.ACTIVE, ClusterState.ACTIVE, false, true);
            this.changeClusterState(GridRestCommand.CLUSTER_SET_STATE, ClusterState.ACTIVE, ClusterState.INACTIVE, false, false);
            this.changeClusterState(GridRestCommand.CLUSTER_SET_STATE, ClusterState.ACTIVE, ClusterState.INACTIVE, true, true);
            this.changeClusterState(GridRestCommand.CLUSTER_SET_STATE, ClusterState.INACTIVE, ClusterState.INACTIVE, false, true);
            this.changeClusterState(GridRestCommand.CLUSTER_SET_STATE, ClusterState.INACTIVE, ClusterState.INACTIVE, true, true);
            this.changeClusterState(GridRestCommand.CLUSTER_SET_STATE, ClusterState.INACTIVE, ClusterState.ACTIVE_READ_ONLY, false, true);
            this.changeClusterState(GridRestCommand.CLUSTER_SET_STATE, ClusterState.ACTIVE_READ_ONLY, ClusterState.ACTIVE_READ_ONLY, false, true);
            this.changeClusterState(GridRestCommand.CLUSTER_SET_STATE, ClusterState.ACTIVE_READ_ONLY, ClusterState.ACTIVE, false, true);
            this.changeClusterStateByDepricatedCommands(GridRestCommand.CLUSTER_ACTIVATE, GridRestCommand.CLUSTER_DEACTIVATE);
            this.changeClusterStateByDepricatedCommands(GridRestCommand.CLUSTER_ACTIVE, GridRestCommand.CLUSTER_INACTIVE);
        }
        finally {
            this.grid(0).cluster().state(ClusterState.ACTIVE);
            this.initCache();
        }
    }

    private void changeClusterStateByDepricatedCommands(GridRestCommand activateCmd, GridRestCommand deactivateCmd) throws Exception {
        JettyRestProcessorAbstractSelfTest.assertTrue((String)activateCmd.name(), (activateCmd == GridRestCommand.CLUSTER_ACTIVE || activateCmd == GridRestCommand.CLUSTER_ACTIVATE ? 1 : 0) != 0);
        JettyRestProcessorAbstractSelfTest.assertTrue((String)deactivateCmd.name(), (deactivateCmd == GridRestCommand.CLUSTER_INACTIVE || deactivateCmd == GridRestCommand.CLUSTER_DEACTIVATE ? 1 : 0) != 0);
        this.grid(0).cluster().state(ClusterState.ACTIVE);
        this.changeClusterState(deactivateCmd, ClusterState.ACTIVE, ClusterState.INACTIVE, false, false);
        this.changeClusterState(deactivateCmd, ClusterState.ACTIVE, ClusterState.INACTIVE, true, true);
        this.changeClusterState(activateCmd, ClusterState.INACTIVE, ClusterState.ACTIVE, false, true);
        this.grid(0).cluster().state(ClusterState.ACTIVE_READ_ONLY);
        this.changeClusterState(deactivateCmd, ClusterState.ACTIVE_READ_ONLY, ClusterState.INACTIVE, false, false);
        this.changeClusterState(deactivateCmd, ClusterState.ACTIVE_READ_ONLY, ClusterState.INACTIVE, true, true);
    }

    @Test
    public void testPut() throws Exception {
        String ret = this.content("default", GridRestCommand.CACHE_PUT, "key", "putKey", "val", "putVal");
        this.info("Put command result: " + ret);
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)"putVal", (Object)this.jcache().localPeek((Object)"putKey", new CachePeekMode[0]));
        this.assertCacheOperation(ret, true);
    }

    @Test
    public void testPutWithExpiration() throws Exception {
        String ret = this.content("default", GridRestCommand.CACHE_PUT, "key", "putKey", "val", "putVal", "exp", "2000");
        this.assertCacheOperation(ret, true);
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)"putVal", (Object)this.jcache().get((Object)"putKey"));
        Thread.sleep(2100L);
        JettyRestProcessorAbstractSelfTest.assertNull((Object)this.jcache().get((Object)"putKey"));
    }

    @Test
    public void testAdd() throws Exception {
        this.jcache().put((Object)"addKey1", (Object)"addVal1");
        String ret = this.content("default", GridRestCommand.CACHE_ADD, "key", "addKey2", "val", "addVal2");
        this.assertCacheOperation(ret, true);
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)"addVal1", (Object)this.jcache().localPeek((Object)"addKey1", new CachePeekMode[0]));
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)"addVal2", (Object)this.jcache().localPeek((Object)"addKey2", new CachePeekMode[0]));
    }

    @Test
    public void testAddWithExpiration() throws Exception {
        String ret = this.content("default", GridRestCommand.CACHE_ADD, "key", "addKey", "val", "addVal", "exp", "2000");
        this.assertCacheOperation(ret, true);
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)"addVal", (Object)this.jcache().get((Object)"addKey"));
        Thread.sleep(2100L);
        JettyRestProcessorAbstractSelfTest.assertNull((Object)this.jcache().get((Object)"addKey"));
    }

    @Test
    public void testPutAll() throws Exception {
        String ret = this.content("default", GridRestCommand.CACHE_PUT_ALL, "k1", "putKey1", "k2", "putKey2", "v1", "putVal1", "v2", "putVal2");
        this.info("Put all command result: " + ret);
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)"putVal1", (Object)this.jcache().localPeek((Object)"putKey1", new CachePeekMode[0]));
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)"putVal2", (Object)this.jcache().localPeek((Object)"putKey2", new CachePeekMode[0]));
        this.assertCacheBulkOperation(ret, true);
    }

    @Test
    public void testRemove() throws Exception {
        this.jcache().put((Object)"rmvKey", (Object)"rmvVal");
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)"rmvVal", (Object)this.jcache().localPeek((Object)"rmvKey", new CachePeekMode[0]));
        String ret = this.content("default", GridRestCommand.CACHE_REMOVE, "key", "rmvKey");
        this.info("Remove command result: " + ret);
        JettyRestProcessorAbstractSelfTest.assertNull((Object)this.jcache().localPeek((Object)"rmvKey", new CachePeekMode[0]));
        this.assertCacheOperation(ret, true);
    }

    @Test
    public void testRemoveAll() throws Exception {
        this.jcache().put((Object)"rmvKey1", (Object)"rmvVal1");
        this.jcache().put((Object)"rmvKey2", (Object)"rmvVal2");
        this.jcache().put((Object)"rmvKey3", (Object)"rmvVal3");
        this.jcache().put((Object)"rmvKey4", (Object)"rmvVal4");
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)"rmvVal1", (Object)this.jcache().localPeek((Object)"rmvKey1", new CachePeekMode[0]));
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)"rmvVal2", (Object)this.jcache().localPeek((Object)"rmvKey2", new CachePeekMode[0]));
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)"rmvVal3", (Object)this.jcache().localPeek((Object)"rmvKey3", new CachePeekMode[0]));
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)"rmvVal4", (Object)this.jcache().localPeek((Object)"rmvKey4", new CachePeekMode[0]));
        String ret = this.content("default", GridRestCommand.CACHE_REMOVE_ALL, "k1", "rmvKey1", "k2", "rmvKey2");
        this.info("Remove all command result: " + ret);
        JettyRestProcessorAbstractSelfTest.assertNull((Object)this.jcache().localPeek((Object)"rmvKey1", new CachePeekMode[0]));
        JettyRestProcessorAbstractSelfTest.assertNull((Object)this.jcache().localPeek((Object)"rmvKey2", new CachePeekMode[0]));
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)"rmvVal3", (Object)this.jcache().localPeek((Object)"rmvKey3", new CachePeekMode[0]));
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)"rmvVal4", (Object)this.jcache().localPeek((Object)"rmvKey4", new CachePeekMode[0]));
        this.assertCacheBulkOperation(ret, true);
        ret = this.content("default", GridRestCommand.CACHE_REMOVE_ALL, new String[0]);
        this.info("Remove all command result: " + ret);
        JettyRestProcessorAbstractSelfTest.assertNull((Object)this.jcache().localPeek((Object)"rmvKey1", new CachePeekMode[0]));
        JettyRestProcessorAbstractSelfTest.assertNull((Object)this.jcache().localPeek((Object)"rmvKey2", new CachePeekMode[0]));
        JettyRestProcessorAbstractSelfTest.assertNull((Object)this.jcache().localPeek((Object)"rmvKey3", new CachePeekMode[0]));
        JettyRestProcessorAbstractSelfTest.assertNull((Object)this.jcache().localPeek((Object)"rmvKey4", new CachePeekMode[0]));
        JettyRestProcessorAbstractSelfTest.assertEquals((int)0, (int)this.jcache().localSize(new CachePeekMode[0]));
        this.assertCacheBulkOperation(ret, true);
    }

    @Test
    public void testCas() throws Exception {
        this.jcache().put((Object)"casKey", (Object)"casOldVal");
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)"casOldVal", (Object)this.jcache().localPeek((Object)"casKey", new CachePeekMode[0]));
        String ret = this.content("default", GridRestCommand.CACHE_CAS, "key", "casKey", "val2", "casOldVal", "val1", "casNewVal");
        this.info("CAS command result: " + ret);
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)"casNewVal", (Object)this.jcache().localPeek((Object)"casKey", new CachePeekMode[0]));
        this.assertCacheOperation(ret, true);
        this.jcache().remove((Object)"casKey");
    }

    @Test
    public void testReplace() throws Exception {
        this.jcache().put((Object)"repKey", (Object)"repOldVal");
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)"repOldVal", (Object)this.jcache().localPeek((Object)"repKey", new CachePeekMode[0]));
        String ret = this.content("default", GridRestCommand.CACHE_REPLACE, "key", "repKey", "val", "repVal");
        this.info("Replace command result: " + ret);
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)"repVal", (Object)this.jcache().localPeek((Object)"repKey", new CachePeekMode[0]));
        this.assertCacheOperation(ret, true);
    }

    @Test
    public void testReplaceWithExpiration() throws Exception {
        this.jcache().put((Object)"replaceKey", (Object)"replaceVal");
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)"replaceVal", (Object)this.jcache().get((Object)"replaceKey"));
        String ret = this.content("default", GridRestCommand.CACHE_REPLACE, "key", "replaceKey", "val", "replaceValNew", "exp", "2000");
        this.assertCacheOperation(ret, true);
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)"replaceValNew", (Object)this.jcache().get((Object)"replaceKey"));
        Thread.sleep(2100L);
        JettyRestProcessorAbstractSelfTest.assertNull((Object)this.jcache().get((Object)"replaceKey"));
    }

    @Test
    public void testAppend() throws Exception {
        this.jcache().put((Object)"appendKey", (Object)"appendVal");
        String ret = this.content("default", GridRestCommand.CACHE_APPEND, "key", "appendKey", "val", "_suffix");
        this.assertCacheOperation(ret, true);
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)"appendVal_suffix", (Object)this.jcache().get((Object)"appendKey"));
    }

    @Test
    public void testPrepend() throws Exception {
        this.jcache().put((Object)"prependKey", (Object)"prependVal");
        String ret = this.content("default", GridRestCommand.CACHE_PREPEND, "key", "prependKey", "val", "prefix_");
        this.assertCacheOperation(ret, true);
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)"prefix_prependVal", (Object)this.jcache().get((Object)"prependKey"));
    }

    @Test
    public void testIncrement() throws Exception {
        String ret = this.content("default", GridRestCommand.ATOMIC_INCREMENT, "key", "incrKey", "init", "2", "delta", "3");
        JsonNode res = this.validateJsonResponse(ret);
        JettyRestProcessorAbstractSelfTest.assertEquals((int)5, (int)res.asInt());
        JettyRestProcessorAbstractSelfTest.assertEquals((long)5L, (long)this.grid(0).atomicLong("incrKey", 0L, true).get());
        ret = this.content("default", GridRestCommand.ATOMIC_INCREMENT, "key", "incrKey", "delta", "10");
        res = this.validateJsonResponse(ret);
        JettyRestProcessorAbstractSelfTest.assertEquals((int)15, (int)res.asInt());
        JettyRestProcessorAbstractSelfTest.assertEquals((long)15L, (long)this.grid(0).atomicLong("incrKey", 0L, true).get());
    }

    @Test
    public void testDecrement() throws Exception {
        String ret = this.content("default", GridRestCommand.ATOMIC_DECREMENT, "key", "decrKey", "init", "15", "delta", "10");
        JsonNode res = this.validateJsonResponse(ret);
        JettyRestProcessorAbstractSelfTest.assertEquals((int)5, (int)res.asInt());
        JettyRestProcessorAbstractSelfTest.assertEquals((long)5L, (long)this.grid(0).atomicLong("decrKey", 0L, true).get());
        ret = this.content("default", GridRestCommand.ATOMIC_DECREMENT, "key", "decrKey", "delta", "3");
        res = this.validateJsonResponse(ret);
        JettyRestProcessorAbstractSelfTest.assertEquals((int)2, (int)res.asInt());
        JettyRestProcessorAbstractSelfTest.assertEquals((long)2L, (long)this.grid(0).atomicLong("decrKey", 0L, true).get());
    }

    @Test
    public void testCar() throws Exception {
        this.jcache().put((Object)"casKey", (Object)"casOldVal");
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)"casOldVal", (Object)this.jcache().localPeek((Object)"casKey", new CachePeekMode[0]));
        String ret = this.content("default", GridRestCommand.CACHE_CAS, "key", "casKey", "val2", "casOldVal");
        this.info("CAR command result: " + ret);
        JettyRestProcessorAbstractSelfTest.assertNull((Object)this.jcache().localPeek((Object)"casKey", new CachePeekMode[0]));
        this.assertCacheOperation(ret, true);
    }

    @Test
    public void testPutIfAbsent() throws Exception {
        JettyRestProcessorAbstractSelfTest.assertNull((Object)this.jcache().localPeek((Object)"casKey", new CachePeekMode[0]));
        String ret = this.content("default", GridRestCommand.CACHE_CAS, "key", "casKey", "val1", "casNewVal");
        this.info("PutIfAbsent command result: " + ret);
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)"casNewVal", (Object)this.jcache().localPeek((Object)"casKey", new CachePeekMode[0]));
        this.assertCacheOperation(ret, true);
    }

    @Test
    public void testCasRemove() throws Exception {
        this.jcache().put((Object)"casKey", (Object)"casVal");
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)"casVal", (Object)this.jcache().localPeek((Object)"casKey", new CachePeekMode[0]));
        String ret = this.content("default", GridRestCommand.CACHE_CAS, "key", "casKey");
        this.info("CAS Remove command result: " + ret);
        JettyRestProcessorAbstractSelfTest.assertNull((Object)this.jcache().localPeek((Object)"casKey", new CachePeekMode[0]));
        this.assertCacheOperation(ret, true);
    }

    @Test
    public void testMetrics() throws Exception {
        String ret = this.content("default", GridRestCommand.CACHE_METRICS, new String[0]);
        this.info("Cache metrics command result: " + ret);
        this.assertCacheMetrics(ret);
    }

    @Test
    public void testProbeCommand() throws Exception {
        String ret = this.content(null, GridRestCommand.PROBE, new String[0]);
        this.validateJsonResponse(ret, false, true);
    }

    private void testMetadata(Collection<GridCacheSqlMetadata> metas, JsonNode arr) throws Exception {
        JettyRestProcessorAbstractSelfTest.assertTrue((boolean)arr.isArray());
        for (JsonNode item : arr) {
            JsonNode cacheNameNode = item.get("cacheName");
            final String cacheName = cacheNameNode == null || "null".equals(cacheNameNode.asText()) ? null : cacheNameNode.asText();
            GridCacheSqlMetadata meta = (GridCacheSqlMetadata)F.find(metas, null, (IgnitePredicate[])new IgnitePredicate[]{new P1<GridCacheSqlMetadata>(){

                public boolean apply(GridCacheSqlMetadata meta) {
                    return F.eq((Object)meta.cacheName(), (Object)cacheName);
                }
            }});
            JettyRestProcessorAbstractSelfTest.assertNotNull((String)("REST return metadata for unexpected cache: " + cacheName), (Object)meta);
            JsonNode types = item.get("types");
            JettyRestProcessorAbstractSelfTest.assertNotNull((Object)types);
            JettyRestProcessorAbstractSelfTest.assertFalse((boolean)types.isNull());
            JettyRestProcessorAbstractSelfTest.assertEqualsCollections((Collection)meta.types(), (Collection)((Collection)JSON_MAPPER.treeToValue((TreeNode)types, Collection.class)));
            JsonNode keyClasses = item.get("keyClasses");
            JettyRestProcessorAbstractSelfTest.assertNotNull((Object)keyClasses);
            JettyRestProcessorAbstractSelfTest.assertFalse((boolean)keyClasses.isNull());
            JettyRestProcessorAbstractSelfTest.assertEquals((Object)meta.keyClasses(), (Object)JSON_MAPPER.treeToValue((TreeNode)keyClasses, Map.class));
            JsonNode valClasses = item.get("valClasses");
            JettyRestProcessorAbstractSelfTest.assertNotNull((Object)valClasses);
            JettyRestProcessorAbstractSelfTest.assertFalse((boolean)valClasses.isNull());
            JettyRestProcessorAbstractSelfTest.assertEquals((Object)meta.valClasses(), (Object)JSON_MAPPER.treeToValue((TreeNode)valClasses, Map.class));
            JsonNode fields = item.get("fields");
            JettyRestProcessorAbstractSelfTest.assertNotNull((Object)fields);
            JettyRestProcessorAbstractSelfTest.assertFalse((boolean)fields.isNull());
            JettyRestProcessorAbstractSelfTest.assertEquals((Object)meta.fields(), (Object)JSON_MAPPER.treeToValue((TreeNode)fields, Map.class));
            JsonNode indexesByType = item.get("indexes");
            JettyRestProcessorAbstractSelfTest.assertNotNull((Object)indexesByType);
            JettyRestProcessorAbstractSelfTest.assertFalse((boolean)indexesByType.isNull());
            JettyRestProcessorAbstractSelfTest.assertEquals((int)meta.indexes().size(), (int)indexesByType.size());
            for (Map.Entry metaIndexes : meta.indexes().entrySet()) {
                JsonNode indexes = indexesByType.get((String)metaIndexes.getKey());
                JettyRestProcessorAbstractSelfTest.assertNotNull((Object)indexes);
                JettyRestProcessorAbstractSelfTest.assertFalse((boolean)indexes.isNull());
                JettyRestProcessorAbstractSelfTest.assertEquals((int)((Collection)metaIndexes.getValue()).size(), (int)indexes.size());
                for (final GridCacheSqlIndexMetadata metaIdx : (Collection)metaIndexes.getValue()) {
                    JsonNode idx = (JsonNode)F.find((Iterable)indexes, null, (IgnitePredicate[])new IgnitePredicate[]{new P1<JsonNode>(){

                        public boolean apply(JsonNode idx) {
                            return metaIdx.name().equals(idx.get("name").asText());
                        }
                    }});
                    JettyRestProcessorAbstractSelfTest.assertNotNull((Object)idx);
                    JettyRestProcessorAbstractSelfTest.assertEqualsCollections((Collection)metaIdx.fields(), (Collection)((Collection)JSON_MAPPER.treeToValue((TreeNode)idx.get("fields"), Collection.class)));
                    JettyRestProcessorAbstractSelfTest.assertEqualsCollections((Collection)metaIdx.descendings(), (Collection)((Collection)JSON_MAPPER.treeToValue((TreeNode)idx.get("descendings"), Collection.class)));
                    JettyRestProcessorAbstractSelfTest.assertEquals((boolean)metaIdx.unique(), (boolean)idx.get("unique").asBoolean());
                }
            }
        }
    }

    @Test
    public void testMetadataLocal() throws Exception {
        IgniteCacheProxy cache = (IgniteCacheProxy)F.first((Iterable)this.grid(0).context().cache().publicCaches());
        JettyRestProcessorAbstractSelfTest.assertNotNull((String)"Should have configured public cache!", (Object)cache);
        Collection metas = cache.context().queries().sqlMetadata();
        String ret = this.content("", GridRestCommand.CACHE_METADATA, new String[0]);
        this.info("Cache metadata: " + ret);
        JsonNode arrRes = this.validateJsonResponse(ret);
        this.testMetadata(metas, arrRes);
        Collection dfltCacheMeta = cache.context().queries().sqlMetadata();
        ret = this.content("default", GridRestCommand.CACHE_METADATA, new String[0]);
        this.info("Cache metadata: " + ret);
        arrRes = this.validateJsonResponse(ret);
        JettyRestProcessorAbstractSelfTest.assertEquals((int)1, (int)arrRes.size());
        this.testMetadata(dfltCacheMeta, arrRes);
        this.assertResponseContainsError(this.content("nonExistingCacheName", GridRestCommand.CACHE_METADATA, new String[0]), "Failed to request meta data. nonExistingCacheName is not found");
    }

    @Test
    public void testMetadataRemote() throws Exception {
        CacheConfiguration partialCacheCfg = new CacheConfiguration("partial");
        partialCacheCfg.setIndexedTypes(new Class[]{Integer.class, String.class});
        partialCacheCfg.setNodeFilter((IgnitePredicate)new NodeConsistentIdFilter(this.grid(1).localNode().consistentId()));
        IgniteCacheProxy c = (IgniteCacheProxy)this.grid(1).createCache(partialCacheCfg);
        Collection metas = c.context().queries().sqlMetadata();
        String ret = this.content("", GridRestCommand.CACHE_METADATA, new String[0]);
        this.info("Cache metadata: " + ret);
        JsonNode arrRes = this.validateJsonResponse(ret);
        this.testMetadata(metas, arrRes);
        ret = this.content("person", GridRestCommand.CACHE_METADATA, new String[0]);
        this.info("Cache metadata with cacheName parameter: " + ret);
        arrRes = this.validateJsonResponse(ret);
        JettyRestProcessorAbstractSelfTest.assertEquals((int)1, (int)arrRes.size());
        this.testMetadata(metas, arrRes);
        this.assertResponseContainsError(this.content("nonExistingCacheName", GridRestCommand.CACHE_METADATA, new String[0]), "Failed to request meta data. nonExistingCacheName is not found");
    }

    @Test
    public void testTopology() throws Exception {
        String ret = this.content(null, GridRestCommand.TOPOLOGY, "attr", "false", "mtr", "false");
        this.info("Topology command result: " + ret);
        JsonNode res = this.validateJsonResponse(ret);
        JettyRestProcessorAbstractSelfTest.assertEquals((int)this.gridCount(), (int)res.size());
        for (JsonNode node : res) {
            JettyRestProcessorAbstractSelfTest.assertTrue((boolean)node.get("attributes").isNull());
            JettyRestProcessorAbstractSelfTest.assertTrue((boolean)node.get("metrics").isNull());
            JsonNode caches = node.get("caches");
            JettyRestProcessorAbstractSelfTest.assertFalse((boolean)caches.isNull());
            Collection publicCaches = this.grid(0).context().cache().publicCaches();
            JettyRestProcessorAbstractSelfTest.assertEquals((int)publicCaches.size(), (int)caches.size());
            for (JsonNode cache : caches) {
                String cacheName0 = cache.get("name").asText();
                final String cacheName = cacheName0.isEmpty() ? null : cacheName0;
                IgniteCacheProxy publicCache = (IgniteCacheProxy)F.find((Iterable)publicCaches, null, (IgnitePredicate[])new IgnitePredicate[]{new P1<IgniteCacheProxy<?, ?>>(){

                    public boolean apply(IgniteCacheProxy<?, ?> c) {
                        return F.eq((Object)c.getName(), (Object)cacheName);
                    }
                }});
                JettyRestProcessorAbstractSelfTest.assertNotNull((Object)publicCache);
                CacheMode cacheMode = CacheMode.valueOf((String)cache.get("mode").asText());
                JettyRestProcessorAbstractSelfTest.assertEquals((Object)((CacheConfiguration)publicCache.getConfiguration(CacheConfiguration.class)).getCacheMode(), (Object)cacheMode);
            }
        }
        ret = this.content(null, GridRestCommand.TOPOLOGY, "attr", "false", "mtr", "false", "caches", "false");
        this.info("Topology command result: " + ret);
        res = this.validateJsonResponse(ret);
        JettyRestProcessorAbstractSelfTest.assertEquals((int)this.gridCount(), (int)res.size());
        for (JsonNode node : res) {
            JettyRestProcessorAbstractSelfTest.assertTrue((boolean)node.get("attributes").isNull());
            JettyRestProcessorAbstractSelfTest.assertTrue((boolean)node.get("metrics").isNull());
            JettyRestProcessorAbstractSelfTest.assertTrue((boolean)node.get("caches").isNull());
        }
    }

    @Test
    public void testNode() throws Exception {
        IgniteEx ignite = this.grid(0);
        String nid = ignite.localNode().id().toString();
        String ret = this.content(null, GridRestCommand.NODE, "attr", "true", "mtr", "true", "id", nid);
        this.info("Topology command result: " + ret);
        JsonNode res = this.validateJsonResponse(ret);
        JettyRestProcessorAbstractSelfTest.assertTrue((boolean)res.get("attributes").isObject());
        JettyRestProcessorAbstractSelfTest.assertTrue((boolean)res.get("metrics").isObject());
        JsonNode caches = res.get("caches");
        JettyRestProcessorAbstractSelfTest.assertTrue((boolean)caches.isArray());
        JettyRestProcessorAbstractSelfTest.assertFalse((boolean)caches.isNull());
        JettyRestProcessorAbstractSelfTest.assertEquals((int)ignite.context().cache().publicCaches().size(), (int)caches.size());
        ret = this.content(null, GridRestCommand.NODE, "attr", "false", "mtr", "false", "ip", "127.0.0.1");
        this.info("Topology command result: " + ret);
        res = this.validateJsonResponse(ret);
        JettyRestProcessorAbstractSelfTest.assertTrue((boolean)res.get("attributes").isNull());
        JettyRestProcessorAbstractSelfTest.assertTrue((boolean)res.get("metrics").isNull());
        ret = this.content(null, GridRestCommand.NODE, "attr", "false", "mtr", "false", "ip", "127.0.0.1", "id", UUID.randomUUID().toString());
        this.info("Topology command result: " + ret);
        res = this.validateJsonResponse(ret);
        JettyRestProcessorAbstractSelfTest.assertTrue((boolean)res.isNull());
        ret = this.content(null, GridRestCommand.NODE, "id", nid, "attr", "false", "mtr", "false", "caches", "false");
        this.info("Topology command result: " + ret);
        res = this.validateJsonResponse(ret);
        JettyRestProcessorAbstractSelfTest.assertTrue((boolean)res.get("attributes").isNull());
        JettyRestProcessorAbstractSelfTest.assertTrue((boolean)res.get("metrics").isNull());
        JettyRestProcessorAbstractSelfTest.assertTrue((boolean)res.get("caches").isNull());
    }

    @Test
    public void testExe() throws Exception {
        String ret = this.content("default", GridRestCommand.EXE, new String[0]);
        this.info("Exe command result: " + ret);
        this.assertResponseContainsError(ret, "Failed to find mandatory parameter in request: name");
        ret = this.content("default", GridRestCommand.EXE, "name", "UNKNOWN_TASK");
        this.info("Exe command result: " + ret);
        this.assertResponseContainsError(ret, "Unknown task name or failed to auto-deploy task (was task (re|un)deployed?)");
        this.grid(0).compute().localDeployTask(TestTask1.class, TestTask1.class.getClassLoader());
        this.grid(0).compute().localDeployTask(TestTask2.class, TestTask2.class.getClassLoader());
        ret = this.content("default", GridRestCommand.EXE, "name", TestTask1.class.getName());
        this.info("Exe command result: " + ret);
        JsonNode res = this.jsonTaskResult(ret);
        JettyRestProcessorAbstractSelfTest.assertTrue((boolean)res.isNull());
        ret = this.content("default", GridRestCommand.EXE, "name", TestTask2.class.getName());
        this.info("Exe command result: " + ret);
        res = this.jsonTaskResult(ret);
        JettyRestProcessorAbstractSelfTest.assertEquals((String)"Task 2 result.", (String)res.asText());
        ret = this.content("default", GridRestCommand.RESULT, new String[0]);
        this.info("Exe command result: " + ret);
        this.assertResponseContainsError(ret, "Failed to find mandatory parameter in request: id");
    }

    @Test
    public void testVisorGatewayCacheConfigurationCollectorTask() throws Exception {
        ClusterNode locNode = this.grid(1).localNode();
        String ret = this.content(new VisorGatewayArgument(VisorCacheConfigurationCollectorTask.class).setNode(locNode).setTaskArgument(VisorCacheConfigurationCollectorTaskArg.class, new Object[0]).addCollectionArgument(String.class, "person"));
        this.info("VisorCacheConfigurationCollectorTask result: " + ret);
        this.jsonTaskResult(ret);
        JettyRestProcessorAbstractSelfTest.assertTrue((boolean)ret.contains(String.format("\"memoryPolicyName\":\"%s\"", this.grid(1).configuration().getDataStorageConfiguration().getDefaultDataRegionConfiguration().getName())));
    }

    @Test
    public void testVisorGateway() throws Exception {
        ClusterNode locNode = this.grid(1).localNode();
        String ret = this.content(new VisorGatewayArgument(VisorCacheStopTask.class).setNode(locNode).setTaskArgument(VisorCacheStopTaskArg.class, "c"));
        this.info("VisorCacheStopTask result: " + ret);
        this.jsonTaskResult(ret);
    }

    @Test
    public void testDataRegionMetrics() throws Exception {
        String ret = this.content(F.asMap((Object)"cmd", (Object)GridRestCommand.DATA_REGION_METRICS.key()));
        JsonNode res = this.validateJsonResponse(ret);
        JettyRestProcessorAbstractSelfTest.assertTrue((res.size() > 0 ? 1 : 0) != 0);
        this.info(GridRestCommand.DATA_REGION_METRICS.key().toUpperCase() + " command result: " + ret);
    }

    @Test
    public void testDataStorageMetricsDisabled() throws Exception {
        if (memoryMetricsEnabled) {
            memoryMetricsEnabled = false;
            this.restartGrid();
        }
        String ret = this.content(F.asMap((Object)"cmd", (Object)GridRestCommand.DATA_STORAGE_METRICS.key()));
        JsonNode res = this.validateJsonResponse(ret);
        JettyRestProcessorAbstractSelfTest.assertTrue((boolean)res.asText().equalsIgnoreCase("Storage metrics are not enabled"));
        this.info(GridRestCommand.DATA_STORAGE_METRICS.key().toUpperCase() + " command result: " + ret);
    }

    @Test
    public void testDataStorageMetricsEnabled() throws Exception {
        if (!memoryMetricsEnabled) {
            memoryMetricsEnabled = true;
            this.restartGrid();
        }
        String ret = this.content(F.asMap((Object)"cmd", (Object)GridRestCommand.DATA_STORAGE_METRICS.key()));
        JettyRestProcessorAbstractSelfTest.assertNotNull((Object)this.validateJsonResponse(ret));
        this.info(GridRestCommand.DATA_STORAGE_METRICS.key().toUpperCase() + " command result: " + ret);
    }

    protected void restartGrid() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
        this.startGrids(this.gridCount());
        this.grid(0).cluster().active(true);
        this.initCache();
    }

    @Test
    public void testVersion() throws Exception {
        String ret = this.content(null, GridRestCommand.VERSION, new String[0]);
        JsonNode res = this.validateJsonResponse(ret, false, true);
        JettyRestProcessorAbstractSelfTest.assertEquals((String)IgniteVersionUtils.VER_STR, (String)res.asText());
    }

    @Test
    public void testQueryArgs() throws Exception {
        String qry = "salary > ? and salary <= ?";
        String ret = this.content("person", GridRestCommand.EXECUTE_SQL_QUERY, "type", "Person", "pageSize", "10", "qry", URLEncoder.encode(qry, CHARSET), "arg1", "1000", "arg2", "2000");
        JsonNode items = this.validateJsonResponse(ret).get("items");
        JettyRestProcessorAbstractSelfTest.assertEquals((int)2, (int)items.size());
        JettyRestProcessorAbstractSelfTest.assertFalse((boolean)this.queryCursorFound());
    }

    @Test
    public void testQueryScan() throws Exception {
        String ret = this.content("person", GridRestCommand.EXECUTE_SCAN_QUERY, "pageSize", "10", "cacheName", "person");
        JsonNode items = this.validateJsonResponse(ret).get("items");
        JettyRestProcessorAbstractSelfTest.assertEquals((int)4, (int)items.size());
        JettyRestProcessorAbstractSelfTest.assertFalse((boolean)this.queryCursorFound());
    }

    @Test
    public void testFilterQueryScan() throws Exception {
        String ret = this.content("person", GridRestCommand.EXECUTE_SCAN_QUERY, "pageSize", "10", "className", ScanFilter.class.getName());
        JsonNode items = this.validateJsonResponse(ret).get("items");
        JettyRestProcessorAbstractSelfTest.assertEquals((int)2, (int)items.size());
        JettyRestProcessorAbstractSelfTest.assertFalse((boolean)this.queryCursorFound());
    }

    @Test
    public void testIncorrectFilterQueryScan() throws Exception {
        String clsName = ScanFilter.class.getName() + 1;
        String ret = this.content("person", GridRestCommand.EXECUTE_SCAN_QUERY, "pageSize", "10", "className", clsName);
        this.assertResponseContainsError(ret, "Failed to find target class: " + clsName);
    }

    @Test
    public void testQuery() throws Exception {
        this.grid(0).cache("default").put((Object)"1", (Object)"1");
        this.grid(0).cache("default").put((Object)"2", (Object)"2");
        this.grid(0).cache("default").put((Object)"3", (Object)"3");
        String ret = this.content("default", GridRestCommand.EXECUTE_SQL_QUERY, "type", "String", "pageSize", "1", "qry", URLEncoder.encode("select * from String", CHARSET));
        JsonNode qryId = this.validateJsonResponse(ret).get("queryId");
        JettyRestProcessorAbstractSelfTest.assertFalse((boolean)this.validateJsonResponse(ret).get("queryId").isNull());
        ret = this.content("default", GridRestCommand.FETCH_SQL_QUERY, "pageSize", "1", "qryId", qryId.asText());
        JsonNode res = this.validateJsonResponse(ret);
        JsonNode qryId0 = this.validateJsonResponse(ret).get("queryId");
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)qryId0, (Object)qryId);
        JettyRestProcessorAbstractSelfTest.assertFalse((boolean)res.get("last").asBoolean());
        ret = this.content("default", GridRestCommand.FETCH_SQL_QUERY, "pageSize", "1", "qryId", qryId.asText());
        res = this.validateJsonResponse(ret);
        qryId0 = this.validateJsonResponse(ret).get("queryId");
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)qryId0, (Object)qryId);
        JettyRestProcessorAbstractSelfTest.assertTrue((boolean)res.get("last").asBoolean());
        JettyRestProcessorAbstractSelfTest.assertFalse((boolean)this.queryCursorFound());
    }

    @Test
    public void testDistributedJoinsQuery() throws Exception {
        String qry = "select * from Person, \"organization\".Organization where \"organization\".Organization.id = Person.orgId and \"organization\".Organization.name = ?";
        String ret = this.content("person", GridRestCommand.EXECUTE_SQL_QUERY, "type", "Person", "distributedJoins", "true", "pageSize", "10", "qry", URLEncoder.encode(qry, CHARSET), "arg1", "o1");
        JsonNode items = this.validateJsonResponse(ret).get("items");
        JettyRestProcessorAbstractSelfTest.assertEquals((int)2, (int)items.size());
        JettyRestProcessorAbstractSelfTest.assertFalse((boolean)this.queryCursorFound());
    }

    @Test
    public void testSqlFieldsQuery() throws Exception {
        String qry = "select concat(firstName, ' ', lastName) from Person";
        String ret = this.content("person", GridRestCommand.EXECUTE_SQL_FIELDS_QUERY, "pageSize", "10", "qry", URLEncoder.encode(qry, CHARSET));
        JsonNode items = this.validateJsonResponse(ret).get("items");
        JettyRestProcessorAbstractSelfTest.assertEquals((int)4, (int)items.size());
        JettyRestProcessorAbstractSelfTest.assertFalse((boolean)this.queryCursorFound());
    }

    @Test
    public void testDistributedJoinsSqlFieldsQuery() throws Exception {
        String qry = "select * from \"person\".Person p, \"organization\".Organization o where o.id = p.orgId";
        String ret = this.content("person", GridRestCommand.EXECUTE_SQL_FIELDS_QUERY, "distributedJoins", "true", "pageSize", "10", "qry", URLEncoder.encode(qry, CHARSET));
        JsonNode items = this.validateJsonResponse(ret).get("items");
        JettyRestProcessorAbstractSelfTest.assertEquals((int)4, (int)items.size());
        JettyRestProcessorAbstractSelfTest.assertFalse((boolean)this.queryCursorFound());
    }

    @Test
    public void testSqlFieldsMetadataQuery() throws Exception {
        String qry = "select firstName, lastName from Person";
        String ret = this.content("person", GridRestCommand.EXECUTE_SQL_FIELDS_QUERY, "pageSize", "10", "qry", URLEncoder.encode(qry, CHARSET));
        JsonNode res = this.validateJsonResponse(ret);
        JsonNode items = res.get("items");
        JsonNode meta = res.get("fieldsMetadata");
        JettyRestProcessorAbstractSelfTest.assertEquals((int)4, (int)items.size());
        JettyRestProcessorAbstractSelfTest.assertEquals((int)2, (int)meta.size());
        JsonNode o = meta.get(0);
        JettyRestProcessorAbstractSelfTest.assertEquals((String)"FIRSTNAME", (String)o.get("fieldName").asText());
        JettyRestProcessorAbstractSelfTest.assertEquals((String)"java.lang.String", (String)o.get("fieldTypeName").asText());
        JettyRestProcessorAbstractSelfTest.assertEquals((String)"person", (String)o.get("schemaName").asText());
        JettyRestProcessorAbstractSelfTest.assertEquals((String)"PERSON", (String)o.get("typeName").asText());
        JettyRestProcessorAbstractSelfTest.assertFalse((boolean)this.queryCursorFound());
    }

    @Test
    public void testQueryClose() throws Exception {
        String qry = "salary > ? and salary <= ?";
        String ret = this.content("person", GridRestCommand.EXECUTE_SQL_QUERY, "type", "Person", "pageSize", "1", "qry", URLEncoder.encode(qry, CHARSET), "arg1", "1000", "arg2", "2000");
        JsonNode res = this.validateJsonResponse(ret);
        JettyRestProcessorAbstractSelfTest.assertEquals((int)1, (int)res.get("items").size());
        JettyRestProcessorAbstractSelfTest.assertTrue((boolean)this.queryCursorFound());
        JettyRestProcessorAbstractSelfTest.assertFalse((boolean)res.get("queryId").isNull());
        String qryId = res.get("queryId").asText();
        this.content("person", GridRestCommand.CLOSE_SQL_QUERY, "qryId", qryId);
        JettyRestProcessorAbstractSelfTest.assertFalse((boolean)this.queryCursorFound());
    }

    @Test
    public void testQueryDelay() throws Exception {
        String qry = "salary > ? and salary <= ?";
        String ret = null;
        for (int i = 0; i < 10; ++i) {
            ret = this.content("person", GridRestCommand.EXECUTE_SQL_QUERY, "type", "Person", "pageSize", "1", "qry", URLEncoder.encode(qry, CHARSET), "arg1", "1000", "arg2", "2000");
        }
        JsonNode items = this.validateJsonResponse(ret).get("items");
        JettyRestProcessorAbstractSelfTest.assertEquals((int)1, (int)items.size());
        JettyRestProcessorAbstractSelfTest.assertTrue((boolean)this.queryCursorFound());
        U.sleep((long)10000L);
        JettyRestProcessorAbstractSelfTest.assertFalse((boolean)this.queryCursorFound());
    }

    protected <K, V> IgniteCache<K, V> typedCache() {
        return this.grid(0).cache("test_typed_access");
    }

    private void putTypedValue(String type, String k, String v, int status) throws Exception {
        String ret = this.content("test_typed_access", GridRestCommand.CACHE_PUT, "keyType", type, "valueType", type, "key", k, "val", v);
        this.info("Command result: " + ret);
        JsonNode json = JSON_MAPPER.readTree(ret);
        JettyRestProcessorAbstractSelfTest.assertEquals((int)status, (int)json.get("successStatus").asInt());
        if (status == 0) {
            JettyRestProcessorAbstractSelfTest.assertTrue((boolean)json.get("error").isNull());
        } else {
            JettyRestProcessorAbstractSelfTest.assertTrue((boolean)json.get("error").asText().startsWith("Failed to convert value to specified type [type="));
        }
    }

    @Test
    public void testTypedPut() throws Exception {
        this.putTypedValue("boolean", "true", "false", 0);
        this.putTypedValue("java.lang.Boolean", "false", "true", 0);
        IgniteCache cBool = this.typedCache();
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)Boolean.FALSE, (Object)cBool.get((Object)true));
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)Boolean.TRUE, (Object)cBool.get((Object)false));
        this.putTypedValue("byte", "64", "100", 0);
        this.putTypedValue("java.lang.Byte", "-25", "-127", 0);
        this.putTypedValue("byte", "65", "aaa", 1);
        this.putTypedValue("byte", "aaa", "64", 1);
        this.putTypedValue("byte", "aaa", "aaa", 1);
        IgniteCache cByte = this.typedCache();
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)Byte.valueOf("100"), (Object)cByte.get((Object)Byte.valueOf("64")));
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)Byte.valueOf("-127"), (Object)cByte.get((Object)Byte.valueOf("-25")));
        this.putTypedValue("short", "1024", "4096", 0);
        this.putTypedValue("java.lang.Short", "-15000", "-16000", 0);
        this.putTypedValue("short", "1025", "bbb", 1);
        this.putTypedValue("short", "bbb", "5", 1);
        this.putTypedValue("short", "bbb", "bbb", 1);
        IgniteCache cShort = this.typedCache();
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)Short.valueOf("4096"), (Object)cShort.get((Object)Short.valueOf("1024")));
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)Short.valueOf("-16000"), (Object)cShort.get((Object)Short.valueOf("-15000")));
        this.putTypedValue("int", "65555", "128256", 0);
        this.putTypedValue("Integer", "74555", "200000", 0);
        this.putTypedValue("java.lang.Integer", "-200", "-100000", 0);
        this.putTypedValue("int", "0", "ccc", 1);
        this.putTypedValue("int", "ccc", "0", 1);
        this.putTypedValue("int", "ccc", "ccc", 1);
        IgniteCache cInt = this.typedCache();
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)128256, (Object)cInt.get((Object)65555));
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)200000, (Object)cInt.get((Object)74555));
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)-100000, (Object)cInt.get((Object)-200));
        this.putTypedValue("long", "3000000", "400000", 0);
        this.putTypedValue("java.lang.Long", "-3000000", "-400000", 0);
        this.putTypedValue("long", "777", "ddd", 1);
        this.putTypedValue("long", "ddd", "777", 1);
        this.putTypedValue("long", "ddd", "ddd", 1);
        IgniteCache cLong = this.typedCache();
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)400000L, (Object)cLong.get((Object)3000000L));
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)-400000L, (Object)cLong.get((Object)-3000000L));
        this.putTypedValue("float", "1.5", "2.5", 0);
        this.putTypedValue("java.lang.Float", "-7.5", "-8.5", 0);
        this.putTypedValue("float", "1.5", "hhh", 1);
        this.putTypedValue("float", "hhh", "1.5", 1);
        this.putTypedValue("float", "hhh", "hhh", 1);
        IgniteCache cFloat = this.typedCache();
        JettyRestProcessorAbstractSelfTest.assertEquals((float)2.5f, (Float)((Float)cFloat.get((Object)Float.valueOf(1.5f))));
        JettyRestProcessorAbstractSelfTest.assertEquals((float)-8.5f, (Float)((Float)cFloat.get((Object)Float.valueOf(-7.5f))));
        this.putTypedValue("double", "5.5", "75.5", 0);
        this.putTypedValue("java.lang.Double", "-155.5", "-255.5", 0);
        this.putTypedValue("double", "jjj", "75.5", 1);
        this.putTypedValue("double", "6.5", "jjj", 1);
        this.putTypedValue("double", "jjj", "jjj", 1);
        IgniteCache cDouble = this.typedCache();
        JettyRestProcessorAbstractSelfTest.assertEquals((double)75.5, (Double)((Double)cDouble.get((Object)5.5)));
        JettyRestProcessorAbstractSelfTest.assertEquals((double)-255.5, (Double)((Double)cDouble.get((Object)-155.5)));
        this.putTypedValue("date", "2018-02-18", "2017-01-01", 0);
        this.putTypedValue("java.sql.Date", "2018-01-01", "2017-02-02", 0);
        this.putTypedValue("date", "xxxx-yy-mm", "2017-01-01", 1);
        this.putTypedValue("date", "2018-03-18", "xxxx-yy-mm", 1);
        this.putTypedValue("date", "xxxx-yy-mm", "xxxx-yy-mm", 1);
        IgniteCache cDate = this.typedCache();
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)Date.valueOf("2017-01-01"), (Object)cDate.get((Object)Date.valueOf("2018-02-18")));
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)Date.valueOf("2017-02-02"), (Object)cDate.get((Object)Date.valueOf("2018-01-01")));
        this.putTypedValue("Time", "01:01:01", "02:02:02", 0);
        this.putTypedValue("java.sql.Time", "03:03:03", "04:04:04", 0);
        this.putTypedValue("Time", "aa:bb:dd", "02:02:02", 1);
        this.putTypedValue("Time", "01:01:01", "zz:vv:pp", 1);
        this.putTypedValue("Time", "zz:zz:zz", "zz:zz:zz", 1);
        IgniteCache cTime = this.typedCache();
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)Time.valueOf("02:02:02"), (Object)cTime.get((Object)Time.valueOf("01:01:01")));
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)Time.valueOf("04:04:04"), (Object)cTime.get((Object)Time.valueOf("03:03:03")));
        this.putTypedValue("Timestamp", "2018-02-18%2001:01:01", "2017-01-01%2002:02:02", 0);
        this.putTypedValue("java.sql.timestamp", "2018-01-01%2001:01:01", "2018-05-05%2005:05:05", 0);
        this.putTypedValue("timestamp", "error", "2018-03-18%2001:01:01", 1);
        this.putTypedValue("timestamp", "2018-03-18%2001:01:01", "error", 1);
        this.putTypedValue("timestamp", "error", "error", 1);
        IgniteCache cTs = this.typedCache();
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)Timestamp.valueOf("2017-01-01 02:02:02"), (Object)cTs.get((Object)Timestamp.valueOf("2018-02-18 01:01:01")));
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)Timestamp.valueOf("2018-05-05 05:05:05"), (Object)cTs.get((Object)Timestamp.valueOf("2018-01-01 01:01:01")));
        UUID k1 = UUID.fromString("121f5ae8-148d-11e8-b642-0ed5f89f718b");
        UUID v1 = UUID.fromString("64c6c225-b31c-4000-b136-ef14562ac785");
        this.putTypedValue("UUID", k1.toString(), v1.toString(), 0);
        this.putTypedValue("UUID", "error", v1.toString(), 1);
        this.putTypedValue("UUID", k1.toString(), "error", 1);
        this.putTypedValue("UUID", "error", "error", 1);
        UUID k2 = UUID.randomUUID();
        UUID v2 = UUID.randomUUID();
        this.putTypedValue("java.util.UUID", k2.toString(), v2.toString(), 0);
        IgniteCache cUUID = this.typedCache();
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)v1, (Object)cUUID.get((Object)k1));
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)v2, (Object)cUUID.get((Object)k2));
        IgniteUuid ik1 = IgniteUuid.randomUuid();
        IgniteUuid iv1 = IgniteUuid.randomUuid();
        this.putTypedValue("IgniteUuid", ik1.toString(), iv1.toString(), 0);
        this.putTypedValue("IgniteUuid", "error", iv1.toString(), 1);
        this.putTypedValue("IgniteUuid", ik1.toString(), "error", 1);
        this.putTypedValue("IgniteUuid", "error", "error", 1);
        IgniteUuid ik2 = IgniteUuid.randomUuid();
        IgniteUuid iv2 = IgniteUuid.randomUuid();
        this.putTypedValue("org.apache.ignite.lang.IgniteUuid", ik2.toString(), iv2.toString(), 0);
        IgniteCache cIgniteUUID = this.typedCache();
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)iv1, (Object)cIgniteUUID.get((Object)ik1));
        JettyRestProcessorAbstractSelfTest.assertEquals((Object)iv2, (Object)cIgniteUUID.get((Object)ik2));
    }

    private void getTypedValue(String keyType, String k, String exp) throws Exception {
        String ret = this.content("test_typed_access", GridRestCommand.CACHE_GET, "keyType", keyType, "key", k);
        this.info("Command result: " + ret);
        JsonNode json = this.validateJsonResponse(ret);
        JettyRestProcessorAbstractSelfTest.assertEquals((String)exp, (String)(json.isObject() ? json.toString() : json.asText()));
    }

    @Test
    public void testTypedGet() throws Exception {
        IgniteCache cBool = this.typedCache();
        cBool.put((Object)true, (Object)false);
        cBool.put((Object)false, (Object)true);
        this.getTypedValue("boolean", "true", "false");
        this.getTypedValue("java.lang.Boolean", "false", "true");
        IgniteCache cByte = this.typedCache();
        cByte.put((Object)77, (Object)55);
        cByte.put((Object)-88, (Object)-10);
        this.getTypedValue("byte", "77", "55");
        this.getTypedValue("java.lang.Byte", "-88", "-10");
        IgniteCache cShort = this.typedCache();
        cShort.put((Object)2222, (Object)3333);
        cShort.put((Object)-11111, (Object)-12222);
        this.getTypedValue("short", "2222", "3333");
        this.getTypedValue("java.lang.Short", "-11111", "-12222");
        IgniteCache cInt = this.typedCache();
        cInt.put((Object)65555, (Object)128256);
        cInt.put((Object)74555, (Object)200000);
        cInt.put((Object)-200, (Object)-100000);
        this.getTypedValue("int", "65555", "128256");
        this.getTypedValue("Integer", "74555", "200000");
        this.getTypedValue("java.lang.Integer", "-200", "-100000");
        IgniteCache cLong = this.typedCache();
        cLong.put((Object)3333333L, (Object)4444444L);
        cLong.put((Object)-3333333L, (Object)-4444444L);
        this.getTypedValue("long", "3333333", "4444444");
        this.getTypedValue("java.lang.Long", "-3333333", "-4444444");
        IgniteCache cFloat = this.typedCache();
        cFloat.put((Object)Float.valueOf(11.5f), (Object)Float.valueOf(21.5f));
        cFloat.put((Object)Float.valueOf(-71.5f), (Object)Float.valueOf(-81.5f));
        this.getTypedValue("float", "11.5", "21.5");
        this.getTypedValue("java.lang.Float", "-71.5", "-81.5");
        IgniteCache cDouble = this.typedCache();
        cDouble.put((Object)58.5, (Object)758.5);
        cDouble.put((Object)-1558.5, (Object)-2558.5);
        this.getTypedValue("double", "58.5", "758.5");
        this.getTypedValue("java.lang.Double", "-1558.5", "-2558.5");
        IgniteCache cDate = this.typedCache();
        cDate.put((Object)Date.valueOf("2018-02-18"), (Object)Date.valueOf("2017-01-01"));
        cDate.put((Object)Date.valueOf("2018-01-01"), (Object)Date.valueOf("2017-02-02"));
        this.getTypedValue("Date", "2018-02-18", "2017-01-01");
        this.getTypedValue("java.sql.Date", "2018-01-01", "2017-02-02");
        IgniteCache cTime = this.typedCache();
        cTime.put((Object)Time.valueOf("01:01:01"), (Object)Time.valueOf("02:02:02"));
        cTime.put((Object)Time.valueOf("03:03:03"), (Object)Time.valueOf("04:04:04"));
        this.getTypedValue("Time", "01:01:01", "02:02:02");
        this.getTypedValue("java.sql.Time", "03:03:03", "04:04:04");
        IgniteCache cTimestamp = this.typedCache();
        cTimestamp.put((Object)Timestamp.valueOf("2018-02-18 01:01:01"), (Object)"test1");
        cTimestamp.put((Object)Timestamp.valueOf("2018-01-01 01:01:01"), (Object)"test2");
        this.getTypedValue("Timestamp", "2018-02-18%2001:01:01", "test1");
        this.getTypedValue("java.sql.timestamp", "2018-01-01%2001:01:01", "test2");
        IgniteCache cUUID = this.typedCache();
        UUID k1 = UUID.fromString("121f5ae8-148d-11e8-b642-0ed5f89f718b");
        UUID v1 = UUID.fromString("64c6c225-b31c-4000-b136-ef14562ac785");
        cUUID.put((Object)k1, (Object)v1);
        UUID k2 = UUID.randomUUID();
        UUID v2 = UUID.randomUUID();
        cUUID.put((Object)k2, (Object)v2);
        this.getTypedValue("UUID", k1.toString(), v1.toString());
        this.getTypedValue("java.util.UUID", k2.toString(), v2.toString());
        IgniteCache cIgniteUUID = this.typedCache();
        IgniteUuid ik1 = IgniteUuid.randomUuid();
        IgniteUuid iv1 = IgniteUuid.randomUuid();
        cIgniteUUID.put((Object)ik1, (Object)iv1);
        IgniteUuid ik2 = IgniteUuid.randomUuid();
        IgniteUuid iv2 = IgniteUuid.randomUuid();
        cIgniteUUID.put((Object)ik2, (Object)iv2);
        this.getTypedValue("IgniteUuid", ik1.toString(), iv1.toString());
        this.getTypedValue("org.apache.ignite.lang.IgniteUuid", ik2.toString(), iv2.toString());
        IgniteCache cTuple = this.typedCache();
        T2 tup = new T2((Object)1, (Object)"test");
        cTuple.put((Object)555, (Object)tup);
        this.getTypedValue("int", "555", JSON_MAPPER.writeValueAsString((Object)tup));
        IgniteCache cEnum = this.typedCache();
        cEnum.put((Object)888, (Object)CacheMode.PARTITIONED);
        this.getTypedValue("int", "888", CacheMode.PARTITIONED.toString());
    }

    @Test
    public void testCacheCommandsWithoutCacheName() throws Exception {
        String ERROR_MSG = "Failed to find mandatory parameter in request: cacheName";
        EnumSet<GridRestCommand[]> cacheCommands = EnumSet.of(GridRestCommand.DESTROY_CACHE, new GridRestCommand[]{GridRestCommand.GET_OR_CREATE_CACHE, GridRestCommand.CACHE_CONTAINS_KEYS, GridRestCommand.CACHE_CONTAINS_KEY, GridRestCommand.CACHE_GET, GridRestCommand.CACHE_GET_AND_PUT, GridRestCommand.CACHE_GET_AND_REPLACE, GridRestCommand.CACHE_GET_AND_PUT_IF_ABSENT, GridRestCommand.CACHE_PUT_IF_ABSENT, GridRestCommand.CACHE_GET_ALL, GridRestCommand.CACHE_PUT, GridRestCommand.CACHE_ADD, GridRestCommand.CACHE_PUT_ALL, GridRestCommand.CACHE_REMOVE, GridRestCommand.CACHE_REMOVE_VALUE, GridRestCommand.CACHE_REPLACE_VALUE, GridRestCommand.CACHE_GET_AND_REMOVE, GridRestCommand.CACHE_REMOVE_ALL, GridRestCommand.CACHE_REPLACE, GridRestCommand.CACHE_CAS, GridRestCommand.CACHE_APPEND, GridRestCommand.CACHE_PREPEND, GridRestCommand.CACHE_METRICS, GridRestCommand.CACHE_SIZE, GridRestCommand.CACHE_METADATA});
        for (GridRestCommand gridRestCommand : cacheCommands) {
            String ret = this.content(null, gridRestCommand, new String[0]);
            if (gridRestCommand == GridRestCommand.CACHE_METADATA) {
                this.validateJsonResponse(ret);
                continue;
            }
            JsonNode err = this.jsonTaskErrorResult(ret);
            JettyRestProcessorAbstractSelfTest.assertFalse((boolean)err.isNull());
            JettyRestProcessorAbstractSelfTest.assertTrue((boolean)err.textValue().contains("Failed to find mandatory parameter in request: cacheName"));
        }
    }

    @Test
    public void testQueryCommandsWithoutCacheName() throws Exception {
        String ERROR_MSG = "Failed to find mandatory parameter in request: cacheName";
        EnumSet<GridRestCommand> qryCommands = EnumSet.of(GridRestCommand.EXECUTE_SQL_QUERY, GridRestCommand.EXECUTE_SQL_FIELDS_QUERY, GridRestCommand.EXECUTE_SCAN_QUERY, GridRestCommand.FETCH_SQL_QUERY, GridRestCommand.CLOSE_SQL_QUERY);
        for (GridRestCommand command : qryCommands) {
            String ret = this.content(null, command, "pageSize", "1", "qry", URLEncoder.encode("SELECT * FROM table", CHARSET));
            JsonNode err = this.jsonTaskErrorResult(ret);
            JettyRestProcessorAbstractSelfTest.assertFalse((boolean)err.isNull());
            if (command == GridRestCommand.EXECUTE_SQL_QUERY || command == GridRestCommand.EXECUTE_SCAN_QUERY || command == GridRestCommand.EXECUTE_SQL_FIELDS_QUERY) {
                JettyRestProcessorAbstractSelfTest.assertTrue((boolean)err.textValue().contains("Failed to find mandatory parameter in request: cacheName"));
                continue;
            }
            JettyRestProcessorAbstractSelfTest.assertFalse((boolean)err.textValue().contains("Failed to find mandatory parameter in request: cacheName"));
        }
    }

    private boolean queryCursorFound() {
        boolean found = false;
        for (int i = 0; i < this.gridCount(); ++i) {
            Map handlers = (Map)GridTestUtils.getFieldValue((Object)this.grid(i).context().rest(), (String[])new String[]{"handlers"});
            GridRestCommandHandler qryHnd = (GridRestCommandHandler)handlers.get(GridRestCommand.CLOSE_SQL_QUERY);
            ConcurrentHashMap its = (ConcurrentHashMap)GridTestUtils.getFieldValue((Object)qryHnd, (String[])new String[]{"qryCurs"});
            found |= !its.isEmpty();
        }
        return found;
    }

    protected void initCache() {
        CacheConfiguration typedCache = new CacheConfiguration("test_typed_access");
        this.ignite(0).getOrCreateCache(typedCache);
        CacheConfiguration orgCacheCfg = new CacheConfiguration("organization");
        orgCacheCfg.setIndexedTypes(new Class[]{Integer.class, Organization.class});
        IgniteCache orgCache = this.ignite(0).getOrCreateCache(orgCacheCfg);
        orgCache.clear();
        Organization o1 = new Organization(1, "o1");
        Organization o2 = new Organization(2, "o2");
        orgCache.put((Object)1, (Object)o1);
        orgCache.put((Object)2, (Object)o2);
        CacheConfiguration personCacheCfg = new CacheConfiguration("person");
        personCacheCfg.setIndexedTypes(new Class[]{Integer.class, Person.class});
        personCacheCfg.setSqlFunctionClasses(new Class[]{JdbcThinStatementCancelSelfTest.TestSQLFunctions.class});
        IgniteCache personCache = this.grid(0).getOrCreateCache(personCacheCfg);
        personCache.clear();
        Person p1 = new Person(1, "John", "Doe", 2000.0);
        Person p2 = new Person(1, "Jane", "Doe", 1000.0);
        Person p3 = new Person(2, "John", "Smith", 1000.0);
        Person p4 = new Person(2, "Jane", "Smith", 2000.0);
        personCache.put((Object)p1.getId(), (Object)p1);
        personCache.put((Object)p2.getId(), (Object)p2);
        personCache.put((Object)p3.getId(), (Object)p3);
        personCache.put((Object)p4.getId(), (Object)p4);
        SqlQuery qry = new SqlQuery(Person.class, "salary > ? and salary <= ?");
        qry.setArgs(new Object[]{1000, 2000});
        JettyRestProcessorAbstractSelfTest.assertEquals((int)2, (int)personCache.query((Query)qry).getAll().size());
    }

    @Override
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        DataStorageConfiguration dsCfg = new DataStorageConfiguration();
        DataRegionConfiguration drCfg = new DataRegionConfiguration();
        drCfg.setName("testDataRegion");
        drCfg.setMaxSize(0x6400000L);
        if (memoryMetricsEnabled) {
            drCfg.setPersistenceEnabled(true);
        }
        dsCfg.setDefaultDataRegionConfiguration(drCfg);
        if (memoryMetricsEnabled) {
            dsCfg.setMetricsEnabled(true).setWalMode(WALMode.NONE);
        } else {
            dsCfg.setMetricsEnabled(false);
        }
        cfg.setDataStorageConfiguration(dsCfg);
        return cfg;
    }

    private void checkState(ClusterState expState) throws Exception {
        this.assertClusterState(expState);
        this.assertClusterState(ClusterState.active((ClusterState)expState));
    }

    private void assertClusterState(ClusterState expState) throws Exception {
        String ret = this.content(null, GridRestCommand.CLUSTER_STATE, new String[0]);
        this.info("Cluster state: " + ret);
        JsonNode res = this.validateJsonResponse(ret);
        JettyRestProcessorAbstractSelfTest.assertEquals((String)ret, (String)expState.toString(), (String)res.asText());
        JettyRestProcessorAbstractSelfTest.assertEquals((String)ret, (Object)expState, (Object)this.grid(0).cluster().state());
    }

    private void assertClusterState(boolean exp) throws Exception {
        String ret = this.content(null, GridRestCommand.CLUSTER_CURRENT_STATE, new String[0]);
        this.info("Cluster state: " + ret);
        JsonNode res = this.validateJsonResponse(ret);
        JettyRestProcessorAbstractSelfTest.assertEquals((String)ret, (boolean)exp, (boolean)res.asBoolean());
        JettyRestProcessorAbstractSelfTest.assertEquals((String)ret, (boolean)exp, (boolean)this.grid(0).cluster().active());
    }

    private void changeClusterState(GridRestCommand cmd, ClusterState curState, ClusterState newState, boolean force, boolean success) throws Exception {
        this.checkState(curState);
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("cmd", cmd.key());
        if (force) {
            params.put("force", "true");
        }
        if (cmd == GridRestCommand.CLUSTER_SET_STATE) {
            params.put("state", newState.name());
        }
        String ret = this.content(params);
        JsonNode res = this.validateJsonResponse(ret, !success);
        JettyRestProcessorAbstractSelfTest.assertFalse((boolean)res.isNull());
        if (success) {
            JettyRestProcessorAbstractSelfTest.assertTrue((boolean)res.asText().startsWith(cmd.key()));
        } else {
            JettyRestProcessorAbstractSelfTest.assertTrue((boolean)res.asText().contains("Deactivation stopped. Deactivation clears in-memory caches (without persistence) including the system caches. Use '--force' flag if you`re still sure."));
        }
        this.checkState(success ? newState : curState);
    }

    static /* synthetic */ AtomicInteger access$300() {
        return KEY_GEN;
    }

    static {
        KEY_GEN = new AtomicInteger(0);
    }

    private static class NodeConsistentIdFilter
    implements IgnitePredicate<ClusterNode> {
        private final Object consistentId;

        NodeConsistentIdFilter(Object consistentId) {
            this.consistentId = consistentId;
        }

        public boolean apply(ClusterNode n) {
            return n.consistentId().equals(this.consistentId);
        }
    }

    public static class ScanFilter
    implements IgniteBiPredicate<Integer, Person> {
        public boolean apply(Integer integer, Person person) {
            return person.salary > 1000.0;
        }
    }

    public static class CompositeKeyExternal
    implements Serializable {
        @QuerySqlField(index=true)
        private Integer id = JettyRestProcessorAbstractSelfTest.access$300().getAndIncrement();
        private CompositeKeyInternal internal;

        CompositeKeyExternal(CompositeKeyInternal internal) {
            this.internal = internal;
        }

        public Integer getId() {
            return this.id;
        }

        public CompositeKeyInternal getInternal() {
            return this.internal;
        }
    }

    public static class CompositeKeyInternal
    implements Serializable {
        @QuerySqlField(index=true)
        private Integer id = JettyRestProcessorAbstractSelfTest.access$300().getAndIncrement();

        CompositeKeyInternal() {
        }

        public Integer getId() {
            return this.id;
        }
    }

    public static class Person
    implements Serializable {
        @QuerySqlField(index=true)
        private Integer id = JettyRestProcessorAbstractSelfTest.access$300().getAndIncrement();
        @QuerySqlField(index=true)
        private Integer orgId;
        @QuerySqlField
        private String firstName;
        @QuerySqlField
        private String lastName;
        @QuerySqlField(index=true)
        private double salary;

        Person(Integer orgId, String firstName, String lastName, double salary) {
            this.orgId = orgId;
            this.firstName = firstName;
            this.lastName = lastName;
            this.salary = salary;
        }

        public Integer getOrganizationId() {
            return this.orgId;
        }

        public String getFirstName() {
            return this.firstName;
        }

        public String getLastName() {
            return this.lastName;
        }

        public double getSalary() {
            return this.salary;
        }

        public Integer getId() {
            return this.id;
        }
    }

    public static class CircularRef
    implements Serializable {
        private int id;
        private String name;
        private CircularRef ref;

        CircularRef(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int id() {
            return this.id;
        }

        public String name() {
            return this.name;
        }

        public CircularRef ref() {
            return this.ref;
        }

        public void ref(CircularRef ref) {
            this.ref = ref;
        }

        public String toString() {
            SB sb = new SB();
            sb.a('{').a('\"').a("id").a('\"').a(':').a(this.id).a(',').a('\"').a("name").a('\"').a(':').a('\"').a(this.name).a('\"').a(',').a('\"').a("ref").a('\"').a(':').a((Object)this.ref).a('}');
            return sb.toString();
        }
    }

    public static class Organization
    implements Serializable {
        @QuerySqlField(index=true)
        private Integer id;
        @QuerySqlField(index=true)
        private String name;

        Organization(Integer id, String name) {
            this.id = id;
            this.name = name;
        }

        public Integer getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }
    }
}

