/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc2;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.ignite.internal.jdbc2.JdbcAbstractUpdateStatementSelfTest;
import org.junit.Test;

public class JdbcDeleteStatementSelfTest
extends JdbcAbstractUpdateStatementSelfTest {
    @Test
    public void testExecute() throws SQLException {
        this.conn.createStatement().execute("delete from Person where cast(substring(_key, 2, 1) as int) % 2 = 0");
        JdbcDeleteStatementSelfTest.assertFalse((boolean)this.jcache(0).containsKey((Object)"p2"));
        JdbcDeleteStatementSelfTest.assertTrue((boolean)this.jcache(0).containsKeys(new HashSet<String>(Arrays.asList("p1", "p3"))));
    }

    @Test
    public void testExecuteUpdate() throws SQLException {
        int res = this.conn.createStatement().executeUpdate("delete from Person where cast(substring(_key, 2, 1) as int) % 2 = 0");
        JdbcDeleteStatementSelfTest.assertEquals((int)1, (int)res);
        JdbcDeleteStatementSelfTest.assertFalse((boolean)this.jcache(0).containsKey((Object)"p2"));
        JdbcDeleteStatementSelfTest.assertTrue((boolean)this.jcache(0).containsKeys(new HashSet<String>(Arrays.asList("p1", "p3"))));
    }

    @Test
    public void testBatch() throws SQLException {
        PreparedStatement ps = this.conn.prepareStatement("delete from Person where firstName = ?");
        ps.setString(1, "John");
        ps.addBatch();
        ps.setString(1, "Harry");
        ps.addBatch();
        int[] res = ps.executeBatch();
        JdbcDeleteStatementSelfTest.assertFalse((boolean)this.jcache(0).containsKey((Object)"p1"));
        JdbcDeleteStatementSelfTest.assertTrue((boolean)this.jcache(0).containsKeys(new HashSet<String>(Arrays.asList("p2", "p3"))));
        JdbcDeleteStatementSelfTest.assertTrue((boolean)Arrays.equals(new int[]{1, 0}, res));
    }
}

