/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc2;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.jdbc2.JdbcConnection;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.jetbrains.annotations.NotNull;
import org.junit.Test;

public class JdbcConnectionSelfTest
extends GridCommonAbstractTest {
    private static final String CUSTOM_CACHE_NAME = "custom-cache";
    private static final int GRID_CNT = 2;
    private boolean daemon;
    private boolean client;

    protected String configURL() {
        return "modules/clients/src/test/config/jdbc-config.xml";
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setCacheConfiguration(new CacheConfiguration[]{this.cacheConfiguration("default"), this.cacheConfiguration(CUSTOM_CACHE_NAME)});
        cfg.setDaemon(this.daemon);
        cfg.setClientMode(this.client);
        return cfg;
    }

    private CacheConfiguration cacheConfiguration(@NotNull String name) throws Exception {
        CacheConfiguration cfg = JdbcConnectionSelfTest.defaultCacheConfiguration();
        cfg.setName(name);
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        this.startGridsMultiThreaded(2);
    }

    @Test
    public void testDefaults() throws Exception {
        String url = "jdbc:ignite:cfg://" + this.configURL();
        try (Connection conn = DriverManager.getConnection(url);){
            JdbcConnectionSelfTest.assertNotNull((Object)conn);
            JdbcConnectionSelfTest.assertTrue((boolean)((JdbcConnection)conn).ignite().configuration().isClientMode());
        }
        conn = DriverManager.getConnection(url + '/');
        var3_3 = null;
        try {
            JdbcConnectionSelfTest.assertNotNull((Object)conn);
            JdbcConnectionSelfTest.assertTrue((boolean)((JdbcConnection)conn).ignite().configuration().isClientMode());
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var3_3 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testNodeId() throws Exception {
        String url = "jdbc:ignite:cfg://nodeId=" + this.grid(0).localNode().id() + '@' + this.configURL();
        try (Connection conn = DriverManager.getConnection(url);){
            JdbcConnectionSelfTest.assertNotNull((Object)conn);
        }
        url = "jdbc:ignite:cfg://cache=custom-cache:nodeId=" + this.grid(0).localNode().id() + '@' + this.configURL();
        conn = DriverManager.getConnection(url);
        var3_3 = null;
        try {
            JdbcConnectionSelfTest.assertNotNull((Object)conn);
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var3_3 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testWrongNodeId() throws Exception {
        UUID wrongId = UUID.randomUUID();
        final String url = "jdbc:ignite:cfg://nodeId=" + wrongId + '@' + this.configURL();
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try (Connection conn = DriverManager.getConnection(url);){
                    Connection connection = conn;
                    return connection;
                }
            }
        }, SQLException.class, (String)("Failed to establish connection with node (is it a server node?): " + wrongId));
    }

    @Test
    public void testClientNodeId() throws Exception {
        this.client = true;
        IgniteEx client = this.startGrid();
        UUID clientId = client.localNode().id();
        final String url = "jdbc:ignite:cfg://nodeId=" + clientId + '@' + this.configURL();
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try (Connection conn = DriverManager.getConnection(url);){
                    Connection connection = conn;
                    return connection;
                }
            }
        }, SQLException.class, (String)("Failed to establish connection with node (is it a server node?): " + clientId));
    }

    @Test
    public void testDaemonNodeId() throws Exception {
        this.daemon = true;
        IgniteEx daemon = this.startGrid(2);
        UUID daemonId = daemon.localNode().id();
        final String url = "jdbc:ignite:cfg://nodeId=" + daemonId + '@' + this.configURL();
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try (Connection conn = DriverManager.getConnection(url);){
                    Connection connection = conn;
                    return connection;
                }
            }
        }, SQLException.class, (String)("Failed to establish connection with node (is it a server node?): " + daemonId));
    }

    @Test
    public void testCustomCache() throws Exception {
        String url = "jdbc:ignite:cfg://cache=custom-cache@" + this.configURL();
        try (Connection conn = DriverManager.getConnection(url);){
            JdbcConnectionSelfTest.assertNotNull((Object)conn);
        }
    }

    @Test
    public void testWrongCache() throws Exception {
        final String url = "jdbc:ignite:cfg://cache=wrongCacheName@" + this.configURL();
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try (Connection conn = DriverManager.getConnection(url);){
                    Connection connection = conn;
                    return connection;
                }
            }
        }, SQLException.class, (String)"Client is invalid. Probably cache name is wrong.");
    }

    @Test
    public void testClose() throws Exception {
        String url = "jdbc:ignite:cfg://" + this.configURL();
        try (final Connection conn = DriverManager.getConnection(url);){
            JdbcConnectionSelfTest.assertNotNull((Object)conn);
            JdbcConnectionSelfTest.assertFalse((boolean)conn.isClosed());
            conn.close();
            JdbcConnectionSelfTest.assertTrue((boolean)conn.isClosed());
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    conn.isValid(2);
                    return null;
                }
            }, SQLException.class, (String)"Connection is closed.");
        }
    }

    @Test
    public void testTxAllowedCommit() throws Exception {
        String url = "jdbc:ignite:cfg://transactionsAllowed=true@" + this.configURL();
        try (Connection conn = DriverManager.getConnection(url);){
            conn.setTransactionIsolation(8);
            JdbcConnectionSelfTest.assertEquals((int)8, (int)conn.getTransactionIsolation());
            conn.setAutoCommit(false);
            conn.commit();
        }
    }

    @Test
    public void testTxAllowedRollback() throws Exception {
        String url = "jdbc:ignite:cfg://transactionsAllowed=true@" + this.configURL();
        try (Connection conn = DriverManager.getConnection(url);){
            conn.setTransactionIsolation(8);
            JdbcConnectionSelfTest.assertEquals((int)8, (int)conn.getTransactionIsolation());
            conn.setAutoCommit(false);
            conn.rollback();
        }
    }

    @Test
    public void testSqlHints() throws Exception {
        try (Connection conn = DriverManager.getConnection("jdbc:ignite:cfg://enforceJoinOrder=true@" + this.configURL());){
            JdbcConnectionSelfTest.assertTrue((boolean)((JdbcConnection)conn).isEnforceJoinOrder());
            JdbcConnectionSelfTest.assertFalse((boolean)((JdbcConnection)conn).isDistributedJoins());
            JdbcConnectionSelfTest.assertFalse((boolean)((JdbcConnection)conn).isCollocatedQuery());
            JdbcConnectionSelfTest.assertEquals((boolean)SqlFieldsQuery.DFLT_LAZY, (boolean)((JdbcConnection)conn).isLazy());
            JdbcConnectionSelfTest.assertFalse((boolean)((JdbcConnection)conn).skipReducerOnUpdate());
        }
        conn = DriverManager.getConnection("jdbc:ignite:cfg://distributedJoins=true@" + this.configURL());
        var2_2 = null;
        try {
            JdbcConnectionSelfTest.assertFalse((boolean)((JdbcConnection)conn).isEnforceJoinOrder());
            JdbcConnectionSelfTest.assertTrue((boolean)((JdbcConnection)conn).isDistributedJoins());
            JdbcConnectionSelfTest.assertFalse((boolean)((JdbcConnection)conn).isCollocatedQuery());
            JdbcConnectionSelfTest.assertEquals((boolean)SqlFieldsQuery.DFLT_LAZY, (boolean)((JdbcConnection)conn).isLazy());
            JdbcConnectionSelfTest.assertFalse((boolean)((JdbcConnection)conn).skipReducerOnUpdate());
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = DriverManager.getConnection("jdbc:ignite:cfg://collocated=true@" + this.configURL());
        var2_2 = null;
        try {
            JdbcConnectionSelfTest.assertFalse((boolean)((JdbcConnection)conn).isEnforceJoinOrder());
            JdbcConnectionSelfTest.assertFalse((boolean)((JdbcConnection)conn).isDistributedJoins());
            JdbcConnectionSelfTest.assertTrue((boolean)((JdbcConnection)conn).isCollocatedQuery());
            JdbcConnectionSelfTest.assertEquals((boolean)SqlFieldsQuery.DFLT_LAZY, (boolean)((JdbcConnection)conn).isLazy());
            JdbcConnectionSelfTest.assertFalse((boolean)((JdbcConnection)conn).skipReducerOnUpdate());
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = DriverManager.getConnection("jdbc:ignite:cfg://lazy=" + !SqlFieldsQuery.DFLT_LAZY + "@" + this.configURL());
        var2_2 = null;
        try {
            JdbcConnectionSelfTest.assertFalse((boolean)((JdbcConnection)conn).isEnforceJoinOrder());
            JdbcConnectionSelfTest.assertFalse((boolean)((JdbcConnection)conn).isDistributedJoins());
            JdbcConnectionSelfTest.assertFalse((boolean)((JdbcConnection)conn).isCollocatedQuery());
            JdbcConnectionSelfTest.assertEquals((!SqlFieldsQuery.DFLT_LAZY ? 1 : 0) != 0, (boolean)((JdbcConnection)conn).isLazy());
            JdbcConnectionSelfTest.assertFalse((boolean)((JdbcConnection)conn).skipReducerOnUpdate());
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = DriverManager.getConnection("jdbc:ignite:cfg://skipReducerOnUpdate=true@" + this.configURL());
        var2_2 = null;
        try {
            JdbcConnectionSelfTest.assertFalse((boolean)((JdbcConnection)conn).isEnforceJoinOrder());
            JdbcConnectionSelfTest.assertFalse((boolean)((JdbcConnection)conn).isDistributedJoins());
            JdbcConnectionSelfTest.assertFalse((boolean)((JdbcConnection)conn).isCollocatedQuery());
            JdbcConnectionSelfTest.assertEquals((boolean)SqlFieldsQuery.DFLT_LAZY, (boolean)((JdbcConnection)conn).isLazy());
            JdbcConnectionSelfTest.assertTrue((boolean)((JdbcConnection)conn).skipReducerOnUpdate());
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }
}

