/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc2;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Arrays;
import org.apache.ignite.internal.jdbc2.JdbcBlob;
import org.junit.Assert;
import org.junit.Test;

public class JdbcBlobTest {
    @Test
    public void testLength() throws Exception {
        JdbcBlob blob = new JdbcBlob(new byte[16]);
        Assert.assertEquals((long)16L, (long)((int)blob.length()));
        blob.free();
        try {
            blob.length();
            Assert.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Test
    public void testGetBytes() throws Exception {
        byte[] arr = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        JdbcBlob blob = new JdbcBlob(arr);
        try {
            blob.getBytes(0L, 16);
            Assert.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            blob.getBytes(17L, 16);
            Assert.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            blob.getBytes(1L, -1);
            Assert.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        byte[] res = blob.getBytes(1L, 0);
        Assert.assertEquals((long)0L, (long)res.length);
        Assert.assertTrue((boolean)Arrays.equals(arr, blob.getBytes(1L, 16)));
        res = blob.getBytes(1L, 20);
        Assert.assertEquals((long)16L, (long)res.length);
        Assert.assertTrue((boolean)Arrays.equals(arr, res));
        res = blob.getBytes(1L, 10);
        Assert.assertEquals((long)10L, (long)res.length);
        Assert.assertEquals((long)0L, (long)res[0]);
        Assert.assertEquals((long)9L, (long)res[9]);
        res = blob.getBytes(7L, 10);
        Assert.assertEquals((long)10L, (long)res.length);
        Assert.assertEquals((long)6L, (long)res[0]);
        Assert.assertEquals((long)15L, (long)res[9]);
        res = blob.getBytes(7L, 20);
        Assert.assertEquals((long)10L, (long)res.length);
        Assert.assertEquals((long)6L, (long)res[0]);
        Assert.assertEquals((long)15L, (long)res[9]);
        res = blob.getBytes(1L, 0);
        Assert.assertEquals((long)0L, (long)res.length);
        blob.free();
        try {
            blob.getBytes(1L, 16);
            Assert.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Test
    public void testGetBinaryStream() throws Exception {
        byte[] arr = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        JdbcBlob blob = new JdbcBlob(arr);
        InputStream is = blob.getBinaryStream();
        byte[] res = JdbcBlobTest.readBytes(is);
        Assert.assertTrue((boolean)Arrays.equals(arr, res));
        blob.free();
        try {
            blob.getBinaryStream();
            Assert.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Test
    public void testGetBinaryStreamWithParams() throws Exception {
        byte[] arr = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        JdbcBlob blob = new JdbcBlob(arr);
        try {
            blob.getBinaryStream(0L, (long)arr.length);
            Assert.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            blob.getBinaryStream(1L, 0L);
            Assert.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            blob.getBinaryStream(17L, (long)arr.length);
            Assert.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            blob.getBinaryStream(1L, (long)(arr.length + 1));
            Assert.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        InputStream is = blob.getBinaryStream(1L, (long)arr.length);
        byte[] res = JdbcBlobTest.readBytes(is);
        Assert.assertTrue((boolean)Arrays.equals(arr, res));
        is = blob.getBinaryStream(1L, 10L);
        res = JdbcBlobTest.readBytes(is);
        Assert.assertEquals((long)10L, (long)res.length);
        Assert.assertEquals((long)0L, (long)res[0]);
        Assert.assertEquals((long)9L, (long)res[9]);
        is = blob.getBinaryStream(6L, 10L);
        res = JdbcBlobTest.readBytes(is);
        Assert.assertEquals((long)10L, (long)res.length);
        Assert.assertEquals((long)5L, (long)res[0]);
        Assert.assertEquals((long)14L, (long)res[9]);
        blob.free();
        try {
            blob.getBinaryStream(1L, (long)arr.length);
            Assert.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Test
    public void testPositionBytePattern() throws Exception {
        byte[] arr = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        JdbcBlob blob = new JdbcBlob(arr);
        Assert.assertEquals((long)-1L, (long)blob.position(new byte[]{1, 2, 3}, 0L));
        Assert.assertEquals((long)-1L, (long)blob.position(new byte[]{1, 2, 3}, (long)(arr.length + 1)));
        Assert.assertEquals((long)-1L, (long)blob.position(new byte[0], 1L));
        Assert.assertEquals((long)-1L, (long)blob.position(new byte[17], 1L));
        Assert.assertEquals((long)-1L, (long)blob.position(new byte[]{3, 2, 1}, 1L));
        Assert.assertEquals((long)1L, (long)blob.position(new byte[]{0, 1, 2}, 1L));
        Assert.assertEquals((long)2L, (long)blob.position(new byte[]{1, 2, 3}, 1L));
        Assert.assertEquals((long)2L, (long)blob.position(new byte[]{1, 2, 3}, 2L));
        Assert.assertEquals((long)-1L, (long)blob.position(new byte[]{1, 2, 3}, 3L));
        Assert.assertEquals((long)14L, (long)blob.position(new byte[]{13, 14, 15}, 3L));
        Assert.assertEquals((long)-1L, (long)blob.position(new byte[]{0, 1, 3}, 1L));
        Assert.assertEquals((long)-1L, (long)blob.position(new byte[]{0, 2, 3}, 1L));
        Assert.assertEquals((long)-1L, (long)blob.position(new byte[]{1, 2, 4}, 1L));
        blob.free();
        try {
            blob.position(new byte[]{0, 1, 2}, 1L);
            Assert.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Test
    public void testPositionBlobPattern() throws Exception {
        byte[] arr = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        JdbcBlob blob = new JdbcBlob(arr);
        Assert.assertEquals((long)-1L, (long)blob.position((Blob)new JdbcBlob(new byte[]{1, 2, 3}), 0L));
        Assert.assertEquals((long)-1L, (long)blob.position((Blob)new JdbcBlob(new byte[]{1, 2, 3}), (long)(arr.length + 1)));
        Assert.assertEquals((long)-1L, (long)blob.position((Blob)new JdbcBlob(new byte[0]), 1L));
        Assert.assertEquals((long)-1L, (long)blob.position((Blob)new JdbcBlob(new byte[17]), 1L));
        Assert.assertEquals((long)-1L, (long)blob.position((Blob)new JdbcBlob(new byte[]{3, 2, 1}), 1L));
        Assert.assertEquals((long)1L, (long)blob.position((Blob)new JdbcBlob(new byte[]{0, 1, 2}), 1L));
        Assert.assertEquals((long)2L, (long)blob.position((Blob)new JdbcBlob(new byte[]{1, 2, 3}), 1L));
        Assert.assertEquals((long)2L, (long)blob.position((Blob)new JdbcBlob(new byte[]{1, 2, 3}), 2L));
        Assert.assertEquals((long)-1L, (long)blob.position((Blob)new JdbcBlob(new byte[]{1, 2, 3}), 3L));
        Assert.assertEquals((long)14L, (long)blob.position((Blob)new JdbcBlob(new byte[]{13, 14, 15}), 3L));
        Assert.assertEquals((long)-1L, (long)blob.position((Blob)new JdbcBlob(new byte[]{0, 1, 3}), 1L));
        Assert.assertEquals((long)-1L, (long)blob.position((Blob)new JdbcBlob(new byte[]{0, 2, 3}), 1L));
        Assert.assertEquals((long)-1L, (long)blob.position((Blob)new JdbcBlob(new byte[]{1, 2, 4}), 1L));
        blob.free();
        try {
            blob.position((Blob)new JdbcBlob(new byte[]{0, 1, 2}), 1L);
            Assert.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Test
    public void testSetBytes() throws Exception {
        byte[] arr = new byte[]{0, 1, 2, 3, 4, 5, 6, 7};
        JdbcBlob blob = new JdbcBlob(arr);
        try {
            blob.setBytes(0L, new byte[4]);
            Assert.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            blob.setBytes(17L, new byte[4]);
            Assert.fail();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        Assert.assertEquals((long)4L, (long)blob.setBytes(1L, new byte[]{3, 2, 1, 0}));
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{3, 2, 1, 0, 4, 5, 6, 7}, blob.getBytes(1L, arr.length)));
        Assert.assertEquals((long)4L, (long)blob.setBytes(5L, new byte[]{7, 6, 5, 4}));
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{3, 2, 1, 0, 7, 6, 5, 4}, blob.getBytes(1L, arr.length)));
        Assert.assertEquals((long)4L, (long)blob.setBytes(7L, new byte[]{8, 9, 10, 11}));
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{3, 2, 1, 0, 7, 6, 8, 9, 10, 11}, blob.getBytes(1L, (int)blob.length())));
        blob = new JdbcBlob(new byte[]{15, 16});
        Assert.assertEquals((long)8L, (long)blob.setBytes(1L, new byte[]{0, 1, 2, 3, 4, 5, 6, 7}));
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{0, 1, 2, 3, 4, 5, 6, 7}, blob.getBytes(1L, (int)blob.length())));
        blob.free();
        try {
            blob.setBytes(1L, new byte[]{0, 1, 2});
            Assert.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Test
    public void testSetBytesWithOffsetAndLength() throws Exception {
        byte[] arr = new byte[]{0, 1, 2, 3, 4, 5, 6, 7};
        JdbcBlob blob = new JdbcBlob(arr);
        try {
            blob.setBytes(0L, new byte[4], 0, 2);
            Assert.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            blob.setBytes(17L, new byte[4], 0, 2);
            Assert.fail();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        try {
            blob.setBytes(1L, new byte[4], -1, 2);
            Assert.fail();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        try {
            blob.setBytes(1L, new byte[4], 0, 5);
            Assert.fail();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        Assert.assertEquals((long)4L, (long)blob.setBytes(1L, new byte[]{3, 2, 1, 0}, 0, 4));
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{3, 2, 1, 0, 4, 5, 6, 7}, blob.getBytes(1L, arr.length)));
        Assert.assertEquals((long)4L, (long)blob.setBytes(5L, new byte[]{7, 6, 5, 4}, 0, 4));
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{3, 2, 1, 0, 7, 6, 5, 4}, blob.getBytes(1L, arr.length)));
        Assert.assertEquals((long)4L, (long)blob.setBytes(7L, new byte[]{8, 9, 10, 11}, 0, 4));
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{3, 2, 1, 0, 7, 6, 8, 9, 10, 11}, blob.getBytes(1L, (int)blob.length())));
        Assert.assertEquals((long)2L, (long)blob.setBytes(1L, new byte[]{3, 2, 1, 0}, 2, 2));
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{1, 0, 1, 0, 7, 6, 8, 9, 10, 11}, blob.getBytes(1L, (int)blob.length())));
        Assert.assertEquals((long)2L, (long)blob.setBytes(9L, new byte[]{3, 2, 1, 0}, 1, 2));
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{1, 0, 1, 0, 7, 6, 8, 9, 2, 1}, blob.getBytes(1L, (int)blob.length())));
        Assert.assertEquals((long)3L, (long)blob.setBytes(9L, new byte[]{3, 2, 1, 0}, 0, 3));
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{1, 0, 1, 0, 7, 6, 8, 9, 3, 2, 1}, blob.getBytes(1L, (int)blob.length())));
        blob = new JdbcBlob(new byte[]{15, 16});
        Assert.assertEquals((long)8L, (long)blob.setBytes(1L, new byte[]{0, 1, 2, 3, 4, 5, 6, 7}, 0, 8));
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{0, 1, 2, 3, 4, 5, 6, 7}, blob.getBytes(1L, (int)blob.length())));
        blob.free();
        try {
            blob.setBytes(1L, new byte[]{0, 1, 2}, 0, 2);
            Assert.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Test
    public void testTruncate() throws Exception {
        byte[] arr = new byte[]{0, 1, 2, 3, 4, 5, 6, 7};
        JdbcBlob blob = new JdbcBlob(arr);
        try {
            blob.truncate(-1L);
            Assert.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            blob.truncate((long)(arr.length + 1));
            Assert.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        blob.truncate(4L);
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{0, 1, 2, 3}, blob.getBytes(1L, (int)blob.length())));
        blob.truncate(0L);
        Assert.assertEquals((long)0L, (long)((int)blob.length()));
        blob.free();
        try {
            blob.truncate(0L);
            Assert.fail();
        }
        catch (SQLException e) {
            System.out.println();
        }
    }

    private static byte[] readBytes(InputStream is) throws IOException {
        int read;
        byte[] tmp = new byte[16];
        int i = 0;
        int cnt = 0;
        while ((read = is.read()) != -1) {
            tmp[i++] = (byte)read;
            ++cnt;
        }
        byte[] res = new byte[cnt];
        System.arraycopy(tmp, 0, res, 0, cnt);
        return res;
    }
}

