/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.internal.client.util.GridClientConsistentHash;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class ClientConsistentHashSelfTest
extends GridCommonAbstractTest {
    private static final int REPLICAS = 512;

    @Test
    public void testCollisions() throws Exception {
        HashMap<Integer, LinkedHashSet<UUID>> map = new HashMap<Integer, LinkedHashSet<UUID>>();
        LinkedHashSet<UUID> nodes = new LinkedHashSet<UUID>();
        while (nodes.size() < 10) {
            UUID uuid = UUID.randomUUID();
            int hashCode = uuid.hashCode();
            LinkedHashSet<UUID> set = (LinkedHashSet<UUID>)map.get(hashCode);
            if (set == null) {
                set = new LinkedHashSet<UUID>();
                map.put(hashCode, set);
            }
            set.add(uuid);
            if (set.size() <= 1) continue;
            nodes.addAll(set);
        }
        map.clear();
        GridClientConsistentHash hash = new GridClientConsistentHash();
        hash.addNodes(nodes, 512);
        boolean fail = false;
        for (UUID exp : nodes) {
            UUID act = (UUID)hash.node((Object)0, Arrays.asList(exp));
            if (exp.equals(act)) {
                this.info("Validation succeed [exp=" + exp + ", act=" + act + ']');
                continue;
            }
            this.info("Validation failed  [exp=" + exp + ", act=" + act + ']');
            fail = true;
        }
        if (fail) {
            ClientConsistentHashSelfTest.fail((String)("Failed to resolve consistent hash node, when node's hash codes collide: " + nodes));
        }
    }

    @Test
    public void testTreeSetRestrictions() throws Exception {
        GridClientConsistentHash hash = new GridClientConsistentHash();
        try {
            hash.addNode(new Object(){

                public int hashCode() {
                    return 0;
                }
            }, 1);
            hash.addNode(new Object(){

                public int hashCode() {
                    return 0;
                }
            }, 1);
            ClientConsistentHashSelfTest.fail((String)"Expects failed due to internal TreeSet requires comparator or natural ordering.");
        }
        catch (ClassCastException e) {
            this.info("Expected fail due to internal TreeSet requires comparator or natural ordering: " + e.getMessage());
        }
        hash = new GridClientConsistentHash((Comparator)new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return System.identityHashCode(o1) - System.identityHashCode(o2);
            }
        }, null);
        hash.addNode(new Object(){

            public int hashCode() {
                return 0;
            }
        }, 1);
        hash.addNode(new Object(){

            public int hashCode() {
                return 0;
            }
        }, 1);
        this.info("Expected pass due to internal TreeSet has explicit comparator.");
    }

    @Test
    public void testHashGeneraton() {
        this.checkHash("", -1484017934);
        this.checkHash("1", -80388575);
        this.checkHash("a", -873690096);
        this.checkHash("Hadoop\u3092\u6bba\u3059", -695300527);
        this.checkHash("key1", -2067461682);
        this.checkHash(true, 1669973725);
        this.checkHash(false, -1900934144);
        this.checkHash(3, 386050343);
        this.checkHash(1000000000, -547312286);
        this.checkHash(Integer.MAX_VALUE, 473949739);
        this.checkHash(-1, -1399925094);
        this.checkHash(Long.MAX_VALUE, 201097861);
        this.checkHash(-1L, -1484017934);
        this.checkHash(Float.valueOf(Float.MIN_VALUE), 1262722378);
        this.checkHash(Float.valueOf(Float.MAX_VALUE), 1313755354);
        this.checkHash(Double.MIN_VALUE, 1262722378);
        this.checkHash(Double.MAX_VALUE, -783615357);
        this.checkHash(UUID.fromString("4d180911-21c9-48f2-a1e6-7bc1daf588a0"), -440525148);
        this.checkUUID("224ea4cd-f449-4dcb-869a-5317c63bd619", 806670090);
        this.checkUUID("fdc9ec54-ff53-4fdb-8239-5a3ac1fb31bd", -354375826);
        this.checkUUID("0f9c9b94-02ae-45a6-9d5c-a066dbdf2636", -1312538272);
        this.checkUUID("d8f1f916-4357-4cfe-a7df-49d4721690bf", -482944041);
        this.checkUUID("d67eb652-4e76-47fb-ad4e-cd902d9b868a", -449444069);
        this.checkUUID("c77ffeae-78a1-4ee6-a0fd-8d197a794412", -168980875);
        this.checkUUID("35de9f21-3c9b-4f4a-a7d5-3e2c6cb01564", -383915637);
    }

    @Test
    public void testMappingToNodes() {
        String n1 = "node #1";
        String n2 = "node #2";
        String n3 = "node #3";
        String n4 = "node #4";
        List<String> nodes = Arrays.asList(n1, n2, n3, n4);
        GridClientConsistentHash hash = new GridClientConsistentHash();
        for (String node : nodes) {
            hash.addNode((Object)node, 5);
        }
        LinkedHashMap<Object, String> data = new LinkedHashMap<Object, String>();
        data.put("", n1);
        data.put("asdf", n3);
        data.put("224ea4cd-f449-4dcb-869a-5317c63bd619", n2);
        data.put("fdc9ec54-ff53-4fdb-8239-5a3ac1fb31bd", n4);
        data.put("0f9c9b94-02ae-45a6-9d5c-a066dbdf2636", n1);
        data.put("d8f1f916-4357-4cfe-a7df-49d4721690bf", n3);
        data.put("c77ffeae-78a1-4ee6-a0fd-8d197a794412", n4);
        data.put("35de9f21-3c9b-4f4a-a7d5-3e2c6cb01564", n4);
        data.put("d67eb652-4e76-47fb-ad4e-cd902d9b868a", n4);
        data.put(0, n1);
        data.put(1, n4);
        data.put(12, n3);
        data.put(123, n3);
        data.put(1234, n3);
        data.put(12345, n4);
        data.put(123456, n3);
        data.put(1234567, n4);
        data.put(12345678, n4);
        data.put(123456789, n4);
        data.put(1234567890, n3);
        data.put(1234567890L, n3);
        data.put(12345678901L, n4);
        data.put(123456789012L, n2);
        data.put(1234567890123L, n4);
        data.put(12345678901234L, n1);
        data.put(123456789012345L, n1);
        data.put(1234567890123456L, n3);
        data.put(-23456789012345L, n2);
        data.put(-2345678901234L, n1);
        data.put(-234567890123L, n4);
        data.put(-23456789012L, n3);
        data.put(-2345678901L, n3);
        data.put(-234567890L, n1);
        data.put(-234567890, n4);
        data.put(-23456789, n4);
        data.put(-2345678, n4);
        data.put(-234567, n4);
        data.put(-23456, n4);
        data.put(-2345, n1);
        data.put(-234, n4);
        data.put(-23, n3);
        data.put(-2, n4);
        data.put(Integer.MIN_VALUE, n2);
        data.put(Integer.MAX_VALUE, n4);
        data.put(Long.MIN_VALUE, n2);
        data.put(Long.MAX_VALUE, n2);
        data.put(1.1, n1);
        data.put(-10.01, n3);
        data.put(100.001, n3);
        data.put(-1000.0001, n4);
        data.put(Double.MAX_VALUE, n4);
        data.put(-1.7976931348623157E308, n4);
        data.put(Double.MIN_VALUE, n4);
        data.put(-4.9E-324, n3);
        for (Map.Entry entry : data.entrySet()) {
            ClientConsistentHashSelfTest.assertEquals((String)("Validate key '" + entry.getKey() + "'."), (String)((String)entry.getValue()), (String)((String)hash.node(entry.getKey())));
        }
        for (Map.Entry entry : data.entrySet()) {
            ClientConsistentHashSelfTest.assertEquals((String)("Validate key '" + entry.getKey() + "'."), (String)((String)entry.getValue()), (String)((String)hash.node(entry.getKey(), nodes)));
        }
        nodes = new ArrayList<String>(nodes);
        Collections.reverse(nodes);
        hash = new GridClientConsistentHash();
        for (String string : nodes) {
            hash.addNode((Object)string, 5);
        }
        for (Map.Entry entry : data.entrySet()) {
            ClientConsistentHashSelfTest.assertEquals((String)("Validate key '" + entry.getKey() + "'."), (String)((String)entry.getValue()), (String)((String)hash.node(entry.getKey())));
        }
        for (Map.Entry entry : data.entrySet()) {
            ClientConsistentHashSelfTest.assertEquals((String)("Validate key '" + entry.getKey() + "'."), (String)((String)entry.getValue()), (String)((String)hash.node(entry.getKey(), nodes)));
        }
    }

    private void checkUUID(String uuid, int code) {
        this.checkHash(UUID.fromString(uuid), code);
    }

    private void checkHash(Object o, int code) {
        int i = GridClientConsistentHash.hash((Object)o);
        ClientConsistentHashSelfTest.assertEquals((String)("Check affinity for object: " + o), (int)code, (int)i);
    }
}

