/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.integration;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.cache.Cache;
import javax.cache.configuration.Factory;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.store.CacheStore;
import org.apache.ignite.cache.store.CacheStoreAdapter;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobAdapter;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeTaskSplitAdapter;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.ConnectorMessageInterceptor;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientClosedException;
import org.apache.ignite.internal.client.GridClientCompute;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientData;
import org.apache.ignite.internal.client.GridClientDataConfiguration;
import org.apache.ignite.internal.client.GridClientException;
import org.apache.ignite.internal.client.GridClientFactory;
import org.apache.ignite.internal.client.GridClientFuture;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.client.GridClientPredicate;
import org.apache.ignite.internal.client.GridClientProtocol;
import org.apache.ignite.internal.client.GridServerUnreachableException;
import org.apache.ignite.internal.client.ssl.GridSslContextFactory;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiInClosure;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.junit.Test;

public abstract class ClientAbstractSelfTest
extends GridCommonAbstractTest {
    private static final String CACHE_NAME = "cache";
    public static final String HOST = "127.0.0.1";
    public static final int JETTY_PORT = 8080;
    public static final int BINARY_PORT = 11212;
    public static final String REST_JETTY_CFG = "modules/clients/src/test/resources/jetty/rest-jetty.xml";
    private static final ConcurrentMap<Object, Object> INTERCEPTED_OBJECTS = new ConcurrentHashMap<Object, Object>();
    private static final Map<String, HashMapStore> cacheStores = new HashMap<String, HashMapStore>();
    public static final String ROUTER_LOG_CFG = "modules/core/src/test/config/log4j-test.xml";
    private static final String INTERCEPTED_SUF = "intercepted";
    private static final String[] TASK_ARGS = new String[]{"executing", "test", "task"};
    private static volatile boolean overwriteIntercepted;
    private ExecutorService exec;
    protected GridClient client;
    private static final ObjectMapper JSON_MAPPER;

    protected void beforeTestsStarted() throws Exception {
        System.setProperty("IGNITE_JETTY_PORT", Integer.toString(8080));
        this.startGrid();
        System.clearProperty("IGNITE_JETTY_PORT");
    }

    protected void beforeTest() throws Exception {
        this.exec = Executors.newCachedThreadPool();
        this.client = this.client();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void afterTest() throws Exception {
        U.shutdownNow(ClientAbstractSelfTest.class, (ExecutorService)this.exec, (IgniteLogger)log);
        this.exec = null;
        if (this.client != null) {
            GridClientFactory.stop((UUID)this.client.id(), (boolean)true);
        }
        this.client = null;
        Map<String, HashMapStore> map = cacheStores;
        synchronized (map) {
            for (HashMapStore cacheStore : cacheStores.values()) {
                cacheStore.map.clear();
            }
        }
        this.grid().cache("default").clear();
        this.grid().cache(CACHE_NAME).clear();
        INTERCEPTED_OBJECTS.clear();
    }

    protected abstract GridClientProtocol protocol();

    protected abstract String serverAddress();

    protected abstract boolean useSsl();

    protected abstract GridSslContextFactory sslContextFactory();

    protected String getTaskName() {
        return TestTask.class.getName();
    }

    protected String getSleepTaskName() {
        return SleepTestTask.class.getName();
    }

    protected Object getTaskArgument() {
        return Arrays.asList(TASK_ARGS);
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setLocalHost(HOST);
        assert (cfg.getConnectorConfiguration() == null);
        ConnectorConfiguration clientCfg = new ConnectorConfiguration();
        clientCfg.setPort(11212);
        if (this.useSsl()) {
            clientCfg.setSslEnabled(true);
            clientCfg.setSslContextFactory(this.sslContextFactory());
        }
        cfg.setConnectorConfiguration(clientCfg);
        cfg.setCacheConfiguration(new CacheConfiguration[]{ClientAbstractSelfTest.cacheConfiguration("default"), ClientAbstractSelfTest.cacheConfiguration("replicated"), ClientAbstractSelfTest.cacheConfiguration("partitioned"), ClientAbstractSelfTest.cacheConfiguration(CACHE_NAME)});
        clientCfg.setMessageInterceptor(new ConnectorMessageInterceptor(){

            public Object onReceive(@Nullable Object obj) {
                if (obj != null) {
                    INTERCEPTED_OBJECTS.put(obj, obj);
                }
                return overwriteIntercepted && obj instanceof String ? obj + ClientAbstractSelfTest.INTERCEPTED_SUF : obj;
            }

            public Object onSend(Object obj) {
                if (obj != null) {
                    INTERCEPTED_OBJECTS.put(obj, obj);
                }
                return obj;
            }
        });
        return cfg;
    }

    private static CacheConfiguration cacheConfiguration(final @NotNull String cacheName) throws Exception {
        CacheConfiguration cfg = ClientAbstractSelfTest.defaultCacheConfiguration();
        cfg.setCacheMode("default".equals(cacheName) || CACHE_NAME.equals(cacheName) ? CacheMode.LOCAL : ("replicated".equals(cacheName) ? CacheMode.REPLICATED : CacheMode.PARTITIONED));
        cfg.setName(cacheName);
        cfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        cfg.setCacheStoreFactory((Factory)new Factory<CacheStore>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public CacheStore create() {
                Map map = cacheStores;
                synchronized (map) {
                    HashMapStore cacheStore = (HashMapStore)((Object)cacheStores.get(cacheName));
                    if (cacheStore == null) {
                        cacheStore = new HashMapStore();
                        cacheStores.put(cacheName, cacheStore);
                    }
                    return cacheStore;
                }
            }
        });
        cfg.setWriteThrough(true);
        cfg.setReadThrough(true);
        cfg.setLoadPreviousValue(true);
        if (cfg.getCacheMode() == CacheMode.PARTITIONED) {
            cfg.setBackups(1);
        }
        return cfg;
    }

    protected GridClient client() throws GridClientException {
        return GridClientFactory.start((GridClientConfiguration)this.clientConfiguration());
    }

    protected GridClientConfiguration clientConfiguration() throws GridClientException {
        GridClientConfiguration cfg = new GridClientConfiguration();
        GridClientDataConfiguration nullCache = new GridClientDataConfiguration();
        GridClientDataConfiguration cache = new GridClientDataConfiguration();
        cache.setName(CACHE_NAME);
        cfg.setDataConfigurations(Arrays.asList(nullCache, cache));
        cfg.setProtocol(this.protocol());
        cfg.setServers(Collections.singleton(this.serverAddress()));
        cfg.setExecutorService(Executors.newCachedThreadPool(new ThreadFactory(){
            private AtomicInteger cntr = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "client-worker-thread-" + this.cntr.getAndIncrement());
            }
        }));
        if (this.useSsl()) {
            cfg.setSslContextFactory(this.sslContextFactory());
        }
        return cfg;
    }

    @Test
    public void testConnectable() throws Exception {
        GridClient client = this.client();
        List nodes = client.compute().refreshTopology(false, false);
        ClientAbstractSelfTest.assertTrue((boolean)((GridClientNode)F.first((List)nodes)).connectable());
    }

    @Test
    public void testNoAsyncExceptions() throws Exception {
        GridClient client = this.client();
        GridClientData data = client.data(CACHE_NAME);
        GridClientCompute compute = client.compute().projection((GridClientPredicate)new GridClientPredicate<GridClientNode>(){

            public boolean apply(GridClientNode e) {
                return false;
            }
        });
        LinkedHashMap<String, GridClientFuture> futs = new LinkedHashMap<String, GridClientFuture>();
        futs.put("exec", compute.executeAsync("taskName", (Object)"taskArg"));
        futs.put("affExec", compute.affinityExecuteAsync("taskName", "cacheName", (Object)"affKey", (Object)"taskArg"));
        futs.put("refreshById", compute.refreshNodeAsync(UUID.randomUUID(), true, true));
        futs.put("refreshByIP", compute.refreshNodeAsync("nodeIP", true, true));
        futs.put("refreshTop", compute.refreshTopologyAsync(true, true));
        GridClientFactory.stop((UUID)client.id(), (boolean)false);
        futs.put("put", data.putAsync((Object)"key", (Object)"val"));
        futs.put("putAll", data.putAllAsync(F.asMap((Object)"key", (Object)"val")));
        futs.put("get", data.getAsync((Object)"key"));
        futs.put("getAll", data.getAllAsync(Collections.singletonList("key")));
        futs.put("remove", data.removeAsync((Object)"key"));
        futs.put("removeAll", data.removeAllAsync(Collections.singletonList("key")));
        futs.put("replace", data.replaceAsync((Object)"key", (Object)"val"));
        futs.put("cas", data.casAsync((Object)"key", (Object)"val", (Object)"val2"));
        futs.put("metrics", data.metricsAsync());
        for (Map.Entry e : futs.entrySet()) {
            try {
                ((GridClientFuture)e.getValue()).get();
                this.info("Expects '" + (String)e.getKey() + "' fails with grid client exception.");
            }
            catch (GridClientClosedException | GridServerUnreachableException throwable) {}
        }
    }

    @Test
    public void testGracefulShutdown() throws Exception {
        GridClientCompute compute = this.client.compute();
        Object taskArg = this.getTaskArgument();
        String taskName = this.getSleepTaskName();
        GridClientFuture fut = compute.executeAsync(taskName, taskArg);
        GridClientFuture fut2 = compute.executeAsync(taskName, taskArg);
        GridClientFactory.stop((UUID)this.client.id(), (boolean)true);
        Assert.assertEquals((Object)17, (Object)fut.get());
        Assert.assertEquals((Object)17, (Object)fut2.get());
    }

    @Test
    public void testForceShutdown() throws Exception {
        GridClientCompute compute = this.client.compute();
        Object taskArg = this.getTaskArgument();
        String taskName = this.getSleepTaskName();
        GridClientFuture fut = compute.executeAsync(taskName, taskArg);
        GridClientFactory.stop((UUID)this.client.id(), (boolean)false);
        try {
            fut.get();
        }
        catch (GridClientClosedException ignored) {
            return;
        }
        Assert.fail((String)"Expected GridClientClosedException.");
    }

    @Test
    public void testShutdown() throws Exception {
        GridClient c = this.client();
        GridClientCompute compute = c.compute();
        String taskName = this.getTaskName();
        Object taskArg = this.getTaskArgument();
        ArrayList<GridClientFuture> futs = new ArrayList<GridClientFuture>();
        compute.execute(taskName, taskArg);
        this.info(">>> First task executed successfully, running batch.");
        for (int i = 0; i < 10; ++i) {
            futs.add(compute.executeAsync(taskName, taskArg));
        }
        GridClientFactory.stop((UUID)c.id(), (boolean)true);
        this.info(">>> Completed stop request.");
        int failed = 0;
        for (GridClientFuture fut : futs) {
            try {
                ClientAbstractSelfTest.assertEquals((Object)17, (Object)fut.get());
            }
            catch (GridClientException e) {
                ++failed;
                log.warning("Task execution failed.", (Throwable)e);
            }
        }
        ClientAbstractSelfTest.assertEquals((int)0, (int)failed);
    }

    @Test
    public void testExecute() throws Exception {
        String taskName = this.getTaskName();
        Object taskArg = this.getTaskArgument();
        GridClientCompute compute = this.client.compute();
        ClientAbstractSelfTest.assertEquals((Object)17, (Object)compute.execute(taskName, taskArg));
        ClientAbstractSelfTest.assertEquals((Object)17, (Object)compute.executeAsync(taskName, taskArg).get());
    }

    @Test
    public void testTopology() throws Exception {
        GridClientCompute compute = this.client.compute();
        List top = compute.refreshTopology(true, true);
        ClientAbstractSelfTest.assertNotNull((Object)top);
        ClientAbstractSelfTest.assertEquals((int)1, (int)top.size());
        GridClientNode node = (GridClientNode)F.first((List)top);
        ClientAbstractSelfTest.assertNotNull((Object)node);
        ClientAbstractSelfTest.assertFalse((boolean)node.attributes().isEmpty());
        ClientAbstractSelfTest.assertNotNull((Object)node.tcpAddresses());
        ClientAbstractSelfTest.assertEquals((Object)this.grid().localNode().id(), (Object)node.nodeId());
        ClientAbstractSelfTest.assertNotNull((Object)node.metrics());
        top = compute.refreshTopology(false, false);
        node = (GridClientNode)F.first((List)top);
        ClientAbstractSelfTest.assertNotNull((Object)top);
        ClientAbstractSelfTest.assertEquals((int)1, (int)top.size());
        ClientAbstractSelfTest.assertNull((Object)node.metrics());
        ClientAbstractSelfTest.assertTrue((boolean)node.attributes().isEmpty());
        node = (GridClientNode)F.first((List)top);
        ClientAbstractSelfTest.assertNotNull((Object)node);
        ClientAbstractSelfTest.assertTrue((boolean)node.attributes().isEmpty());
        ClientAbstractSelfTest.assertNull((Object)node.metrics());
        ClientAbstractSelfTest.assertNotNull((Object)node.tcpAddresses());
        ClientAbstractSelfTest.assertEquals((Object)this.grid().localNode().id(), (Object)node.nodeId());
        top = (List)compute.refreshTopologyAsync(true, true).get();
        ClientAbstractSelfTest.assertNotNull((Object)top);
        ClientAbstractSelfTest.assertEquals((int)1, (int)top.size());
        node = (GridClientNode)F.first((List)top);
        ClientAbstractSelfTest.assertNotNull((Object)node);
        ClientAbstractSelfTest.assertFalse((boolean)node.attributes().isEmpty());
        ClientAbstractSelfTest.assertNotNull((Object)node.metrics());
        ClientAbstractSelfTest.assertNotNull((Object)node.tcpAddresses());
        ClientAbstractSelfTest.assertEquals((Object)this.grid().localNode().id(), (Object)node.nodeId());
        top = (List)compute.refreshTopologyAsync(false, false).get();
        ClientAbstractSelfTest.assertNotNull((Object)top);
        ClientAbstractSelfTest.assertEquals((int)1, (int)top.size());
        node = (GridClientNode)F.first((List)top);
        ClientAbstractSelfTest.assertNotNull((Object)node);
        ClientAbstractSelfTest.assertTrue((boolean)node.attributes().isEmpty());
        ClientAbstractSelfTest.assertNull((Object)node.metrics());
        ClientAbstractSelfTest.assertNotNull((Object)node.tcpAddresses());
        ClientAbstractSelfTest.assertEquals((Object)this.grid().localNode().id(), (Object)node.nodeId());
    }

    static {
        JSON_MAPPER = new ObjectMapper();
    }

    private static class HashMapStore
    extends CacheStoreAdapter<Object, Object> {
        private final Map<Object, Object> map = new HashMap<Object, Object>();

        private HashMapStore() {
        }

        public void loadCache(IgniteBiInClosure<Object, Object> clo, Object ... args) {
            for (Map.Entry<Object, Object> e : this.map.entrySet()) {
                clo.apply(e.getKey(), e.getValue());
            }
        }

        public Object load(Object key) {
            return this.map.get(key);
        }

        public void write(Cache.Entry<?, ?> e) {
            this.map.put(e.getKey(), e.getValue());
        }

        public void delete(Object key) {
            this.map.remove(key);
        }
    }

    protected static class SleepHttpTestTask
    extends ComputeTaskSplitAdapter<String, Integer> {
        private final SleepTestTask delegate = new SleepTestTask();

        protected SleepHttpTestTask() {
        }

        protected Collection<? extends ComputeJob> split(int gridSize, String arg) {
            try {
                JsonNode json = JSON_MAPPER.readTree(arg);
                ArrayList<String> list = null;
                if (json.isArray()) {
                    list = new ArrayList<String>();
                    for (JsonNode child : json) {
                        list.add(child.asText());
                    }
                }
                return this.delegate.split(gridSize, list);
            }
            catch (IOException e) {
                throw new IgniteException((Throwable)e);
            }
        }

        public Integer reduce(List<ComputeJobResult> results) {
            return this.delegate.reduce((List)results);
        }
    }

    protected static class HttpTestTask
    extends ComputeTaskSplitAdapter<String, Integer> {
        private final TestTask delegate = new TestTask();

        protected HttpTestTask() {
        }

        protected Collection<? extends ComputeJob> split(int gridSize, String arg) {
            if (arg.endsWith(ClientAbstractSelfTest.INTERCEPTED_SUF)) {
                arg = arg.substring(0, arg.length() - 11);
            }
            try {
                JsonNode json = JSON_MAPPER.readTree(arg);
                ArrayList<String> list = null;
                if (json.isArray()) {
                    list = new ArrayList<String>();
                    for (JsonNode child : json) {
                        list.add(child.asText());
                    }
                }
                return this.delegate.split(gridSize, list);
            }
            catch (IOException e) {
                throw new IgniteException((Throwable)e);
            }
        }

        public Integer reduce(List<ComputeJobResult> results) {
            return this.delegate.reduce((List)results);
        }
    }

    private static class SleepTestTask
    extends ComputeTaskSplitAdapter<List<String>, Integer> {
        private SleepTestTask() {
        }

        protected Collection<? extends ComputeJob> split(int gridSize, List<String> list) {
            ArrayList<1> jobs = new ArrayList<1>();
            if (list != null) {
                for (final String val : list) {
                    jobs.add(new ComputeJobAdapter(){

                        public Object execute() {
                            try {
                                Thread.sleep(5000L);
                                return val == null ? 0 : val.length();
                            }
                            catch (InterruptedException ignored) {
                                return -1;
                            }
                        }
                    });
                }
            }
            return jobs;
        }

        public Integer reduce(List<ComputeJobResult> results) {
            int sum = 0;
            for (ComputeJobResult res : results) {
                sum += ((Integer)res.getData()).intValue();
            }
            return sum;
        }
    }

    private static class TestTask
    extends ComputeTaskSplitAdapter<List<String>, Integer> {
        private TestTask() {
        }

        protected Collection<? extends ComputeJob> split(int gridSize, List<String> list) {
            ArrayList<1> jobs = new ArrayList<1>();
            if (list != null) {
                for (final String val : list) {
                    jobs.add(new ComputeJobAdapter(){

                        public Object execute() {
                            try {
                                Thread.sleep(1L);
                            }
                            catch (InterruptedException ignored) {
                                Thread.currentThread().interrupt();
                            }
                            return val == null ? 0 : val.length();
                        }
                    });
                }
            }
            return jobs;
        }

        public Integer reduce(List<ComputeJobResult> results) {
            int sum = 0;
            for (ComputeJobResult res : results) {
                sum += ((Integer)res.getData()).intValue();
            }
            return sum;
        }
    }
}

