/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.common;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import javax.cache.CacheException;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.client.ClientCacheConfiguration;
import org.apache.ignite.client.ClientException;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.ClientConfiguration;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.jdbc.thin.JdbcThinConnection;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class ClientSizeCacheCreationDestructionTest
extends GridCommonAbstractTest {
    private static final String CACHE_NAME = "CacheName";
    private static final String ANOTHER_CACHE_NAME = "AnotherCacheName";
    private static final String CLIENT_CACHE_NAME = "ClientCacheName";
    private static final String CACHE_GROUP_NAME = "CacheGroupName";
    protected Ignite srv;
    private Ignite thickClient;
    private IgniteClient thinClient;
    private Connection jdbcConn;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration configuration = super.getConfiguration(igniteInstanceName);
        configuration.setConnectorConfiguration(new ConnectorConfiguration());
        return configuration;
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.srv = this.startGrid("server");
        int port = (Integer)this.srv.cluster().localNode().attributes().get("clientListenerPort");
        this.thickClient = this.startClientGrid(1);
        ClientConfiguration clientCfg = new ClientConfiguration().setAddresses(new String[]{"127.0.0.1:" + port}).setClusterDiscoveryEnabled(false);
        this.thinClient = Ignition.startClient((ClientConfiguration)clientCfg);
        this.jdbcConn = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1:" + port);
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        if (this.thickClient != null) {
            this.thickClient.close();
        }
        if (this.thinClient != null) {
            this.thinClient.close();
        }
        if (this.jdbcConn != null) {
            this.jdbcConn.close();
        }
        this.stopAllGrids();
    }

    protected void afterTestsStopped() throws Exception {
        super.afterTestsStopped();
        this.stopAllGrids();
    }

    @Test
    public void testServerThenClientCacheCreation() throws Exception {
        this.createCache((AutoCloseable)this.srv, (Serializable)this.cacheConfig());
        this.createCache((AutoCloseable)this.thickClient, (Serializable)this.cacheConfig().setName(CLIENT_CACHE_NAME));
        IgniteCache cache = this.srv.cache(CLIENT_CACHE_NAME);
        cache.put((Object)1L, (Object)"abc");
        ClientSizeCacheCreationDestructionTest.assertEquals((Object)"abc", (Object)cache.get((Object)1L));
    }

    @Test
    public void testFewCachesCreatedInChainWithinFourCacheGroupsThickClient() throws Exception {
        int i;
        for (i = 0; i < 4; ++i) {
            this.createCache((AutoCloseable)this.srv, (Serializable)this.cacheConfig().setGroupName(CACHE_GROUP_NAME + i).setName(CACHE_NAME + i));
        }
        for (i = 0; i < 4; ++i) {
            this.createCache((AutoCloseable)this.thickClient, (Serializable)this.cacheConfig().setGroupName(CACHE_GROUP_NAME + i).setName(CLIENT_CACHE_NAME + i));
        }
        ClientSizeCacheCreationDestructionTest.assertEquals((int)8, (int)this.srv.cacheNames().size());
        for (i = 0; i < 4; ++i) {
            ClientSizeCacheCreationDestructionTest.assertEquals((String)(CACHE_GROUP_NAME + i), (String)((CacheConfiguration)this.srv.cache(CACHE_NAME + i).getConfiguration(CacheConfiguration.class)).getGroupName());
            ClientSizeCacheCreationDestructionTest.assertEquals((String)(CACHE_GROUP_NAME + i), (String)((CacheConfiguration)this.srv.cache(CLIENT_CACHE_NAME + i).getConfiguration(CacheConfiguration.class)).getGroupName());
            this.srv.cache(CACHE_NAME + i).put((Object)1, (Object)("abc_srv" + i));
            ClientSizeCacheCreationDestructionTest.assertEquals((Object)("abc_srv" + i), (Object)this.srv.cache(CACHE_NAME + i).get((Object)1));
            this.srv.cache(CLIENT_CACHE_NAME + i).put((Object)1, (Object)("abc_cli" + i));
            ClientSizeCacheCreationDestructionTest.assertEquals((Object)("abc_cli" + i), (Object)this.srv.cache(CLIENT_CACHE_NAME + i).get((Object)1));
        }
    }

    @Test
    public void testFewCachesCreatedInChainWithinFourCacheGroupsThinClient() throws Exception {
        int i;
        for (i = 0; i < 4; ++i) {
            this.createCache((AutoCloseable)this.srv, (Serializable)this.cacheConfig().setGroupName(CACHE_GROUP_NAME + i).setName(CACHE_NAME + i));
        }
        for (i = 0; i < 4; ++i) {
            this.createCache((AutoCloseable)this.thinClient, (Serializable)this.clientCacheConfig().setGroupName(CACHE_GROUP_NAME + i).setName(CLIENT_CACHE_NAME + i));
        }
        ClientSizeCacheCreationDestructionTest.assertEquals((int)8, (int)this.srv.cacheNames().size());
        for (i = 0; i < 4; ++i) {
            ClientSizeCacheCreationDestructionTest.assertEquals((String)(CACHE_GROUP_NAME + i), (String)((CacheConfiguration)this.srv.cache(CACHE_NAME + i).getConfiguration(CacheConfiguration.class)).getGroupName());
            ClientSizeCacheCreationDestructionTest.assertEquals((String)(CACHE_GROUP_NAME + i), (String)((CacheConfiguration)this.srv.cache(CLIENT_CACHE_NAME + i).getConfiguration(CacheConfiguration.class)).getGroupName());
            this.srv.cache(CACHE_NAME + i).put((Object)1, (Object)("abc_srv" + i));
            ClientSizeCacheCreationDestructionTest.assertEquals((Object)("abc_srv" + i), (Object)this.srv.cache(CACHE_NAME + i).get((Object)1));
            this.srv.cache(CLIENT_CACHE_NAME + i).put((Object)1, (Object)("abc_cli" + i));
            ClientSizeCacheCreationDestructionTest.assertEquals((Object)("abc_cli" + i), (Object)this.srv.cache(CLIENT_CACHE_NAME + i).get((Object)1));
        }
    }

    @Test
    public void testFewCachesCreatedInChainWithinFourCacheGroupsJdbcThinClient() throws Exception {
        int i;
        for (i = 0; i < 4; ++i) {
            this.createCache((AutoCloseable)this.srv, (Serializable)this.cacheConfig().setGroupName(CACHE_GROUP_NAME + i).setName(CACHE_NAME + i));
        }
        for (i = 0; i < 4; ++i) {
            this.createCache(this.jdbcConn, (Serializable)this.cacheConfig().setGroupName(CACHE_GROUP_NAME + i).setName(CLIENT_CACHE_NAME + i));
        }
        ClientSizeCacheCreationDestructionTest.assertEquals((int)8, (int)this.srv.cacheNames().size());
        for (i = 0; i < 4; ++i) {
            ClientSizeCacheCreationDestructionTest.assertEquals((String)(CACHE_GROUP_NAME + i), (String)((CacheConfiguration)this.srv.cache(CACHE_NAME + i).getConfiguration(CacheConfiguration.class)).getGroupName());
            ClientSizeCacheCreationDestructionTest.assertEquals((String)(CACHE_GROUP_NAME + i), (String)((CacheConfiguration)this.srv.cache("SQL_PUBLIC_" + CLIENT_CACHE_NAME.toUpperCase() + i).getConfiguration(CacheConfiguration.class)).getGroupName());
            this.srv.cache(CACHE_NAME + i).put((Object)1, (Object)("abc_srv" + i));
            ClientSizeCacheCreationDestructionTest.assertEquals((Object)("abc_srv" + i), (Object)this.srv.cache(CACHE_NAME + i).get((Object)1));
            this.srv.cache("SQL_PUBLIC_" + CLIENT_CACHE_NAME.toUpperCase() + i).put((Object)1, (Object)("abc_cli" + i));
            ClientSizeCacheCreationDestructionTest.assertEquals((Object)("abc_cli" + i), (Object)this.srv.cache("SQL_PUBLIC_" + CLIENT_CACHE_NAME.toUpperCase() + i).get((Object)1));
        }
    }

    @Test
    public void testFewCachesCreatedInChainWithinFourCacheGroupsRestClient() throws Exception {
        int i;
        for (i = 0; i < 4; ++i) {
            this.createCache((AutoCloseable)this.srv, (Serializable)this.cacheConfig().setGroupName(CACHE_GROUP_NAME + i).setName(CACHE_NAME + i));
        }
        for (i = 0; i < 4; ++i) {
            this.createCacheWithRestClient(this.cacheConfig().setGroupName(CACHE_GROUP_NAME + i).setName(CLIENT_CACHE_NAME + i));
        }
        ClientSizeCacheCreationDestructionTest.assertEquals((int)8, (int)this.srv.cacheNames().size());
        for (i = 0; i < 4; ++i) {
            ClientSizeCacheCreationDestructionTest.assertEquals((String)(CACHE_GROUP_NAME + i), (String)((CacheConfiguration)this.srv.cache(CACHE_NAME + i).getConfiguration(CacheConfiguration.class)).getGroupName());
            ClientSizeCacheCreationDestructionTest.assertEquals((String)(CACHE_GROUP_NAME + i), (String)((CacheConfiguration)this.srv.cache(CLIENT_CACHE_NAME + i).getConfiguration(CacheConfiguration.class)).getGroupName());
            this.srv.cache(CACHE_NAME + i).put((Object)1, (Object)("abc_srv" + i));
            ClientSizeCacheCreationDestructionTest.assertEquals((Object)("abc_srv" + i), (Object)this.srv.cache(CACHE_NAME + i).get((Object)1));
            this.srv.cache(CLIENT_CACHE_NAME + i).put((Object)1, (Object)("abc_cli" + i));
            ClientSizeCacheCreationDestructionTest.assertEquals((Object)("abc_cli" + i), (Object)this.srv.cache(CLIENT_CACHE_NAME + i).get((Object)1));
        }
    }

    @Test
    public void testFewCachesCreatedInChainWithinTwoCacheGroupsThickClient() throws Exception {
        int i;
        for (i = 0; i < 4; ++i) {
            this.createCache((AutoCloseable)this.srv, (Serializable)this.cacheConfig().setGroupName(CACHE_GROUP_NAME + i % 2).setName(CACHE_NAME + i));
        }
        for (i = 0; i < 4; ++i) {
            this.createCache((AutoCloseable)this.thickClient, (Serializable)this.cacheConfig().setGroupName(CACHE_GROUP_NAME + i % 2).setName(CLIENT_CACHE_NAME + i));
        }
        ClientSizeCacheCreationDestructionTest.assertEquals((int)8, (int)this.srv.cacheNames().size());
        for (i = 0; i < 4; ++i) {
            ClientSizeCacheCreationDestructionTest.assertEquals((String)(CACHE_GROUP_NAME + i % 2), (String)((CacheConfiguration)this.srv.cache(CACHE_NAME + i).getConfiguration(CacheConfiguration.class)).getGroupName());
            ClientSizeCacheCreationDestructionTest.assertEquals((String)(CACHE_GROUP_NAME + i % 2), (String)((CacheConfiguration)this.srv.cache(CLIENT_CACHE_NAME + i).getConfiguration(CacheConfiguration.class)).getGroupName());
            this.srv.cache(CACHE_NAME + i).put((Object)1, (Object)("abc_srv" + i));
            ClientSizeCacheCreationDestructionTest.assertEquals((Object)("abc_srv" + i), (Object)this.srv.cache(CACHE_NAME + i).get((Object)1));
            this.srv.cache(CLIENT_CACHE_NAME + i).put((Object)1, (Object)("abc_cli" + i));
            ClientSizeCacheCreationDestructionTest.assertEquals((Object)("abc_cli" + i), (Object)this.srv.cache(CLIENT_CACHE_NAME + i).get((Object)1));
        }
    }

    @Test
    public void testFewCachesCreatedInChainWithinTwoCacheGroupsThinClient() throws Exception {
        int i;
        for (i = 0; i < 4; ++i) {
            this.createCache((AutoCloseable)this.srv, (Serializable)this.cacheConfig().setGroupName(CACHE_GROUP_NAME + i % 2).setName(CACHE_NAME + i));
        }
        for (i = 0; i < 4; ++i) {
            this.createCache((AutoCloseable)this.thinClient, (Serializable)this.clientCacheConfig().setGroupName(CACHE_GROUP_NAME + i % 2).setName(CLIENT_CACHE_NAME + i));
        }
        ClientSizeCacheCreationDestructionTest.assertEquals((int)8, (int)this.srv.cacheNames().size());
        for (i = 0; i < 4; ++i) {
            ClientSizeCacheCreationDestructionTest.assertEquals((String)(CACHE_GROUP_NAME + i % 2), (String)((CacheConfiguration)this.srv.cache(CACHE_NAME + i).getConfiguration(CacheConfiguration.class)).getGroupName());
            ClientSizeCacheCreationDestructionTest.assertEquals((String)(CACHE_GROUP_NAME + i % 2), (String)((CacheConfiguration)this.srv.cache(CLIENT_CACHE_NAME + i).getConfiguration(CacheConfiguration.class)).getGroupName());
            this.srv.cache(CACHE_NAME + i).put((Object)1, (Object)("abc_srv" + i));
            ClientSizeCacheCreationDestructionTest.assertEquals((Object)("abc_srv" + i), (Object)this.srv.cache(CACHE_NAME + i).get((Object)1));
            this.srv.cache(CLIENT_CACHE_NAME + i).put((Object)1, (Object)("abc_cli" + i));
            ClientSizeCacheCreationDestructionTest.assertEquals((Object)("abc_cli" + i), (Object)this.srv.cache(CLIENT_CACHE_NAME + i).get((Object)1));
        }
    }

    @Test
    public void testFewCachesCreatedInChainWithinTwoCacheGroupsJdbcThinClient() throws Exception {
        int i;
        for (i = 0; i < 4; ++i) {
            this.createCache((AutoCloseable)this.srv, (Serializable)this.cacheConfig().setGroupName(CACHE_GROUP_NAME + i % 2).setName(CACHE_NAME + i));
        }
        for (i = 0; i < 4; ++i) {
            this.createCache(this.jdbcConn, (Serializable)this.cacheConfig().setGroupName(CACHE_GROUP_NAME + i % 2).setName(CLIENT_CACHE_NAME + i));
        }
        ClientSizeCacheCreationDestructionTest.assertEquals((int)8, (int)this.srv.cacheNames().size());
        for (i = 0; i < 4; ++i) {
            ClientSizeCacheCreationDestructionTest.assertEquals((String)(CACHE_GROUP_NAME + i % 2), (String)((CacheConfiguration)this.srv.cache(CACHE_NAME + i).getConfiguration(CacheConfiguration.class)).getGroupName());
            ClientSizeCacheCreationDestructionTest.assertEquals((String)(CACHE_GROUP_NAME + i % 2), (String)((CacheConfiguration)this.srv.cache("SQL_PUBLIC_" + CLIENT_CACHE_NAME.toUpperCase() + i).getConfiguration(CacheConfiguration.class)).getGroupName());
            this.srv.cache(CACHE_NAME + i).put((Object)1, (Object)("abc_srv" + i));
            ClientSizeCacheCreationDestructionTest.assertEquals((Object)("abc_srv" + i), (Object)this.srv.cache(CACHE_NAME + i).get((Object)1));
            this.srv.cache("SQL_PUBLIC_" + CLIENT_CACHE_NAME.toUpperCase() + i).put((Object)1, (Object)("abc_cli" + i));
            ClientSizeCacheCreationDestructionTest.assertEquals((Object)("abc_cli" + i), (Object)this.srv.cache("SQL_PUBLIC_" + CLIENT_CACHE_NAME.toUpperCase() + i).get((Object)1));
        }
    }

    @Test
    public void testFewCachesCreatedInChainWithinTwoCacheGroupsRestClient() throws Exception {
        int i;
        for (i = 0; i < 4; ++i) {
            this.createCache((AutoCloseable)this.srv, (Serializable)this.cacheConfig().setGroupName(CACHE_GROUP_NAME + i % 2).setName(CACHE_NAME + i));
        }
        for (i = 0; i < 4; ++i) {
            this.createCacheWithRestClient(this.cacheConfig().setGroupName(CACHE_GROUP_NAME + i % 2).setName(CLIENT_CACHE_NAME + i));
        }
        ClientSizeCacheCreationDestructionTest.assertEquals((int)8, (int)this.srv.cacheNames().size());
        for (i = 0; i < 4; ++i) {
            ClientSizeCacheCreationDestructionTest.assertEquals((String)(CACHE_GROUP_NAME + i % 2), (String)((CacheConfiguration)this.srv.cache(CACHE_NAME + i).getConfiguration(CacheConfiguration.class)).getGroupName());
            ClientSizeCacheCreationDestructionTest.assertEquals((String)(CACHE_GROUP_NAME + i % 2), (String)((CacheConfiguration)this.srv.cache(CLIENT_CACHE_NAME + i).getConfiguration(CacheConfiguration.class)).getGroupName());
            this.srv.cache(CACHE_NAME + i).put((Object)1, (Object)("abc_srv" + i));
            ClientSizeCacheCreationDestructionTest.assertEquals((Object)("abc_srv" + i), (Object)this.srv.cache(CACHE_NAME + i).get((Object)1));
            this.srv.cache(CLIENT_CACHE_NAME + i).put((Object)1, (Object)("abc_cli" + i));
            ClientSizeCacheCreationDestructionTest.assertEquals((Object)("abc_cli" + i), (Object)this.srv.cache(CLIENT_CACHE_NAME + i).get((Object)1));
        }
    }

    @Test
    public void testFewCachesCreatedInChainWithCacheGroupNameEqualsFirstCacheNameThickClient() throws Exception {
        for (int i = 0; i < 4; ++i) {
            this.createCache((AutoCloseable)this.srv, (Serializable)this.cacheConfigWithoutCacheGroup().setName(CACHE_NAME + i));
        }
        GridTestUtils.assertThrows(null, () -> {
            this.createCache((AutoCloseable)this.thickClient, (Serializable)this.cacheConfig().setGroupName("CacheName0").setName(CLIENT_CACHE_NAME));
            return null;
        }, CacheException.class, (String)"Failed to start cache. Cache group name conflict with existing cache (change group name)");
    }

    @Test
    public void testFewCachesCreatedInChainWithCacheGroupNameEqualsFirstCacheNameThinClient() throws Exception {
        for (int i = 0; i < 4; ++i) {
            this.createCache((AutoCloseable)this.srv, (Serializable)this.cacheConfigWithoutCacheGroup().setName(CACHE_NAME + i));
        }
        GridTestUtils.assertThrows(null, () -> {
            this.createCache((AutoCloseable)this.thinClient, (Serializable)this.clientCacheConfig().setGroupName("CacheName0").setName(CLIENT_CACHE_NAME));
            return null;
        }, ClientException.class, (String)"Failed to start cache. Cache group name conflict with existing cache (change group name)");
    }

    @Test
    public void testFewCachesCreatedInChainWithCacheGroupNameEqualsFirstCacheNameJdbcThinClient() throws Exception {
        for (int i = 0; i < 4; ++i) {
            this.createCache((AutoCloseable)this.srv, (Serializable)this.cacheConfigWithoutCacheGroup().setName(CACHE_NAME + i));
        }
        GridTestUtils.assertThrows(null, () -> {
            this.createCache(this.jdbcConn, (Serializable)this.cacheConfig().setGroupName("CacheName0").setName(CLIENT_CACHE_NAME));
            return null;
        }, SQLException.class, (String)"Failed to start cache. Cache group name conflict with existing cache (change group name)");
    }

    @Test
    public void testFewCachesCreatedInChainWithCacheGroupNameEqualsFirstCacheNameRestClient() throws Exception {
        for (int i = 0; i < 4; ++i) {
            this.createCache((AutoCloseable)this.srv, (Serializable)this.cacheConfigWithoutCacheGroup().setName(CACHE_NAME + i));
        }
        GridTestUtils.assertThrows(null, () -> {
            this.createCacheWithRestClient(this.cacheConfig().setGroupName("CacheName0").setName(CLIENT_CACHE_NAME));
            return null;
        }, AssertionError.class, (String)"expected:<0> but was:<1>");
    }

    @Test
    public void testFewCachesCreatedInChainWithDifferentConfigThickClient() throws Exception {
        this.createCache((AutoCloseable)this.srv, (Serializable)this.cacheConfig().setGroupName(CACHE_GROUP_NAME).setName(CACHE_NAME).setBackups(1));
        GridTestUtils.assertThrows(null, () -> {
            this.createCache((AutoCloseable)this.thickClient, (Serializable)this.cacheConfig().setGroupName(CACHE_GROUP_NAME).setName(CLIENT_CACHE_NAME).setBackups(2));
            return null;
        }, CacheException.class, (String)"Backups mismatch for caches related to the same group");
    }

    @Test
    public void testFewCachesCreatedInChainWithDifferentConfigThinClient() throws Exception {
        this.createCache((AutoCloseable)this.srv, (Serializable)this.cacheConfig().setGroupName(CACHE_GROUP_NAME).setName(CACHE_NAME).setBackups(1));
        GridTestUtils.assertThrows(null, () -> {
            this.createCache((AutoCloseable)this.thinClient, (Serializable)this.clientCacheConfig().setGroupName(CACHE_GROUP_NAME).setName(CLIENT_CACHE_NAME).setBackups(2));
            return null;
        }, ClientException.class, (String)"Backups mismatch for caches related to the same group");
    }

    @Test
    public void testFewCachesCreatedInChainWithDifferentConfigJdbcThinClient() throws Exception {
        this.createCache((AutoCloseable)this.srv, (Serializable)this.cacheConfig().setGroupName(CACHE_GROUP_NAME).setName(CACHE_NAME).setBackups(1));
        GridTestUtils.assertThrows(null, () -> {
            this.createCache(this.jdbcConn, (Serializable)this.cacheConfig().setGroupName(CACHE_GROUP_NAME).setName(CLIENT_CACHE_NAME).setBackups(2));
            return null;
        }, SQLException.class, (String)"Backups mismatch for caches related to the same group");
    }

    @Test
    public void testFewCachesCreatedInChainWithDifferentConfigRestClient() throws Exception {
        this.createCache((AutoCloseable)this.srv, (Serializable)this.cacheConfig().setGroupName(CACHE_GROUP_NAME).setName(CACHE_NAME).setBackups(1));
        GridTestUtils.assertThrows(null, () -> {
            this.createCacheWithRestClient(this.cacheConfig().setGroupName(CACHE_GROUP_NAME).setName(CLIENT_CACHE_NAME).setBackups(2));
            return null;
        }, AssertionError.class, (String)"expected:<0> but was:<1>");
    }

    @Test
    public void testDestroyCachesThickClient() throws Exception {
        for (int i = 0; i < 2; ++i) {
            this.createCache((AutoCloseable)this.srv, (Serializable)this.cacheConfig().setGroupName(CACHE_GROUP_NAME).setName(CACHE_NAME + i));
        }
        CountDownLatch latch = new CountDownLatch(1);
        IgniteInternalFuture srv = GridTestUtils.runAsync(() -> {
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                ClientSizeCacheCreationDestructionTest.fail((String)e.toString());
            }
            this.srv.destroyCache("CacheName0");
        });
        IgniteInternalFuture client = GridTestUtils.runAsync(() -> {
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                ClientSizeCacheCreationDestructionTest.fail((String)e.toString());
            }
            this.thickClient.destroyCache("CacheName1");
        });
        latch.countDown();
        srv.get();
        client.get();
        ClientSizeCacheCreationDestructionTest.assertEquals((int)0, (int)this.srv.cacheNames().size());
        this.srv.createCache(CACHE_GROUP_NAME);
    }

    @Test
    public void testDestroyCachesThinClient() throws Exception {
        for (int i = 0; i < 2; ++i) {
            this.createCache((AutoCloseable)this.srv, (Serializable)this.cacheConfig().setGroupName(CACHE_GROUP_NAME).setName(CACHE_NAME + i));
        }
        CountDownLatch latch = new CountDownLatch(1);
        IgniteInternalFuture srv = GridTestUtils.runAsync(() -> {
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                ClientSizeCacheCreationDestructionTest.fail((String)e.toString());
            }
            this.srv.destroyCache("CacheName0");
        });
        IgniteInternalFuture client = GridTestUtils.runAsync(() -> {
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                ClientSizeCacheCreationDestructionTest.fail((String)e.toString());
            }
            this.thinClient.destroyCache("CacheName1");
        });
        latch.countDown();
        srv.get();
        client.get();
        ClientSizeCacheCreationDestructionTest.assertEquals((int)0, (int)this.srv.cacheNames().size());
        this.srv.createCache(CACHE_GROUP_NAME);
    }

    @Test
    public void testDestroyCachesRestClient() throws Exception {
        for (int i = 0; i < 2; ++i) {
            this.createCache((AutoCloseable)this.srv, (Serializable)this.cacheConfig().setGroupName(CACHE_GROUP_NAME).setName(CACHE_NAME + i));
        }
        CountDownLatch latch = new CountDownLatch(1);
        IgniteInternalFuture srv = GridTestUtils.runAsync(() -> {
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                ClientSizeCacheCreationDestructionTest.fail((String)e.toString());
            }
            this.srv.destroyCache("CacheName0");
        });
        IgniteInternalFuture client = GridTestUtils.runAsync(() -> {
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                ClientSizeCacheCreationDestructionTest.fail((String)e.toString());
            }
            URLConnection conn = null;
            try {
                conn = new URL("http://localhost:8080/ignite?cmd=destcache&cacheName=CacheName1").openConnection();
            }
            catch (IOException e) {
                ClientSizeCacheCreationDestructionTest.fail((String)e.toString());
            }
            try {
                conn.connect();
                try (InputStreamReader streamReader = new InputStreamReader(conn.getInputStream());){
                    ObjectMapper objMapper = new ObjectMapper();
                    Map myMap = (Map)objMapper.readValue((Reader)streamReader, (TypeReference)new TypeReference<Map<String, Object>>(){});
                    log.info("Version command response is: " + myMap);
                    ClientSizeCacheCreationDestructionTest.assertTrue((boolean)myMap.containsKey("response"));
                    ClientSizeCacheCreationDestructionTest.assertEquals((Object)0, myMap.get("successStatus"));
                }
            }
            catch (IOException e) {
                ClientSizeCacheCreationDestructionTest.fail((String)e.toString());
            }
        });
        latch.countDown();
        srv.get();
        client.get();
        ClientSizeCacheCreationDestructionTest.assertEquals((int)0, (int)this.srv.cacheNames().size());
        this.srv.createCache(CACHE_GROUP_NAME);
    }

    @Test
    public void testCreateOnSrvDestroyOnThickClient() {
        this.srv.createCache(this.cacheConfig().setName(ANOTHER_CACHE_NAME));
        this.srv.createCache(this.cacheConfig());
        this.thickClient.destroyCache(CACHE_NAME);
        ClientSizeCacheCreationDestructionTest.assertEquals((int)1, (int)this.srv.cacheNames().size());
        ClientSizeCacheCreationDestructionTest.assertEquals((String)ANOTHER_CACHE_NAME, (String)((String)this.srv.cacheNames().iterator().next()));
    }

    @Test
    public void testCreateOnSrvDestroyOnThinClient() {
        this.srv.createCache(this.cacheConfig().setName(ANOTHER_CACHE_NAME));
        this.srv.createCache(this.cacheConfig());
        this.thinClient.destroyCache(CACHE_NAME);
        ClientSizeCacheCreationDestructionTest.assertEquals((int)1, (int)this.srv.cacheNames().size());
        ClientSizeCacheCreationDestructionTest.assertEquals((String)ANOTHER_CACHE_NAME, (String)((String)this.srv.cacheNames().iterator().next()));
    }

    @Test
    public void testCreateOnSrvDestroyOnRestClient() throws Exception {
        this.srv.createCache(this.cacheConfig().setName(ANOTHER_CACHE_NAME));
        this.srv.createCache(this.cacheConfig());
        this.destroyCacheWithRestClient(CACHE_NAME);
        ClientSizeCacheCreationDestructionTest.assertEquals((int)1, (int)this.srv.cacheNames().size());
        ClientSizeCacheCreationDestructionTest.assertEquals((String)ANOTHER_CACHE_NAME, (String)((String)this.srv.cacheNames().iterator().next()));
    }

    @Test
    public void testCreateOnThickClientDestroyOnSrv() {
        this.srv.createCache(this.cacheConfig().setName(ANOTHER_CACHE_NAME));
        this.thickClient.createCache(this.cacheConfig());
        this.srv.destroyCache(CACHE_NAME);
        ClientSizeCacheCreationDestructionTest.assertEquals((int)1, (int)this.srv.cacheNames().size());
        ClientSizeCacheCreationDestructionTest.assertEquals((String)ANOTHER_CACHE_NAME, (String)((String)this.srv.cacheNames().iterator().next()));
    }

    @Test
    public void testCreateOnThinClientSrvDestroyOnSrv() {
        this.srv.createCache(this.cacheConfig().setName(ANOTHER_CACHE_NAME));
        this.thinClient.createCache(this.clientCacheConfig());
        this.srv.destroyCache(CACHE_NAME);
        ClientSizeCacheCreationDestructionTest.assertEquals((int)1, (int)this.srv.cacheNames().size());
        ClientSizeCacheCreationDestructionTest.assertEquals((String)ANOTHER_CACHE_NAME, (String)((String)this.srv.cacheNames().iterator().next()));
    }

    @Test
    public void testCreateOnJdbcClientDestroyOnSrv() throws Exception {
        this.srv.createCache(this.cacheConfig().setName(ANOTHER_CACHE_NAME));
        this.createCache(this.jdbcConn, (Serializable)this.cacheConfig());
        this.srv.destroyCache("SQL_PUBLIC_" + CACHE_NAME.toUpperCase());
        ClientSizeCacheCreationDestructionTest.assertEquals((int)1, (int)this.srv.cacheNames().size());
        ClientSizeCacheCreationDestructionTest.assertEquals((String)ANOTHER_CACHE_NAME, (String)((String)this.srv.cacheNames().iterator().next()));
    }

    @Test
    public void testCreateOnRestClientDestroyOnSrv() throws Exception {
        this.srv.createCache(this.cacheConfig().setName(ANOTHER_CACHE_NAME));
        this.createCacheWithRestClient(this.cacheConfig());
        this.srv.destroyCache(CACHE_NAME);
        ClientSizeCacheCreationDestructionTest.assertEquals((int)1, (int)this.srv.cacheNames().size());
        ClientSizeCacheCreationDestructionTest.assertEquals((String)ANOTHER_CACHE_NAME, (String)((String)this.srv.cacheNames().iterator().next()));
    }

    @Test
    public void testCreateOnThickClientDestroyThinClient() {
        this.srv.createCache(this.cacheConfig().setName(ANOTHER_CACHE_NAME));
        this.thickClient.createCache(this.cacheConfig());
        this.thinClient.destroyCache(CACHE_NAME);
        ClientSizeCacheCreationDestructionTest.assertEquals((int)1, (int)this.srv.cacheNames().size());
        ClientSizeCacheCreationDestructionTest.assertEquals((String)ANOTHER_CACHE_NAME, (String)((String)this.srv.cacheNames().iterator().next()));
    }

    @Test
    public void testCreateOnThinClientSrvDestroyOnRestClient() throws Exception {
        this.srv.createCache(this.cacheConfig().setName(ANOTHER_CACHE_NAME));
        this.thinClient.createCache(this.clientCacheConfig());
        this.destroyCacheWithRestClient(CACHE_NAME);
        ClientSizeCacheCreationDestructionTest.assertEquals((int)1, (int)this.srv.cacheNames().size());
        ClientSizeCacheCreationDestructionTest.assertEquals((String)ANOTHER_CACHE_NAME, (String)((String)this.srv.cacheNames().iterator().next()));
    }

    @Test
    public void testCreateOnJdbcClientDestroyOnThinClient() throws Exception {
        this.srv.createCache(this.cacheConfig().setName(ANOTHER_CACHE_NAME));
        this.createCache(this.jdbcConn, (Serializable)this.cacheConfig());
        this.thinClient.destroyCache("SQL_PUBLIC_" + CACHE_NAME.toUpperCase());
        ClientSizeCacheCreationDestructionTest.assertEquals((int)1, (int)this.srv.cacheNames().size());
        ClientSizeCacheCreationDestructionTest.assertEquals((String)ANOTHER_CACHE_NAME, (String)((String)this.srv.cacheNames().iterator().next()));
    }

    @Test
    public void testCreateOnRestClientDestroyOnThickClient() throws Exception {
        this.srv.createCache(this.cacheConfig().setName(ANOTHER_CACHE_NAME));
        this.createCacheWithRestClient(this.cacheConfig());
        this.thickClient.destroyCache(CACHE_NAME);
        ClientSizeCacheCreationDestructionTest.assertEquals((int)1, (int)this.srv.cacheNames().size());
        ClientSizeCacheCreationDestructionTest.assertEquals((String)ANOTHER_CACHE_NAME, (String)((String)this.srv.cacheNames().iterator().next()));
    }

    private void createCache(AutoCloseable node, Serializable cacheCfg) throws SQLException {
        if (node instanceof IgniteClient) {
            ((IgniteClient)node).createCache((ClientCacheConfiguration)cacheCfg);
        } else if (node instanceof Ignite) {
            ((Ignite)node).createCache((CacheConfiguration)cacheCfg);
        } else if (node instanceof JdbcThinConnection) {
            CacheConfiguration jdbcCacheCfg = (CacheConfiguration)cacheCfg;
            this.srv.addCacheConfiguration(jdbcCacheCfg);
            try (Statement stmt = this.jdbcConn.createStatement();){
                stmt.execute("CREATE TABLE " + jdbcCacheCfg.getName() + " (id int, name varchar, primary key (id)) WITH \"template=" + jdbcCacheCfg.getName() + "\"");
            }
        } else {
            ClientSizeCacheCreationDestructionTest.fail((String)" Unexpected node/client type");
        }
    }

    private void createCacheWithRestClient(CacheConfiguration cacheCfg) throws Exception {
        this.srv.addCacheConfiguration(cacheCfg);
        URLConnection conn = new URL("http://localhost:8080/ignite?cmd=getorcreate&cacheName=" + cacheCfg.getName() + "&templateName=" + cacheCfg.getName()).openConnection();
        conn.connect();
        try (InputStreamReader streamReader = new InputStreamReader(conn.getInputStream());){
            ObjectMapper objMapper = new ObjectMapper();
            Map myMap = (Map)objMapper.readValue((Reader)streamReader, (TypeReference)new TypeReference<Map<String, Object>>(){});
            log.info("Version command response is: " + myMap);
            ClientSizeCacheCreationDestructionTest.assertTrue((boolean)myMap.containsKey("response"));
            ClientSizeCacheCreationDestructionTest.assertEquals((Object)0, myMap.get("successStatus"));
        }
    }

    private void destroyCacheWithRestClient(String cacheName) throws Exception {
        URLConnection conn = new URL("http://localhost:8080/ignite?cmd=destcache&cacheName=" + cacheName).openConnection();
        conn.connect();
        try (InputStreamReader streamReader = new InputStreamReader(conn.getInputStream());){
            ObjectMapper objMapper = new ObjectMapper();
            Map myMap = (Map)objMapper.readValue((Reader)streamReader, (TypeReference)new TypeReference<Map<String, Object>>(){});
            log.info("Version command response is: " + myMap);
            ClientSizeCacheCreationDestructionTest.assertTrue((boolean)myMap.containsKey("response"));
            ClientSizeCacheCreationDestructionTest.assertEquals((Object)0, myMap.get("successStatus"));
        }
    }

    private ClientCacheConfiguration clientCacheConfig() {
        return new ClientCacheConfiguration().setGroupName(CACHE_GROUP_NAME).setName(CACHE_NAME).setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setCacheMode(CacheMode.PARTITIONED);
    }

    private CacheConfiguration cacheConfig() {
        return new CacheConfiguration().setGroupName(CACHE_GROUP_NAME).setName(CACHE_NAME).setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setCacheMode(CacheMode.PARTITIONED);
    }

    private CacheConfiguration cacheConfigWithoutCacheGroup() {
        return new CacheConfiguration().setName(CACHE_NAME).setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setCacheMode(CacheMode.PARTITIONED);
    }
}

