/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.qa.query;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import javax.management.InvalidAttributeValueException;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.query.IndexQuery;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.ClientConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.query.SqlFieldsQueryEx;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.qa.query.WarningOnBigQueryResultsBaseTest;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.testframework.GridTestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assume;
import org.junit.Test;

public class WarningOnBigQueryResultsTest
extends WarningOnBigQueryResultsBaseTest {
    private static final String JDBC_THIN_URL = "jdbc:ignite:thin://127.0.0.1:10850";
    private static final String THIN_CLI_ADDR = "127.0.0.1:10850";
    private static final String JDBC_V2_URL_PREFIX = "jdbc:ignite:cfg://";
    private static final String JDBC_V2_CFG = "modules/clients/src/test/config/jdbc-config.xml";

    protected boolean lazy() {
        return false;
    }

    protected String label() {
        return null;
    }

    @Test
    public void testDisableWarning() throws Exception {
        this.setBigResultThreshold(this.grid(0), 0L, 0);
        this.setBigResultThreshold(this.grid(1), 0L, 0);
        this.setBigResultThreshold(this.grid(2), 0L, 0);
        this.setBigResultThreshold(this.grid(3), 0L, 0);
        WarningOnBigQueryResultsTest.assertEquals((int)2000, (int)this.grid("cli").context().query().querySqlFields(this.sqlFieldsQuery("SELECT * FROM TEST0").setSchema("TEST0"), false).getAll().size());
        WarningOnBigQueryResultsTest.assertEquals((int)0, (int)this.listener((Ignite)this.grid(0)).messageCount());
        WarningOnBigQueryResultsTest.assertEquals((int)0, (int)this.listener((Ignite)this.grid(1)).messageCount());
        WarningOnBigQueryResultsTest.assertEquals((int)0, (int)this.listener((Ignite)this.grid(2)).messageCount());
        WarningOnBigQueryResultsTest.assertEquals((int)0, (int)this.listener((Ignite)this.grid(3)).messageCount());
        WarningOnBigQueryResultsTest.assertEquals((int)2000, (int)this.grid("cli").context().query().querySqlFields(this.sqlFieldsQuery("SELECT * FROM TEST1").setSchema("TEST1"), false).getAll().size());
        WarningOnBigQueryResultsTest.assertEquals((int)0, (int)this.listener((Ignite)this.grid(0)).messageCount());
        WarningOnBigQueryResultsTest.assertEquals((int)0, (int)this.listener((Ignite)this.grid(1)).messageCount());
        WarningOnBigQueryResultsTest.assertEquals((int)0, (int)this.listener((Ignite)this.grid(2)).messageCount());
        WarningOnBigQueryResultsTest.assertEquals((int)0, (int)this.listener((Ignite)this.grid(3)).messageCount());
        this.setBigResultThreshold(this.grid(0), -1L, -1);
        this.setBigResultThreshold(this.grid(1), -1L, -1);
        this.setBigResultThreshold(this.grid(2), -1L, -1);
        this.setBigResultThreshold(this.grid(3), -1L, -1);
        WarningOnBigQueryResultsTest.assertEquals((int)2000, (int)this.grid("cli").context().query().querySqlFields(this.sqlFieldsQuery("SELECT * FROM TEST0").setSchema("TEST0"), false).getAll().size());
        WarningOnBigQueryResultsTest.assertEquals((int)0, (int)this.listener((Ignite)this.grid(0)).messageCount());
        WarningOnBigQueryResultsTest.assertEquals((int)0, (int)this.listener((Ignite)this.grid(1)).messageCount());
        WarningOnBigQueryResultsTest.assertEquals((int)0, (int)this.listener((Ignite)this.grid(2)).messageCount());
        WarningOnBigQueryResultsTest.assertEquals((int)0, (int)this.listener((Ignite)this.grid(3)).messageCount());
        WarningOnBigQueryResultsTest.assertEquals((int)2000, (int)this.grid("cli").context().query().querySqlFields(this.sqlFieldsQuery("SELECT * FROM TEST1").setSchema("TEST1"), false).getAll().size());
        WarningOnBigQueryResultsTest.assertEquals((int)0, (int)this.listener((Ignite)this.grid(0)).messageCount());
        WarningOnBigQueryResultsTest.assertEquals((int)0, (int)this.listener((Ignite)this.grid(1)).messageCount());
        WarningOnBigQueryResultsTest.assertEquals((int)0, (int)this.listener((Ignite)this.grid(2)).messageCount());
        WarningOnBigQueryResultsTest.assertEquals((int)0, (int)this.listener((Ignite)this.grid(3)).messageCount());
    }

    @Test
    public void testQueryCacheTest0() throws Exception {
        WarningOnBigQueryResultsTest.assertEquals((int)2000, (int)this.grid("cli").context().query().querySqlFields(this.sqlFieldsQuery("SELECT * FROM TEST0 ORDER BY val DESC").setSchema("TEST0"), false).getAll().size());
        WarningOnBigQueryResultsTest.assertEquals((int)6, (int)this.listener((Ignite)this.grid("cli")).messageCount());
        WarningOnBigQueryResultsTest.assertEquals(Arrays.asList(10L, 30L, 90L, 270L, 810L, 2000L), this.listener((Ignite)this.grid((String)"cli")).fetched);
        this.checkDurations(this.listener((Ignite)this.grid((String)"cli")).duration);
        WarningOnBigQueryResultsTest.assertEquals((String)"REDUCE", (String)this.listener((Ignite)this.grid((String)"cli")).type);
        WarningOnBigQueryResultsTest.assertEquals((String)"TEST0", (String)this.listener((Ignite)this.grid((String)"cli")).schema);
        WarningOnBigQueryResultsTest.assertEquals((String)this.label(), (String)this.listener((Ignite)this.grid((String)"cli")).label);
        WarningOnBigQueryResultsTest.assertFalse((boolean)this.listener((Ignite)this.grid((String)"cli")).enforceJoinOrder);
        WarningOnBigQueryResultsTest.assertFalse((boolean)this.listener((Ignite)this.grid((String)"cli")).distributedJoin);
        WarningOnBigQueryResultsTest.assertFalse((boolean)this.listener((Ignite)this.grid((String)"cli")).lazy);
        this.checkStateAfterQuery0("TEST0");
    }

    @Test
    public void testQueryInsideCompute() throws Exception {
        final String label = this.label();
        List res = (List)this.grid("cli").compute(this.grid("cli").cluster().forNode(this.grid(0).localNode(), new ClusterNode[0])).call(new IgniteCallable<List<List<?>>>(){
            @IgniteInstanceResource
            Ignite ign;

            public List<List<?>> call() throws Exception {
                return this.ign.cache("test0").query(new SqlFieldsQuery("SELECT * FROM TEST0").setLabel(label).setLazy(WarningOnBigQueryResultsTest.this.lazy())).getAll();
            }
        });
        WarningOnBigQueryResultsTest.assertEquals((int)2000, (int)res.size());
        this.checkStateAfterQuery0("TEST0");
    }

    @Test
    public void testQueryCacheTest1() throws Exception {
        WarningOnBigQueryResultsTest.assertEquals((int)2000, (int)this.grid("cli").context().query().querySqlFields(this.sqlFieldsQuery("SELECT * FROM TEST1").setSchema("TEST1").setEnforceJoinOrder(true), false).getAll().size());
        WarningOnBigQueryResultsTest.assertEquals((int)0, (int)this.listener((Ignite)this.grid(0)).messageCount());
        WarningOnBigQueryResultsTest.assertEquals((int)0, (int)this.listener((Ignite)this.grid(1)).messageCount());
        WarningOnBigQueryResultsTest.assertEquals((int)6, (int)this.listener((Ignite)this.grid(2)).messageCount());
        WarningOnBigQueryResultsTest.assertEquals((int)2, (int)this.listener((Ignite)this.grid(3)).messageCount());
        WarningOnBigQueryResultsTest.assertEquals(Arrays.asList(50L, 100L, 200L, 400L, 800L, 1000L), this.listener((Ignite)this.grid((int)2)).fetched);
        WarningOnBigQueryResultsTest.assertEquals(Arrays.asList(100L, 1000L), this.listener((Ignite)this.grid((int)3)).fetched);
        this.checkDurations(this.listener((Ignite)this.grid((int)2)).duration);
        this.checkDurations(this.listener((Ignite)this.grid((int)3)).duration);
        WarningOnBigQueryResultsTest.assertEquals((String)"MAP", (String)this.listener((Ignite)this.grid((int)2)).type);
        WarningOnBigQueryResultsTest.assertEquals((String)"MAP", (String)this.listener((Ignite)this.grid((int)3)).type);
        WarningOnBigQueryResultsTest.assertEquals((String)"TEST1", (String)this.listener((Ignite)this.grid((int)2)).schema);
        WarningOnBigQueryResultsTest.assertEquals((String)"TEST1", (String)this.listener((Ignite)this.grid((int)3)).schema);
        WarningOnBigQueryResultsTest.assertTrue((boolean)this.listener((Ignite)this.grid((int)2)).enforceJoinOrder);
        WarningOnBigQueryResultsTest.assertTrue((boolean)this.listener((Ignite)this.grid((int)3)).enforceJoinOrder);
        WarningOnBigQueryResultsTest.assertFalse((boolean)this.listener((Ignite)this.grid((int)2)).distributedJoin);
        WarningOnBigQueryResultsTest.assertFalse((boolean)this.listener((Ignite)this.grid((int)3)).distributedJoin);
        WarningOnBigQueryResultsTest.assertEquals((boolean)this.lazy(), (boolean)this.listener((Ignite)this.grid((int)2)).lazy);
        WarningOnBigQueryResultsTest.assertEquals((boolean)this.lazy(), (boolean)this.listener((Ignite)this.grid((int)3)).lazy);
        WarningOnBigQueryResultsTest.assertEquals((String)this.label(), (String)this.listener((Ignite)this.grid((int)2)).label);
        WarningOnBigQueryResultsTest.assertEquals((String)this.label(), (String)this.listener((Ignite)this.grid((int)3)).label);
    }

    @Test
    public void testQueryJdbcThin() throws Exception {
        this.checkJdbc("jdbc:ignite:thin://127.0.0.1:10850/?lazy=" + this.lazy());
    }

    @Test
    public void testQueryJdbcV2() throws Exception {
        this.checkJdbc("jdbc:ignite:cfg://lazy=" + this.lazy() + "@" + JDBC_V2_CFG);
    }

    @Test
    public void testThinClient() {
        try (IgniteClient cli = Ignition.startClient((ClientConfiguration)new ClientConfiguration().setAddresses(new String[]{THIN_CLI_ADDR}));){
            WarningOnBigQueryResultsTest.assertEquals((int)2000, (int)cli.query(this.sqlFieldsQuery("SELECT * FROM TEST0").setSchema("TEST0")).getAll().size());
            this.checkStateAfterQuery0("TEST0");
        }
    }

    @Test
    public void testThinClientIndexQuery() {
        Assume.assumeThat((String)"Lazy mode is not configurable in index queries", (Object)this.lazy(), (Matcher)Matchers.is((Object)SqlFieldsQuery.DFLT_LAZY));
        try (IgniteClient cli = Ignition.startClient((ClientConfiguration)new ClientConfiguration().setAddresses(new String[]{THIN_CLI_ADDR}));){
            List res = cli.cache("test0").query((Query)new IndexQuery(Long.class).setLabel(this.label())).getAll();
            WarningOnBigQueryResultsTest.assertEquals((int)2000, (int)res.size());
            this.checkStateAfterQuery0("TEST0");
        }
    }

    @Test
    public void testJmxAttributesValues() throws Exception {
        GridTestUtils.assertThrows((IgniteLogger)log, () -> {
            GridTestUtils.setJmxAttribute((IgniteEx)this.grid(0), (String)"SQL Query", (String)"SqlQueryMXBeanImpl", (String)"ResultSetSizeThreshold", (Object)"qwer");
            return null;
        }, InvalidAttributeValueException.class, (String)"Invalid value for attribute ResultSetSizeThreshold: qwer");
        GridTestUtils.assertThrows((IgniteLogger)log, () -> {
            GridTestUtils.setJmxAttribute((IgniteEx)this.grid(0), (String)"SQL Query", (String)"SqlQueryMXBeanImpl", (String)"ResultSetSizeThreshold", (Object)123.456);
            return null;
        }, InvalidAttributeValueException.class, (String)"Invalid value for attribute ResultSetSizeThreshold: 123.456");
        GridTestUtils.setJmxAttribute((IgniteEx)this.grid(0), (String)"SQL Query", (String)"SqlQueryMXBeanImpl", (String)"ResultSetSizeThreshold", (Object)-1);
        WarningOnBigQueryResultsTest.assertEquals((Object)-1L, (Object)GridTestUtils.getJmxAttribute((IgniteEx)this.grid(0), (String)"SQL Query", (String)"SqlQueryMXBeanImpl", (String)"ResultSetSizeThreshold"));
        GridTestUtils.setJmxAttribute((IgniteEx)this.grid(0), (String)"SQL Query", (String)"SqlQueryMXBeanImpl", (String)"ResultSetSizeThreshold", (Object)100000000);
        WarningOnBigQueryResultsTest.assertEquals((Object)100000000L, (Object)GridTestUtils.getJmxAttribute((IgniteEx)this.grid(0), (String)"SQL Query", (String)"SqlQueryMXBeanImpl", (String)"ResultSetSizeThreshold"));
        GridTestUtils.assertThrows((IgniteLogger)log, () -> {
            GridTestUtils.setJmxAttribute((IgniteEx)this.grid(0), (String)"SQL Query", (String)"SqlQueryMXBeanImpl", (String)"ResultSetSizeThresholdMultiplier", (Object)"qwer");
            return null;
        }, InvalidAttributeValueException.class, (String)"Invalid value for attribute ResultSetSizeThresholdMultiplier: qwer");
        GridTestUtils.assertThrows((IgniteLogger)log, () -> {
            GridTestUtils.setJmxAttribute((IgniteEx)this.grid(0), (String)"SQL Query", (String)"SqlQueryMXBeanImpl", (String)"ResultSetSizeThresholdMultiplier", (Object)123.456);
            return null;
        }, InvalidAttributeValueException.class, (String)"Invalid value for attribute ResultSetSizeThresholdMultiplier: 123.456");
        GridTestUtils.assertThrows((IgniteLogger)log, () -> {
            GridTestUtils.setJmxAttribute((IgniteEx)this.grid(0), (String)"SQL Query", (String)"SqlQueryMXBeanImpl", (String)"ResultSetSizeThresholdMultiplier", (Object)0.63);
            return null;
        }, InvalidAttributeValueException.class, (String)"Invalid value for attribute ResultSetSizeThresholdMultiplier: 0.63");
        GridTestUtils.setJmxAttribute((IgniteEx)this.grid(0), (String)"SQL Query", (String)"SqlQueryMXBeanImpl", (String)"ResultSetSizeThresholdMultiplier", (Object)100000000);
        WarningOnBigQueryResultsTest.assertEquals((Object)100000000, (Object)GridTestUtils.getJmxAttribute((IgniteEx)this.grid(0), (String)"SQL Query", (String)"SqlQueryMXBeanImpl", (String)"ResultSetSizeThresholdMultiplier"));
    }

    private SqlFieldsQuery sqlFieldsQuery(String sql) {
        return new SqlFieldsQueryEx(sql, Boolean.valueOf(true)).setLazy(this.lazy()).setLabel(this.label());
    }

    void checkJdbc(String url) throws Exception {
        try (Connection c = DriverManager.getConnection(url);
             Statement stmt = c.createStatement();){
            stmt.execute("SELECT * FROM TEST0.TEST0");
            try (ResultSet rs = stmt.getResultSet();){
                int cnt = 0;
                while (rs.next()) {
                    ++cnt;
                }
                WarningOnBigQueryResultsTest.assertEquals((int)2000, (int)cnt);
                this.checkStateAfterQuery0("PUBLIC", false);
            }
        }
    }

    private void checkStateAfterQuery0(String schema) {
        this.checkStateAfterQuery0(schema, true);
    }

    private void checkStateAfterQuery0(String schema, boolean checkLabel) {
        WarningOnBigQueryResultsTest.assertEquals((int)6, (int)this.listener((Ignite)this.grid(0)).messageCount());
        WarningOnBigQueryResultsTest.assertEquals((int)7, (int)this.listener((Ignite)this.grid(1)).messageCount());
        WarningOnBigQueryResultsTest.assertEquals((int)0, (int)this.listener((Ignite)this.grid(2)).messageCount());
        WarningOnBigQueryResultsTest.assertEquals((int)0, (int)this.listener((Ignite)this.grid(3)).messageCount());
        WarningOnBigQueryResultsTest.assertEquals(Arrays.asList(10L, 30L, 90L, 270L, 810L, 1000L), this.listener((Ignite)this.grid((int)0)).fetched);
        WarningOnBigQueryResultsTest.assertEquals(Arrays.asList(25L, 50L, 100L, 200L, 400L, 800L, 1000L), this.listener((Ignite)this.grid((int)1)).fetched);
        this.checkDurations(this.listener((Ignite)this.grid((int)0)).duration);
        this.checkDurations(this.listener((Ignite)this.grid((int)1)).duration);
        WarningOnBigQueryResultsTest.assertEquals((String)"MAP", (String)this.listener((Ignite)this.grid((int)0)).type);
        WarningOnBigQueryResultsTest.assertEquals((String)"MAP", (String)this.listener((Ignite)this.grid((int)1)).type);
        WarningOnBigQueryResultsTest.assertEquals((String)schema, (String)this.listener((Ignite)this.grid((int)0)).schema);
        WarningOnBigQueryResultsTest.assertEquals((String)schema, (String)this.listener((Ignite)this.grid((int)1)).schema);
        WarningOnBigQueryResultsTest.assertFalse((boolean)this.listener((Ignite)this.grid((int)0)).enforceJoinOrder);
        WarningOnBigQueryResultsTest.assertFalse((boolean)this.listener((Ignite)this.grid((int)1)).enforceJoinOrder);
        WarningOnBigQueryResultsTest.assertFalse((boolean)this.listener((Ignite)this.grid((int)0)).distributedJoin);
        WarningOnBigQueryResultsTest.assertFalse((boolean)this.listener((Ignite)this.grid((int)1)).distributedJoin);
        WarningOnBigQueryResultsTest.assertEquals((boolean)this.lazy(), (boolean)this.listener((Ignite)this.grid((int)0)).lazy);
        WarningOnBigQueryResultsTest.assertEquals((boolean)this.lazy(), (boolean)this.listener((Ignite)this.grid((int)1)).lazy);
        if (checkLabel) {
            WarningOnBigQueryResultsTest.assertEquals((String)this.label(), (String)this.listener((Ignite)this.grid((int)0)).label);
            WarningOnBigQueryResultsTest.assertEquals((String)this.label(), (String)this.listener((Ignite)this.grid((int)1)).label);
        }
    }
}

