/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.qa.query;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.ClientConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.util.GridLogThrottle;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.ListeningTestLogger;
import org.apache.ignite.testframework.LogListener;

public class WarningOnBigQueryResultsBaseTest
extends AbstractIndexingCommonTest {
    protected static final int KEYS_PER_NODE = 1000;
    protected static final int CLI_PORT = 10850;
    protected static final String TEST0_ATTR = "TEST0_ATTR";
    protected static final String TEST1_ATTR = "TEST1_ATTR";
    protected static final String CACHE0 = "test0";
    protected static final String CACHE1 = "test1";
    private static final Pattern logPtrn = Pattern.compile("(label=([-\\w]+),)? fetched=([0-9]+), duration=([0-9]+)ms, type=(MAP|LOCAL|REDUCE), distributedJoin=(true|false), enforceJoinOrder=(true|false), lazy=(true|false), schema=(\\S+), sql");
    private static Map<String, BigResultsLogListener> logListeners = new HashMap<String, BigResultsLogListener>();

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName).setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration().setName(CACHE0).setSqlSchema("TEST0").setQueryEntities(Collections.singleton(new QueryEntity(Long.class, Long.class).setTableName(CACHE0).addQueryField("id", Long.class.getName(), null).addQueryField("val", Long.class.getName(), null).setKeyFieldName("id").setValueFieldName("val"))).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 10)).setNodeFilter((IgnitePredicate & Serializable)node -> node.attribute(TEST0_ATTR) != null && (Boolean)node.attribute(TEST0_ATTR) != false), new CacheConfiguration().setName(CACHE1).setSqlSchema("TEST1").setQueryEntities(Collections.singleton(new QueryEntity(Long.class, Long.class).setTableName(CACHE1).addQueryField("id", Long.class.getName(), null).addQueryField("val", Long.class.getName(), null).setKeyFieldName("id").setValueFieldName("val"))).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 10)).setNodeFilter((IgnitePredicate & Serializable)node -> node.attribute(TEST1_ATTR) != null && (Boolean)node.attribute(TEST1_ATTR) != false)});
        if (igniteInstanceName.startsWith("cli")) {
            cfg.setClientMode(true).setClientConnectorConfiguration(new ClientConnectorConfiguration().setPort(10850));
        } else {
            cfg.setUserAttributes(Collections.singletonMap(this.getTestIgniteInstanceIndex(igniteInstanceName) < 2 ? TEST0_ATTR : TEST1_ATTR, true));
        }
        ListeningTestLogger testLog = new ListeningTestLogger(false, log);
        BigResultsLogListener lst = new BigResultsLogListener();
        testLog.registerListener((LogListener)lst);
        logListeners.put(igniteInstanceName, lst);
        cfg.setGridLogger((IgniteLogger)new ListeningTestLogger(false, (IgniteLogger)testLog));
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        int k;
        Iterator iterator;
        List keys;
        int i;
        super.beforeTestsStarted();
        GridLogThrottle.throttleTimeout((int)-1);
        this.startGrid(0);
        this.startGrid("cli");
        this.startGrid(1);
        this.startGrid(2);
        this.startGrid(3);
        this.awaitPartitionMapExchange();
        for (i = 0; i < 2; ++i) {
            keys = this.primaryKeys(this.grid(i).cache(CACHE0), 1000, 0);
            WarningOnBigQueryResultsBaseTest.assertEquals((int)1000, (int)keys.size());
            iterator = keys.iterator();
            while (iterator.hasNext()) {
                k = (Integer)iterator.next();
                this.grid(i).cache(CACHE0).put((Object)k, (Object)k);
            }
        }
        for (i = 2; i < 4; ++i) {
            keys = this.primaryKeys(this.grid(i).cache(CACHE1), 1000, 0);
            WarningOnBigQueryResultsBaseTest.assertEquals((int)1000, (int)keys.size());
            iterator = keys.iterator();
            while (iterator.hasNext()) {
                k = (Integer)iterator.next();
                this.grid(i).cache(CACHE1).put((Object)k, (Object)k);
            }
        }
    }

    protected void afterTestsStopped() throws Exception {
        this.stopAllGrids();
        GridLogThrottle.throttleTimeout((int)300000);
        super.afterTestsStopped();
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.setBigResultThreshold(this.grid("cli"), 10L, 3);
        this.setBigResultThreshold(this.grid(0), 10L, 3);
        this.setBigResultThreshold(this.grid(1), 25L, 2);
        this.setBigResultThreshold(this.grid(2), 50L, 2);
        this.setBigResultThreshold(this.grid(3), 100L, 1);
        logListeners.values().forEach(BigResultsLogListener::reset);
    }

    protected void setBigResultThreshold(IgniteEx node, long threshold, int thresholdMult) throws Exception {
        GridTestUtils.setJmxAttribute((IgniteEx)node, (String)"SQL Query", (String)"SqlQueryMXBeanImpl", (String)"ResultSetSizeThreshold", (Object)threshold);
        GridTestUtils.setJmxAttribute((IgniteEx)node, (String)"SQL Query", (String)"SqlQueryMXBeanImpl", (String)"ResultSetSizeThresholdMultiplier", (Object)thresholdMult);
    }

    protected void checkDurations(List<Long> durations) {
        WarningOnBigQueryResultsBaseTest.assertFalse((boolean)F.isEmpty(durations));
        WarningOnBigQueryResultsBaseTest.assertTrue((String)("Invalid durations: " + durations), (durations.get(0) >= 0L ? 1 : 0) != 0);
        for (int i = 0; i < durations.size() - 1; ++i) {
            WarningOnBigQueryResultsBaseTest.assertTrue((String)("Invalid durations: " + durations), (durations.get(i + 1) >= 0L ? 1 : 0) != 0);
            WarningOnBigQueryResultsBaseTest.assertTrue((String)("Invalid durations: " + durations), (durations.get(i) <= durations.get(i + 1) ? 1 : 0) != 0);
        }
    }

    protected BigResultsLogListener listener(Ignite node) {
        assert (logListeners.get(node.name()) != null);
        return logListeners.get(node.name());
    }

    public static class BigResultsLogListener
    extends LogListener {
        ArrayList<Long> fetched = new ArrayList();
        ArrayList<Long> duration = new ArrayList();
        String label;
        boolean lazy;
        boolean enforceJoinOrder;
        boolean distributedJoin;
        String type;
        String schema;
        String sql;
        String plan;

        public boolean check() {
            return this.messageCount() > 0;
        }

        public void reset() {
            this.duration.clear();
            this.fetched.clear();
        }

        public void accept(String s) {
            if (s.contains("Query produced big result set")) {
                Matcher m = logPtrn.matcher(s);
                WarningOnBigQueryResultsBaseTest.assertTrue((boolean)m.find());
                int idx = 2;
                this.label = m.group(idx++);
                this.fetched.add(Long.parseLong(m.group(idx++)));
                this.duration.add(Long.parseLong(m.group(idx++)));
                this.type = m.group(idx++);
                this.distributedJoin = Boolean.parseBoolean(m.group(idx++));
                this.enforceJoinOrder = Boolean.parseBoolean(m.group(idx++));
                this.lazy = Boolean.parseBoolean(m.group(idx++));
                this.schema = m.group(idx++);
                this.sql = s.substring(s.indexOf(", sql='") + 7, s.indexOf("', plan="));
                this.plan = s.substring(s.indexOf("', plan=") + 8, s.indexOf(", reqId="));
                WarningOnBigQueryResultsBaseTest.assertTrue((boolean)this.sql.contains("SELECT"));
                WarningOnBigQueryResultsBaseTest.assertTrue((boolean)this.plan.contains("SELECT"));
            }
        }

        public int messageCount() {
            return this.fetched.size();
        }
    }
}

