/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc.thin;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.processors.query.NestedTxMode;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.jdbc.thin.JdbcThinAbstractSelfTest;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.testframework.GridStringLogger;
import org.apache.ignite.testframework.GridTestUtils;
import org.jetbrains.annotations.NotNull;
import org.junit.Test;

public class JdbcThinTransactionsWithMvccEnabledSelfTest
extends JdbcThinAbstractSelfTest {
    private static final String URL = "jdbc:ignite:thin://127.0.0.1";
    private GridStringLogger log;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setCacheConfiguration(new CacheConfiguration[]{this.cacheConfiguration("default").setNearConfiguration(null)});
        cfg.setMarshaller((Marshaller)new BinaryMarshaller());
        this.log = new GridStringLogger();
        cfg.setGridLogger((IgniteLogger)this.log);
        return cfg;
    }

    private CacheConfiguration cacheConfiguration(@NotNull String name) {
        CacheConfiguration cfg = JdbcThinTransactionsWithMvccEnabledSelfTest.defaultCacheConfiguration();
        cfg.setName(name);
        cfg.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT);
        return cfg;
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.startGrid(0);
        try (Connection c = JdbcThinTransactionsWithMvccEnabledSelfTest.c(true, NestedTxMode.ERROR);
             Statement s = c.createStatement();){
            s.execute("CREATE TABLE INTS (k int primary key, v int) WITH \"cache_name=ints,wrap_value=false,atomicity=transactional_snapshot\"");
        }
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
    }

    private static Connection c(boolean autoCommit, NestedTxMode nestedTxMode) throws SQLException {
        Connection res = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1/?nestedTransactionsMode=" + nestedTxMode.name());
        res.setAutoCommit(autoCommit);
        return res;
    }

    @Test
    public void testTransactionsBeginCommitRollback() throws IgniteCheckedException {
        final AtomicBoolean stop = new AtomicBoolean();
        IgniteInternalFuture fut = GridTestUtils.runMultiThreadedAsync((Runnable)new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                try (Connection c = JdbcThinTransactionsWithMvccEnabledSelfTest.c(false, NestedTxMode.ERROR);){
                    while (!stop.get()) {
                        Statement s;
                        block24: {
                            s = c.createStatement();
                            Throwable throwable = null;
                            try {
                                s.execute("BEGIN");
                                c.commit();
                                s.execute("BEGIN");
                                c.rollback();
                                if (s == null) continue;
                                if (throwable == null) break block24;
                            }
                            catch (Throwable throwable2) {
                                try {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                catch (Throwable throwable3) {
                                    if (s == null) throw throwable3;
                                    if (throwable != null) {
                                        try {
                                            s.close();
                                            throw throwable3;
                                        }
                                        catch (Throwable throwable4) {
                                            throwable.addSuppressed(throwable4);
                                            throw throwable3;
                                        }
                                    }
                                    s.close();
                                    throw throwable3;
                                }
                            }
                            try {
                                s.close();
                                continue;
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                                continue;
                            }
                        }
                        s.close();
                    }
                    return;
                }
                catch (SQLException e) {
                    throw new AssertionError((Object)e);
                }
            }
        }, (int)8, (String)"jdbc-transactions");
        U.sleep((long)5000L);
        stop.set(true);
        fut.get();
    }

    @Test
    public void testTransactionsBeginCommitRollbackAutocommit() throws IgniteCheckedException {
        GridTestUtils.runMultiThreadedAsync((Runnable)new Runnable(){

            @Override
            public void run() {
                try (Connection c = JdbcThinTransactionsWithMvccEnabledSelfTest.c(true, NestedTxMode.ERROR);
                     Statement s = c.createStatement();){
                    s.execute("BEGIN");
                    s.execute("COMMIT");
                    s.execute("BEGIN");
                    s.execute("ROLLBACK");
                }
                catch (SQLException e) {
                    throw new AssertionError((Object)e);
                }
            }
        }, (int)8, (String)"jdbc-transactions").get();
    }

    @Test
    public void testIgnoreNestedTxAutocommitOff() throws SQLException {
        try (Connection c = JdbcThinTransactionsWithMvccEnabledSelfTest.c(false, NestedTxMode.IGNORE);){
            this.doNestedTxStart(c, false);
        }
        JdbcThinTransactionsWithMvccEnabledSelfTest.assertTrue((boolean)this.log.toString().contains("ignoring BEGIN command"));
    }

    @Test
    public void testCommitNestedTxAutocommitOff() throws SQLException {
        try (Connection c = JdbcThinTransactionsWithMvccEnabledSelfTest.c(false, NestedTxMode.COMMIT);){
            this.doNestedTxStart(c, false);
        }
        JdbcThinTransactionsWithMvccEnabledSelfTest.assertFalse((boolean)this.log.toString().contains("ignoring BEGIN command"));
    }

    @Test
    public void testErrorNestedTxAutocommitOff() {
        GridTestUtils.assertThrows(null, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try (Connection c = JdbcThinTransactionsWithMvccEnabledSelfTest.c(false, NestedTxMode.ERROR);){
                    JdbcThinTransactionsWithMvccEnabledSelfTest.this.doNestedTxStart(c, false);
                }
                throw new AssertionError();
            }
        }, SQLException.class, (String)"Transaction has already been started.");
    }

    @Test
    public void testIgnoreNestedTxAutocommitOn() throws SQLException {
        try (Connection c = JdbcThinTransactionsWithMvccEnabledSelfTest.c(true, NestedTxMode.IGNORE);){
            this.doNestedTxStart(c, false);
        }
        JdbcThinTransactionsWithMvccEnabledSelfTest.assertTrue((boolean)this.log.toString().contains("ignoring BEGIN command"));
    }

    @Test
    public void testCommitNestedTxAutocommitOn() throws SQLException {
        try (Connection c = JdbcThinTransactionsWithMvccEnabledSelfTest.c(true, NestedTxMode.COMMIT);){
            this.doNestedTxStart(c, false);
        }
        JdbcThinTransactionsWithMvccEnabledSelfTest.assertFalse((boolean)this.log.toString().contains("ignoring BEGIN command"));
    }

    @Test
    public void testErrorNestedTxAutocommitOn() {
        GridTestUtils.assertThrows(null, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try (Connection c = JdbcThinTransactionsWithMvccEnabledSelfTest.c(true, NestedTxMode.ERROR);){
                    JdbcThinTransactionsWithMvccEnabledSelfTest.this.doNestedTxStart(c, false);
                }
                throw new AssertionError();
            }
        }, SQLException.class, (String)"Transaction has already been started.");
    }

    @Test
    public void testIgnoreNestedTxAutocommitOffBatched() throws SQLException {
        try (Connection c = JdbcThinTransactionsWithMvccEnabledSelfTest.c(false, NestedTxMode.IGNORE);){
            this.doNestedTxStart(c, true);
        }
        JdbcThinTransactionsWithMvccEnabledSelfTest.assertTrue((boolean)this.log.toString().contains("ignoring BEGIN command"));
    }

    @Test
    public void testCommitNestedTxAutocommitOffBatched() throws SQLException {
        try (Connection c = JdbcThinTransactionsWithMvccEnabledSelfTest.c(false, NestedTxMode.COMMIT);){
            this.doNestedTxStart(c, true);
        }
        JdbcThinTransactionsWithMvccEnabledSelfTest.assertFalse((boolean)this.log.toString().contains("ignoring BEGIN command"));
    }

    @Test
    public void testErrorNestedTxAutocommitOffBatched() {
        GridTestUtils.assertThrows(null, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try (Connection c = JdbcThinTransactionsWithMvccEnabledSelfTest.c(false, NestedTxMode.ERROR);){
                    JdbcThinTransactionsWithMvccEnabledSelfTest.this.doNestedTxStart(c, true);
                }
                throw new AssertionError();
            }
        }, BatchUpdateException.class, (String)"Transaction has already been started.");
    }

    @Test
    public void testIgnoreNestedTxAutocommitOnBatched() throws SQLException {
        try (Connection c = JdbcThinTransactionsWithMvccEnabledSelfTest.c(true, NestedTxMode.IGNORE);){
            this.doNestedTxStart(c, true);
        }
        JdbcThinTransactionsWithMvccEnabledSelfTest.assertTrue((boolean)this.log.toString().contains("ignoring BEGIN command"));
    }

    @Test
    public void testCommitNestedTxAutocommitOnBatched() throws SQLException {
        try (Connection c = JdbcThinTransactionsWithMvccEnabledSelfTest.c(true, NestedTxMode.COMMIT);){
            this.doNestedTxStart(c, true);
        }
        JdbcThinTransactionsWithMvccEnabledSelfTest.assertFalse((boolean)this.log.toString().contains("ignoring BEGIN command"));
    }

    @Test
    public void testErrorNestedTxAutocommitOnBatched() {
        GridTestUtils.assertThrows(null, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try (Connection c = JdbcThinTransactionsWithMvccEnabledSelfTest.c(true, NestedTxMode.ERROR);){
                    JdbcThinTransactionsWithMvccEnabledSelfTest.this.doNestedTxStart(c, true);
                }
                throw new AssertionError();
            }
        }, BatchUpdateException.class, (String)"Transaction has already been started.");
    }

    private void doNestedTxStart(Connection conn, boolean batched) throws SQLException {
        try (Statement s = conn.createStatement();){
            s.executeQuery("SELECT * FROM INTS");
            if (batched) {
                s.addBatch("BEGIN");
                s.addBatch("BEGIN");
                s.executeBatch();
            } else {
                s.execute("BEGIN");
                s.execute("BEGIN");
            }
        }
    }

    @Test
    public void testAutoCommitSingle() throws SQLException {
        this.doTestAutoCommit(false);
    }

    @Test
    public void testAutoCommitBatched() throws SQLException {
        this.doTestAutoCommit(true);
    }

    private void doTestAutoCommit(boolean batched) throws SQLException {
        IgniteCache cache = this.grid(0).cache("ints");
        try (Connection c = JdbcThinTransactionsWithMvccEnabledSelfTest.c(false, NestedTxMode.ERROR);
             Statement s = c.createStatement();){
            JdbcThinTransactionsWithMvccEnabledSelfTest.assertFalse((boolean)s.executeQuery("SELECT * from INTS").next());
            if (batched) {
                s.addBatch("INSERT INTO INTS(k, v) values(1, 1)");
                s.executeBatch();
            } else {
                s.execute("INSERT INTO INTS(k, v) values(1, 1)");
            }
            JdbcThinTransactionsWithMvccEnabledSelfTest.assertTrue((boolean)cache.query(new SqlFieldsQuery("SELECT * from INTS")).getAll().isEmpty());
            JdbcThinTransactionsWithMvccEnabledSelfTest.assertTrue((boolean)s.executeQuery("SELECT * from INTS").next());
            c.commit();
            c.setAutoCommit(true);
            JdbcThinTransactionsWithMvccEnabledSelfTest.assertEquals((Object)1, (Object)cache.get((Object)1));
            JdbcThinTransactionsWithMvccEnabledSelfTest.assertTrue((boolean)s.executeQuery("SELECT * from INTS").next());
        }
    }

    @Test
    public void testExceptionHandling() throws SQLException {
        try (Connection c = JdbcThinTransactionsWithMvccEnabledSelfTest.c(true, NestedTxMode.ERROR);
             final Statement s = c.createStatement();){
            s.execute("INSERT INTO INTS(k, v) values(1, 1)");
            JdbcThinTransactionsWithMvccEnabledSelfTest.assertEquals((Object)1, (Object)this.grid(0).cache("ints").get((Object)1));
            GridTestUtils.assertThrows(null, (Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    s.execute("INSERT INTO INTS(x, y) values(1, 1)");
                    return null;
                }
            }, SQLException.class, (String)"Failed to parse query");
            s.execute("INSERT INTO INTS(k, v) values(2, 2)");
            JdbcThinTransactionsWithMvccEnabledSelfTest.assertEquals((Object)2, (Object)this.grid(0).cache("ints").get((Object)2));
        }
    }
}

