/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc.thin;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.jdbc.thin.JdbcThinAbstractSelfTest;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class JdbcThinSystemSchemaAbstractTest
extends JdbcThinAbstractSelfTest {
    protected static final String BASE_URL = "jdbc:ignite:thin://127.0.0.1/";
    protected Connection conn;

    protected abstract String expectedSysSchemaName();

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        GridTestUtils.setFieldValue(QueryUtils.class, (String)"schemaSys", null);
        this.startGrid(0);
    }

    @Before
    public void init() throws SQLException {
        this.conn = DriverManager.getConnection(this.getUrl());
    }

    @After
    public void tearDown() throws SQLException {
        if (this.conn != null && !this.conn.isClosed()) {
            this.conn.close();
        }
    }

    protected String getUrl() {
        return BASE_URL;
    }

    @Test
    public void testSysSchema() throws Exception {
        String schemaName = "SYS";
        if ("SYS".equals(this.expectedSysSchemaName())) {
            this.verifyNodesView("SYS");
        } else {
            GridTestUtils.assertThrows((IgniteLogger)log, () -> this.verifyNodesView("SYS"), IgniteException.class, (String)"Failed to parse query. Schema \"SYS\" not found;");
        }
    }

    @Test
    public void testIgniteSchema() throws SQLException {
        String schemaName = "IGNITE";
        if ("IGNITE".equals(this.expectedSysSchemaName())) {
            this.verifyNodesView("IGNITE");
        } else {
            GridTestUtils.assertThrows((IgniteLogger)log, () -> this.verifyNodesView("IGNITE"), IgniteException.class, (String)"Failed to parse query. Schema \"IGNITE\" not found;");
        }
    }

    private void verifyNodesView(String schema) throws SQLException {
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT NODE_ID FROM " + schema + ".nodes");
        HashSet<String> act = new HashSet<String>();
        while (rs.next()) {
            act.add(rs.getString(1));
        }
        Set exp = G.allGrids().stream().map(iEx -> ((IgniteEx)iEx).localNode().id().toString()).collect(Collectors.toSet());
        Assert.assertEquals(exp, act);
    }
}

