/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc.thin;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.failure.FailureHandler;
import org.apache.ignite.failure.TestFailureHandler;
import org.apache.ignite.internal.processors.query.h2.H2LocalResultFactory;
import org.apache.ignite.jdbc.thin.JdbcThinAbstractSelfTest;
import org.apache.ignite.testframework.GridTestUtils;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.result.LocalResult;
import org.junit.Test;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class JdbcThinDatabaseFailureTest
extends JdbcThinAbstractSelfTest {
    private static volatile boolean criticalDbFail;
    private TestFailureHandler fHnd;
    private boolean fakeLocalFactory;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        if (this.fakeLocalFactory) {
            System.setProperty("IGNITE_H2_LOCAL_RESULT_FACTORY", TestH2LocalResultFactory.class.getName());
        }
        return super.getConfiguration(igniteInstanceName);
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        System.clearProperty("IGNITE_H2_LOCAL_RESULT_FACTORY");
        super.afterTest();
    }

    protected FailureHandler getFailureHandler(String igniteInstanceName) {
        this.fHnd = new TestFailureHandler(false);
        return this.fHnd;
    }

    @Test
    public void fhTriggersIfH2DbIsDown() throws Exception {
        this.fakeLocalFactory = true;
        this.startGrid(1);
        Connection conn = this.createConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("create table t1 (k1 int primary key, k2 int)");
        String sql = "select * from t1";
        GridTestUtils.assertThrows((IgniteLogger)log, () -> {
            criticalDbFail = true;
            Statement stmt1 = conn.createStatement();
            stmt1.execute(sql);
            stmt1.getResultSet();
        }, IgniteException.class, (String)"Critical database error");
        Throwable err = this.fHnd.failureContext().error();
        String msg = err.getMessage();
        JdbcThinDatabaseFailureTest.assertTrue((boolean)msg.contains("The database has been closed"));
    }

    protected Connection createConnection() throws SQLException {
        return DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1");
    }

    public static class TestH2LocalResultFactory
    extends H2LocalResultFactory {
        public LocalResult create(Session ses, Expression[] expressions, int visibleColCnt, boolean system) {
            if (criticalDbFail) {
                ses.setPowerOffCount(1);
            }
            return super.create(ses, expressions, visibleColCnt, system);
        }

        public LocalResult create() {
            throw new NotImplementedException();
        }
    }
}

