/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc.thin;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.concurrent.Callable;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.jdbc.thin.JdbcThinAbstractSelfTest;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.testframework.GridStringLogger;
import org.apache.ignite.testframework.GridTestUtils;
import org.jetbrains.annotations.NotNull;
import org.junit.Test;

public class JdbcThinConnectionMvccEnabledSelfTest
extends JdbcThinAbstractSelfTest {
    private static final String URL = "jdbc:ignite:thin://127.0.0.1";

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setCacheConfiguration(new CacheConfiguration[]{this.cacheConfiguration("default").setNearConfiguration(null)});
        cfg.setMarshaller((Marshaller)new BinaryMarshaller());
        cfg.setGridLogger((IgniteLogger)new GridStringLogger());
        return cfg;
    }

    private CacheConfiguration cacheConfiguration(@NotNull String name) {
        CacheConfiguration cfg = JdbcThinConnectionMvccEnabledSelfTest.defaultCacheConfiguration();
        cfg.setName(name);
        cfg.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT);
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGridsMultiThreaded(2);
    }

    @Test
    public void testMetadataDefaults() throws Exception {
        try (Connection conn = DriverManager.getConnection(URL);){
            DatabaseMetaData meta = conn.getMetaData();
            JdbcThinConnectionMvccEnabledSelfTest.assertEquals((int)4, (int)meta.getDefaultTransactionIsolation());
            JdbcThinConnectionMvccEnabledSelfTest.assertTrue((boolean)meta.supportsTransactions());
            JdbcThinConnectionMvccEnabledSelfTest.assertFalse((boolean)meta.supportsTransactionIsolationLevel(0));
            JdbcThinConnectionMvccEnabledSelfTest.assertFalse((boolean)meta.supportsTransactionIsolationLevel(1));
            JdbcThinConnectionMvccEnabledSelfTest.assertFalse((boolean)meta.supportsTransactionIsolationLevel(2));
            JdbcThinConnectionMvccEnabledSelfTest.assertTrue((boolean)meta.supportsTransactionIsolationLevel(4));
            JdbcThinConnectionMvccEnabledSelfTest.assertFalse((boolean)meta.supportsTransactionIsolationLevel(8));
        }
    }

    @Test
    public void testGetSetAutoCommit() throws Exception {
        try (final Connection conn = DriverManager.getConnection(URL);){
            JdbcThinConnectionMvccEnabledSelfTest.assertTrue((boolean)conn.getMetaData().supportsTransactions());
            JdbcThinConnectionMvccEnabledSelfTest.assertTrue((boolean)conn.getAutoCommit());
            conn.setAutoCommit(false);
            JdbcThinConnectionMvccEnabledSelfTest.assertFalse((boolean)conn.getAutoCommit());
            conn.setAutoCommit(true);
            JdbcThinConnectionMvccEnabledSelfTest.assertTrue((boolean)conn.getAutoCommit());
            conn.close();
            this.checkConnectionClosed(new GridTestUtils.RunnableX(){

                public void runx() throws Exception {
                    conn.setAutoCommit(true);
                }
            });
        }
    }

    @Test
    public void testCommit() throws Exception {
        try (final Connection conn = DriverManager.getConnection(URL);){
            JdbcThinConnectionMvccEnabledSelfTest.assertTrue((boolean)conn.getMetaData().supportsTransactions());
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    conn.commit();
                    return null;
                }
            }, SQLException.class, (String)"Transaction cannot be committed explicitly in auto-commit mode");
            conn.setAutoCommit(false);
            conn.commit();
            conn.close();
            this.checkConnectionClosed(new GridTestUtils.RunnableX(){

                public void runx() throws Exception {
                    conn.commit();
                }
            });
        }
    }

    @Test
    public void testRollback() throws Exception {
        try (final Connection conn = DriverManager.getConnection(URL);){
            JdbcThinConnectionMvccEnabledSelfTest.assertTrue((boolean)conn.getMetaData().supportsTransactions());
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    conn.rollback();
                    return null;
                }
            }, SQLException.class, (String)"Transaction cannot be rolled back explicitly in auto-commit mode.");
            conn.setAutoCommit(false);
            conn.rollback();
            conn.close();
            this.checkConnectionClosed(new GridTestUtils.RunnableX(){

                public void runx() throws Exception {
                    conn.rollback();
                }
            });
        }
    }

    @Test
    public void testSetSavepoint() throws Exception {
        try (final Connection conn = DriverManager.getConnection(URL);){
            assert (!conn.getMetaData().supportsSavepoints());
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    conn.setSavepoint();
                    return null;
                }
            }, SQLException.class, (String)"Savepoint cannot be set in auto-commit mode");
            conn.setAutoCommit(false);
            this.checkNotSupported(new GridTestUtils.RunnableX(){

                public void runx() throws Exception {
                    conn.setSavepoint();
                }
            });
            conn.close();
            this.checkConnectionClosed(new GridTestUtils.RunnableX(){

                public void runx() throws Exception {
                    conn.setSavepoint();
                }
            });
        }
    }

    @Test
    public void testSetSavepointName() throws Exception {
        try (final Connection conn = DriverManager.getConnection(URL);){
            assert (!conn.getMetaData().supportsSavepoints());
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    conn.setSavepoint(null);
                    return null;
                }
            }, SQLException.class, (String)"Savepoint name cannot be null");
            String name = "savepoint";
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    conn.setSavepoint("savepoint");
                    return null;
                }
            }, SQLException.class, (String)"Savepoint cannot be set in auto-commit mode");
            conn.setAutoCommit(false);
            this.checkNotSupported(new GridTestUtils.RunnableX(){

                public void runx() throws Exception {
                    conn.setSavepoint("savepoint");
                }
            });
            conn.close();
            this.checkConnectionClosed(new GridTestUtils.RunnableX(){

                public void runx() throws Exception {
                    conn.setSavepoint("savepoint");
                }
            });
        }
    }

    @Test
    public void testRollbackSavePoint() throws Exception {
        try (final Connection conn = DriverManager.getConnection(URL);){
            assert (!conn.getMetaData().supportsSavepoints());
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    conn.rollback(null);
                    return null;
                }
            }, SQLException.class, (String)"Invalid savepoint");
            final Savepoint savepoint = this.getFakeSavepoint();
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    conn.rollback(savepoint);
                    return null;
                }
            }, SQLException.class, (String)"Auto-commit mode");
            conn.setAutoCommit(false);
            this.checkNotSupported(new GridTestUtils.RunnableX(){

                public void runx() throws Exception {
                    conn.rollback(savepoint);
                }
            });
            conn.close();
            this.checkConnectionClosed(new GridTestUtils.RunnableX(){

                public void runx() throws Exception {
                    conn.rollback(savepoint);
                }
            });
        }
    }

    private Savepoint getFakeSavepoint() {
        return new Savepoint(){

            @Override
            public int getSavepointId() throws SQLException {
                return 100;
            }

            @Override
            public String getSavepointName() {
                return "savepoint";
            }
        };
    }
}

