/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class JdbcStatementSelfTest
extends GridCommonAbstractTest {
    private static final String URL = "jdbc:ignite://127.0.0.1/";
    private static final String SQL = "select * from Person where age > 30";
    private Connection conn;
    private Statement stmt;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        CacheConfiguration cache = JdbcStatementSelfTest.defaultCacheConfiguration();
        cache.setCacheMode(CacheMode.PARTITIONED);
        cache.setBackups(1);
        cache.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        cache.setIndexedTypes(new Class[]{String.class, Person.class});
        cfg.setCacheConfiguration(new CacheConfiguration[]{cache});
        cfg.setConnectorConfiguration(new ConnectorConfiguration());
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        this.startGridsMultiThreaded(3);
        IgniteCache cache = this.grid(0).cache("default");
        assert (cache != null);
        cache.put((Object)"p1", (Object)new Person(1, "John", "White", 25));
        cache.put((Object)"p2", (Object)new Person(2, "Joe", "Black", 35));
        cache.put((Object)"p3", (Object)new Person(3, "Mike", "Green", 40));
    }

    protected void beforeTest() throws Exception {
        this.conn = DriverManager.getConnection(URL);
        this.stmt = this.conn.createStatement();
        assert (this.stmt != null);
        assert (!this.stmt.isClosed());
    }

    protected void afterTest() throws Exception {
        if (this.stmt != null && !this.stmt.isClosed()) {
            this.stmt.close();
        }
        this.conn.close();
        assert (this.stmt.isClosed());
        assert (this.conn.isClosed());
    }

    @Test
    public void testExecuteQuery() throws Exception {
        ResultSet rs = this.stmt.executeQuery(SQL);
        assert (rs != null);
        int cnt = 0;
        while (rs.next()) {
            int id = rs.getInt("id");
            if (id == 2) {
                assert ("Joe".equals(rs.getString("firstName")));
                assert ("Black".equals(rs.getString("lastName")));
                assert (rs.getInt("age") == 35);
            } else if (id == 3) {
                assert ("Mike".equals(rs.getString("firstName")));
                assert ("Green".equals(rs.getString("lastName")));
                assert (rs.getInt("age") == 40);
            } else assert (false) : "Wrong ID: " + id;
            ++cnt;
        }
        assert (cnt == 2);
    }

    @Test
    public void testExecute() throws Exception {
        assert (this.stmt.execute(SQL));
        ResultSet rs = this.stmt.getResultSet();
        assert (rs != null);
        assert (this.stmt.getResultSet() == null);
        int cnt = 0;
        while (rs.next()) {
            int id = rs.getInt("id");
            if (id == 2) {
                assert ("Joe".equals(rs.getString("firstName")));
                assert ("Black".equals(rs.getString("lastName")));
                assert (rs.getInt("age") == 35);
            } else if (id == 3) {
                assert ("Mike".equals(rs.getString("firstName")));
                assert ("Green".equals(rs.getString("lastName")));
                assert (rs.getInt("age") == 40);
            } else assert (false) : "Wrong ID: " + id;
            ++cnt;
        }
        assert (cnt == 2);
    }

    @Test
    public void testMaxRows() throws Exception {
        int id;
        this.stmt.setMaxRows(1);
        ResultSet rs = this.stmt.executeQuery(SQL);
        assert (rs != null);
        int cnt = 0;
        while (rs.next()) {
            id = rs.getInt("id");
            if (id == 2) {
                assert ("Joe".equals(rs.getString("firstName")));
                assert ("Black".equals(rs.getString("lastName")));
                assert (rs.getInt("age") == 35);
            } else if (id == 3) {
                assert ("Mike".equals(rs.getString("firstName")));
                assert ("Green".equals(rs.getString("lastName")));
                assert (rs.getInt("age") == 40);
            } else assert (false) : "Wrong ID: " + id;
            ++cnt;
        }
        assert (cnt == 1);
        this.stmt.setMaxRows(0);
        rs = this.stmt.executeQuery(SQL);
        assert (rs != null);
        cnt = 0;
        while (rs.next()) {
            id = rs.getInt("id");
            if (id == 2) {
                assert ("Joe".equals(rs.getString("firstName")));
                assert ("Black".equals(rs.getString("lastName")));
                assert (rs.getInt("age") == 35);
            } else if (id == 3) {
                assert ("Mike".equals(rs.getString("firstName")));
                assert ("Green".equals(rs.getString("lastName")));
                assert (rs.getInt("age") == 40);
            } else assert (false) : "Wrong ID: " + id;
            ++cnt;
        }
        assert (cnt == 2);
    }

    private static class Person
    implements Serializable {
        @QuerySqlField
        private final int id;
        @QuerySqlField(index=false)
        private final String firstName;
        @QuerySqlField(index=false)
        private final String lastName;
        @QuerySqlField
        private final int age;

        private Person(int id, String firstName, String lastName, int age) {
            assert (!F.isEmpty((String)firstName));
            assert (!F.isEmpty((String)lastName));
            assert (age > 0);
            this.id = id;
            this.firstName = firstName;
            this.lastName = lastName;
            this.age = age;
        }
    }
}

