/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.apache.ignite.IgniteBinary;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

public class JdbcResultSetSelfTest
extends GridCommonAbstractTest {
    private static final String URL = "jdbc:ignite://127.0.0.1/";
    private static final String SQL = "select id, boolVal, byteVal, shortVal, intVal, longVal, floatVal, doubleVal, bigVal, strVal, arrVal, dateVal, timeVal, tsVal, urlVal, f1, f2, f3, _val from TestObject where id = 1";
    private Statement stmt;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        CacheConfiguration cache = JdbcResultSetSelfTest.defaultCacheConfiguration();
        cache.setCacheMode(CacheMode.PARTITIONED);
        cache.setBackups(1);
        cache.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        cache.setIndexedTypes(new Class[]{Integer.class, TestObject.class});
        cfg.setCacheConfiguration(new CacheConfiguration[]{cache});
        cfg.setConnectorConfiguration(new ConnectorConfiguration());
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        this.startGridsMultiThreaded(3);
        IgniteCache cache = this.grid(0).cache("default");
        assert (cache != null);
        TestObject o = this.createObjectWithData(1);
        cache.put((Object)1, (Object)o);
        cache.put((Object)2, (Object)new TestObject(2));
    }

    protected void beforeTest() throws Exception {
        this.stmt = DriverManager.getConnection(URL).createStatement();
        assert (this.stmt != null);
        assert (!this.stmt.isClosed());
    }

    protected void afterTest() throws Exception {
        if (this.stmt != null) {
            this.stmt.getConnection().close();
            this.stmt.close();
            assert (this.stmt.isClosed());
        }
    }

    private TestObject createObjectWithData(int id) throws MalformedURLException {
        TestObject o = new TestObject(id);
        o.boolVal = true;
        o.byteVal = (byte)1;
        o.shortVal = (short)1;
        o.intVal = 1;
        o.longVal = 1L;
        o.floatVal = Float.valueOf(1.0f);
        o.doubleVal = 1.0;
        o.bigVal = new BigDecimal(1);
        o.strVal = "str";
        TestObject.access$1002(o, new byte[]{1});
        o.dateVal = new Date(1, 1, 1);
        o.timeVal = new Time(1, 1, 1);
        o.tsVal = new Timestamp(1L);
        o.urlVal = new URL("http://abc.com/");
        return o;
    }

    @Test
    public void testBoolean() throws Exception {
        ResultSet rs = this.stmt.executeQuery(SQL);
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) {
                assert (rs.getBoolean("boolVal"));
                assert (rs.getBoolean(2));
            }
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testByte() throws Exception {
        ResultSet rs = this.stmt.executeQuery(SQL);
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) {
                assert (rs.getByte("byteVal") == 1);
                assert (rs.getByte(3) == 1);
            }
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testShort() throws Exception {
        ResultSet rs = this.stmt.executeQuery(SQL);
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) {
                assert (rs.getShort("shortVal") == 1);
                assert (rs.getShort(4) == 1);
            }
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testInteger() throws Exception {
        ResultSet rs = this.stmt.executeQuery(SQL);
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) {
                assert (rs.getInt("intVal") == 1);
                assert (rs.getInt(5) == 1);
            }
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testLong() throws Exception {
        ResultSet rs = this.stmt.executeQuery(SQL);
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) {
                assert (rs.getLong("longVal") == 1L);
                assert (rs.getLong(6) == 1L);
            }
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testFloat() throws Exception {
        ResultSet rs = this.stmt.executeQuery(SQL);
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) {
                assert ((double)rs.getFloat("floatVal") == 1.0);
                assert ((double)rs.getFloat(7) == 1.0);
            }
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testDouble() throws Exception {
        ResultSet rs = this.stmt.executeQuery(SQL);
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) {
                assert (rs.getDouble("doubleVal") == 1.0);
                assert (rs.getDouble(8) == 1.0);
            }
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testBigDecimal() throws Exception {
        ResultSet rs = this.stmt.executeQuery(SQL);
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) {
                assert (rs.getBigDecimal("bigVal").intValue() == 1);
                assert (rs.getBigDecimal(9).intValue() == 1);
            }
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testString() throws Exception {
        ResultSet rs = this.stmt.executeQuery(SQL);
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) {
                assert ("str".equals(rs.getString("strVal")));
                assert ("str".equals(rs.getString(10)));
            }
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testArray() throws Exception {
        ResultSet rs = this.stmt.executeQuery(SQL);
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) {
                assert (Arrays.equals(rs.getBytes("arrVal"), new byte[]{1}));
                assert (Arrays.equals(rs.getBytes(11), new byte[]{1}));
            }
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testDate() throws Exception {
        ResultSet rs = this.stmt.executeQuery(SQL);
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) {
                assert (rs.getDate("dateVal").equals(new Date(1, 1, 1)));
                assert (rs.getDate(12).equals(new Date(1, 1, 1)));
            }
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testTime() throws Exception {
        ResultSet rs = this.stmt.executeQuery(SQL);
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) {
                assert (rs.getTime("timeVal").equals(new Time(1, 1, 1)));
                assert (rs.getTime(13).equals(new Time(1, 1, 1)));
            }
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testTimestamp() throws Exception {
        ResultSet rs = this.stmt.executeQuery(SQL);
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) {
                assert (rs.getTimestamp("tsVal").getTime() == 1L);
                assert (rs.getTimestamp(14).getTime() == 1L);
            }
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testUrl() throws Exception {
        ResultSet rs = this.stmt.executeQuery(SQL);
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) {
                JdbcResultSetSelfTest.assertTrue((boolean)"http://abc.com/".equals(rs.getURL("urlVal").toString()));
                JdbcResultSetSelfTest.assertTrue((boolean)"http://abc.com/".equals(rs.getURL(15).toString()));
            }
            ++cnt;
        }
        assert (cnt == 1);
    }

    public static void assertEqualsToStringRepresentation(Object originalObj, @Nullable IgniteBinary binary, Object resSetObj) {
        if (binary != null) {
            BinaryObject origObjAsBinary = (BinaryObject)binary.toBinary(originalObj);
            String strFromResSet = Objects.toString(resSetObj);
            for (Field declaredField : originalObj.getClass().getDeclaredFields()) {
                JdbcResultSetSelfTest.checkFieldPresenceInToString(origObjAsBinary, strFromResSet, declaredField.getName());
            }
        } else {
            JdbcResultSetSelfTest.assertEquals((String)originalObj.toString(), (String)Objects.toString(resSetObj));
        }
    }

    private static void checkFieldPresenceInToString(BinaryObject original, String strToCheck, String fieldName) {
        Object fieldVal = original.field(fieldName);
        String strValToSearch = Objects.toString(fieldVal);
        if (fieldVal != null) {
            Class<?> aCls = fieldVal.getClass();
            if (aCls.isArray()) {
                Class<?> elemCls = aCls.getComponentType();
                if (elemCls == Byte.TYPE) {
                    strValToSearch = Arrays.toString((byte[])fieldVal);
                }
            } else if (BinaryObject.class.isAssignableFrom(aCls)) {
                strValToSearch = "";
            }
        }
        JdbcResultSetSelfTest.assertTrue((String)("Expected to find field " + fieldName + " having value " + strValToSearch + " in toString representation [" + strToCheck + "]"), (boolean)strToCheck.contains(fieldName + "=" + strValToSearch));
    }

    private static String removeIdHash(String str) {
        return str.replaceAll("idHash=(\\d)*", "idHash=...");
    }

    @Test
    @WithSystemProperty(key="IGNITE_SENSITIVE_DATA_LOGGING", value="plain")
    public void testObject() throws Exception {
        IgniteEx ignite = this.ignite(0);
        boolean binaryMarshaller = ignite.configuration().getMarshaller() instanceof BinaryMarshaller;
        IgniteBinary binary = binaryMarshaller ? ignite.binary() : null;
        ResultSet rs = this.stmt.executeQuery(SQL);
        TestObjectField f1 = new TestObjectField(100, "AAAA");
        TestObjectField f2 = new TestObjectField(500, "BBBB");
        TestObject o = this.createObjectWithData(1);
        JdbcResultSetSelfTest.assertTrue((boolean)rs.next());
        JdbcResultSetSelfTest.assertEqualsToStringRepresentation(f1, binary, rs.getObject("f1"));
        JdbcResultSetSelfTest.assertEqualsToStringRepresentation(f1, binary, rs.getObject(16));
        JdbcResultSetSelfTest.assertEqualsToStringRepresentation(f2, binary, rs.getObject("f2"));
        JdbcResultSetSelfTest.assertEqualsToStringRepresentation(f2, binary, rs.getObject(17));
        JdbcResultSetSelfTest.assertNull((Object)rs.getObject("f3"));
        JdbcResultSetSelfTest.assertTrue((boolean)rs.wasNull());
        JdbcResultSetSelfTest.assertNull((Object)rs.getObject(18));
        JdbcResultSetSelfTest.assertTrue((boolean)rs.wasNull());
        JdbcResultSetSelfTest.assertEqualsToStringRepresentation(o, binary, rs.getObject("_val"));
        JdbcResultSetSelfTest.assertEqualsToStringRepresentation(o, binary, rs.getObject(19));
        JdbcResultSetSelfTest.assertFalse((boolean)rs.next());
    }

    @Test
    public void testNavigation() throws Exception {
        ResultSet rs = this.stmt.executeQuery("select * from TestObject where id > 0");
        assert (rs.isBeforeFirst());
        assert (!rs.isAfterLast());
        assert (!rs.isFirst());
        assert (!rs.isLast());
        assert (rs.getRow() == 0);
        assert (rs.next());
        assert (!rs.isBeforeFirst());
        assert (!rs.isAfterLast());
        assert (rs.isFirst());
        assert (!rs.isLast());
        assert (rs.getRow() == 1);
        assert (rs.next());
        assert (!rs.isBeforeFirst());
        assert (!rs.isAfterLast());
        assert (!rs.isFirst());
        assert (rs.isLast());
        assert (rs.getRow() == 2);
        assert (!rs.next());
        assert (!rs.isBeforeFirst());
        assert (rs.isAfterLast());
        assert (!rs.isFirst());
        assert (!rs.isLast());
        assert (rs.getRow() == 0);
    }

    @Test
    public void testFindColumn() throws Exception {
        final ResultSet rs = this.stmt.executeQuery(SQL);
        assert (rs != null);
        assert (rs.next());
        assert (rs.findColumn("id") == 1);
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                rs.findColumn("wrong");
                return null;
            }
        }, SQLException.class, (String)"Column not found: wrong");
    }

    private static class TestObjectField
    implements Serializable {
        @GridToStringInclude
        final int a;
        @GridToStringInclude
        final String b;

        private TestObjectField(int a, String b) {
            this.a = a;
            this.b = b;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestObjectField that = (TestObjectField)o;
            return this.a == that.a && !(this.b == null ? that.b != null : !this.b.equals(that.b));
        }

        public int hashCode() {
            int res = this.a;
            res = 31 * res + (this.b != null ? this.b.hashCode() : 0);
            return res;
        }

        public String toString() {
            return S.toString(TestObjectField.class, (Object)this);
        }
    }

    private static class TestObject
    implements Serializable {
        @QuerySqlField
        private final int id;
        @QuerySqlField(index=false)
        private Boolean boolVal;
        @QuerySqlField(index=false)
        private Byte byteVal;
        @QuerySqlField(index=false)
        private Short shortVal;
        @QuerySqlField(index=false)
        private Integer intVal;
        @QuerySqlField(index=false)
        private Long longVal;
        @QuerySqlField(index=false)
        private Float floatVal;
        @QuerySqlField(index=false)
        private Double doubleVal;
        @QuerySqlField(index=false)
        private BigDecimal bigVal;
        @QuerySqlField(index=false)
        private String strVal;
        @QuerySqlField(index=false)
        private byte[] arrVal;
        @QuerySqlField(index=false)
        private Date dateVal;
        @QuerySqlField(index=false)
        private Time timeVal;
        @QuerySqlField(index=false)
        private Timestamp tsVal;
        @QuerySqlField(index=false)
        private URL urlVal;
        @QuerySqlField(index=false)
        private TestObjectField f1 = new TestObjectField(100, "AAAA");
        @QuerySqlField(index=false)
        private TestObjectField f2 = new TestObjectField(500, "BBBB");
        @QuerySqlField(index=false)
        private TestObjectField f3;

        private TestObject(int id) {
            this.id = id;
        }

        public String toString() {
            return S.toString(TestObject.class, (Object)this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestObject that = (TestObject)o;
            if (this.id != that.id) {
                return false;
            }
            if (!Arrays.equals(this.arrVal, that.arrVal)) {
                return false;
            }
            if (this.bigVal != null ? !this.bigVal.equals(that.bigVal) : that.bigVal != null) {
                return false;
            }
            if (this.boolVal != null ? !this.boolVal.equals(that.boolVal) : that.boolVal != null) {
                return false;
            }
            if (this.byteVal != null ? !this.byteVal.equals(that.byteVal) : that.byteVal != null) {
                return false;
            }
            if (this.dateVal != null ? !this.dateVal.equals(that.dateVal) : that.dateVal != null) {
                return false;
            }
            if (this.doubleVal != null ? !this.doubleVal.equals(that.doubleVal) : that.doubleVal != null) {
                return false;
            }
            if (this.f1 != null ? !this.f1.equals(that.f1) : that.f1 != null) {
                return false;
            }
            if (this.f2 != null ? !this.f2.equals(that.f2) : that.f2 != null) {
                return false;
            }
            if (this.f3 != null ? !this.f3.equals(that.f3) : that.f3 != null) {
                return false;
            }
            if (this.floatVal != null ? !this.floatVal.equals(that.floatVal) : that.floatVal != null) {
                return false;
            }
            if (this.intVal != null ? !this.intVal.equals(that.intVal) : that.intVal != null) {
                return false;
            }
            if (this.longVal != null ? !this.longVal.equals(that.longVal) : that.longVal != null) {
                return false;
            }
            if (this.shortVal != null ? !this.shortVal.equals(that.shortVal) : that.shortVal != null) {
                return false;
            }
            if (this.strVal != null ? !this.strVal.equals(that.strVal) : that.strVal != null) {
                return false;
            }
            if (this.timeVal != null ? !this.timeVal.equals(that.timeVal) : that.timeVal != null) {
                return false;
            }
            if (this.tsVal != null ? !this.tsVal.equals(that.tsVal) : that.tsVal != null) {
                return false;
            }
            return !(this.urlVal != null ? !this.urlVal.equals(that.urlVal) : that.urlVal != null);
        }

        public int hashCode() {
            int res = this.id;
            res = 31 * res + (this.boolVal != null ? this.boolVal.hashCode() : 0);
            res = 31 * res + (this.byteVal != null ? this.byteVal.hashCode() : 0);
            res = 31 * res + (this.shortVal != null ? this.shortVal.hashCode() : 0);
            res = 31 * res + (this.intVal != null ? this.intVal.hashCode() : 0);
            res = 31 * res + (this.longVal != null ? this.longVal.hashCode() : 0);
            res = 31 * res + (this.floatVal != null ? this.floatVal.hashCode() : 0);
            res = 31 * res + (this.doubleVal != null ? this.doubleVal.hashCode() : 0);
            res = 31 * res + (this.bigVal != null ? this.bigVal.hashCode() : 0);
            res = 31 * res + (this.strVal != null ? this.strVal.hashCode() : 0);
            res = 31 * res + (this.arrVal != null ? Arrays.hashCode(this.arrVal) : 0);
            res = 31 * res + (this.dateVal != null ? this.dateVal.hashCode() : 0);
            res = 31 * res + (this.timeVal != null ? this.timeVal.hashCode() : 0);
            res = 31 * res + (this.tsVal != null ? this.tsVal.hashCode() : 0);
            res = 31 * res + (this.urlVal != null ? this.urlVal.hashCode() : 0);
            res = 31 * res + (this.f1 != null ? this.f1.hashCode() : 0);
            res = 31 * res + (this.f2 != null ? this.f2.hashCode() : 0);
            res = 31 * res + (this.f3 != null ? this.f3.hashCode() : 0);
            return res;
        }

        static /* synthetic */ byte[] access$1002(TestObject x0, byte[] x1) {
            x0.arrVal = x1;
            return x1;
        }
    }
}

