/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.List;
import javax.cache.Cache;
import javax.cache.integration.CacheLoaderException;
import javax.cache.integration.CacheWriterException;
import org.apache.ignite.cache.CacheInterceptor;
import org.apache.ignite.cache.CacheInterceptorAdapter;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.store.CacheStoreAdapter;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public abstract class JdbcErrorsAbstractSelfTest
extends GridCommonAbstractTest {
    protected static final String CACHE_STORE_TEMPLATE = "cache_store";
    protected static final String CACHE_INTERCEPTOR_TEMPLATE = "cache_interceptor";

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        IgniteEx grid = this.startGrid(this.getConfiguration(this.getTestIgniteInstanceName(0)).setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration("test").setQueryEntities(Collections.singletonList(new QueryEntity(Integer.class, Integer.class)))}));
        grid.addCacheConfiguration(new CacheConfiguration(CACHE_STORE_TEMPLATE).setCacheStoreFactory(JdbcErrorsAbstractSelfTest.singletonFactory((Object)new TestCacheStore())).setReadThrough(true));
        grid.addCacheConfiguration(new CacheConfiguration(CACHE_INTERCEPTOR_TEMPLATE).setInterceptor((CacheInterceptor)new TestCacheInterceptor()));
    }

    protected boolean keepSerializedObjects() {
        return true;
    }

    @Test
    public void testParsingErrors() throws SQLException {
        this.checkErrorState("gibberish", "42000", "Failed to parse query. Syntax error in SQL statement \"GIBBERISH[*] \"");
    }

    @Test
    public void testTableErrors() throws SQLException {
        this.checkErrorState("DROP TABLE \"PUBLIC\".missing", "42000", "Table doesn't exist: MISSING");
    }

    @Test
    public void testIndexErrors() throws SQLException {
        this.checkErrorState("DROP INDEX \"PUBLIC\".missing", "42000", "Index doesn't exist: MISSING");
    }

    @Test
    public void testDmlErrors() throws SQLException {
        this.checkErrorState("INSERT INTO \"test\".INTEGER(_key, _val) values(1, null)", "22004", "Value for INSERT, COPY, MERGE, or UPDATE must not be null");
        this.checkErrorState("INSERT INTO \"test\".INTEGER(_key, _val) values(1, 'zzz')", "0700B", "Value conversion failed [column=_VAL, from=java.lang.String, to=java.lang.Integer]");
    }

    @Test
    public void testUnsupportedSql() throws SQLException {
        this.checkErrorState("ALTER TABLE \"test\".Integer MODIFY COLUMN _key CHAR", "0A000", "ALTER COLUMN is not supported");
    }

    @Test
    public void testConnectionClosed() throws SQLException {
        this.checkErrorState(new IgniteCallable<Void>(){

            public Void call() throws Exception {
                Connection conn = JdbcErrorsAbstractSelfTest.this.getConnection();
                conn.close();
                conn.prepareStatement("SELECT 1");
                return null;
            }
        }, "08003", "Connection is closed.");
        this.checkErrorState(new IgniteCallable<Void>(){

            public Void call() throws Exception {
                Connection conn = JdbcErrorsAbstractSelfTest.this.getConnection();
                conn.close();
                conn.createStatement();
                return null;
            }
        }, "08003", "Connection is closed.");
        this.checkErrorState(new IgniteCallable<Void>(){

            public Void call() throws Exception {
                Connection conn = JdbcErrorsAbstractSelfTest.this.getConnection();
                conn.close();
                conn.getMetaData();
                return null;
            }
        }, "08003", "Connection is closed.");
        this.checkErrorState(new IgniteCallable<Void>(){

            public Void call() throws Exception {
                Connection conn = JdbcErrorsAbstractSelfTest.this.getConnection();
                DatabaseMetaData meta = conn.getMetaData();
                conn.close();
                meta.getIndexInfo(null, null, null, false, false);
                return null;
            }
        }, "08003", "Connection is closed.");
        this.checkErrorState(new IgniteCallable<Void>(){

            public Void call() throws Exception {
                Connection conn = JdbcErrorsAbstractSelfTest.this.getConnection();
                DatabaseMetaData meta = conn.getMetaData();
                conn.close();
                meta.getColumns(null, null, null, null);
                return null;
            }
        }, "08003", "Connection is closed.");
        this.checkErrorState(new IgniteCallable<Void>(){

            public Void call() throws Exception {
                Connection conn = JdbcErrorsAbstractSelfTest.this.getConnection();
                DatabaseMetaData meta = conn.getMetaData();
                conn.close();
                meta.getPrimaryKeys(null, null, null);
                return null;
            }
        }, "08003", "Connection is closed.");
        this.checkErrorState(new IgniteCallable<Void>(){

            public Void call() throws Exception {
                Connection conn = JdbcErrorsAbstractSelfTest.this.getConnection();
                DatabaseMetaData meta = conn.getMetaData();
                conn.close();
                meta.getSchemas(null, null);
                return null;
            }
        }, "08003", "Connection is closed.");
        this.checkErrorState(new IgniteCallable<Void>(){

            public Void call() throws Exception {
                Connection conn = JdbcErrorsAbstractSelfTest.this.getConnection();
                DatabaseMetaData meta = conn.getMetaData();
                conn.close();
                meta.getTables(null, null, null, null);
                return null;
            }
        }, "08003", "Connection is closed.");
    }

    @Test
    public void testResultSetClosed() throws SQLException {
        this.checkErrorState(new ConnClosure(){

            @Override
            public void run(Connection conn) throws Exception {
                try (PreparedStatement stmt = conn.prepareStatement("SELECT 1");){
                    ResultSet rs = stmt.executeQuery();
                    rs.next();
                    rs.close();
                    rs.getInt(1);
                }
            }
        }, "24000", "Result set is closed");
    }

    @Test
    public void testInvalidIntFormat() throws SQLException {
        this.checkErrorState(new ConnClosure(){

            @Override
            public void run(Connection conn) throws Exception {
                try (PreparedStatement stmt = conn.prepareStatement("SELECT 'zzz'");){
                    ResultSet rs = stmt.executeQuery();
                    rs.next();
                    rs.getInt(1);
                }
            }
        }, "0700B", "Cannot convert to int");
    }

    @Test
    public void testInvalidLongFormat() throws SQLException {
        this.checkErrorState(new ConnClosure(){

            @Override
            public void run(Connection conn) throws Exception {
                try (PreparedStatement stmt = conn.prepareStatement("SELECT 'zzz'");){
                    ResultSet rs = stmt.executeQuery();
                    rs.next();
                    rs.getLong(1);
                }
            }
        }, "0700B", "Cannot convert to long");
    }

    @Test
    public void testInvalidFloatFormat() throws SQLException {
        this.checkErrorState(new ConnClosure(){

            @Override
            public void run(Connection conn) throws Exception {
                try (PreparedStatement stmt = conn.prepareStatement("SELECT 'zzz'");){
                    ResultSet rs = stmt.executeQuery();
                    rs.next();
                    rs.getFloat(1);
                }
            }
        }, "0700B", "Cannot convert to float");
    }

    @Test
    public void testInvalidDoubleFormat() throws SQLException {
        this.checkErrorState(new ConnClosure(){

            @Override
            public void run(Connection conn) throws Exception {
                try (PreparedStatement stmt = conn.prepareStatement("SELECT 'zzz'");){
                    ResultSet rs = stmt.executeQuery();
                    rs.next();
                    rs.getDouble(1);
                }
            }
        }, "0700B", "Cannot convert to double");
    }

    @Test
    public void testInvalidByteFormat() throws SQLException {
        this.checkErrorState(new ConnClosure(){

            @Override
            public void run(Connection conn) throws Exception {
                try (PreparedStatement stmt = conn.prepareStatement("SELECT 'zzz'");){
                    ResultSet rs = stmt.executeQuery();
                    rs.next();
                    rs.getByte(1);
                }
            }
        }, "0700B", "Cannot convert to byte");
    }

    @Test
    public void testInvalidShortFormat() throws SQLException {
        this.checkErrorState(new ConnClosure(){

            @Override
            public void run(Connection conn) throws Exception {
                try (PreparedStatement stmt = conn.prepareStatement("SELECT 'zzz'");){
                    ResultSet rs = stmt.executeQuery();
                    rs.next();
                    rs.getShort(1);
                }
            }
        }, "0700B", "Cannot convert to short");
    }

    @Test
    public void testInvalidBigDecimalFormat() throws SQLException {
        this.checkErrorState(new ConnClosure(){

            @Override
            public void run(Connection conn) throws Exception {
                try (PreparedStatement stmt = conn.prepareStatement("SELECT 'zzz'");){
                    ResultSet rs = stmt.executeQuery();
                    rs.next();
                    rs.getBigDecimal(1);
                }
            }
        }, "0700B", "Cannot convert to");
    }

    @Test
    public void testInvalidBooleanFormat() throws SQLException {
        this.checkErrorState(new ConnClosure(){

            @Override
            public void run(Connection conn) throws Exception {
                try (PreparedStatement stmt = conn.prepareStatement("SELECT 'zzz'");){
                    ResultSet rs = stmt.executeQuery();
                    rs.next();
                    rs.getBoolean(1);
                }
            }
        }, "0700B", "Cannot convert to boolean");
    }

    @Test
    public void testInvalidObjectFormat() throws SQLException {
        this.checkErrorState(new ConnClosure(){

            @Override
            public void run(Connection conn) throws Exception {
                try (PreparedStatement stmt = conn.prepareStatement("SELECT 'zzz'");){
                    ResultSet rs = stmt.executeQuery();
                    rs.next();
                    rs.getObject(1, List.class);
                }
            }
        }, "0700B", "Cannot convert to");
    }

    @Test
    public void testInvalidDateFormat() throws SQLException {
        this.checkErrorState(new ConnClosure(){

            @Override
            public void run(Connection conn) throws Exception {
                try (PreparedStatement stmt = conn.prepareStatement("SELECT 'zzz'");){
                    ResultSet rs = stmt.executeQuery();
                    rs.next();
                    rs.getDate(1);
                }
            }
        }, "0700B", "Cannot convert to date");
    }

    @Test
    public void testInvalidTimeFormat() throws SQLException {
        this.checkErrorState(new ConnClosure(){

            @Override
            public void run(Connection conn) throws Exception {
                try (PreparedStatement stmt = conn.prepareStatement("SELECT 'zzz'");){
                    ResultSet rs = stmt.executeQuery();
                    rs.next();
                    rs.getTime(1);
                }
            }
        }, "0700B", "Cannot convert to time");
    }

    @Test
    public void testInvalidTimestampFormat() throws SQLException {
        this.checkErrorState(new ConnClosure(){

            @Override
            public void run(Connection conn) throws Exception {
                try (PreparedStatement stmt = conn.prepareStatement("SELECT 'zzz'");){
                    ResultSet rs = stmt.executeQuery();
                    rs.next();
                    rs.getTimestamp(1);
                }
            }
        }, "0700B", "Cannot convert to timestamp");
    }

    @Test
    public void testInvalidUrlFormat() throws SQLException {
        this.checkErrorState(new ConnClosure(){

            @Override
            public void run(Connection conn) throws Exception {
                try (PreparedStatement stmt = conn.prepareStatement("SELECT 'zzz'");){
                    ResultSet rs = stmt.executeQuery();
                    rs.next();
                    rs.getURL(1);
                }
            }
        }, "0700B", "Cannot convert to");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNotNullViolation() throws SQLException {
        try (Connection conn = this.getConnection();){
            conn.setSchema("PUBLIC");
            try (final Statement stmt = conn.createStatement();){
                stmt.execute("CREATE TABLE nulltest(id INT PRIMARY KEY, name CHAR NOT NULL)");
                try {
                    this.checkErrorState(new IgniteCallable<Void>(){

                        public Void call() throws Exception {
                            stmt.execute("INSERT INTO nulltest(id, name) VALUES (1, NULLIF('a', 'a'))");
                            return null;
                        }
                    }, "22004", "Null value is not allowed for column 'NAME'");
                }
                finally {
                    stmt.execute("DROP TABLE nulltest");
                }
            }
        }
    }

    @Test
    public void testNotNullRestrictionReadThroughCacheStore() throws SQLException {
        this.checkErrorState(new ConnClosure(){

            @Override
            public void run(Connection conn) throws Exception {
                conn.setSchema("PUBLIC");
                try (Statement stmt = conn.createStatement();){
                    stmt.execute("CREATE TABLE cache_store_nulltest(id INT PRIMARY KEY, age INT NOT NULL) WITH \"template=cache_store\"");
                }
            }
        }, "0A000", "NOT NULL constraint is not supported when CacheConfiguration.readThrough is enabled.");
    }

    @Test
    public void testNotNullRestrictionCacheInterceptor() throws SQLException {
        this.checkErrorState(new ConnClosure(){

            @Override
            public void run(Connection conn) throws Exception {
                conn.setSchema("PUBLIC");
                try (Statement stmt = conn.createStatement();){
                    stmt.execute("CREATE TABLE cache_interceptor_nulltest(id INT PRIMARY KEY, age INT NOT NULL) WITH \"template=cache_interceptor\"");
                }
            }
        }, "0A000", "NOT NULL constraint is not supported when CacheConfiguration.interceptor is set.");
    }

    @Test
    public void testSelectWrongTable() throws SQLException {
        this.checkSqlErrorMessage("select from wrong", "42000", "Failed to parse query. Table \"WRONG\" not found");
    }

    @Test
    public void testSelectWrongColumnName() throws SQLException {
        this.checkSqlErrorMessage("select wrong from test", "42000", "Failed to parse query. Column \"WRONG\" not found");
    }

    @Test
    public void testSelectWrongSyntax() throws SQLException {
        this.checkSqlErrorMessage("select from test where", "42000", "Failed to parse query. Syntax error in SQL statement \"SELECT FROM TEST WHERE[*]");
    }

    @Test
    public void testDmlWrongTable() throws SQLException {
        this.checkSqlErrorMessage("insert into wrong (id, val) values (3, 'val3')", "42000", "Failed to parse query. Table \"WRONG\" not found");
        this.checkSqlErrorMessage("merge into wrong (id, val) values (3, 'val3')", "42000", "Failed to parse query. Table \"WRONG\" not found");
        this.checkSqlErrorMessage("update wrong set val = 'val3' where id = 2", "42000", "Failed to parse query. Table \"WRONG\" not found");
        this.checkSqlErrorMessage("delete from wrong where id = 2", "42000", "Failed to parse query. Table \"WRONG\" not found");
    }

    @Test
    public void testDmlWrongColumnName() throws SQLException {
        this.checkSqlErrorMessage("insert into test (id, wrong) values (3, 'val3')", "42000", "Failed to parse query. Column \"WRONG\" not found");
        this.checkSqlErrorMessage("merge into test (id, wrong) values (3, 'val3')", "42000", "Failed to parse query. Column \"WRONG\" not found");
        this.checkSqlErrorMessage("update test set wrong = 'val3' where id = 2", "42000", "Failed to parse query. Column \"WRONG\" not found");
        this.checkSqlErrorMessage("delete from test where wrong = 2", "42000", "Failed to parse query. Column \"WRONG\" not found");
    }

    @Test
    public void testDmlWrongSyntax() throws SQLException {
        this.checkSqlErrorMessage("insert test (id, val) values (3, 'val3')", "42000", "Failed to parse query. Syntax error in SQL statement \"INSERT TEST[*] (ID, VAL)");
        this.checkSqlErrorMessage("merge test (id, val) values (3, 'val3')", "42000", "Failed to parse query. Syntax error in SQL statement \"MERGE TEST[*] (ID, VAL)");
        this.checkSqlErrorMessage("update test val = 'val3' where id = 2", "42000", "Failed to parse query. Syntax error in SQL statement \"UPDATE TEST VAL =[*] 'val3' WHERE ID = 2");
        this.checkSqlErrorMessage("delete from test 1where id = 2", "42000", "Failed to parse query. Syntax error in SQL statement \"DELETE FROM TEST 1[*]WHERE ID = 2 ");
    }

    @Test
    public void testDdlWrongTable() throws SQLException {
        this.checkSqlErrorMessage("create table test (id int primary key, val varchar)", "42000", "Table already exists: TEST");
        this.checkSqlErrorMessage("drop table wrong", "42000", "Table doesn't exist: WRONG");
        this.checkSqlErrorMessage("create index idx1 on wrong (val)", "42000", "Table doesn't exist: WRONG");
        this.checkSqlErrorMessage("drop index wrong", "42000", "Index doesn't exist: WRONG");
        this.checkSqlErrorMessage("alter table wrong drop column val", "42000", "Failed to parse query. Table \"WRONG\" not found");
    }

    @Test
    public void testDdlWrongColumnName() throws SQLException {
        this.checkSqlErrorMessage("create index idx1 on test (wrong)", "42000", "Column doesn't exist: WRONG");
        this.checkSqlErrorMessage("alter table test drop column wrong", "42000", "Failed to parse query. Column \"WRONG\" not found");
        this.checkSqlErrorMessage("create table test(id integer primary key, AgE integer, AGe integer)", "42000", "Duplicate column name: AGE");
        this.checkSqlErrorMessage("create table test(\"id\" integer primary key, \"age\" integer, \"age\" integer)", "42000", "Duplicate column name: age");
        this.checkSqlErrorMessage("create table test(id integer primary key, age integer, age varchar)", "42000", "Duplicate column name: AGE");
    }

    @Test
    public void testDdlWrongSyntax() throws SQLException {
        this.checkSqlErrorMessage("create table test2 (id int wrong key, val varchar)", "42000", "Failed to parse query. Syntax error in SQL statement \"CREATE TABLE TEST2 (ID INT WRONG[*]");
        this.checkSqlErrorMessage("drop table test on", "42000", "Failed to parse query. Syntax error in SQL statement \"DROP TABLE TEST ON[*]");
        this.checkSqlErrorMessage("create index idx1 test (val)", "42000", "Failed to parse query. Syntax error in SQL statement \"CREATE INDEX IDX1 TEST[*]");
        this.checkSqlErrorMessage("drop index", "42000", "Failed to parse query. Syntax error in SQL statement \"DROP INDEX [*]");
        this.checkSqlErrorMessage("alter table test drop column", "42000", "Failed to parse query. Syntax error in SQL statement \"ALTER TABLE TEST DROP COLUMN [*]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdatesRejectedInReadOnlyMode() throws Exception {
        try (Connection conn2 = this.getConnection();
             Statement statement = conn2.createStatement();){
            statement.executeUpdate("CREATE TABLE TEST_READ_ONLY (ID LONG PRIMARY KEY, VAL LONG)");
        }
        this.grid(0).cluster().state(ClusterState.ACTIVE_READ_ONLY);
        try {
            this.checkErrorState((Connection conn) -> {
                try (Statement statement = conn.createStatement();){
                    statement.executeUpdate("INSERT INTO TEST_READ_ONLY VALUES (1, 2)");
                }
            }, "90097", "Failed to execute DML statement. Cluster in read-only mode");
        }
        finally {
            this.grid(0).cluster().state(ClusterState.ACTIVE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBatchUpdatesRejectedInReadOnlyMode() throws Exception {
        try (Connection conn2 = this.getConnection();
             Statement statement = conn2.createStatement();){
            statement.executeUpdate("CREATE TABLE TEST_READ_ONLY_BATCH (ID LONG PRIMARY KEY, VAL LONG)");
        }
        this.grid(0).cluster().state(ClusterState.ACTIVE_READ_ONLY);
        try {
            this.checkErrorState((Connection conn) -> {
                try (Statement statement = conn.createStatement();){
                    statement.addBatch("INSERT INTO TEST_READ_ONLY_BATCH VALUES (1, 2)");
                    statement.executeBatch();
                }
            }, "90097", null);
        }
        finally {
            this.grid(0).cluster().state(ClusterState.ACTIVE);
        }
    }

    protected abstract Connection getConnection() throws SQLException;

    private void checkErrorState(final String sql, String expState, String expMsg) throws SQLException {
        this.checkErrorState(new ConnClosure(){

            @Override
            public void run(Connection conn) throws Exception {
                try (PreparedStatement stmt = conn.prepareStatement(sql);){
                    stmt.execute();
                }
            }
        }, expState, expMsg);
    }

    protected void checkErrorState(final ConnClosure clo, String expState, String expMsg) throws SQLException {
        this.checkErrorState(new IgniteCallable<Void>(){

            public Void call() throws Exception {
                try (Connection conn = JdbcErrorsAbstractSelfTest.this.getConnection();){
                    clo.run(conn);
                    JdbcErrorsAbstractSelfTest.fail();
                    Void void_ = null;
                    return void_;
                }
            }
        }, expState, expMsg);
    }

    protected void checkErrorState(IgniteCallable<Void> clo, String expState, String expMsg) throws SQLException {
        SQLException ex = (SQLException)GridTestUtils.assertThrows(null, clo, SQLException.class, (String)expMsg);
        JdbcErrorsAbstractSelfTest.assertEquals((String)expState, (String)ex.getSQLState());
    }

    private void checkSqlErrorMessage(final String sql, String expState, String expMsg) throws SQLException {
        this.checkErrorState(new IgniteCallable<Void>(){

            public Void call() throws Exception {
                try (Connection conn = JdbcErrorsAbstractSelfTest.this.getConnection();){
                    conn.setSchema("PUBLIC");
                    try (Statement stmt = conn.createStatement();){
                        stmt.executeUpdate("DROP TABLE IF EXISTS wrong");
                        stmt.executeUpdate("DROP TABLE IF EXISTS test");
                        stmt.executeUpdate("CREATE TABLE test (id INT PRIMARY KEY, val VARCHAR)");
                        stmt.executeUpdate("INSERT INTO test (id, val) VALUES (1, 'val1')");
                        stmt.executeUpdate("INSERT INTO test (id, val) VALUES (2, 'val2')");
                        stmt.execute(sql);
                        JdbcErrorsAbstractSelfTest.fail((String)"Exception is expected");
                    }
                    Void void_ = null;
                    return void_;
                }
            }
        }, expState, expMsg);
    }

    private static class TestCacheInterceptor
    extends CacheInterceptorAdapter<Object, Object>
    implements Serializable {
        private TestCacheInterceptor() {
        }
    }

    protected class TestCacheStore
    extends CacheStoreAdapter<Object, Object>
    implements Serializable {
        protected TestCacheStore() {
        }

        public Object load(Object key) throws CacheLoaderException {
            return null;
        }

        public void write(Cache.Entry<?, ?> entry) throws CacheWriterException {
        }

        public void delete(Object key) throws CacheWriterException {
        }
    }

    protected static interface ConnClosure {
        public void run(Connection var1) throws Exception;
    }
}

