/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest.protocols.tcp.redis;

import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.internal.processors.rest.protocols.tcp.redis.RedisCommonAbstractTest;
import org.junit.Assert;
import org.junit.Test;
import redis.clients.jedis.Jedis;

public class RedisProtocolServerSelfTest
extends RedisCommonAbstractTest {
    @Test
    public void testDbSize() throws Exception {
        try (Jedis jedis = pool.getResource();){
            Assert.assertEquals((long)0L, (long)jedis.dbSize());
            this.jcache().putAll((Map)new HashMap<Integer, Integer>(){
                {
                    for (int i = 0; i < 100; ++i) {
                        this.put(i, i);
                    }
                }
            });
            Assert.assertEquals((long)100L, (long)jedis.dbSize());
        }
    }

    @Test
    public void testFlushDb() throws Exception {
        try (Jedis jedis = pool.getResource();){
            Assert.assertEquals((long)0L, (long)jedis.dbSize());
            this.jcache().putAll((Map)new HashMap<Integer, Integer>(){
                {
                    for (int i = 0; i < 100; ++i) {
                        this.put(i, i);
                    }
                }
            });
            Assert.assertEquals((long)100L, (long)jedis.dbSize());
            jedis.select(1);
            this.jcache().putAll((Map)new HashMap<Integer, Integer>(){
                {
                    for (int i = 0; i < 100; ++i) {
                        this.put(i, i);
                    }
                }
            });
            jedis.flushDB();
            Assert.assertEquals((long)0L, (long)jedis.dbSize());
            jedis.select(0);
            Assert.assertEquals((long)100L, (long)jedis.dbSize());
        }
    }

    @Test
    public void testFlushAll() throws Exception {
        try (Jedis jedis = pool.getResource();){
            int i;
            Assert.assertEquals((long)0L, (long)jedis.dbSize());
            for (i = 0; i < 100; ++i) {
                jedis.set(String.valueOf(i), String.valueOf(i));
            }
            Assert.assertEquals((long)100L, (long)jedis.dbSize());
            jedis.select(1);
            for (i = 0; i < 100; ++i) {
                jedis.set(String.valueOf(i), String.valueOf(i));
            }
            Assert.assertEquals((long)100L, (long)jedis.dbSize());
            jedis.flushAll();
            Assert.assertEquals((long)0L, (long)jedis.dbSize());
            jedis.select(0);
            Assert.assertEquals((long)0L, (long)jedis.dbSize());
        }
    }
}

