/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc2;

import java.io.Serializable;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.concurrent.Callable;
import org.apache.ignite.IgniteBinary;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class JdbcResultSetSelfTest
extends GridCommonAbstractTest {
    private static final String BASE_URL = "jdbc:ignite:cfg://cache=default@modules/clients/src/test/config/jdbc-config.xml";
    private static final String SQL = "select id, boolVal, byteVal, shortVal, intVal, longVal, floatVal, doubleVal, bigVal, strVal, arrVal, dateVal, timeVal, tsVal, urlVal, f1, f2, f3, _val, boolVal2, boolVal3, boolVal4 from TestObject where id = 1";
    private Statement stmt;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        CacheConfiguration cache = JdbcResultSetSelfTest.defaultCacheConfiguration();
        cache.setCacheMode(CacheMode.PARTITIONED);
        cache.setBackups(1);
        cache.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        cache.setIndexedTypes(new Class[]{Integer.class, TestObject.class});
        cfg.setCacheConfiguration(new CacheConfiguration[]{cache});
        cfg.setConnectorConfiguration(new ConnectorConfiguration());
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        this.startGridsMultiThreaded(3);
        IgniteCache cache = this.grid(0).cache("default");
        assert (cache != null);
        TestObject o = this.createObjectWithData(1);
        cache.put((Object)1, (Object)o);
        cache.put((Object)2, (Object)new TestObject(2));
        cache.put((Object)3, (Object)new TestObject(3));
    }

    protected void beforeTest() throws Exception {
        this.stmt = DriverManager.getConnection(BASE_URL).createStatement();
        assert (this.stmt != null);
        assert (!this.stmt.isClosed());
    }

    protected void afterTest() throws Exception {
        if (this.stmt != null) {
            this.stmt.getConnection().close();
            this.stmt.close();
            assert (this.stmt.isClosed());
        }
    }

    private TestObject createObjectWithData(int id) throws MalformedURLException {
        TestObject o = new TestObject(id);
        o.boolVal = true;
        o.boolVal2 = true;
        o.boolVal3 = true;
        o.boolVal4 = true;
        o.byteVal = (byte)1;
        o.shortVal = (short)1;
        o.intVal = 1;
        o.longVal = 1L;
        o.floatVal = Float.valueOf(1.0f);
        o.doubleVal = 1.0;
        o.bigVal = new BigDecimal(1);
        o.strVal = "1";
        TestObject.access$1002(o, new byte[]{1});
        o.dateVal = new Date(1, 1, 1);
        o.timeVal = new Time(1, 1, 1);
        o.tsVal = new Timestamp(1L);
        o.urlVal = new URL("http://abc.com/");
        return o;
    }

    @Test
    public void testBoolean() throws Exception {
        ResultSet rs = this.stmt.executeQuery(SQL);
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) {
                assert (rs.getBoolean("boolVal"));
                assert (rs.getBoolean(2));
                assert (rs.getByte(2) == 1);
                assert (rs.getInt(2) == 1);
                assert (rs.getShort(2) == 1);
                assert (rs.getLong(2) == 1L);
                assert (rs.getDouble(2) == 1.0);
                assert (rs.getFloat(2) == 1.0f);
                assert (rs.getBigDecimal(2).equals(new BigDecimal(1)));
                assert (rs.getString(2).equals("true"));
                assert (rs.getObject(2, Boolean.class).booleanValue());
                assert (rs.getObject(2, Byte.class) == 1);
                assert (rs.getObject(2, Short.class) == 1);
                assert (rs.getObject(2, Integer.class) == 1);
                assert (rs.getObject(2, Long.class) == 1L);
                assert (rs.getObject(2, Float.class).floatValue() == 1.0f);
                assert (rs.getObject(2, Double.class) == 1.0);
                assert (rs.getObject(2, BigDecimal.class).equals(new BigDecimal(1)));
                assert (rs.getObject(2, String.class).equals("true"));
            }
            ++cnt;
        }
        assert (cnt == 1);
        ResultSet rs0 = this.stmt.executeQuery("select 1");
        assert (rs0.next());
        assert (rs0.getBoolean(1));
        rs0 = this.stmt.executeQuery("select 0");
        assert (rs0.next());
        assert (!rs0.getBoolean(1));
        rs0 = this.stmt.executeQuery("select '1'");
        assert (rs0.next());
        assert (rs0.getBoolean(1));
        rs0 = this.stmt.executeQuery("select '0'");
        assert (rs0.next());
        assert (!rs0.getBoolean(1));
        GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ResultSet rs0 = JdbcResultSetSelfTest.this.stmt.executeQuery("select ''");
                assert (rs0.next());
                assert (rs0.getBoolean(1));
                return null;
            }
        }, SQLException.class, (String)"Cannot convert to boolean: ");
        GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ResultSet rs0 = JdbcResultSetSelfTest.this.stmt.executeQuery("select 'qwe'");
                assert (rs0.next());
                assert (rs0.getBoolean(1));
                return null;
            }
        }, SQLException.class, (String)"Cannot convert to boolean: qwe");
    }

    @Test
    public void testBoolean2() throws Exception {
        ResultSet rs = this.stmt.executeQuery(SQL);
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) {
                assert (rs.getBoolean("boolVal2"));
                assert (rs.getBoolean(20));
            }
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testBoolean3() throws Exception {
        ResultSet rs = this.stmt.executeQuery(SQL);
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) {
                assert (rs.getBoolean("boolVal3"));
                assert (rs.getBoolean(21));
            }
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testBoolean4() throws Exception {
        ResultSet rs = this.stmt.executeQuery(SQL);
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) {
                assert (rs.getBoolean("boolVal4"));
                assert (rs.getBoolean(22));
            }
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testByte() throws Exception {
        ResultSet rs = this.stmt.executeQuery(SQL);
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) {
                assert (rs.getByte("byteVal") == 1);
                assert (rs.getByte(3) == 1);
                assert (rs.getBoolean(3));
                assert (rs.getByte(3) == 1);
                assert (rs.getInt(3) == 1);
                assert (rs.getShort(3) == 1);
                assert (rs.getLong(3) == 1L);
                assert (rs.getDouble(3) == 1.0);
                assert (rs.getFloat(3) == 1.0f);
                assert (rs.getBigDecimal(3).equals(new BigDecimal(1)));
                assert (rs.getString(3).equals("1"));
                assert (rs.getObject(3, Boolean.class).booleanValue());
                assert (rs.getObject(3, Byte.class) == 1);
                assert (rs.getObject(3, Short.class) == 1);
                assert (rs.getObject(3, Integer.class) == 1);
                assert (rs.getObject(3, Long.class) == 1L);
                assert (rs.getObject(3, Float.class).floatValue() == 1.0f);
                assert (rs.getObject(3, Double.class) == 1.0);
                assert (rs.getObject(3, BigDecimal.class).equals(new BigDecimal(1)));
                assert (rs.getObject(3, String.class).equals("1"));
            }
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testShort() throws Exception {
        ResultSet rs = this.stmt.executeQuery(SQL);
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) {
                assert (rs.getShort("shortVal") == 1);
                assert (rs.getShort(4) == 1);
                assert (rs.getBoolean(4));
                assert (rs.getByte(4) == 1);
                assert (rs.getShort(4) == 1);
                assert (rs.getInt(4) == 1);
                assert (rs.getLong(4) == 1L);
                assert (rs.getDouble(4) == 1.0);
                assert (rs.getFloat(4) == 1.0f);
                assert (rs.getBigDecimal(4).equals(new BigDecimal(1)));
                assert (rs.getString(4).equals("1"));
                assert (rs.getObject(4, Boolean.class).booleanValue());
                assert (rs.getObject(4, Byte.class) == 1);
                assert (rs.getObject(4, Short.class) == 1);
                assert (rs.getObject(4, Integer.class) == 1);
                assert (rs.getObject(4, Long.class) == 1L);
                assert (rs.getObject(4, Float.class).floatValue() == 1.0f);
                assert (rs.getObject(4, Double.class) == 1.0);
                assert (rs.getObject(4, BigDecimal.class).equals(new BigDecimal(1)));
                assert (rs.getObject(4, String.class).equals("1"));
            }
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testInteger() throws Exception {
        ResultSet rs = this.stmt.executeQuery(SQL);
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) {
                assert (rs.getInt("intVal") == 1);
                assert (rs.getInt(5) == 1);
                assert (rs.getBoolean(5));
                assert (rs.getByte(5) == 1);
                assert (rs.getShort(5) == 1);
                assert (rs.getInt(5) == 1);
                assert (rs.getLong(5) == 1L);
                assert (rs.getDouble(5) == 1.0);
                assert (rs.getFloat(5) == 1.0f);
                assert (rs.getBigDecimal(5).equals(new BigDecimal(1)));
                assert (rs.getString(5).equals("1"));
                assert (rs.getObject(5, Boolean.class).booleanValue());
                assert (rs.getObject(5, Byte.class) == 1);
                assert (rs.getObject(5, Short.class) == 1);
                assert (rs.getObject(5, Integer.class) == 1);
                assert (rs.getObject(5, Long.class) == 1L);
                assert (rs.getObject(5, Float.class).floatValue() == 1.0f);
                assert (rs.getObject(5, Double.class) == 1.0);
                assert (rs.getObject(5, BigDecimal.class).equals(new BigDecimal(1)));
                assert (rs.getObject(5, String.class).equals("1"));
            }
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testLong() throws Exception {
        ResultSet rs = this.stmt.executeQuery(SQL);
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) {
                assert (rs.getLong("longVal") == 1L);
                assert (rs.getLong(6) == 1L);
                assert (rs.getBoolean(6));
                assert (rs.getByte(6) == 1);
                assert (rs.getShort(6) == 1);
                assert (rs.getInt(6) == 1);
                assert (rs.getLong(6) == 1L);
                assert (rs.getDouble(6) == 1.0);
                assert (rs.getFloat(6) == 1.0f);
                assert (rs.getBigDecimal(6).equals(new BigDecimal(1)));
                assert (rs.getString(6).equals("1"));
                assert (rs.getObject(6, Boolean.class).booleanValue());
                assert (rs.getObject(6, Byte.class) == 1);
                assert (rs.getObject(6, Short.class) == 1);
                assert (rs.getObject(6, Integer.class) == 1);
                assert (rs.getObject(6, Long.class) == 1L);
                assert (rs.getObject(6, Float.class).floatValue() == 1.0f);
                assert (rs.getObject(6, Double.class) == 1.0);
                assert (rs.getObject(6, BigDecimal.class).equals(new BigDecimal(1)));
                assert (rs.getObject(6, String.class).equals("1"));
            }
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testFloat() throws Exception {
        ResultSet rs = this.stmt.executeQuery(SQL);
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) {
                assert ((double)rs.getFloat("floatVal") == 1.0);
                assert ((double)rs.getFloat(7) == 1.0);
                assert (rs.getBoolean(7));
                assert (rs.getByte(7) == 1);
                assert (rs.getShort(7) == 1);
                assert (rs.getInt(7) == 1);
                assert (rs.getLong(7) == 1L);
                assert (rs.getDouble(7) == 1.0);
                assert (rs.getFloat(7) == 1.0f);
                assert (rs.getBigDecimal(7).equals(new BigDecimal(1)));
                assert (rs.getString(7).equals("1.0"));
                assert (rs.getObject(7, Boolean.class).booleanValue());
                assert (rs.getObject(7, Byte.class) == 1);
                assert (rs.getObject(7, Short.class) == 1);
                assert (rs.getObject(7, Integer.class) == 1);
                assert (rs.getObject(7, Long.class) == 1L);
                assert (rs.getObject(7, Float.class).floatValue() == 1.0f);
                assert (rs.getObject(7, Double.class) == 1.0);
                assert (rs.getObject(7, BigDecimal.class).equals(new BigDecimal(1)));
                assert (rs.getObject(7, String.class).equals("1.0"));
            }
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testDouble() throws Exception {
        ResultSet rs = this.stmt.executeQuery(SQL);
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) {
                assert (rs.getDouble("doubleVal") == 1.0);
                assert (rs.getDouble(8) == 1.0);
                assert (rs.getBoolean(8));
                assert (rs.getByte(8) == 1);
                assert (rs.getShort(8) == 1);
                assert (rs.getInt(8) == 1);
                assert (rs.getLong(8) == 1L);
                assert (rs.getDouble(8) == 1.0);
                assert (rs.getFloat(8) == 1.0f);
                assert (rs.getBigDecimal(8).equals(new BigDecimal(1)));
                assert (rs.getString(8).equals("1.0"));
                assert (rs.getObject(8, Boolean.class).booleanValue());
                assert (rs.getObject(8, Byte.class) == 1);
                assert (rs.getObject(8, Short.class) == 1);
                assert (rs.getObject(8, Integer.class) == 1);
                assert (rs.getObject(8, Long.class) == 1L);
                assert (rs.getObject(8, Float.class).floatValue() == 1.0f);
                assert (rs.getObject(8, Double.class) == 1.0);
                assert (rs.getObject(8, BigDecimal.class).equals(new BigDecimal(1)));
                assert (rs.getObject(8, String.class).equals("1.0"));
            }
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testBigDecimal() throws Exception {
        ResultSet rs = this.stmt.executeQuery(SQL);
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) {
                assert (rs.getBigDecimal("bigVal").intValue() == 1);
                assert (rs.getBigDecimal(9).intValue() == 1);
                assert (rs.getBoolean(9));
                assert (rs.getByte(9) == 1);
                assert (rs.getShort(9) == 1);
                assert (rs.getInt(9) == 1);
                assert (rs.getLong(9) == 1L);
                assert (rs.getDouble(9) == 1.0);
                assert (rs.getFloat(9) == 1.0f);
                assert (rs.getBigDecimal(9).equals(new BigDecimal(1)));
                assert (rs.getString(9).equals("1"));
                assert (rs.getObject(9, Boolean.class).booleanValue());
                assert (rs.getObject(9, Byte.class) == 1);
                assert (rs.getObject(9, Short.class) == 1);
                assert (rs.getObject(9, Integer.class) == 1);
                assert (rs.getObject(9, Long.class) == 1L);
                assert (rs.getObject(9, Float.class).floatValue() == 1.0f);
                assert (rs.getObject(9, Double.class) == 1.0);
                assert (rs.getObject(9, BigDecimal.class).equals(new BigDecimal(1)));
                assert (rs.getObject(9, String.class).equals("1"));
            }
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testBigDecimalScale() throws Exception {
        assert ("0.12".equals(this.convertStringToBigDecimalViaJdbc("0.1234", 2).toString()));
        assert ("1.001".equals(this.convertStringToBigDecimalViaJdbc("1.0005", 3).toString()));
        assert ("1E+3".equals(this.convertStringToBigDecimalViaJdbc("1205.5", -3).toString()));
        assert ("1.3E+4".equals(this.convertStringToBigDecimalViaJdbc("12505.5", -3).toString()));
    }

    private BigDecimal convertStringToBigDecimalViaJdbc(String strDec, int scale) throws SQLException {
        try (ResultSet rs = this.stmt.executeQuery("select '" + strDec + "'");){
            assert (rs.next());
            BigDecimal bigDecimal = rs.getBigDecimal(1, scale);
            return bigDecimal;
        }
    }

    @Test
    public void testString() throws Exception {
        ResultSet rs = this.stmt.executeQuery(SQL);
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) {
                assert ("1".equals(rs.getString("strVal")));
                assert (rs.getBoolean(10));
                assert (rs.getByte(10) == 1);
                assert (rs.getShort(10) == 1);
                assert (rs.getInt(10) == 1);
                assert (rs.getLong(10) == 1L);
                assert (rs.getDouble(10) == 1.0);
                assert (rs.getFloat(10) == 1.0f);
                assert (rs.getBigDecimal(10).equals(new BigDecimal("1")));
                assert (rs.getString(10).equals("1"));
                assert (rs.getObject(10, Boolean.class).booleanValue());
                assert (rs.getObject(10, Byte.class) == 1);
                assert (rs.getObject(10, Short.class) == 1);
                assert (rs.getObject(10, Integer.class) == 1);
                assert (rs.getObject(10, Long.class) == 1L);
                assert (rs.getObject(10, Float.class).floatValue() == 1.0f);
                assert (rs.getObject(10, Double.class) == 1.0);
                assert (rs.getObject(10, BigDecimal.class).equals(new BigDecimal(1)));
                assert (rs.getObject(10, String.class).equals("1"));
            }
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testArray() throws Exception {
        ResultSet rs = this.stmt.executeQuery(SQL);
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) {
                assert (Arrays.equals(rs.getBytes("arrVal"), new byte[]{1}));
                assert (Arrays.equals(rs.getBytes(11), new byte[]{1}));
            }
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testDate() throws Exception {
        ResultSet rs = this.stmt.executeQuery(SQL);
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) {
                assert (rs.getDate("dateVal").equals(new Date(1, 1, 1)));
                assert (rs.getDate(12).equals(new Date(1, 1, 1)));
                assert (rs.getTime(12).equals(new Time(new Date(1, 1, 1).getTime())));
                assert (rs.getTimestamp(12).equals(new Timestamp(new Date(1, 1, 1).getTime())));
                assert (rs.getObject(12, Date.class).equals(new Date(1, 1, 1)));
                assert (rs.getObject(12, Time.class).equals(new Time(new Date(1, 1, 1).getTime())));
                assert (rs.getObject(12, Timestamp.class).equals(new Timestamp(new Date(1, 1, 1).getTime())));
            }
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testTime() throws Exception {
        ResultSet rs = this.stmt.executeQuery(SQL);
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) {
                assert (rs.getTime("timeVal").equals(new Time(1, 1, 1)));
                assert (rs.getDate(13).equals(new Date(new Time(1, 1, 1).getTime())));
                assert (rs.getTime(13).equals(new Time(1, 1, 1)));
                assert (rs.getTimestamp(13).equals(new Timestamp(new Time(1, 1, 1).getTime())));
                assert (rs.getObject(13, Date.class).equals(new Date(new Time(1, 1, 1).getTime())));
                assert (rs.getObject(13, Time.class).equals(new Time(1, 1, 1)));
                assert (rs.getObject(13, Timestamp.class).equals(new Timestamp(new Time(1, 1, 1).getTime())));
            }
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testTimestamp() throws Exception {
        ResultSet rs = this.stmt.executeQuery(SQL);
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) {
                assert (rs.getTimestamp("tsVal").getTime() == 1L);
                assert (rs.getDate(14).equals(new Date(new Timestamp(1L).getTime())));
                assert (rs.getTime(14).equals(new Time(new Timestamp(1L).getTime())));
                assert (rs.getTimestamp(14).equals(new Timestamp(1L)));
                assert (rs.getObject(14, Date.class).equals(new Date(new Timestamp(1L).getTime())));
                assert (rs.getObject(14, Time.class).equals(new Time(new Timestamp(1L).getTime())));
                assert (rs.getObject(14, Timestamp.class).equals(new Timestamp(1L)));
            }
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testUrl() throws Exception {
        ResultSet rs = this.stmt.executeQuery(SQL);
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) {
                JdbcResultSetSelfTest.assertTrue((boolean)"http://abc.com/".equals(rs.getURL("urlVal").toString()));
                JdbcResultSetSelfTest.assertTrue((boolean)"http://abc.com/".equals(rs.getURL(15).toString()));
            }
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    @WithSystemProperty(key="IGNITE_SENSITIVE_DATA_LOGGING", value="plain")
    public void testObject() throws Exception {
        IgniteEx ignite = this.ignite(0);
        boolean binaryMarshaller = ignite.configuration().getMarshaller() instanceof BinaryMarshaller;
        IgniteBinary binary = binaryMarshaller ? ignite.binary() : null;
        ResultSet rs = this.stmt.executeQuery(SQL);
        TestObjectField f1 = new TestObjectField(100, "AAAA");
        TestObjectField f2 = new TestObjectField(500, "BBBB");
        TestObject o = this.createObjectWithData(1);
        JdbcResultSetSelfTest.assertTrue((boolean)rs.next());
        org.apache.ignite.jdbc.JdbcResultSetSelfTest.assertEqualsToStringRepresentation(f1, binary, rs.getObject("f1"));
        org.apache.ignite.jdbc.JdbcResultSetSelfTest.assertEqualsToStringRepresentation(f1, binary, rs.getObject(16));
        org.apache.ignite.jdbc.JdbcResultSetSelfTest.assertEqualsToStringRepresentation(f2, binary, rs.getObject("f2"));
        org.apache.ignite.jdbc.JdbcResultSetSelfTest.assertEqualsToStringRepresentation(f2, binary, rs.getObject(17));
        JdbcResultSetSelfTest.assertNull((Object)rs.getObject("f3"));
        JdbcResultSetSelfTest.assertTrue((boolean)rs.wasNull());
        JdbcResultSetSelfTest.assertNull((Object)rs.getObject(18));
        JdbcResultSetSelfTest.assertTrue((boolean)rs.wasNull());
        org.apache.ignite.jdbc.JdbcResultSetSelfTest.assertEqualsToStringRepresentation(o, binary, rs.getObject("_val"));
        org.apache.ignite.jdbc.JdbcResultSetSelfTest.assertEqualsToStringRepresentation(o, binary, rs.getObject(19));
        JdbcResultSetSelfTest.assertFalse((boolean)rs.next());
    }

    @Test
    public void testNavigation() throws Exception {
        ResultSet rs = this.stmt.executeQuery("select * from TestObject where id > 0");
        JdbcResultSetSelfTest.assertTrue((boolean)rs.isBeforeFirst());
        JdbcResultSetSelfTest.assertFalse((boolean)rs.isAfterLast());
        JdbcResultSetSelfTest.assertFalse((boolean)rs.isFirst());
        JdbcResultSetSelfTest.assertFalse((boolean)rs.isLast());
        JdbcResultSetSelfTest.assertEquals((int)0, (int)rs.getRow());
        JdbcResultSetSelfTest.assertTrue((boolean)rs.next());
        JdbcResultSetSelfTest.assertFalse((boolean)rs.isBeforeFirst());
        JdbcResultSetSelfTest.assertFalse((boolean)rs.isAfterLast());
        JdbcResultSetSelfTest.assertTrue((boolean)rs.isFirst());
        JdbcResultSetSelfTest.assertFalse((boolean)rs.isLast());
        JdbcResultSetSelfTest.assertEquals((int)1, (int)rs.getRow());
        JdbcResultSetSelfTest.assertTrue((boolean)rs.next());
        JdbcResultSetSelfTest.assertFalse((boolean)rs.isBeforeFirst());
        JdbcResultSetSelfTest.assertFalse((boolean)rs.isAfterLast());
        JdbcResultSetSelfTest.assertFalse((boolean)rs.isFirst());
        JdbcResultSetSelfTest.assertFalse((boolean)rs.isLast());
        JdbcResultSetSelfTest.assertEquals((int)2, (int)rs.getRow());
        JdbcResultSetSelfTest.assertTrue((boolean)rs.next());
        JdbcResultSetSelfTest.assertFalse((boolean)rs.isBeforeFirst());
        JdbcResultSetSelfTest.assertFalse((boolean)rs.isAfterLast());
        JdbcResultSetSelfTest.assertFalse((boolean)rs.isFirst());
        JdbcResultSetSelfTest.assertTrue((boolean)rs.isLast());
        JdbcResultSetSelfTest.assertEquals((int)3, (int)rs.getRow());
        JdbcResultSetSelfTest.assertFalse((boolean)rs.next());
        JdbcResultSetSelfTest.assertFalse((boolean)rs.isBeforeFirst());
        JdbcResultSetSelfTest.assertTrue((boolean)rs.isAfterLast());
        JdbcResultSetSelfTest.assertFalse((boolean)rs.isFirst());
        JdbcResultSetSelfTest.assertFalse((boolean)rs.isLast());
        JdbcResultSetSelfTest.assertEquals((int)0, (int)rs.getRow());
    }

    @Test
    public void testFetchSize() throws Exception {
        this.stmt.setFetchSize(1);
        ResultSet rs = this.stmt.executeQuery("select * from TestObject where id > 0");
        JdbcResultSetSelfTest.assertTrue((boolean)rs.next());
        JdbcResultSetSelfTest.assertTrue((boolean)rs.next());
        JdbcResultSetSelfTest.assertTrue((boolean)rs.next());
        this.stmt.setFetchSize(0);
    }

    @Test
    public void testNewQueryTaskFetchSize() throws Exception {
        this.stmt.setFetchSize(1);
        boolean res = this.stmt.execute("select * from TestObject where id > 0");
        JdbcResultSetSelfTest.assertTrue((boolean)res);
        ResultSet rs = this.stmt.getResultSet();
        JdbcResultSetSelfTest.assertTrue((boolean)rs.next());
        JdbcResultSetSelfTest.assertTrue((boolean)rs.next());
        JdbcResultSetSelfTest.assertTrue((boolean)rs.next());
        this.stmt.setFetchSize(0);
    }

    @Test
    public void testFindColumn() throws Exception {
        final ResultSet rs = this.stmt.executeQuery(SQL);
        JdbcResultSetSelfTest.assertNotNull((Object)rs);
        JdbcResultSetSelfTest.assertTrue((boolean)rs.next());
        assert (rs.findColumn("id") == 1);
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                rs.findColumn("wrong");
                return null;
            }
        }, SQLException.class, (String)"Column not found: wrong");
    }

    private static class TestObjectField
    implements Serializable {
        @GridToStringInclude
        final int a;
        @GridToStringInclude
        final String b;

        private TestObjectField(int a, String b) {
            this.a = a;
            this.b = b;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestObjectField that = (TestObjectField)o;
            return this.a == that.a && !(this.b == null ? that.b != null : !this.b.equals(that.b));
        }

        public int hashCode() {
            int res = this.a;
            res = 31 * res + (this.b != null ? this.b.hashCode() : 0);
            return res;
        }

        public String toString() {
            return S.toString(TestObjectField.class, (Object)this);
        }
    }

    private static class TestObject
    extends BaseTestObject {
        @QuerySqlField
        private final int id;
        @QuerySqlField(index=false)
        private Boolean boolVal;
        @QuerySqlField(index=false)
        private Byte byteVal;
        @QuerySqlField(index=false)
        private Short shortVal;
        @QuerySqlField(index=false)
        private Integer intVal;
        @QuerySqlField(index=false)
        private Long longVal;
        @QuerySqlField(index=false)
        private Float floatVal;
        @QuerySqlField(index=false)
        private Double doubleVal;
        @QuerySqlField(index=false)
        private BigDecimal bigVal;
        @QuerySqlField(index=false)
        private String strVal;
        @QuerySqlField(index=false)
        private byte[] arrVal;
        @QuerySqlField(index=false)
        private Date dateVal;
        @QuerySqlField(index=false)
        private Time timeVal;
        @QuerySqlField(index=false)
        private Timestamp tsVal;
        @QuerySqlField(index=false)
        private URL urlVal;
        @QuerySqlField(index=false)
        private TestObjectField f1 = new TestObjectField(100, "AAAA");
        @QuerySqlField(index=false)
        private TestObjectField f2 = new TestObjectField(500, "BBBB");
        @QuerySqlField(index=false)
        private TestObjectField f3;

        private TestObject(int id) {
            this.id = id;
        }

        public String toString() {
            return S.toString(TestObject.class, (Object)this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestObject that = (TestObject)o;
            if (this.id != that.id) {
                return false;
            }
            if (!Arrays.equals(this.arrVal, that.arrVal)) {
                return false;
            }
            if (this.bigVal != null ? !this.bigVal.equals(that.bigVal) : that.bigVal != null) {
                return false;
            }
            if (this.boolVal != null ? !this.boolVal.equals(that.boolVal) : that.boolVal != null) {
                return false;
            }
            if (this.byteVal != null ? !this.byteVal.equals(that.byteVal) : that.byteVal != null) {
                return false;
            }
            if (this.dateVal != null ? !this.dateVal.equals(that.dateVal) : that.dateVal != null) {
                return false;
            }
            if (this.doubleVal != null ? !this.doubleVal.equals(that.doubleVal) : that.doubleVal != null) {
                return false;
            }
            if (this.f1 != null ? !this.f1.equals(that.f1) : that.f1 != null) {
                return false;
            }
            if (this.f2 != null ? !this.f2.equals(that.f2) : that.f2 != null) {
                return false;
            }
            if (this.f3 != null ? !this.f3.equals(that.f3) : that.f3 != null) {
                return false;
            }
            if (this.floatVal != null ? !this.floatVal.equals(that.floatVal) : that.floatVal != null) {
                return false;
            }
            if (this.intVal != null ? !this.intVal.equals(that.intVal) : that.intVal != null) {
                return false;
            }
            if (this.longVal != null ? !this.longVal.equals(that.longVal) : that.longVal != null) {
                return false;
            }
            if (this.shortVal != null ? !this.shortVal.equals(that.shortVal) : that.shortVal != null) {
                return false;
            }
            if (this.strVal != null ? !this.strVal.equals(that.strVal) : that.strVal != null) {
                return false;
            }
            if (this.timeVal != null ? !this.timeVal.equals(that.timeVal) : that.timeVal != null) {
                return false;
            }
            if (this.tsVal != null ? !this.tsVal.equals(that.tsVal) : that.tsVal != null) {
                return false;
            }
            return !(this.urlVal != null ? !this.urlVal.equals(that.urlVal) : that.urlVal != null);
        }

        public int hashCode() {
            int res = this.id;
            res = 31 * res + (this.boolVal != null ? this.boolVal.hashCode() : 0);
            res = 31 * res + (this.byteVal != null ? this.byteVal.hashCode() : 0);
            res = 31 * res + (this.shortVal != null ? this.shortVal.hashCode() : 0);
            res = 31 * res + (this.intVal != null ? this.intVal.hashCode() : 0);
            res = 31 * res + (this.longVal != null ? this.longVal.hashCode() : 0);
            res = 31 * res + (this.floatVal != null ? this.floatVal.hashCode() : 0);
            res = 31 * res + (this.doubleVal != null ? this.doubleVal.hashCode() : 0);
            res = 31 * res + (this.bigVal != null ? this.bigVal.hashCode() : 0);
            res = 31 * res + (this.strVal != null ? this.strVal.hashCode() : 0);
            res = 31 * res + (this.arrVal != null ? Arrays.hashCode(this.arrVal) : 0);
            res = 31 * res + (this.dateVal != null ? this.dateVal.hashCode() : 0);
            res = 31 * res + (this.timeVal != null ? this.timeVal.hashCode() : 0);
            res = 31 * res + (this.tsVal != null ? this.tsVal.hashCode() : 0);
            res = 31 * res + (this.urlVal != null ? this.urlVal.hashCode() : 0);
            res = 31 * res + (this.f1 != null ? this.f1.hashCode() : 0);
            res = 31 * res + (this.f2 != null ? this.f2.hashCode() : 0);
            res = 31 * res + (this.f3 != null ? this.f3.hashCode() : 0);
            return res;
        }

        static /* synthetic */ byte[] access$1002(TestObject x0, byte[] x1) {
            x0.arrVal = x1;
            return x1;
        }
    }

    private static class BaseTestObject
    implements Serializable {
        @QuerySqlField(index=false)
        protected Boolean boolVal2;
        @QuerySqlField(index=false)
        protected boolean boolVal3;
        @QuerySqlField(index=false)
        protected boolean boolVal4;

        private BaseTestObject() {
        }

        public boolean isBoolVal4() {
            return this.boolVal4;
        }
    }
}

