/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc2;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class JdbcConnectionWithoutCacheNameTest
extends GridCommonAbstractTest {
    private static final String CFG_PATH = "modules/clients/src/test/config/jdbc-config.xml";

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        CacheConfiguration cache = JdbcConnectionWithoutCacheNameTest.defaultCacheConfiguration();
        cache.setCacheMode(CacheMode.PARTITIONED);
        cache.setBackups(1);
        cache.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        cache.setSqlSchema("\"default\"");
        cfg.setCacheConfiguration(new CacheConfiguration[]{cache});
        cfg.setConnectorConfiguration(new ConnectorConfiguration());
        return cfg;
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        super.afterTest();
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.startGrid("srv");
    }

    @Test
    public void testWithoutCache() throws Exception {
        try (Connection c = DriverManager.getConnection("jdbc:ignite:cfg://modules/clients/src/test/config/jdbc-config.xml");
             Statement stmt = c.createStatement();){
            stmt.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, VAL VARCHAR)");
            stmt.execute("INSERT INTO TEST VALUES(1, '1')");
            stmt.execute("DROP TABLE TEST ");
        }
    }

    @Test
    public void testSchemaParameter() throws Exception {
        Throwable throwable;
        Statement stmt;
        try (Connection c = DriverManager.getConnection("jdbc:ignite:cfg://schema=\"default\"@modules/clients/src/test/config/jdbc-config.xml");){
            stmt = c.createStatement();
            throwable = null;
            try {
                stmt.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, VAL VARCHAR)");
                stmt.execute("INSERT INTO TEST VALUES(1, '1')");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stmt != null) {
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        c = DriverManager.getConnection("jdbc:ignite:cfg://modules/clients/src/test/config/jdbc-config.xml");
        var2_2 = null;
        try {
            stmt = c.createStatement();
            throwable = null;
            try {
                stmt.execute("DROP TABLE \"default\".TEST ");
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (stmt != null) {
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        catch (Throwable throwable6) {
            var2_2 = throwable6;
            throw throwable6;
        }
        finally {
            if (c != null) {
                if (var2_2 != null) {
                    try {
                        c.close();
                    }
                    catch (Throwable throwable7) {
                        var2_2.addSuppressed(throwable7);
                    }
                } else {
                    c.close();
                }
            }
        }
    }

    @Test
    public void testFailOnMultipleStatements() throws Exception {
        try (Connection c = DriverManager.getConnection("jdbc:ignite:cfg://modules/clients/src/test/config/jdbc-config.xml");
             Statement stmt = c.createStatement();){
            stmt.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, VAL VARCHAR)");
            GridTestUtils.assertThrows((IgniteLogger)log, () -> {
                stmt.execute("INSERT INTO TEST VALUES(0, '0'); INSERT INTO TEST VALUES(1, '1');");
                return null;
            }, SQLException.class, (String)"Multiple statements queries are not supported.");
        }
    }
}

