/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc2;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.jetbrains.annotations.NotNull;
import org.junit.Before;
import org.junit.Test;

public abstract class JdbcAbstractSchemaCaseTest
extends GridCommonAbstractTest {
    private static final int GRID_CNT = 2;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setCacheConfiguration(new CacheConfiguration[]{this.cacheConfiguration("test0", "test0"), this.cacheConfiguration("test1", "tEst1"), this.cacheConfiguration("test2", "\"TestCase\"")});
        return cfg;
    }

    protected abstract Connection connect(String var1) throws SQLException;

    private CacheConfiguration cacheConfiguration(@NotNull String name, @NotNull String schema) throws Exception {
        CacheConfiguration cfg = JdbcAbstractSchemaCaseTest.defaultCacheConfiguration();
        cfg.setIndexedTypes(new Class[]{Integer.class, Integer.class});
        cfg.setName(name);
        cfg.setSqlSchema(schema);
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGridsMultiThreaded(2);
    }

    @Before
    public void dropTables() throws Exception {
        List<String> schemas = this.getSchemasWithTestTable();
        try (Connection conn = this.connect("PUBLIC");){
            Statement stmt = conn.createStatement();
            for (String schema : schemas) {
                stmt.executeUpdate("DROP TABLE IF EXISTS \"" + schema + "\".TAB");
            }
        }
    }

    @Test
    public void testSchemaName() throws Exception {
        this.checkSchemaConnection("test0");
        this.checkSchemaConnection("test1");
        this.checkSchemaConnection("\"TestCase\"");
        this.checkSchemaConnection("\"TEST0\"");
        this.checkSchemaConnection("\"TEST1\"");
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JdbcAbstractSchemaCaseTest.this.checkSchemaConnection("TestCase");
                return null;
            }
        }, SQLException.class, null);
    }

    @Test
    public void testSchemaNameWithCreateTableIfNotExists() throws Exception {
        this.createTableWithImplicitSchema("test0");
        this.assertTablesInSchemasPresented("TEST0");
        this.createTableWithImplicitSchema("test1");
        this.assertTablesInSchemasPresented("TEST0", "TEST1");
        this.createTableWithImplicitSchema("\"TestCase\"");
        this.assertTablesInSchemasPresented("TEST0", "TEST1", "TestCase");
        this.createTableWithImplicitSchema("\"TEST0\"");
        this.assertTablesInSchemasPresented("TEST0", "TEST1", "TestCase");
        this.createTableWithImplicitSchema("\"TEST1\"");
        this.assertTablesInSchemasPresented("TEST0", "TEST1", "TestCase");
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JdbcAbstractSchemaCaseTest.this.createTableWithImplicitSchema("TestCase");
                return null;
            }
        }, SQLException.class, null);
    }

    private void checkSchemaConnection(String schema) throws SQLException {
        try (Connection conn = this.connect(schema);){
            Statement stmt = conn.createStatement();
            JdbcAbstractSchemaCaseTest.assertNotNull((Object)stmt);
            JdbcAbstractSchemaCaseTest.assertFalse((boolean)stmt.isClosed());
            stmt.execute("select t._key, t._val from Integer t");
        }
    }

    private void createTableWithImplicitSchema(String schema) throws SQLException {
        try (Connection conn = this.connect(schema);){
            this.execute(conn, "CREATE TABLE IF NOT EXISTS TAB (id INT PRIMARY KEY, val INT);");
            this.execute(conn, "CREATE TABLE IF NOT EXISTS TAB (id INT PRIMARY KEY, val INT);");
            this.execute(conn, "CREATE TABLE IF NOT EXISTS TAB (newId VARCHAR PRIMARY KEY, val VARCHAR);");
            this.execute(conn, "CREATE TABLE IF NOT EXISTS TAB (newId VARCHAR PRIMARY KEY, val VARCHAR);");
        }
    }

    private void execute(Connection conn, String sql) throws SQLException {
        try (PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.execute();
        }
    }

    List<String> getSchemasWithTestTable() throws SQLException {
        try (Connection conn = this.connect("PUBLIC");){
            Statement stmt = conn.createStatement();
            ArrayList<String> schemasWithTab = new ArrayList<String>();
            try (ResultSet tabs = stmt.executeQuery("SELECT SCHEMA_NAME, TABLE_NAME FROM " + QueryUtils.sysSchemaName() + ".TABLES WHERE TABLE_NAME = 'TAB' ORDER BY SCHEMA_NAME;");){
                while (tabs.next()) {
                    schemasWithTab.add(tabs.getString("SCHEMA_NAME"));
                }
            }
            ArrayList<String> arrayList = schemasWithTab;
            return arrayList;
        }
    }

    void assertTablesInSchemasPresented(String ... schemas) throws SQLException {
        Arrays.sort(schemas);
        List<String> exp = Arrays.asList(schemas);
        JdbcAbstractSchemaCaseTest.assertEqualsCollections(exp, this.getSchemasWithTestTable());
    }
}

