/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc.thin;

import java.sql.Connection;
import java.sql.DriverManager;
import org.apache.ignite.internal.jdbc.thin.JdbcThinStatement;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class JdbcThinStatementTimeoutInternalsTest
extends GridCommonAbstractTest {
    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.startGrid(0);
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        super.afterTest();
    }

    @Test
    public void testUrlQueryTimeoutPropertyIsSetInternally() throws Exception {
        JdbcThinStatement stmt;
        try (Connection conn = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1");){
            stmt = (JdbcThinStatement)conn.createStatement();
            JdbcThinStatementTimeoutInternalsTest.assertEquals((int)0, (int)stmt.requestTimeout());
            JdbcThinStatementTimeoutInternalsTest.assertFalse((boolean)stmt.explicitTimeout);
            stmt.setQueryTimeout(1);
            JdbcThinStatementTimeoutInternalsTest.assertEquals((int)1000, (int)stmt.requestTimeout());
            JdbcThinStatementTimeoutInternalsTest.assertTrue((boolean)stmt.explicitTimeout);
        }
        conn = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1?queryTimeout=1");
        var2_2 = null;
        try {
            stmt = (JdbcThinStatement)conn.createStatement();
            JdbcThinStatementTimeoutInternalsTest.assertEquals((int)1000, (int)stmt.requestTimeout());
            JdbcThinStatementTimeoutInternalsTest.assertTrue((boolean)stmt.explicitTimeout);
            stmt.setQueryTimeout(2);
            JdbcThinStatementTimeoutInternalsTest.assertEquals((int)2000, (int)stmt.requestTimeout());
            JdbcThinStatementTimeoutInternalsTest.assertTrue((boolean)stmt.explicitTimeout);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }
}

