/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.ignite.IgniteException;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeJobResultPolicy;
import org.apache.ignite.compute.ComputeTaskSplitAdapter;
import org.apache.ignite.internal.client.ClientTcpTask;

public class ClientHttpTask
extends ComputeTaskSplitAdapter<String, Integer> {
    private final ClientTcpTask delegate = new ClientTcpTask();
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();

    protected Collection<? extends ComputeJob> split(int gridSize, String arg) {
        try {
            JsonNode json = JSON_MAPPER.readTree(arg);
            ArrayList<String> list = null;
            if (json.isArray()) {
                list = new ArrayList<String>();
                for (JsonNode child : json) {
                    list.add(child.asText());
                }
            }
            return this.delegate.split(gridSize, list);
        }
        catch (IOException e) {
            throw new IgniteException((Throwable)e);
        }
    }

    public Integer reduce(List<ComputeJobResult> results) {
        return this.delegate.reduce((List)results);
    }

    public ComputeJobResultPolicy result(ComputeJobResult res, List<ComputeJobResult> rcvd) {
        if (res.getException() != null) {
            return ComputeJobResultPolicy.FAILOVER;
        }
        return ComputeJobResultPolicy.WAIT;
    }
}

