/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.IgniteServices;
import org.apache.ignite.Ignition;
import org.apache.ignite.client.ClientServices;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.configuration.ClientConfiguration;
import org.apache.ignite.configuration.ClientConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.events.Event;
import org.apache.ignite.events.ServiceEvent;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.services.Service;
import org.apache.ignite.services.ServiceConfiguration;
import org.apache.ignite.services.ServiceContext;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class ServiceEventSubjectIdSelfTest
extends GridCommonAbstractTest {
    private static final String SVC_NAME = "simpleService";
    protected static final Collection<Event> evts = new ArrayList<Event>();
    protected static CountDownLatch latch;
    private UUID subjId;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName).setClientConnectorConfiguration(new ClientConnectorConfiguration());
        cfg.setIncludeEventTypes(new int[]{163, 164, 165});
        if ("srv".equals(igniteInstanceName)) {
            cfg.setServiceConfiguration(new ServiceConfiguration[]{new ServiceConfiguration().setName(SVC_NAME).setService((Service)new SimpleServiceImpl()).setTotalCount(1)});
        }
        return cfg;
    }

    protected void beforeTest() throws Exception {
        evts.clear();
        this.stopAllGrids();
        IgniteEx g = this.startGrid("srv");
        g.events().localListen((IgnitePredicate)new IgnitePredicate<Event>(){

            public boolean apply(Event evt) {
                evts.add(evt);
                latch.countDown();
                return true;
            }
        }, new int[]{163, 164, 165});
        latch = new CountDownLatch(2);
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
    }

    @Test
    public void testSimpleServiceThinClient() throws Exception {
        try (IgniteClient thinClient = Ignition.startClient((ClientConfiguration)this.getClientConfiguration());){
            this.subjId = this.grid("srv").localNode().id();
            ClientServices services = thinClient.services();
            SimpleService simpleSvc = (SimpleService)services.serviceProxy(SVC_NAME, SimpleService.class, 1000L);
            String simpleValue = simpleSvc.simpleMethod("simpleValue");
            ServiceEventSubjectIdSelfTest.assertEquals((String)"simpleValue", (String)simpleValue);
        }
        ServiceEventSubjectIdSelfTest.assertTrue((String)"Failed to wait for service execution.", (boolean)latch.await(1L, TimeUnit.SECONDS));
        this.checkEvtsCnt();
        Iterator<Event> it = evts.iterator();
        UUID subjId = this.getSubjId(it);
        ServiceEventSubjectIdSelfTest.assertTrue((boolean)it.hasNext());
        Event evt = it.next();
        ServiceEventSubjectIdSelfTest.assertNotNull((Object)evt);
        ServiceEventSubjectIdSelfTest.assertEquals((int)163, (int)evt.type());
        ServiceEventSubjectIdSelfTest.assertEquals((Object)subjId, (Object)((ServiceEvent)evt).subjectId());
        ServiceEventSubjectIdSelfTest.assertEquals((String)SVC_NAME, (String)((ServiceEvent)evt).serviceName());
        ServiceEventSubjectIdSelfTest.assertEquals((String)"simpleMethod", (String)((ServiceEvent)evt).methodName());
        UUID startRequestId = ((ServiceEvent)evt).requestId();
        ServiceEventSubjectIdSelfTest.assertNotNull((Object)startRequestId);
        ServiceEventSubjectIdSelfTest.assertTrue((boolean)it.hasNext());
        evt = it.next();
        ServiceEventSubjectIdSelfTest.assertNotNull((Object)evt);
        ServiceEventSubjectIdSelfTest.assertEquals((int)164, (int)evt.type());
        ServiceEventSubjectIdSelfTest.assertEquals((Object)subjId, (Object)((ServiceEvent)evt).subjectId());
        ServiceEventSubjectIdSelfTest.assertEquals((String)SVC_NAME, (String)((ServiceEvent)evt).serviceName());
        ServiceEventSubjectIdSelfTest.assertEquals((String)"simpleMethod", (String)((ServiceEvent)evt).methodName());
        UUID finishRequestId = ((ServiceEvent)evt).requestId();
        ServiceEventSubjectIdSelfTest.assertNotNull((Object)finishRequestId);
        ServiceEventSubjectIdSelfTest.assertEquals((Object)startRequestId, (Object)finishRequestId);
    }

    @Test
    public void testSimpleService() throws Exception {
        try (IgniteEx thickClient = this.startGrid("cli");){
            this.subjId = thickClient.cluster().localNode().id();
            IgniteServices services = thickClient.services();
            SimpleService simpleSvc = (SimpleService)services.serviceProxy(SVC_NAME, SimpleService.class, true);
            String simpleValue = simpleSvc.simpleMethod("simpleValue");
            ServiceEventSubjectIdSelfTest.assertEquals((String)"simpleValue", (String)simpleValue);
        }
        ServiceEventSubjectIdSelfTest.assertTrue((String)"Failed to wait for service execution.", (boolean)latch.await(1L, TimeUnit.SECONDS));
        this.checkEvtsCnt();
        Iterator<Event> it = evts.iterator();
        UUID subjId = this.getSubjId(it);
        ServiceEventSubjectIdSelfTest.assertTrue((boolean)it.hasNext());
        ServiceEvent evt = (ServiceEvent)it.next();
        ServiceEventSubjectIdSelfTest.assertNotNull((Object)evt);
        ServiceEventSubjectIdSelfTest.assertEquals((int)163, (int)evt.type());
        ServiceEventSubjectIdSelfTest.assertEquals((Object)subjId, (Object)evt.subjectId());
        ServiceEventSubjectIdSelfTest.assertEquals((String)SVC_NAME, (String)evt.serviceName());
        ServiceEventSubjectIdSelfTest.assertEquals((String)"simpleMethod", (String)evt.methodName());
        UUID startRequestId = evt.requestId();
        ServiceEventSubjectIdSelfTest.assertNotNull((Object)startRequestId);
        ServiceEventSubjectIdSelfTest.assertTrue((boolean)it.hasNext());
        evt = (ServiceEvent)it.next();
        ServiceEventSubjectIdSelfTest.assertNotNull((Object)evt);
        ServiceEventSubjectIdSelfTest.assertEquals((int)164, (int)evt.type());
        ServiceEventSubjectIdSelfTest.assertEquals((Object)subjId, (Object)evt.subjectId());
        ServiceEventSubjectIdSelfTest.assertEquals((String)SVC_NAME, (String)evt.serviceName());
        ServiceEventSubjectIdSelfTest.assertEquals((String)"simpleMethod", (String)evt.methodName());
        UUID finishRequestId = evt.requestId();
        ServiceEventSubjectIdSelfTest.assertNotNull((Object)finishRequestId);
        ServiceEventSubjectIdSelfTest.assertEquals((Object)startRequestId, (Object)finishRequestId);
    }

    @Test
    public void testSimpleFailureService() throws Exception {
        try (IgniteEx thickClient = this.startGrid("cli");){
            this.subjId = thickClient.cluster().localNode().id();
            IgniteServices services = thickClient.services();
            SimpleService simpleSvc = (SimpleService)services.serviceProxy(SVC_NAME, SimpleService.class, true);
            GridTestUtils.assertThrows(null, simpleSvc::simpleFailureMethod, RuntimeException.class, (String)"test exception");
        }
        ServiceEventSubjectIdSelfTest.assertTrue((String)"Failed to wait for service execution.", (boolean)latch.await(1L, TimeUnit.SECONDS));
        this.checkEvtsCnt();
        Iterator<Event> it = evts.iterator();
        UUID subjId = this.getSubjId(it);
        ServiceEventSubjectIdSelfTest.assertTrue((boolean)it.hasNext());
        ServiceEvent evt = (ServiceEvent)it.next();
        ServiceEventSubjectIdSelfTest.assertNotNull((Object)evt);
        ServiceEventSubjectIdSelfTest.assertEquals((int)163, (int)evt.type());
        ServiceEventSubjectIdSelfTest.assertEquals((Object)subjId, (Object)evt.subjectId());
        ServiceEventSubjectIdSelfTest.assertEquals((String)SVC_NAME, (String)evt.serviceName());
        ServiceEventSubjectIdSelfTest.assertEquals((String)"simpleFailureMethod", (String)evt.methodName());
        UUID startRequestId = evt.requestId();
        ServiceEventSubjectIdSelfTest.assertNotNull((Object)startRequestId);
        ServiceEventSubjectIdSelfTest.assertTrue((boolean)it.hasNext());
        evt = (ServiceEvent)it.next();
        ServiceEventSubjectIdSelfTest.assertNotNull((Object)evt);
        ServiceEventSubjectIdSelfTest.assertEquals((int)165, (int)evt.type());
        ServiceEventSubjectIdSelfTest.assertEquals((Object)subjId, (Object)evt.subjectId());
        ServiceEventSubjectIdSelfTest.assertEquals((String)SVC_NAME, (String)evt.serviceName());
        ServiceEventSubjectIdSelfTest.assertEquals((String)"simpleFailureMethod", (String)evt.methodName());
        UUID finishRequestId = evt.requestId();
        ServiceEventSubjectIdSelfTest.assertNotNull((Object)finishRequestId);
        ServiceEventSubjectIdSelfTest.assertEquals((Object)startRequestId, (Object)finishRequestId);
    }

    protected ClientConfiguration getClientConfiguration() {
        return new ClientConfiguration().setAddresses(new String[]{"127.0.0.1:" + this.grid("srv").localNode().attribute("clientListenerPort")});
    }

    protected void checkEvtsCnt() {
        ServiceEventSubjectIdSelfTest.assertEquals((int)2, (int)evts.size());
    }

    protected UUID getSubjId(Iterator<Event> it) {
        return this.subjId;
    }

    public static class SimpleServiceImpl
    implements SimpleService {
        @Override
        public String simpleMethod(String simpleArg) {
            return simpleArg;
        }

        @Override
        public String simpleFailureMethod() {
            throw new RuntimeException("test exception");
        }

        public void init(ServiceContext ctx) throws Exception {
        }

        public void execute(ServiceContext ctx) throws Exception {
        }

        public void cancel(ServiceContext ctx) {
        }
    }

    public static interface SimpleService
    extends Service {
        public String simpleMethod(String var1);

        public String simpleFailureMethod();
    }
}

