/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.loadtests.client;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Random;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientData;
import org.apache.ignite.internal.client.GridClientDataAffinity;
import org.apache.ignite.internal.client.GridClientDataConfiguration;
import org.apache.ignite.internal.client.GridClientException;
import org.apache.ignite.internal.client.GridClientFactory;
import org.apache.ignite.internal.client.GridClientPartitionAffinity;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.GridFileLock;
import org.apache.ignite.testframework.GridLoadTestUtils;

public class ClientCacheBenchmark {
    private static final int KEY_COUNT = 1000;
    private static final int VALUE_LENGTH = 4096;
    private static final byte[][] values = new byte[1000][];
    private static final double WRITE_PROB = 0.2;
    private final Random rnd = new Random();
    private final int threadCnt;
    private final int iterationCnt;
    private GridClient client;
    private double itersPerSec;

    public ClientCacheBenchmark(int threadCnt, int iterationCnt) {
        this.threadCnt = threadCnt;
        this.iterationCnt = iterationCnt;
        this.initValues();
    }

    private void initValues() {
        for (int i = 0; i < 1000; ++i) {
            ClientCacheBenchmark.values[i] = new byte[4096];
            this.rnd.nextBytes(values[i]);
        }
    }

    public void run(boolean printResults) throws GridClientException {
        ArrayList<TestThread> workers = new ArrayList<TestThread>(this.threadCnt);
        this.client = GridClientFactory.start((GridClientConfiguration)this.configuration());
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < this.threadCnt; ++i) {
            TestThread th = new TestThread();
            workers.add(th);
            th.start();
        }
        U.joinThreads(workers, null);
        if (printResults) {
            this.countAndPrintSummary(workers, startTime);
        }
        GridClientFactory.stopAll();
    }

    public double getItersPerSec() {
        return this.itersPerSec;
    }

    private void countAndPrintSummary(Collection<TestThread> workers, long startTime) {
        long total = 0L;
        int thCnt = workers.size();
        for (TestThread t : workers) {
            total += t.iters;
        }
        double timeSpent = (double)(System.currentTimeMillis() - startTime) / 1000.0;
        this.itersPerSec = (double)total / timeSpent;
        System.out.printf("%8s, %12.0f, %12.0f, %12s\n", thCnt, this.itersPerSec, (double)total / timeSpent / (double)thCnt, total);
    }

    private GridClientConfiguration configuration() {
        GridClientConfiguration cfg = new GridClientConfiguration();
        cfg.setServers(Collections.singleton("localhost:11211"));
        GridClientDataConfiguration cacheCfg = new GridClientDataConfiguration();
        cacheCfg.setName("partitioned");
        cacheCfg.setAffinity((GridClientDataAffinity)new GridClientPartitionAffinity());
        cfg.setDataConfigurations(Collections.singletonList(cacheCfg));
        return cfg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws GridClientException, IgniteCheckedException {
        fileLock.lock();
        try (GridFileLock fileLock = GridLoadTestUtils.fileLock();){
            System.out.printf("%8s, %12s, %12s, %12s\n", "Threads", "It./s.", "It./s.*th.", "Iters.");
            if (args.length == 0) {
                ClientCacheBenchmark benchmark;
                int i;
                for (i = 1; i <= 16; i *= 2) {
                    benchmark = new ClientCacheBenchmark(i, 10000);
                    benchmark.run(false);
                    System.gc();
                }
                for (i = 1; i <= 64; i *= 2) {
                    benchmark = new ClientCacheBenchmark(i, 10000);
                    benchmark.run(true);
                    System.gc();
                }
            } else {
                int nThreads = Integer.parseInt(args[0]);
                String outputFileName = args.length >= 2 ? args[1] : null;
                ClientCacheBenchmark benchmark = null;
                for (int i = 0; i < 2; ++i) {
                    benchmark = new ClientCacheBenchmark(nThreads, 10000);
                    benchmark.run(true);
                }
                if (outputFileName != null) {
                    X.println((String)("Writing test results to a file: " + outputFileName), (Object[])new Object[0]);
                    assert (benchmark != null);
                    try {
                        GridLoadTestUtils.appendLineToFile((String)outputFileName, (String)"%s,%d", (Object[])new Object[]{IgniteUtils.LONG_DATE_FMT.format(Instant.now()), Math.round(benchmark.getItersPerSec())});
                    }
                    catch (IOException e) {
                        X.error((String)"Failed to output to a file", (Object[])new Object[]{e});
                    }
                }
            }
        }
    }

    private class TestThread
    extends Thread {
        private final Random rnd = new Random();
        private long iters;

        private TestThread() {
        }

        @Override
        public void run() {
            try {
                GridClientData data = ClientCacheBenchmark.this.client.data("partitioned");
                for (int i = 0; i < ClientCacheBenchmark.this.iterationCnt; ++i) {
                    this.performIteration(data);
                }
            }
            catch (GridClientException e) {
                e.printStackTrace();
            }
        }

        private void performIteration(GridClientData data) throws GridClientException {
            if (this.rnd.nextDouble() <= 0.2) {
                data.put((Object)this.rnd.nextInt(1000), (Object)values[this.rnd.nextInt(1000)]);
            } else {
                data.get((Object)this.rnd.nextInt(1000));
            }
            ++this.iters;
        }
    }
}

