/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc.thin;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.jdbc.thin.AffinityCache;
import org.apache.ignite.internal.jdbc.thin.JdbcThinConnection;
import org.apache.ignite.internal.jdbc.thin.JdbcThinTcpIo;
import org.apache.ignite.internal.jdbc.thin.QualifiedSQLQuery;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionSingleNode;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.jdbc.thin.JdbcThinAbstractSelfTest;
import org.apache.ignite.testframework.GridTestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class JdbcThinPartitionAwarenessReconnectionAndFailoverSelfTest
extends JdbcThinAbstractSelfTest {
    private static final int ROWS_COUNT = 100;
    private static final String URL = "jdbc:ignite:thin://127.0.0.1:10800..10802?partitionAwareness=true";
    public static final String URL_WITH_ONE_PORT = "jdbc:ignite:thin://127.0.0.1:10800?partitionAwareness=true";
    private static final int INITIAL_NODES_CNT = 3;
    private static LogHandler logHnd;

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGridsMultiThreaded(3);
        Logger log = Logger.getLogger(JdbcThinConnection.class.getName());
        logHnd = new LogHandler();
        logHnd.setLevel(Level.ALL);
        log.setUseParentHandlers(false);
        log.addHandler(logHnd);
        log.setLevel(Level.ALL);
    }

    @Test
    public void testBackgroundConnectionEstablishment() throws Exception {
        try (Connection conn = DriverManager.getConnection(URL);){
            Map ios = (Map)GridTestUtils.getFieldValue((Object)conn, (String[])new String[]{"ios"});
            this.assertConnectionsCount(ios, 3);
        }
    }

    @Test
    public void testConnectionFailover() throws Exception {
        try (Connection conn = DriverManager.getConnection(URL);){
            Map ios = (Map)GridTestUtils.getFieldValue((Object)conn, (String[])new String[]{"ios"});
            this.assertConnectionsCount(ios, 3);
            JdbcThinPartitionAwarenessReconnectionAndFailoverSelfTest.assertEquals((String)"Unexpected connections count.", (int)3, (int)ios.size());
            this.stopGrid(1);
            this.invalidateConnectionToStoppedNode(conn);
            JdbcThinPartitionAwarenessReconnectionAndFailoverSelfTest.assertEquals((String)"Unexpected connections count.", (int)2, (int)ios.size());
            this.startGrid(1);
            this.assertConnectionsCount(ios, 3);
        }
    }

    @Test
    public void testTotalConnectionFailover() throws Exception {
        try (Connection conn = DriverManager.getConnection(URL);){
            int i;
            Map ios = (Map)GridTestUtils.getFieldValue((Object)conn, (String[])new String[]{"ios"});
            this.assertConnectionsCount(ios, 3);
            for (i = 0; i < 3; ++i) {
                this.stopGrid(i);
                this.invalidateConnectionToStoppedNode(conn);
            }
            this.assertConnectionsCount(ios, 0);
            for (i = 0; i < 3; ++i) {
                this.startGrid(i);
            }
            this.assertConnectionsCount(ios, 3);
        }
    }

    @Test
    public void testEagerConnectionFailover() throws Exception {
        try (Connection conn = DriverManager.getConnection(URL);){
            int i;
            Map ios = (Map)GridTestUtils.getFieldValue((Object)conn, (String[])new String[]{"ios"});
            this.assertConnectionsCount(ios, 3);
            for (i = 0; i < 3; ++i) {
                this.stopGrid(i);
                this.invalidateConnectionToStoppedNode(conn);
            }
            JdbcThinPartitionAwarenessReconnectionAndFailoverSelfTest.assertEquals((String)"Unexpected connections count.", (int)0, (int)ios.size());
            JdbcThinPartitionAwarenessReconnectionAndFailoverSelfTest.doSleep((long)800L);
            for (i = 0; i < 3; ++i) {
                this.startGrid(i);
            }
            conn.createStatement().execute("select 1;");
            this.assertConnectionsCount(ios, 3);
        }
    }

    @Test
    public void testReconnectionDelayIncreasing() throws Exception {
        try (Connection ignored = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1:10800,127.0.0.1:10810?partitionAwareness=true");){
            logHnd.records.clear();
            JdbcThinPartitionAwarenessReconnectionAndFailoverSelfTest.doSleep((long)1800L);
            JdbcThinPartitionAwarenessReconnectionAndFailoverSelfTest.assertEquals((String)"Unexpected log records count.", (int)4, (int)logHnd.records.size());
            String expRecordMsg = "Failed to connect to Ignite node [url=jdbc:ignite:thin://127.0.0.1:10800,127.0.0.1:10810]. address = [";
            for (LogRecord record : logHnd.records) {
                Assert.assertThat((String)"Unexpected log record text.", (Object)record.getMessage(), (Matcher)Matchers.startsWith((String)expRecordMsg));
                JdbcThinPartitionAwarenessReconnectionAndFailoverSelfTest.assertEquals((String)"Unexpected log level", (Object)Level.WARNING, (Object)record.getLevel());
            }
        }
    }

    @Test
    public void testReconnectionDelaySelectiveIncreasing() throws Exception {
        try (Connection conn = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1:10800..10801?partitionAwareness=true");){
            this.stopGrid(0);
            this.invalidateConnectionToStoppedNode(conn);
            Map ios = (Map)GridTestUtils.getFieldValue((Object)conn, (String[])new String[]{"ios"});
            JdbcThinPartitionAwarenessReconnectionAndFailoverSelfTest.assertEquals((String)"Unexpected connections count.", (int)1, (int)ios.size());
            logHnd.records.clear();
            JdbcThinPartitionAwarenessReconnectionAndFailoverSelfTest.doSleep((long)1800L);
            JdbcThinPartitionAwarenessReconnectionAndFailoverSelfTest.assertEquals((String)"Unexpected log records count.", (int)4, (int)logHnd.records.size());
            String expRecordMsg = "Failed to connect to Ignite node [url=jdbc:ignite:thin://127.0.0.1:10800..10801]. address = [";
            for (LogRecord record : logHnd.records) {
                Assert.assertThat((String)"Unexpected log record text.", (Object)record.getMessage(), (Matcher)Matchers.startsWith((String)expRecordMsg));
                JdbcThinPartitionAwarenessReconnectionAndFailoverSelfTest.assertEquals((String)"Unexpected log level", (Object)Level.WARNING, (Object)record.getLevel());
            }
            this.startGrid(0);
            logHnd.records.clear();
            JdbcThinPartitionAwarenessReconnectionAndFailoverSelfTest.doSleep((long)1800L);
            JdbcThinPartitionAwarenessReconnectionAndFailoverSelfTest.assertEquals((String)"Unexpected log records count.", (int)0, (int)logHnd.records.size());
            JdbcThinPartitionAwarenessReconnectionAndFailoverSelfTest.assertEquals((String)"Unexpected connections count.", (int)2, (int)ios.size());
            this.stopGrid(0);
            this.invalidateConnectionToStoppedNode(conn);
            JdbcThinPartitionAwarenessReconnectionAndFailoverSelfTest.assertEquals((String)"Unexpected connections count.", (int)1, (int)ios.size());
            logHnd.records.clear();
            JdbcThinPartitionAwarenessReconnectionAndFailoverSelfTest.doSleep((long)1800L);
            JdbcThinPartitionAwarenessReconnectionAndFailoverSelfTest.assertEquals((String)"Unexpected log records count.", (int)4, (int)logHnd.records.size());
            for (LogRecord record : logHnd.records) {
                Assert.assertThat((String)"Unexpected log record text.", (Object)record.getMessage(), (Matcher)Matchers.startsWith((String)expRecordMsg));
                JdbcThinPartitionAwarenessReconnectionAndFailoverSelfTest.assertEquals((String)"Unexpected log level", (Object)Level.WARNING, (Object)record.getLevel());
            }
            this.startGrid(0);
        }
    }

    @Test
    public void testSQLExceptionFailover() throws Exception {
        try (final Connection conn = DriverManager.getConnection(URL);){
            logHnd.records.clear();
            GridTestUtils.assertThrows(null, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    conn.createStatement().execute("select invalid column name.");
                    return null;
                }
            }, SQLException.class, (String)"Failed to parse query.");
        }
        JdbcThinPartitionAwarenessReconnectionAndFailoverSelfTest.assertEquals((String)"Unexpected log records count.", (int)1, (int)logHnd.records.size());
        LogRecord record = (LogRecord)logHnd.records.get(0);
        JdbcThinPartitionAwarenessReconnectionAndFailoverSelfTest.assertEquals((String)"Unexpected log record text.", (String)"Exception during sending an sql request.", (String)record.getMessage());
        JdbcThinPartitionAwarenessReconnectionAndFailoverSelfTest.assertEquals((String)"Unexpected log level", (Object)Level.FINE, (Object)record.getLevel());
    }

    @Test
    public void testQueryFailover() throws Exception {
        try (Connection conn = DriverManager.getConnection(URL);){
            String cacheName = UUID.randomUUID().toString().substring(0, 6);
            String sql = "select * from \"" + cacheName + "\".Person where _key = 1";
            CacheConfiguration<Object, Object> cache = this.prepareCacheConfig(cacheName);
            this.ignite(0).createCache(cache);
            this.fillCache(cacheName);
            Statement stmt = conn.createStatement();
            stmt.execute(sql);
            stmt.execute(sql);
            AffinityCache affinityCache = (AffinityCache)GridTestUtils.getFieldValue((Object)conn, (String[])new String[]{"affinityCache"});
            Integer part = ((PartitionSingleNode)affinityCache.partitionResult(new QualifiedSQLQuery("PUBLIC", sql)).partitionResult().tree()).value();
            UUID nodeId = affinityCache.cacheDistribution(GridCacheUtils.cacheId((String)cacheName))[part];
            int gridIdx = new Integer(Ignition.ignite((UUID)nodeId).name().substring(this.getTestIgniteInstanceName().length()));
            this.stopGrid(gridIdx);
            logHnd.records.clear();
            conn.createStatement().execute(sql);
            this.startGrid(gridIdx);
        }
        JdbcThinPartitionAwarenessReconnectionAndFailoverSelfTest.assertEquals((String)"Unexpected log records count.", (int)1, (int)logHnd.records.size());
        LogRecord record = (LogRecord)logHnd.records.get(0);
        JdbcThinPartitionAwarenessReconnectionAndFailoverSelfTest.assertEquals((String)"Unexpected log record text.", (String)"Exception during sending an sql request.", (String)record.getMessage());
        JdbcThinPartitionAwarenessReconnectionAndFailoverSelfTest.assertEquals((String)"Unexpected log level", (Object)Level.FINE, (Object)record.getLevel());
    }

    @Test
    public void testFailoverOnAllNodes() throws Exception {
        try (final Connection conn = DriverManager.getConnection(URL);){
            Map ios = (Map)GridTestUtils.getFieldValue((Object)conn, (String[])new String[]{"ios"});
            this.assertConnectionsCount(ios, 3);
            this.stopAllGrids();
            logHnd.records.clear();
            GridTestUtils.assertThrows(null, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    conn.createStatement().execute("select 1");
                    return null;
                }
            }, SQLException.class, (String)"Failed to connect to server [url=jdbc:ignite:thin://127.0.0.1:10800..10802]");
        }
        JdbcThinPartitionAwarenessReconnectionAndFailoverSelfTest.assertEquals((String)"Unexpected log records count.", (int)3, (int)logHnd.records.size());
        for (LogRecord record : logHnd.records) {
            JdbcThinPartitionAwarenessReconnectionAndFailoverSelfTest.assertEquals((String)"Unexpected log record text.", (String)"Exception during sending an sql request.", (String)record.getMessage());
            JdbcThinPartitionAwarenessReconnectionAndFailoverSelfTest.assertEquals((String)"Unexpected log level", (Object)Level.FINE, (Object)record.getLevel());
        }
        this.startGridsMultiThreaded(3);
    }

    @Test
    public void testFailoverLimit() throws Exception {
        this.startGrid(3);
        this.startGrid(4);
        this.startGrid(5);
        try (final Connection conn = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1:10800..10805?partitionAwareness=true");){
            Map ios = (Map)GridTestUtils.getFieldValue((Object)conn, (String[])new String[]{"ios"});
            this.assertConnectionsCount(ios, 6);
            this.stopAllGrids();
            logHnd.records.clear();
            GridTestUtils.assertThrows(null, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    conn.createStatement().execute("select 1");
                    return null;
                }
            }, SQLException.class, (String)"Failed to communicate with Ignite cluster.");
            JdbcThinPartitionAwarenessReconnectionAndFailoverSelfTest.assertEquals((String)"Unexpected connections count.", (int)1, (int)ios.keySet().size());
        }
        JdbcThinPartitionAwarenessReconnectionAndFailoverSelfTest.assertEquals((String)"Unexpected log records count.", (int)5, (int)logHnd.records.size());
        for (LogRecord record : logHnd.records) {
            JdbcThinPartitionAwarenessReconnectionAndFailoverSelfTest.assertEquals((String)"Unexpected log record text.", (String)"Exception during sending an sql request.", (String)record.getMessage());
            JdbcThinPartitionAwarenessReconnectionAndFailoverSelfTest.assertEquals((String)"Unexpected log level", (Object)Level.FINE, (Object)record.getLevel());
        }
        this.startGridsMultiThreaded(3);
    }

    @Test
    public void testTransactionalQueryFailover() throws Exception {
        try (Connection conn = DriverManager.getConnection(URL_WITH_ONE_PORT);){
            String cacheName = UUID.randomUUID().toString().substring(0, 6);
            final String sql = "select 1 from \"" + cacheName + "\".Person";
            CacheConfiguration cache = JdbcThinPartitionAwarenessReconnectionAndFailoverSelfTest.defaultCacheConfiguration().setName(cacheName).setNearConfiguration(null).setIndexedTypes(new Class[]{Integer.class, Person.class}).setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT);
            this.ignite(0).createCache(cache);
            final Statement stmt = conn.createStatement();
            stmt.execute("BEGIN");
            stmt.execute(sql);
            this.stopGrid(0);
            logHnd.records.clear();
            GridTestUtils.assertThrows(null, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    stmt.execute(sql);
                    return null;
                }
            }, SQLException.class, (String)"Failed to communicate with Ignite cluster.");
        }
        JdbcThinPartitionAwarenessReconnectionAndFailoverSelfTest.assertEquals((String)"Unexpected log records count.", (int)1, (int)logHnd.records.size());
        LogRecord record = (LogRecord)logHnd.records.get(0);
        JdbcThinPartitionAwarenessReconnectionAndFailoverSelfTest.assertEquals((String)"Unexpected log record text.", (String)"Exception during sending an sql request.", (String)record.getMessage());
        JdbcThinPartitionAwarenessReconnectionAndFailoverSelfTest.assertEquals((String)"Unexpected log level", (Object)Level.FINE, (Object)record.getLevel());
        this.startGrid(0);
    }

    @Test
    public void testNoRetriesOccurred() throws Exception {
        this.checkNoRetriesOccurred(() -> {
            try (Connection conn = DriverManager.getConnection(URL_WITH_ONE_PORT);){
                Statement stmt = conn.createStatement();
                ResultSet rs = stmt.executeQuery("select 1");
                this.stopGrid(0);
                rs.getMetaData();
            }
            return null;
        });
        this.startGrid(0);
        this.checkNoRetriesOccurred(() -> {
            try (Connection conn = DriverManager.getConnection(URL_WITH_ONE_PORT);){
                Statement stmt = conn.createStatement();
                this.stopGrid(0);
                stmt.executeQuery("select 1; select 2");
            }
            return null;
        });
        this.startGrid(0);
        this.checkNoRetriesOccurred(() -> {
            try (Connection conn = DriverManager.getConnection(URL_WITH_ONE_PORT);){
                Statement stmt = conn.createStatement();
                this.stopGrid(0);
                stmt.execute("CREATE TABLE PARENT" + UUID.randomUUID().toString().substring(0, 6) + " (ID INT, NAME VARCHAR, PRIMARY KEY(ID));");
            }
            return null;
        });
        this.startGrid(0);
        this.checkNoRetriesOccurred(() -> {
            try (Connection conn = DriverManager.getConnection(URL_WITH_ONE_PORT);){
                Statement stmt = conn.createStatement();
                String tblName = "PARENT" + UUID.randomUUID().toString().substring(0, 6);
                stmt.execute("CREATE TABLE " + tblName + " (ID INT, NAME VARCHAR, PRIMARY KEY(ID));");
                this.stopGrid(0);
                stmt.execute("INSERT INTO" + tblName + " (ID, NAME) VALUES(1, 'aaa')");
            }
            return null;
        });
        this.startGrid(0);
    }

    @Test
    public void testMetadataQueries() throws Exception {
        this.checkRetriesOccurred(() -> {
            try (Connection conn = DriverManager.getConnection(URL_WITH_ONE_PORT);){
                this.stopGrid(0);
                conn.getMetaData().getTables(null, null, null, null);
            }
            return null;
        });
        this.startGrid(0);
        this.checkRetriesOccurred(() -> {
            try (Connection conn = DriverManager.getConnection(URL_WITH_ONE_PORT);){
                this.stopGrid(0);
                conn.getMetaData().getColumns(null, null, null, null);
            }
            return null;
        });
        this.startGrid(0);
        this.checkRetriesOccurred(() -> {
            try (Connection conn = DriverManager.getConnection(URL_WITH_ONE_PORT);){
                this.stopGrid(0);
                conn.getMetaData().getIndexInfo(null, null, null, false, false);
            }
            return null;
        });
        this.startGrid(0);
        this.checkRetriesOccurred(() -> {
            try (Connection conn = DriverManager.getConnection(URL_WITH_ONE_PORT);){
                this.stopGrid(0);
                PreparedStatement preparedStmt = conn.prepareStatement("select 1");
                preparedStmt.getParameterMetaData();
            }
            return null;
        });
        this.startGrid(0);
        this.checkRetriesOccurred(() -> {
            try (Connection conn = DriverManager.getConnection(URL_WITH_ONE_PORT);){
                this.stopGrid(0);
                conn.getMetaData().getPrimaryKeys(null, null, null);
            }
            return null;
        });
        this.startGrid(0);
        this.checkRetriesOccurred(() -> {
            try (Connection conn = DriverManager.getConnection(URL_WITH_ONE_PORT);){
                this.stopGrid(0);
                conn.getMetaData().getSchemas(null, null);
            }
            return null;
        });
        this.startGrid(0);
    }

    private void checkRetriesOccurred(final Callable queriesToTest) {
        logHnd.records.clear();
        GridTestUtils.assertThrows(null, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                queriesToTest.call();
                return null;
            }
        }, SQLException.class, (String)"Failed to connect to server");
        JdbcThinPartitionAwarenessReconnectionAndFailoverSelfTest.assertEquals((String)"Unexpected log records count.", (int)1, (int)logHnd.records.size());
        LogRecord record = (LogRecord)logHnd.records.get(0);
        JdbcThinPartitionAwarenessReconnectionAndFailoverSelfTest.assertEquals((String)"Unexpected log record text.", (String)"Exception during sending an sql request.", (String)record.getMessage());
        JdbcThinPartitionAwarenessReconnectionAndFailoverSelfTest.assertEquals((String)"Unexpected log level", (Object)Level.FINE, (Object)record.getLevel());
    }

    private void checkNoRetriesOccurred(final Callable queriesToTest) {
        logHnd.records.clear();
        GridTestUtils.assertThrows(null, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                queriesToTest.call();
                return null;
            }
        }, SQLException.class, (String)"Failed to communicate with Ignite cluster.");
        JdbcThinPartitionAwarenessReconnectionAndFailoverSelfTest.assertEquals((String)"Unexpected log records count.", (int)1, (int)logHnd.records.size());
        LogRecord record = (LogRecord)logHnd.records.get(0);
        JdbcThinPartitionAwarenessReconnectionAndFailoverSelfTest.assertEquals((String)"Unexpected log record text.", (String)"Exception during sending an sql request.", (String)record.getMessage());
        JdbcThinPartitionAwarenessReconnectionAndFailoverSelfTest.assertEquals((String)"Unexpected log level", (Object)Level.FINE, (Object)record.getLevel());
    }

    private void assertConnectionsCount(Map<UUID, JdbcThinTcpIo> ios, int expConnCnt) throws IgniteInterruptedCheckedException {
        boolean allConnectionsEstablished = GridTestUtils.waitForCondition(() -> ios.size() == expConnCnt, (long)10000L);
        JdbcThinPartitionAwarenessReconnectionAndFailoverSelfTest.assertTrue((String)"Unexpected connections count.", (boolean)allConnectionsEstablished);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void invalidateConnectionToStoppedNode(Connection conn) {
        try {
            while (true) {
                Statement stmt;
                block12: {
                    stmt = conn.createStatement();
                    Throwable throwable = null;
                    try {
                        stmt.execute("select ';';");
                        if (stmt == null) continue;
                        if (throwable == null) break block12;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (stmt == null) throw throwable3;
                            if (throwable == null) {
                                stmt.close();
                                throw throwable3;
                            }
                            try {
                                stmt.close();
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                                throw throwable3;
                            }
                        }
                    }
                    try {
                        stmt.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    continue;
                }
                stmt.close();
            }
        }
        catch (SQLException e) {
            return;
        }
    }

    protected CacheConfiguration<Object, Object> prepareCacheConfig(String cacheName) {
        CacheConfiguration cache = JdbcThinPartitionAwarenessReconnectionAndFailoverSelfTest.defaultCacheConfiguration();
        cache.setName(cacheName);
        cache.setCacheMode(CacheMode.PARTITIONED);
        cache.setBackups(1);
        cache.setIndexedTypes(new Class[]{Integer.class, Person.class});
        return cache;
    }

    private void fillCache(String cacheName) {
        IgniteCache cachePerson = this.grid(0).cache(cacheName);
        assert (cachePerson != null);
        for (int i = 0; i < 100; ++i) {
            cachePerson.put((Object)i, (Object)new Person(i, "John" + i, "White" + i, i + 1));
        }
    }

    private static class Person
    implements Serializable {
        @QuerySqlField
        private final int id;
        @QuerySqlField
        private final String firstName;
        @QuerySqlField
        private final String lastName;
        @QuerySqlField
        private final int age;

        private Person(int id, String firstName, String lastName, int age) {
            assert (!F.isEmpty((String)firstName));
            assert (!F.isEmpty((String)lastName));
            assert (age > 0);
            this.id = id;
            this.firstName = firstName;
            this.lastName = lastName;
            this.age = age;
        }
    }

    static class LogHandler
    extends Handler {
        private final List<LogRecord> records = new ArrayList<LogRecord>();

        LogHandler() {
        }

        @Override
        public void publish(LogRecord record) {
            this.records.add(record);
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        public List<LogRecord> records() {
            return this.records;
        }
    }
}

