/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc.thin;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Random;
import java.util.UUID;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.AbstractDataTypesCoverageTest;
import org.apache.ignite.sqltests.SqlDataTypesCoverageTests;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class JdbcThinJdbcToCacheDataTypesCoverageTest
extends SqlDataTypesCoverageTests {
    public static boolean affinityAwareness;
    private String url = affinityAwareness ? "jdbc:ignite:thin://127.0.0.1:10800..10802?affinityAwareness=true" : "jdbc:ignite:thin://127.0.0.1?affinityAwareness=false";
    private Connection conn;
    private Statement stmt;

    protected void beforeTestsStarted() throws Exception {
        System.setProperty("IGNITE_DISABLE_CREATE_LUCENE_INDEX_FOR_STRING", "true");
        super.beforeTestsStarted();
    }

    @Before
    public void init() throws Exception {
        super.init();
        this.conn = DriverManager.getConnection(this.url);
        this.stmt = this.conn.createStatement();
        assert (this.stmt != null);
        assert (!this.stmt.isClosed());
    }

    @After
    public void tearDown() throws Exception {
        if (this.stmt != null && !this.stmt.isClosed()) {
            this.stmt.close();
            assert (this.stmt.isClosed());
        }
        if (this.conn != null && !this.conn.isClosed()) {
            this.conn.close();
            assert (this.conn.isClosed());
        }
    }

    @Test
    public void testTimeDataType() throws Exception {
        super.testTimeDataType();
    }

    @Test
    public void testSmallIntDataType() throws Exception {
        super.testSmallIntDataType();
    }

    @Test
    public void testBinaryDataType() throws Exception {
        super.testBinaryDataType();
    }

    @Test
    public void testGeometryDataType() throws Exception {
        super.testGeometryDataType();
    }

    @Ignore(value="https://ggsystems.atlassian.net/browse/GG-23665")
    @Test
    public void testDateDataType() throws Exception {
        super.testDateDataType();
    }

    @Test
    public void testTinyIntDataType() throws Exception {
        super.testTinyIntDataType();
    }

    protected void checkBasicSqlOperations(SqlDataTypesCoverageTests.SqlDataType dataType, Object ... valsToCheck) throws Exception {
        assert (valsToCheck.length > 0);
        IgniteEx ignite = this.cacheMode == CacheMode.LOCAL || this.writeSyncMode == CacheWriteSynchronizationMode.PRIMARY_SYNC ? this.grid(0) : this.grid(new Random().nextInt(3));
        String uuidPostfix = UUID.randomUUID().toString().replaceAll("-", "_");
        String tblName = "table" + uuidPostfix;
        String templateName = "template" + uuidPostfix;
        String cacheName = "cache" + uuidPostfix;
        String idxName = "idx" + uuidPostfix;
        CacheConfiguration cfg = new CacheConfiguration(templateName).setAtomicityMode(this.atomicityMode).setCacheMode(this.cacheMode).setExpiryPolicyFactory(this.ttlFactory).setBackups(this.backups).setEvictionPolicyFactory(this.evictionFactory).setOnheapCacheEnabled(this.evictionFactory != null || this.onheapCacheEnabled).setWriteSynchronizationMode(this.writeSyncMode).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 16));
        ignite.addCacheConfiguration(cfg);
        this.stmt.execute("CREATE TABLE " + tblName + "(id " + dataType + " PRIMARY KEY, val " + dataType + ") WITH \"template=" + templateName + ",cache_name=" + cacheName + ",wrap_value=false\"");
        if (this.cacheMode != CacheMode.LOCAL) {
            this.stmt.execute("CREATE INDEX " + idxName + " ON " + tblName + "(id, val)");
        }
        for (Object valToCheck : valsToCheck) {
            Object sqlStrVal = valToCheck instanceof AbstractDataTypesCoverageTest.SqlStrConvertedValHolder ? ((AbstractDataTypesCoverageTest.SqlStrConvertedValHolder)valToCheck).sqlStrVal() : valToCheck;
            Object orignialVal = valToCheck instanceof AbstractDataTypesCoverageTest.SqlStrConvertedValHolder ? ((AbstractDataTypesCoverageTest.SqlStrConvertedValHolder)valToCheck).originalVal() : valToCheck;
            this.stmt.execute("INSERT INTO " + tblName + "(id, val)  VALUES (" + sqlStrVal + ", " + sqlStrVal + ");");
            if (this.writeSyncMode == CacheWriteSynchronizationMode.FULL_ASYNC && !GridTestUtils.waitForCondition(() -> ignite.cache(cacheName).get(orignialVal) != null, (long)10000L)) {
                JdbcThinJdbcToCacheDataTypesCoverageTest.fail((String)"Unable to retrieve data via cache get.");
            }
            Object gotVal = ignite.cache(cacheName).get(orignialVal);
            JdbcThinJdbcToCacheDataTypesCoverageTest.assertNotNull((Object)gotVal);
            JdbcThinJdbcToCacheDataTypesCoverageTest.assertEquals((String)"Unexpected data type found.", orignialVal.getClass(), gotVal.getClass());
            if (orignialVal instanceof byte[]) {
                JdbcThinJdbcToCacheDataTypesCoverageTest.assertTrue((String)"Unexpected value found.", (boolean)Arrays.equals((byte[])orignialVal, (byte[])gotVal));
            } else {
                JdbcThinJdbcToCacheDataTypesCoverageTest.assertEquals((String)"Unexpected value found.", (Object)orignialVal, (Object)gotVal);
            }
            ignite.cache(cacheName).remove(orignialVal);
            if (this.writeSyncMode == CacheWriteSynchronizationMode.FULL_ASYNC && !GridTestUtils.waitForCondition(() -> ignite.cache(cacheName).get(orignialVal) == null, (long)10000L)) {
                JdbcThinJdbcToCacheDataTypesCoverageTest.fail((String)"Deleted data are still retrievable via cache.get().");
            }
            JdbcThinJdbcToCacheDataTypesCoverageTest.assertNull((Object)ignite.cache(cacheName).get(orignialVal));
        }
    }
}

