/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc.thin;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.Callable;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.jdbc.thin.JdbcThinAbstractDmlStatementSelfTest;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.ListeningTestLogger;
import org.apache.ignite.testframework.LogListener;
import org.junit.Test;

public class JdbcThinInsertStatementSelfTest
extends JdbcThinAbstractDmlStatementSelfTest {
    private static final String SQL = "insert into Person(_key, id, firstName, lastName, age) values ('p1', 1, 'John', 'White', 25), ('p2', 2, 'Joe', 'Black', 35), ('p3', 3, 'Mike', 'Green', 40)";
    private static final String SQL_PREPARED = "insert into Person(_key, id, firstName, lastName, age) values (?, ?, ?, ?, ?), (?, ?, ?, ?, ?), (?, ?, ?, ?, ?)";
    private final Object[][] args = new Object[][]{{"p1", 1, "John", "White", 25}, {"p3", 3, "Mike", "Green", 40}, {"p2", 2, "Joe", "Black", 35}};
    private static ListeningTestLogger srvLog;
    private Statement stmt;
    private PreparedStatement prepStmt;

    @Override
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        return super.getConfiguration(igniteInstanceName).setGridLogger((IgniteLogger)srvLog);
    }

    @Override
    protected void beforeTestsStarted() throws Exception {
        srvLog = new ListeningTestLogger(log);
        super.beforeTestsStarted();
    }

    @Override
    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.stmt = this.conn.createStatement();
        this.prepStmt = this.conn.prepareStatement(SQL_PREPARED);
        JdbcThinInsertStatementSelfTest.assertNotNull((Object)this.stmt);
        JdbcThinInsertStatementSelfTest.assertFalse((boolean)this.stmt.isClosed());
        JdbcThinInsertStatementSelfTest.assertNotNull((Object)this.prepStmt);
        JdbcThinInsertStatementSelfTest.assertFalse((boolean)this.prepStmt.isClosed());
        int paramCnt = 1;
        for (Object[] arg : this.args) {
            this.prepStmt.setString(paramCnt++, (String)arg[0]);
            this.prepStmt.setInt(paramCnt++, (Integer)arg[1]);
            this.prepStmt.setString(paramCnt++, (String)arg[2]);
            this.prepStmt.setString(paramCnt++, (String)arg[3]);
            this.prepStmt.setInt(paramCnt++, (Integer)arg[4]);
        }
    }

    @Override
    protected void afterTest() throws Exception {
        try (Statement selStmt = this.conn.createStatement();){
            JdbcThinInsertStatementSelfTest.assertTrue((boolean)selStmt.execute("select _key, id, firstName, lastName, age from Person"));
            ResultSet rs = selStmt.getResultSet();
            assert (rs != null);
            block15: while (rs.next()) {
                int id = rs.getInt("id");
                switch (id) {
                    case 1: {
                        JdbcThinInsertStatementSelfTest.assertEquals((String)"p1", (String)rs.getString("_key"));
                        JdbcThinInsertStatementSelfTest.assertEquals((String)"John", (String)rs.getString("firstName"));
                        JdbcThinInsertStatementSelfTest.assertEquals((String)"White", (String)rs.getString("lastName"));
                        JdbcThinInsertStatementSelfTest.assertEquals((int)25, (int)rs.getInt("age"));
                        continue block15;
                    }
                    case 2: {
                        JdbcThinInsertStatementSelfTest.assertEquals((String)"p2", (String)rs.getString("_key"));
                        JdbcThinInsertStatementSelfTest.assertEquals((String)"Joe", (String)rs.getString("firstName"));
                        JdbcThinInsertStatementSelfTest.assertEquals((String)"Black", (String)rs.getString("lastName"));
                        JdbcThinInsertStatementSelfTest.assertEquals((int)35, (int)rs.getInt("age"));
                        continue block15;
                    }
                    case 3: {
                        JdbcThinInsertStatementSelfTest.assertEquals((String)"p3", (String)rs.getString("_key"));
                        JdbcThinInsertStatementSelfTest.assertEquals((String)"Mike", (String)rs.getString("firstName"));
                        JdbcThinInsertStatementSelfTest.assertEquals((String)"Green", (String)rs.getString("lastName"));
                        JdbcThinInsertStatementSelfTest.assertEquals((int)40, (int)rs.getInt("age"));
                        continue block15;
                    }
                    case 4: {
                        JdbcThinInsertStatementSelfTest.assertEquals((String)"p4", (String)rs.getString("_key"));
                        JdbcThinInsertStatementSelfTest.assertEquals((String)"Leah", (String)rs.getString("firstName"));
                        JdbcThinInsertStatementSelfTest.assertEquals((String)"Grey", (String)rs.getString("lastName"));
                        JdbcThinInsertStatementSelfTest.assertEquals((int)22, (int)rs.getInt("age"));
                        continue block15;
                    }
                }
                assert (false) : "Invalid ID: " + id;
            }
        }
        if (this.stmt != null && !this.stmt.isClosed()) {
            this.stmt.close();
        }
        if (this.prepStmt != null && !this.prepStmt.isClosed()) {
            this.prepStmt.close();
        }
        JdbcThinInsertStatementSelfTest.assertTrue((boolean)this.prepStmt.isClosed());
        JdbcThinInsertStatementSelfTest.assertTrue((boolean)this.stmt.isClosed());
        super.afterTest();
    }

    @Test
    public void testExecuteUpdate() throws SQLException {
        JdbcThinInsertStatementSelfTest.assertEquals((int)3, (int)this.stmt.executeUpdate(SQL));
    }

    @Test
    public void testPreparedExecuteUpdate() throws SQLException {
        JdbcThinInsertStatementSelfTest.assertEquals((int)3, (int)this.prepStmt.executeUpdate());
    }

    @Test
    public void testExecute() throws SQLException {
        JdbcThinInsertStatementSelfTest.assertFalse((boolean)this.stmt.execute(SQL));
    }

    @Test
    public void testPreparedExecute() throws SQLException {
        JdbcThinInsertStatementSelfTest.assertFalse((boolean)this.prepStmt.execute());
    }

    @Test
    public void testDuplicateKeys() throws InterruptedException {
        this.jcache(0).put((Object)"p2", (Object)new JdbcThinAbstractDmlStatementSelfTest.Person(2, "Joe", "Black", 35));
        LogListener lsnr = LogListener.matches((String)"Failed to execute SQL query").build();
        srvLog.registerListener(lsnr);
        GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return JdbcThinInsertStatementSelfTest.this.stmt.execute(JdbcThinInsertStatementSelfTest.SQL);
            }
        }, SQLException.class, (String)"Failed to INSERT some keys because they are already in cache [keys=[p2]]");
        JdbcThinInsertStatementSelfTest.assertFalse((boolean)lsnr.check(1000L));
        JdbcThinInsertStatementSelfTest.assertEquals((int)3, (int)this.jcache(0).withKeepBinary().getAll(new HashSet<String>(Arrays.asList("p1", "p2", "p3"))).size());
    }
}

