/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc.thin;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.ignite.jdbc.JdbcErrorsAbstractSelfTest;
import org.apache.ignite.lang.IgniteCallable;
import org.junit.Assert;
import org.junit.Test;

public class JdbcThinErrorsSelfTest
extends JdbcErrorsAbstractSelfTest {
    @Override
    protected Connection getConnection() throws SQLException {
        return DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1");
    }

    @Test
    public void testConnectionError() throws SQLException {
        this.checkErrorState(new IgniteCallable<Void>(){

            public Void call() throws Exception {
                DriverManager.getConnection("jdbc:ignite:thin://host.invalid");
                return null;
            }
        }, "08001", "Failed to connect to ");
    }

    @Test
    public void testInvalidConnectionStringFormat() throws SQLException {
        this.checkErrorState(new IgniteCallable<Void>(){

            public Void call() throws Exception {
                DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1:1000000");
                return null;
            }
        }, "08001", "port range contains invalid port 1000000");
    }

    @Test
    public void testInvalidIsolationLevel() throws SQLException {
        this.checkErrorState(new JdbcErrorsAbstractSelfTest.ConnClosure(){

            @Override
            public void run(Connection conn) throws Exception {
                conn.setTransactionIsolation(1000);
            }
        }, "0700E", "Invalid transaction isolation level.");
    }

    @Test
    public void testBatchUpdateException() throws SQLException {
        try (Connection conn = this.getConnection();){
            try (Statement stmt = conn.createStatement();){
                stmt.executeUpdate("CREATE TABLE test (id int primary key, val varchar)");
                stmt.addBatch("insert into test (id, val) values (1, 'val1')");
                stmt.addBatch("insert into test (id, val) values (2, 'val2')");
                stmt.addBatch("insert into test (id1, val1) values (3, 'val3')");
                stmt.executeBatch();
                JdbcThinErrorsSelfTest.fail((String)"BatchUpdateException is expected");
            }
            catch (BatchUpdateException e) {
                JdbcThinErrorsSelfTest.assertEquals((int)3, (int)e.getUpdateCounts().length);
                Assert.assertArrayEquals((String)"", (int[])new int[]{1, 1, -3}, (int[])e.getUpdateCounts());
                JdbcThinErrorsSelfTest.assertEquals((String)"42000", (String)e.getSQLState());
                JdbcThinErrorsSelfTest.assertTrue((String)("Unexpected error message: " + e.getMessage()), (e.getMessage() != null && e.getMessage().contains("Failed to parse query. Column \"ID1\" not found") ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testExplainUpdatesUnsupported() throws Exception {
        this.checkErrorState((Connection conn) -> {
            try (Statement statement = conn.createStatement();){
                statement.executeUpdate("CREATE TABLE TEST_EXPLAIN (ID LONG PRIMARY KEY, VAL LONG)");
                statement.executeUpdate("EXPLAIN INSERT INTO TEST_EXPLAIN VALUES (1, 2)");
            }
        }, "0A000", "Explains of update queries are not supported.");
    }
}

