/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc.thin;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.SqlConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class JdbcThinDefaultTimeoutTest
extends GridCommonAbstractTest {
    public static final int ROW_COUNT = 200;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        CacheConfiguration ccfg = new CacheConfiguration("default").setIndexedTypes(new Class[]{Integer.class, Integer.class}).setSqlSchema("PUBLIC").setSqlFunctionClasses(new Class[]{GridTestUtils.SqlTestFunctions.class});
        return super.getConfiguration(igniteInstanceName).setCacheConfiguration(new CacheConfiguration[]{ccfg}).setSqlConfiguration(new SqlConfiguration().setDefaultQueryTimeout(100L));
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        IgniteEx ign = this.startGrid(0);
        Map vals = IntStream.range(0, 200).boxed().collect(Collectors.toMap(Function.identity(), Function.identity()));
        ign.cache("default").putAll(vals);
    }

    protected void afterTestsStopped() throws Exception {
        this.stopAllGrids();
        super.afterTestsStopped();
    }

    @Test
    public void testDefaultTimeoutIgnored() throws Exception {
        try (Connection conn = DriverManager.getConnection("jdbc:ignite:thin://localhost");){
            Statement stmt = conn.createStatement();
            stmt.setQueryTimeout(0);
            ResultSet rs = stmt.executeQuery("select _key, _val, delay(5) from Integer");
            int cnt = 0;
            while (rs.next()) {
                ++cnt;
            }
            JdbcThinDefaultTimeoutTest.assertEquals((int)200, (int)cnt);
        }
    }

    @Test
    public void testDefaultTimeout() throws Exception {
        try (Connection conn = DriverManager.getConnection("jdbc:ignite:thin://localhost");){
            Statement stmt = conn.createStatement();
            GridTestUtils.assertThrows((IgniteLogger)log, () -> {
                ResultSet rs = stmt.executeQuery("select _key, _val, delay(5) from Integer");
                int cnt = 0;
                while (rs.next()) {
                    ++cnt;
                }
                return null;
            }, SQLException.class, (String)"The query was cancelled while executing");
        }
    }
}

