/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc.thin;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.processors.authentication.AuthorizationContext;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.jdbc.thin.JdbcThinAbstractSelfTest;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;

public class JdbcThinAuthenticateConnectionSelfTest
extends JdbcThinAbstractSelfTest {
    private static final String URL = "jdbc:ignite:thin://127.0.0.1";

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setMarshaller((Marshaller)new BinaryMarshaller());
        cfg.setAuthenticationEnabled(true);
        cfg.setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true).setMaxSize(0x10000000L)));
        return cfg;
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"db", (boolean)true);
        this.startGrids(2);
        this.grid(0).cluster().active(true);
        AuthorizationContext.context((AuthorizationContext)this.grid(0).context().authentication().authenticate("ignite", "ignite"));
        this.grid(0).context().authentication().addUser("another_user", "passwd");
        AuthorizationContext.clear();
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
    }

    @Test
    public void testConnection() throws Exception {
        this.checkConnection(URL, "ignite", "ignite");
        this.checkConnection(URL, "another_user", "passwd");
        this.checkConnection("jdbc:ignite:thin://127.0.0.1?user=ignite&password=ignite", null, null);
        this.checkConnection("jdbc:ignite:thin://127.0.0.1?user=another_user&password=passwd", null, null);
    }

    @Test
    public void testInvalidUserPassword() {
        String err = "Unauthenticated sessions are prohibited";
        this.checkInvalidUserPassword(URL, null, null, err);
        err = "The user name or password is incorrect";
        this.checkInvalidUserPassword(URL, "ignite", null, err);
        this.checkInvalidUserPassword(URL, "another_user", null, err);
        this.checkInvalidUserPassword(URL, "ignite", "", err);
        this.checkInvalidUserPassword(URL, "ignite", "password", err);
        this.checkInvalidUserPassword(URL, "another_user", "ignite", err);
        this.checkInvalidUserPassword(URL, "another_user", "password", err);
        this.checkInvalidUserPassword(URL, "another_user", "password", err);
    }

    @Test
    public void testUserSqlOnAuthorized() throws SQLException {
        try (Connection conn = DriverManager.getConnection(URL, "ignite", "ignite");){
            conn.createStatement().execute("CREATE USER test WITH PASSWORD 'test'");
            this.checkConnection(URL, "TEST", "test");
            conn.createStatement().execute("ALTER USER test WITH PASSWORD 'newpasswd'");
            this.checkConnection(URL, "TEST", "newpasswd");
            conn.createStatement().execute("DROP USER test");
            this.checkInvalidUserPassword(URL, "TEST", "newpasswd", "The user name or password is incorrect");
        }
    }

    @Test
    public void testUserSqlWithNotIgniteUser() throws SQLException {
        try (Connection conn = DriverManager.getConnection(URL, "another_user", "passwd");){
            String err = "User management operations are not allowed for user";
            this.checkUnauthorizedOperation(conn, "CREATE USER test WITH PASSWORD 'test'", err);
            this.checkUnauthorizedOperation(conn, "ALTER USER test WITH PASSWORD 'newpasswd'", err);
            this.checkUnauthorizedOperation(conn, "DROP USER test", err);
            this.checkUnauthorizedOperation(conn, "DROP USER \"another_user\"", err);
            conn.createStatement().execute("ALTER USER \"another_user\" WITH PASSWORD 'newpasswd'");
            this.checkConnection(URL, "another_user", "newpasswd");
        }
    }

    @Test
    public void testQuotedUsername() throws SQLException {
        this.checkUserPassword(" test", "    ");
        this.checkUserPassword(" test ", " test ");
        this.checkUserPassword("test ", " ");
        this.checkUserPassword(" ", " ");
        this.checkUserPassword("user", "&/:=?");
        this.checkUserPassword("user", "&");
        this.checkUserPassword("user", "/");
        this.checkUserPassword("user", ":");
        this.checkUserPassword("user", "=");
        this.checkUserPassword("user", "?");
        this.checkUserPassword("\\u044E\\u0437\\u0435\\u0440", "\\u043F\\u0430\\u0440\\u043E\\u043B\\u044C");
        this.checkUserPassword("\\u7528\\u6236", "\\u5BC6\\u78BC");
    }

    private void checkUserPassword(String user, String passwd) throws SQLException {
        try (Connection conn = DriverManager.getConnection(URL, "ignite", "ignite");){
            conn.createStatement().execute(String.format("CREATE USER \"%s\" WITH PASSWORD '%s'", user, passwd));
            this.checkConnection(URL, user, passwd);
            this.checkConnection(URL + String.format("?user={%s}&password={%s}", user, passwd), null, null);
            conn.createStatement().execute(String.format("DROP USER \"%s\"", user));
        }
    }

    private void checkConnection(String url, String user, String passwd) throws SQLException {
        try (Connection conn = DriverManager.getConnection(url, user, passwd);){
            conn.createStatement().execute("SELECT 1");
        }
    }

    private void checkInvalidUserPassword(final String url, final String user, final String passwd, String err) {
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                JdbcThinAuthenticateConnectionSelfTest.this.checkConnection(url, user, passwd);
                return null;
            }
        }, SQLException.class, (String)err);
    }

    private void checkUnauthorizedOperation(final Connection conn, final String sql, String err) {
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                conn.createStatement().execute(sql);
                return null;
            }
        }, SQLException.class, (String)err);
    }
}

