/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest.protocols.tcp;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.client.marshaller.GridClientMarshaller;
import org.apache.ignite.internal.client.marshaller.optimized.GridClientOptimizedMarshaller;
import org.apache.ignite.internal.processors.rest.client.message.GridClientCacheRequest;
import org.apache.ignite.internal.processors.rest.client.message.GridClientHandshakeRequest;
import org.apache.ignite.internal.processors.rest.client.message.GridClientMessage;
import org.apache.ignite.internal.processors.rest.protocols.tcp.GridMemcachedMessage;
import org.apache.ignite.internal.processors.rest.protocols.tcp.GridTcpRestParser;
import org.apache.ignite.internal.util.nio.GridNioSession;
import org.apache.ignite.internal.util.nio.GridNioSessionMetaKey;
import org.apache.ignite.internal.util.nio.impl.MockNioSession;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

public class TcpRestParserSelfTest
extends GridCommonAbstractTest {
    private GridClientMarshaller marshaller = new GridClientOptimizedMarshaller();
    public static final byte[] EXTRAS = new byte[]{-34, 0, -66, 0, 0, 0, 0, 0};

    @Test
    public void testSimplePacketParsing() throws Exception {
        MockNioSession ses = new MockNioSession();
        GridTcpRestParser parser = new GridTcpRestParser(false);
        byte hdr = -128;
        byte[] opCodes = new byte[]{1, 2, 3};
        byte[] opaque = new byte[]{1, 2, 3, -1};
        String key = "key";
        String val = "value";
        for (byte opCode : opCodes) {
            ByteBuffer raw = this.rawPacket(hdr, opCode, opaque, key.getBytes(), val.getBytes(), EXTRAS);
            GridClientMessage msg = parser.decode((GridNioSession)ses, raw);
            TcpRestParserSelfTest.assertTrue((boolean)(msg instanceof GridMemcachedMessage));
            GridMemcachedMessage packet = (GridMemcachedMessage)msg;
            TcpRestParserSelfTest.assertEquals((String)"Parser leaved unparsed bytes", (int)0, (int)raw.remaining());
            TcpRestParserSelfTest.assertEquals((String)"Invalid opcode", (byte)opCode, (byte)packet.operationCode());
            TcpRestParserSelfTest.assertEquals((String)"Invalid key", (Object)key, (Object)packet.key());
            TcpRestParserSelfTest.assertEquals((String)"Invalid value", (Object)val, (Object)packet.value());
        }
    }

    @Test
    public void testIncorrectPackets() throws Exception {
        MockNioSession ses = new MockNioSession();
        final GridTcpRestParser parser = new GridTcpRestParser(false);
        byte[] opaque = new byte[]{1, 2, 3, -1};
        String key = "key";
        String val = "value";
        GridTestUtils.assertThrows((IgniteLogger)this.log(), (Callable)new Callable<Object>((GridNioSession)ses, opaque){
            final /* synthetic */ GridNioSession val$ses;
            final /* synthetic */ byte[] val$opaque;
            {
                this.val$ses = gridNioSession;
                this.val$opaque = byArray;
            }

            @Override
            @Nullable
            public Object call() throws Exception {
                parser.decode(this.val$ses, TcpRestParserSelfTest.this.rawPacket((byte)1, (byte)1, this.val$opaque, "key".getBytes(), "value".getBytes(), EXTRAS));
                return null;
            }
        }, IOException.class, null);
        GridTestUtils.assertThrows((IgniteLogger)this.log(), (Callable)new Callable<Object>((GridNioSession)ses, opaque){
            final /* synthetic */ GridNioSession val$ses;
            final /* synthetic */ byte[] val$opaque;
            {
                this.val$ses = gridNioSession;
                this.val$opaque = byArray;
            }

            @Override
            @Nullable
            public Object call() throws Exception {
                parser.decode(this.val$ses, TcpRestParserSelfTest.this.rawPacket((byte)-128, (byte)1, this.val$opaque, "key".getBytes(), "value".getBytes(), null));
                return null;
            }
        }, IOException.class, null);
        GridTestUtils.assertThrows((IgniteLogger)this.log(), (Callable)new Callable<Object>((GridNioSession)ses){
            final /* synthetic */ GridNioSession val$ses;
            {
                this.val$ses = gridNioSession;
            }

            @Override
            @Nullable
            public Object call() throws Exception {
                ByteBuffer fake = ByteBuffer.allocate(21);
                fake.put((byte)-112);
                fake.put(U.intToBytes((int)-5));
                fake.put(U.longToBytes((long)0L));
                fake.put(U.longToBytes((long)0L));
                fake.flip();
                parser.decode(this.val$ses, fake);
                return null;
            }
        }, IOException.class, null);
    }

    @Test
    public void testCustomMessages() throws Exception {
        GridClientCacheRequest req = new GridClientCacheRequest(GridClientCacheRequest.GridCacheOperation.CAS);
        req.key((Object)"key");
        req.value((Object)1);
        req.value2((Object)2);
        req.clientId(UUID.randomUUID());
        ByteBuffer raw = this.clientRequestPacket((GridClientMessage)req);
        MockNioSession ses = new MockNioSession();
        ses.addMeta(GridNioSessionMetaKey.MARSHALLER.ordinal(), (Object)new GridClientOptimizedMarshaller());
        GridTcpRestParser parser = new GridTcpRestParser(false);
        GridClientMessage msg = parser.decode((GridNioSession)ses, raw);
        TcpRestParserSelfTest.assertNotNull((Object)msg);
        TcpRestParserSelfTest.assertEquals((String)"Parser leaved unparsed bytes", (int)0, (int)raw.remaining());
        TcpRestParserSelfTest.assertTrue((boolean)(msg instanceof GridClientCacheRequest));
        GridClientCacheRequest res = (GridClientCacheRequest)msg;
        TcpRestParserSelfTest.assertEquals((String)"Invalid operation", (Object)req.operation(), (Object)res.operation());
        TcpRestParserSelfTest.assertEquals((String)"Invalid clientId", (Object)req.clientId(), (Object)res.clientId());
        TcpRestParserSelfTest.assertEquals((String)"Invalid key", (Object)req.key(), (Object)res.key());
        TcpRestParserSelfTest.assertEquals((String)"Invalid value 1", (Object)req.value(), (Object)res.value());
        TcpRestParserSelfTest.assertEquals((String)"Invalid value 2", (Object)req.value2(), (Object)res.value2());
    }

    @Test
    public void testMixedParsing() throws Exception {
        MockNioSession ses1 = new MockNioSession();
        MockNioSession ses2 = new MockNioSession();
        ses1.addMeta(GridNioSessionMetaKey.MARSHALLER.ordinal(), (Object)new GridClientOptimizedMarshaller());
        ses2.addMeta(GridNioSessionMetaKey.MARSHALLER.ordinal(), (Object)new GridClientOptimizedMarshaller());
        GridTcpRestParser parser = new GridTcpRestParser(false);
        GridClientCacheRequest req = new GridClientCacheRequest(GridClientCacheRequest.GridCacheOperation.CAS);
        req.key((Object)"key");
        String val = "value";
        req.value((Object)val);
        req.value2((Object)val);
        req.clientId(UUID.randomUUID());
        byte[] opaque = new byte[]{1, 2, 3, -1};
        String key = "key";
        ByteBuffer raw1 = this.rawPacket((byte)-128, (byte)1, opaque, key.getBytes(), val.getBytes(), EXTRAS);
        ByteBuffer raw2 = this.clientRequestPacket((GridClientMessage)req);
        raw1.mark();
        raw2.mark();
        int splits = Math.min(raw1.remaining(), raw2.remaining());
        for (int i = 1; i < splits; ++i) {
            ByteBuffer[] packet1 = this.split(raw1, i);
            ByteBuffer[] packet2 = this.split(raw2, i);
            GridClientMessage msg = parser.decode((GridNioSession)ses1, packet1[0]);
            TcpRestParserSelfTest.assertNull((Object)msg);
            msg = parser.decode((GridNioSession)ses2, packet2[0]);
            TcpRestParserSelfTest.assertNull((Object)msg);
            msg = parser.decode((GridNioSession)ses1, packet1[1]);
            TcpRestParserSelfTest.assertTrue((boolean)(msg instanceof GridMemcachedMessage));
            TcpRestParserSelfTest.assertEquals((Object)key, (Object)((GridMemcachedMessage)msg).key());
            TcpRestParserSelfTest.assertEquals((Object)val, (Object)((GridMemcachedMessage)msg).value());
            msg = parser.decode((GridNioSession)ses2, packet2[1]);
            TcpRestParserSelfTest.assertTrue((boolean)(msg instanceof GridClientCacheRequest));
            TcpRestParserSelfTest.assertEquals((Object)val, (Object)((GridClientCacheRequest)msg).value());
            TcpRestParserSelfTest.assertEquals((Object)val, (Object)((GridClientCacheRequest)msg).value2());
            raw1.reset();
            raw2.reset();
        }
    }

    @Test
    public void testParseContinuousSplit() throws Exception {
        ByteBuffer tmp = ByteBuffer.allocate(10240);
        GridClientCacheRequest req = new GridClientCacheRequest(GridClientCacheRequest.GridCacheOperation.CAS);
        req.key((Object)"key");
        req.value((Object)1);
        req.value2((Object)2);
        req.clientId(UUID.randomUUID());
        for (int i = 0; i < 5; ++i) {
            tmp.put(this.clientRequestPacket((GridClientMessage)req));
        }
        tmp.flip();
        for (int splitPos = 0; splitPos < tmp.remaining(); ++splitPos) {
            ByteBuffer[] split = this.split(tmp, splitPos);
            tmp.flip();
            MockNioSession ses = new MockNioSession();
            ses.addMeta(GridNioSessionMetaKey.MARSHALLER.ordinal(), (Object)new GridClientOptimizedMarshaller());
            GridTcpRestParser parser = new GridTcpRestParser(false);
            ArrayList<GridClientCacheRequest> lst = new ArrayList<GridClientCacheRequest>(5);
            for (ByteBuffer buf : split) {
                GridClientCacheRequest r;
                while (buf.hasRemaining() && (r = (GridClientCacheRequest)parser.decode((GridNioSession)ses, buf)) != null) {
                    lst.add(r);
                }
                TcpRestParserSelfTest.assertTrue((String)"Parser has left unparsed bytes.", (buf.remaining() == 0 ? 1 : 0) != 0);
            }
            TcpRestParserSelfTest.assertEquals((int)5, (int)lst.size());
            for (GridClientCacheRequest res : lst) {
                TcpRestParserSelfTest.assertEquals((String)"Invalid operation", (Object)req.operation(), (Object)res.operation());
                TcpRestParserSelfTest.assertEquals((String)"Invalid clientId", (Object)req.clientId(), (Object)res.clientId());
                TcpRestParserSelfTest.assertEquals((String)"Invalid key", (Object)req.key(), (Object)res.key());
                TcpRestParserSelfTest.assertEquals((String)"Invalid value 1", (Object)req.value(), (Object)res.value());
                TcpRestParserSelfTest.assertEquals((String)"Invalid value 2", (Object)req.value2(), (Object)res.value2());
            }
        }
    }

    @Test
    public void testParseClientHandshake() throws Exception {
        for (int splitPos = 1; splitPos < 5; ++splitPos) {
            log.info("Checking split position: " + splitPos);
            ByteBuffer tmp = this.clientHandshakePacket();
            ByteBuffer[] split = this.split(tmp, splitPos);
            MockNioSession ses = new MockNioSession();
            ses.addMeta(GridNioSessionMetaKey.MARSHALLER.ordinal(), (Object)new GridClientOptimizedMarshaller());
            GridTcpRestParser parser = new GridTcpRestParser(false);
            ArrayList<GridClientMessage> lst = new ArrayList<GridClientMessage>(1);
            for (ByteBuffer buf : split) {
                GridClientMessage r;
                while (buf.hasRemaining() && (r = parser.decode((GridNioSession)ses, buf)) != null) {
                    lst.add(r);
                }
                TcpRestParserSelfTest.assertTrue((String)"Parser has left unparsed bytes.", (buf.remaining() == 0 ? 1 : 0) != 0);
            }
            TcpRestParserSelfTest.assertEquals((int)1, (int)lst.size());
            GridClientHandshakeRequest req = (GridClientHandshakeRequest)F.first(lst);
            TcpRestParserSelfTest.assertNotNull((Object)req);
            TcpRestParserSelfTest.assertEquals((short)U.bytesToShort((byte[])new byte[]{5, 0}, (int)0), (short)req.version());
        }
    }

    private ByteBuffer[] split(ByteBuffer original, int pos) {
        byte[] data = new byte[pos];
        original.get(data);
        ByteBuffer[] res = new ByteBuffer[2];
        res[0] = ByteBuffer.wrap(data);
        data = new byte[original.remaining()];
        original.get(data);
        res[1] = ByteBuffer.wrap(data);
        return res;
    }

    private ByteBuffer clientRequestPacket(GridClientMessage msg) throws IOException {
        ByteBuffer res = this.marshaller.marshal((Object)msg, 45);
        ByteBuffer slice = res.slice();
        slice.put((byte)-112);
        slice.putInt(res.remaining() - 5);
        slice.putLong(msg.requestId());
        slice.put(U.uuidToBytes((UUID)msg.clientId()));
        slice.put(U.uuidToBytes((UUID)msg.destinationId()));
        return res;
    }

    private ByteBuffer clientHandshakePacket() {
        ByteBuffer res = ByteBuffer.allocate(6);
        res.put(new byte[]{-111, 5, 0, 0, 0, 0});
        res.flip();
        return res;
    }

    private ByteBuffer rawPacket(byte magic, byte opCode, byte[] opaque, @Nullable byte[] key, @Nullable byte[] val, @Nullable byte[] extras) {
        ByteBuffer res = ByteBuffer.allocate(1024);
        res.put(magic);
        res.put(opCode);
        int keyLen = key == null ? 0 : key.length;
        int extrasLen = extras == null ? 0 : extras.length;
        int valLen = val == null ? 0 : val.length;
        res.putShort((short)keyLen);
        res.put((byte)extrasLen);
        res.put((byte)0);
        res.putShort((short)0);
        res.putInt(keyLen + extrasLen + valLen);
        res.put(opaque);
        res.putLong(0L);
        if (extrasLen > 0) {
            res.put(extras);
        }
        if (keyLen > 0) {
            res.put(key);
        }
        if (valLen > 0) {
            res.put(val);
        }
        res.flip();
        return res;
    }
}

