/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.client.marshaller.GridClientMarshaller;
import org.apache.ignite.internal.client.marshaller.optimized.GridClientOptimizedMarshaller;
import org.apache.ignite.internal.processors.rest.client.message.GridClientCacheRequest;
import org.apache.ignite.internal.processors.rest.client.message.GridClientHandshakeRequest;
import org.apache.ignite.internal.processors.rest.client.message.GridClientHandshakeResponse;
import org.apache.ignite.internal.processors.rest.client.message.GridClientMessage;
import org.apache.ignite.internal.processors.rest.client.message.GridClientNodeBean;
import org.apache.ignite.internal.processors.rest.client.message.GridClientResponse;
import org.apache.ignite.internal.processors.rest.client.message.GridClientTaskRequest;
import org.apache.ignite.internal.processors.rest.client.message.GridClientTaskResultBean;
import org.apache.ignite.internal.processors.rest.client.message.GridClientTopologyRequest;
import org.apache.ignite.internal.util.GridClientByteUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.logger.java.JavaLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TestBinaryClient {
    private final IgniteLogger log = new JavaLogger();
    private final GridClientMarshaller marsh = new GridClientOptimizedMarshaller();
    private final Socket sock;
    private final InputStream input;
    private final AtomicInteger idCntr = new AtomicInteger(0);
    private final BlockingQueue<Response> queue = new LinkedBlockingQueue<Response>();
    private final Thread rdr;
    private static final Response QUIT_RESP = new Response(0L, 1, null, null);
    private UUID id = UUID.randomUUID();

    TestBinaryClient(String host, int port) throws IgniteCheckedException {
        assert (host != null);
        assert (port > 0);
        try {
            this.sock = new Socket(host, port);
            this.input = this.sock.getInputStream();
            GridClientHandshakeRequest req = new GridClientHandshakeRequest();
            req.marshallerId((byte)1);
            this.sock.getOutputStream().write(-111);
            this.sock.getOutputStream().write(req.rawBytes());
            byte[] buf = new byte[2];
            int read = this.input.read(buf);
            assert (read == 2) : read;
            assert (buf[0] == -110);
            assert (buf[1] == GridClientHandshakeResponse.OK.resultCode()) : "Client handshake failed [code=" + buf[0] + ']';
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to establish connection.", (Throwable)e);
        }
        this.rdr = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ByteArrayOutputStream buf = new ByteArrayOutputStream();
                    int len = 0;
                    boolean running = true;
                    block5: while (running) {
                        int symbol = TestBinaryClient.this.input.read();
                        if (symbol == -1) {
                            break;
                        }
                        if ((byte)symbol != -112) {
                            if (TestBinaryClient.this.log.isDebugEnabled()) {
                                TestBinaryClient.this.log.debug("Failed to parse incoming packet (invalid packet start): " + Integer.toHexString(symbol & 0xFF));
                            }
                            break;
                        }
                        while (true) {
                            if ((symbol = TestBinaryClient.this.input.read()) == -1) {
                                running = false;
                                continue block5;
                            }
                            byte b = (byte)symbol;
                            buf.write(b);
                            if (len == 0) {
                                if (buf.size() != 4) continue;
                                len = U.bytesToInt((byte[])buf.toByteArray(), (int)0);
                                if (TestBinaryClient.this.log.isInfoEnabled()) {
                                    TestBinaryClient.this.log.info("Read length: " + len);
                                }
                                buf.reset();
                                continue;
                            }
                            if (buf.size() == len) break;
                        }
                        byte[] bytes = buf.toByteArray();
                        byte[] hdrBytes = Arrays.copyOfRange(bytes, 0, 40);
                        byte[] msgBytes = Arrays.copyOfRange(bytes, 40, bytes.length);
                        GridClientResponse msg = (GridClientResponse)TestBinaryClient.this.marsh.unmarshal(msgBytes);
                        long reqId = GridClientByteUtils.bytesToLong((byte[])hdrBytes, (int)0);
                        UUID clientId = GridClientByteUtils.bytesToUuid((byte[])hdrBytes, (int)8);
                        UUID destId = GridClientByteUtils.bytesToUuid((byte[])hdrBytes, (int)24);
                        msg.requestId(reqId);
                        msg.clientId(clientId);
                        msg.destinationId(destId);
                        buf.reset();
                        len = 0;
                        TestBinaryClient.this.queue.offer(new Response(msg.requestId(), msg.successStatus(), msg.result(), msg.errorMessage()));
                    }
                }
                catch (IOException e) {
                    if (!Thread.currentThread().isInterrupted()) {
                        U.error((IgniteLogger)TestBinaryClient.this.log, (Object)e);
                    }
                }
                finally {
                    U.closeQuiet((Socket)TestBinaryClient.this.sock);
                    TestBinaryClient.this.queue.add(QUIT_RESP);
                }
            }
        });
        this.rdr.start();
    }

    public void shutdown() throws IgniteCheckedException {
        try {
            if (this.rdr != null) {
                this.rdr.interrupt();
                U.closeQuiet((Socket)this.sock);
                this.rdr.join();
            }
        }
        catch (InterruptedException e) {
            throw new IgniteCheckedException((Throwable)e);
        }
    }

    private Response makeRequest(GridClientMessage msg) throws IgniteCheckedException {
        assert (msg != null);
        try {
            this.sock.getOutputStream().write(this.createPacket(msg));
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to send packet.", (Throwable)e);
        }
        try {
            while (true) {
                Response res;
                if ((res = this.queue.take()) == QUIT_RESP) {
                    return res;
                }
                if (res.opaque() == msg.requestId()) {
                    if (!res.isSuccess() && res.error() != null) {
                        throw new IgniteCheckedException(res.error());
                    }
                    return res;
                }
                this.queue.add(res);
            }
        }
        catch (InterruptedException e) {
            throw new IgniteCheckedException("Interrupted while waiting for response.", (Throwable)e);
        }
    }

    private byte[] createPacket(GridClientMessage msg) throws IOException {
        msg.clientId(this.id);
        ByteBuffer res = this.marsh.marshal((Object)msg, 45);
        ByteBuffer slice = res.slice();
        slice.put((byte)-112);
        slice.putInt(res.remaining() - 5);
        slice.putLong(msg.requestId());
        slice.put(U.uuidToBytes((UUID)msg.clientId()));
        slice.put(U.uuidToBytes((UUID)msg.destinationId()));
        byte[] arr = new byte[res.remaining()];
        res.get(arr);
        return arr;
    }

    public <K, V> boolean cachePut(@NotNull String cacheName, K key, V val) throws IgniteCheckedException {
        return this.cachePutAll(cacheName, Collections.singletonMap(key, val));
    }

    public <K, V> boolean cachePutAll(@NotNull String cacheName, Map<K, V> entries) throws IgniteCheckedException {
        assert (entries != null);
        GridClientCacheRequest req = new GridClientCacheRequest(GridClientCacheRequest.GridCacheOperation.PUT_ALL);
        req.requestId((long)this.idCntr.incrementAndGet());
        req.cacheName(cacheName);
        req.values(entries);
        return (Boolean)this.makeRequest((GridClientMessage)req).getObject();
    }

    public <K, V> V cacheGet(@NotNull String cacheName, K key) throws IgniteCheckedException {
        assert (key != null);
        GridClientCacheRequest req = new GridClientCacheRequest(GridClientCacheRequest.GridCacheOperation.GET);
        req.requestId((long)this.idCntr.getAndIncrement());
        req.cacheName(cacheName);
        req.key(key);
        return (V)this.makeRequest((GridClientMessage)req).getObject();
    }

    public <K, V> Map<K, V> cacheGetAll(@NotNull String cacheName, K ... keys) throws IgniteCheckedException {
        assert (keys != null);
        GridClientCacheRequest req = new GridClientCacheRequest(GridClientCacheRequest.GridCacheOperation.GET_ALL);
        req.requestId((long)this.idCntr.getAndIncrement());
        req.cacheName(cacheName);
        req.keys(Arrays.asList(keys));
        return (Map)this.makeRequest((GridClientMessage)req).getObject();
    }

    public <K> boolean cacheRemove(@NotNull String cacheName, K key) throws IgniteCheckedException {
        assert (key != null);
        GridClientCacheRequest req = new GridClientCacheRequest(GridClientCacheRequest.GridCacheOperation.RMV);
        req.requestId((long)this.idCntr.getAndIncrement());
        req.cacheName(cacheName);
        req.key(key);
        return (Boolean)this.makeRequest((GridClientMessage)req).getObject();
    }

    public <K> boolean cacheRemoveAll(@NotNull String cacheName, K ... keys) throws IgniteCheckedException {
        assert (keys != null);
        GridClientCacheRequest req = new GridClientCacheRequest(GridClientCacheRequest.GridCacheOperation.RMV_ALL);
        req.requestId((long)this.idCntr.getAndIncrement());
        req.cacheName(cacheName);
        req.keys(Arrays.asList(keys));
        return this.makeRequest((GridClientMessage)req).isSuccess();
    }

    public <K, V> boolean cacheReplace(@NotNull String cacheName, K key, V val) throws IgniteCheckedException {
        assert (key != null);
        assert (val != null);
        GridClientCacheRequest replace = new GridClientCacheRequest(GridClientCacheRequest.GridCacheOperation.REPLACE);
        replace.requestId((long)this.idCntr.getAndIncrement());
        replace.cacheName(cacheName);
        replace.key(key);
        replace.value(val);
        return (Boolean)this.makeRequest((GridClientMessage)replace).getObject();
    }

    public <K, V> boolean cacheCompareAndSet(@NotNull String cacheName, K key, @Nullable V val1, @Nullable V val2) throws IgniteCheckedException {
        assert (key != null);
        GridClientCacheRequest msg = new GridClientCacheRequest(GridClientCacheRequest.GridCacheOperation.CAS);
        msg.requestId((long)this.idCntr.getAndIncrement());
        msg.cacheName(cacheName);
        msg.key(key);
        msg.value(val1);
        msg.value2(val2);
        return (Boolean)this.makeRequest((GridClientMessage)msg).getObject();
    }

    public <K> Map<String, Long> cacheMetrics(@NotNull String cacheName) throws IgniteCheckedException {
        GridClientCacheRequest metrics = new GridClientCacheRequest(GridClientCacheRequest.GridCacheOperation.METRICS);
        metrics.requestId((long)this.idCntr.getAndIncrement());
        metrics.cacheName(cacheName);
        return (Map)this.makeRequest((GridClientMessage)metrics).getObject();
    }

    public <K, V> boolean cacheAppend(@NotNull String cacheName, K key, V val) throws IgniteCheckedException {
        assert (key != null);
        assert (val != null);
        GridClientCacheRequest add = new GridClientCacheRequest(GridClientCacheRequest.GridCacheOperation.APPEND);
        add.requestId((long)this.idCntr.getAndIncrement());
        add.cacheName(cacheName);
        add.key(key);
        add.value(val);
        return (Boolean)this.makeRequest((GridClientMessage)add).getObject();
    }

    public <K, V> boolean cachePrepend(@NotNull String cacheName, K key, V val) throws IgniteCheckedException {
        assert (key != null);
        assert (val != null);
        GridClientCacheRequest add = new GridClientCacheRequest(GridClientCacheRequest.GridCacheOperation.PREPEND);
        add.requestId((long)this.idCntr.getAndIncrement());
        add.cacheName(cacheName);
        add.key(key);
        add.value(val);
        return (Boolean)this.makeRequest((GridClientMessage)add).getObject();
    }

    public GridClientTaskResultBean execute(String taskName, @Nullable Object arg) throws IgniteCheckedException {
        assert (!F.isEmpty((String)taskName));
        GridClientTaskRequest msg = new GridClientTaskRequest();
        msg.taskName(taskName);
        msg.argument(arg);
        return (GridClientTaskResultBean)this.makeRequest((GridClientMessage)msg).getObject();
    }

    public GridClientNodeBean node(UUID id, boolean includeAttrs, boolean includeMetrics) throws IgniteCheckedException {
        assert (id != null);
        GridClientTopologyRequest msg = new GridClientTopologyRequest();
        msg.nodeId(id);
        msg.includeAttributes(includeAttrs);
        msg.includeMetrics(includeMetrics);
        return (GridClientNodeBean)this.makeRequest((GridClientMessage)msg).getObject();
    }

    public GridClientNodeBean node(String ipAddr, boolean includeAttrs, boolean includeMetrics) throws IgniteCheckedException {
        assert (!F.isEmpty((String)ipAddr));
        GridClientTopologyRequest msg = new GridClientTopologyRequest();
        msg.nodeIp(ipAddr);
        msg.includeAttributes(includeAttrs);
        msg.includeMetrics(includeMetrics);
        return (GridClientNodeBean)this.makeRequest((GridClientMessage)msg).getObject();
    }

    public List<GridClientNodeBean> topology(boolean includeAttrs, boolean includeMetrics) throws IgniteCheckedException {
        GridClientTopologyRequest msg = new GridClientTopologyRequest();
        msg.includeAttributes(includeAttrs);
        msg.includeMetrics(includeMetrics);
        return (List)this.makeRequest((GridClientMessage)msg).getObject();
    }

    private static class Response {
        private final long opaque;
        private final int success;
        private final Object obj;
        private final String error;

        Response(long opaque, int success, @Nullable Object obj, @Nullable String error) {
            assert (opaque >= 0L);
            this.opaque = opaque;
            this.success = success;
            this.obj = obj;
            this.error = error;
        }

        long opaque() {
            return this.opaque;
        }

        boolean isSuccess() {
            return this.success == 0;
        }

        <T> T getObject() {
            return (T)this.obj;
        }

        String error() {
            return this.error;
        }
    }
}

