/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc2;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.jdbc2.JdbcAbstractUpdateStatementSelfTest;
import org.apache.ignite.internal.util.typedef.F;
import org.junit.Test;

public class JdbcUpdateStatementSelfTest
extends JdbcAbstractUpdateStatementSelfTest {
    @Test
    public void testExecute() throws SQLException {
        this.conn.createStatement().execute("update Person set firstName = 'Jack' where cast(substring(_key, 2, 1) as int) % 2 = 0");
        JdbcUpdateStatementSelfTest.assertEquals(Arrays.asList(F.asList((Object)"John"), F.asList((Object)"Jack"), F.asList((Object)"Mike")), (Object)this.jcache(0).query(new SqlFieldsQuery("select firstName from Person order by _key")).getAll());
    }

    @Test
    public void testExecuteUpdate() throws SQLException {
        this.conn.createStatement().executeUpdate("update Person set firstName = 'Jack' where cast(substring(_key, 2, 1) as int) % 2 = 0");
        JdbcUpdateStatementSelfTest.assertEquals(Arrays.asList(F.asList((Object)"John"), F.asList((Object)"Jack"), F.asList((Object)"Mike")), (Object)this.jcache(0).query(new SqlFieldsQuery("select firstName from Person order by _key")).getAll());
    }

    @Test
    public void testBatch() throws SQLException {
        PreparedStatement ps = this.conn.prepareStatement("update Person set lastName = concat(firstName, 'son') where firstName = ?");
        ps.setString(1, "John");
        ps.addBatch();
        ps.setString(1, "Harry");
        ps.addBatch();
        int[] res = ps.executeBatch();
        JdbcUpdateStatementSelfTest.assertEquals(Arrays.asList(F.asList((Object)"Johnson"), F.asList((Object)"Black"), F.asList((Object)"Green")), (Object)this.jcache(0).query(new SqlFieldsQuery("select lastName from Person order by _key")).getAll());
        JdbcUpdateStatementSelfTest.assertTrue((boolean)Arrays.equals(new int[]{1, 0}, res));
    }
}

